using System;
using System.Collections.Generic;
using System.Text;
using NetSNS.DALFactory;
using NetSNS.Model;
using System.Data.SqlClient;
using System.Data;
using NetSNS.DALProfile;
using NetSNS.Config;

namespace NetSNS.DALSQLServer
{
    public class CarATCCal : DbBase, ICarATCCal
    {
        /// <summary>
        /// ӻճϢ
        /// </summary>
        /// <param name="atccalinfo">ճϢ</param>
        /// <returns></returns>
        public int Add(CarATCCalInfo caratccalinfo)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();
            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                int GroupID = 0, UserID = 0;
                string Sql = "select GroupID,UserID from NT_CarClub where ID=" + caratccalinfo.CID;
                IDataReader dr = DbHelper.ExecuteReader(DBConfig.CnString, CommandType.Text, Sql, null);
                if (dr.Read())
                {
                    GroupID = dr.GetInt32(0);
                    UserID = dr.GetInt32(1);
                }

                //
                SqlParameter[] albumparam = new SqlParameter[7];
                albumparam[0] = new SqlParameter("@UserID", SqlDbType.Int, 4);
                albumparam[0].Value = UserID;
                albumparam[1] = new SqlParameter("@Title", SqlDbType.NVarChar, 50);
                albumparam[1].Value = caratccalinfo.CName;
                albumparam[2] = new SqlParameter("@Description", SqlDbType.NVarChar, 255);
                albumparam[2].Value = caratccalinfo.CDesc;
                albumparam[3] = new SqlParameter("@ImagesCount", SqlDbType.Int, 4);
                albumparam[3].Value = 0;
                albumparam[4] = new SqlParameter("@CreateTime", SqlDbType.DateTime, 8);
                albumparam[4].Value = DateTime.Now;
                albumparam[5] = new SqlParameter("@Privacy", SqlDbType.Int, 4);
                albumparam[5].Value = (int)EnumPrivacy.ForWholeSite;
                albumparam[6] = new SqlParameter("@GroupID", SqlDbType.Int, 4);
                albumparam[6].Value = GroupID;
                Sql = "Insert Into [NT_Album]" +
                      "([UserID],[Title],[Description],[ImagesCount],[CreateTime],[Privacy],[GroupID]) " +
                      "Values(@UserID,@Title,@Description,@ImagesCount,@CreateTime,@Privacy,@GroupID);" +
                      "Select @@IDENTITY";
                int AlbumID = Convert.ToInt32(DbHelper.ExecuteScalar(trans, CommandType.Text, Sql, albumparam));

                caratccalinfo.AlbumID = AlbumID;
                SqlParameter[] parm = getParameters(caratccalinfo);

                string sql = "insert into NT_CarATCCal(CName,CDesc,CSleep,Cfood,CTr,CTrs,LogIDS,AlbumID,MapParam,HID,CID) values(@CName,@CDesc,@CSleep,@Cfood,@CTr,@CTrs,@LogIDS,@AlbumID,@MapParam,@HID,@CID)";
                int n = DbHelper.ExecuteNonQuery(trans, CommandType.Text, sql, parm);
                dr.Close();
                trans.Commit();
                return n;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }
        /// <summary>
        /// ȡûճϢ
        /// </summary>
        /// <param name="ID">ճID</param>
        /// <returns></returns>
        public CarATCCalInfo GetInfo(int ID)
        {
            CarATCCalInfo caratccalinfo = new CarATCCalInfo();
            SqlParameter param = new SqlParameter("@ID", SqlDbType.Int, 4);
            param.Value = ID;
            string sql = "select ID,CName,CDesc,CSleep,Cfood,CTr,CTrs,LogIDS,AlbumID,MapParam,HID,CID from NT_CarATCCal where ID=@ID";
            IDataReader dr = DbHelper.ExecuteReader(CommandType.Text, sql, param);
            if (dr.Read())
            {
                caratccalinfo.ID = dr.GetInt32(0);
                caratccalinfo.CName = dr.GetString(1);
                caratccalinfo.CDesc = dr.GetString(2);
                caratccalinfo.CSleep = dr.GetString(3);
                caratccalinfo.Cfood = dr.GetString(4);
                caratccalinfo.CTr = dr.GetString(5);
                caratccalinfo.CTrs = dr.GetString(6);
                caratccalinfo.LogIDS = dr.GetString(7);
                caratccalinfo.AlbumID = dr.GetInt32(8);
                caratccalinfo.MapParam = dr.GetString(9);
                caratccalinfo.HID = dr.GetInt32(10);
                caratccalinfo.CID = dr.GetInt32(11);
            }
            else
            {
                caratccalinfo = null;
            }
            return caratccalinfo;
        }
        /// <summary>
        /// ȡûճϢ
        /// </summary>
        /// <param name="CName">ճ̰</param>
        /// <returns></returns>
        public CarATCCalInfo GetInfo(string CName)
        {
            CarATCCalInfo caratccalinfo = new CarATCCalInfo();
            SqlParameter param = new SqlParameter("@CName", SqlDbType.NVarChar, 200);
            param.Value = CName;
            string sql = "select ID,CName,CDesc,CSleep,Cfood,CTr,CTrs,LogIDS,AlbumID,MapParam,HID,CID from NT_CarATCCal where CName=@CName";
            IDataReader dr = DbHelper.ExecuteReader(CommandType.Text, sql, param);
            if (dr.Read())
            {
                caratccalinfo.ID = dr.GetInt32(0);
                caratccalinfo.CName = dr.GetString(1);
                caratccalinfo.CDesc = dr.GetString(2);
                caratccalinfo.CSleep = dr.GetString(3);
                caratccalinfo.Cfood = dr.GetString(4);
                caratccalinfo.CTr = dr.GetString(5);
                caratccalinfo.CTrs = dr.GetString(6);
                caratccalinfo.LogIDS = dr.GetString(7);
                caratccalinfo.AlbumID = dr.GetInt32(8);
                caratccalinfo.MapParam = dr.GetString(9);
                caratccalinfo.HID = dr.GetInt32(10);
                caratccalinfo.CID = dr.GetInt32(11);
            }
            else
            {
                caratccalinfo = null;
            }
            return caratccalinfo;
        }

        /// <summary>
        /// ѻ
        /// </summary>
        /// <param name="CID">ѻ</param>
        /// <param name="Num">ȡ</param>
        /// <returns>ݱ</returns>
        public DataTable AlbumList(int CID, int Num)
        {
            if (Num < 0)
                Num = 5;
            string Sql = "Select Top " + Num + " AlbumID From NT_CarATCCal Where CID=" + CID + " Order By ID Desc";
            return DbHelper.ExecuteTable(CommandType.Text, Sql, null);
        }

        /// <summary>
        /// ɾճ
        /// </summary>
        /// <param name="ID">ճID</param>
        /// <returns></returns>
        public int Delete(int ID)
        {
            SqlParameter param = new SqlParameter("@ID", SqlDbType.Int, 4);
            param.Value = ID;
            string sql = "delete from NT_CarATCCal where ID=@ID";
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, param);
        }
        /// <summary>
        /// »ճϢ
        /// </summary>
        /// <param name="atccalinfo">ճϢʵ</param>
        /// <returns></returns>
        public int Update(CarATCCalInfo atccalinfo)
        {
            SqlParameter[] parm = getParameters(atccalinfo);
            string sql = "update NT_CarATCCal set CName=@CName,CDesc=@CDesc,CSleep=@CSleep,Cfood=@Cfood,CTr=@CTr,CTrs=@CTrs,LogIDS=@LogIDS,AlbumID=@AlbumID,MapParam=@MapParam,HID=@HID,CID=@CID where ID=@ID";
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, parm);
        }
        /// <summary>
        /// ػжճ
        /// </summary>
        /// <param name="Hid">id</param>
        /// <returns>¼</returns>
        public int Count(int Hid)
        {
            SqlParameter param = new SqlParameter("@HID", SqlDbType.Int, 4);
            param.Value = Hid;
            string sql = "select count(*) from NT_CarATCCal where HID=@HID";
            return Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, sql, param));
        }
        /// <summary>
        /// ȡûճϢ
        /// </summary>
        /// <param name="Hid">ID</param>
        /// <returns></returns>
        public List<CarATCCalInfo> InfoList(int Hid)
        {
            List<CarATCCalInfo> infolist = new List<CarATCCalInfo>();
            SqlParameter param = new SqlParameter("@HID", SqlDbType.Int, 4);
            param.Value = Hid;
            string sql = "select ID,CName,CDesc,CSleep,Cfood,CTr,CTrs,LogIDS,AlbumID,MapParam,HID,CID from NT_CarATCCal where HID=@HID";
            IDataReader dr = DbHelper.ExecuteReader(CommandType.Text, sql, param);
            while (dr.Read())
            {
                CarATCCalInfo info = new CarATCCalInfo();
                info.ID = dr.GetInt32(0);
                info.CName = dr.GetString(1);
                info.CDesc = dr.GetString(2);
                info.CSleep = dr.GetString(3);
                info.Cfood = dr.GetString(4);
                info.CTr = dr.GetString(5);
                info.CTrs = dr.GetString(6);
                info.LogIDS = dr.GetString(7);
                info.AlbumID = dr.GetInt32(8);
                info.MapParam = dr.GetString(9);
                info.HID = dr.GetInt32(10);
                info.CID = dr.GetInt32(11);
                infolist.Add(info);
            }
            return infolist;
        }
        /// <summary>
        /// ȡճ̵־
        /// </summary>
        /// <param name="num">ճ</param>
        /// <returns></returns>
        public string GetCalBlog(int num)
        {
            StringBuilder sb = new StringBuilder();
            string topstr = "";
            if (num != 0)
                topstr = " top "+num+" ";
            string sql = "select " + topstr + " logIDS from NT_CarATCCal order by id desc";
            IDataReader dr = DbHelper.ExecuteReader(CommandType.Text, sql, null);
            while (dr.Read())
            {
                if (!dr.IsDBNull(0))
                {
                    sb.Append(dr.GetString(0));
                }
            }
            string s = sb.ToString();
            if (!string.IsNullOrEmpty(s))
            {
                s = NetSNS.Common.Input.FixCommaStr(s);
            }
            return s;
        }
        /// <summary>
        /// SQL
        /// </summary>
        /// <param name="Info">ճʵ</param>
        /// <returns></returns>
        private SqlParameter[] getParameters(CarATCCalInfo Info)
        {
            SqlParameter[] param = new SqlParameter[12];
            param[0] = new SqlParameter("@ID", SqlDbType.Int, 4);
            param[0].Value = Info.ID;
            param[1] = new SqlParameter("@CName", SqlDbType.NVarChar, 200);
            param[1].Value = Info.CName;
            param[2] = new SqlParameter("@CDesc", SqlDbType.NVarChar, 200);
            param[2].Value = Info.CDesc;
            param[3] = new SqlParameter("@CSleep", SqlDbType.NVarChar, 200);
            param[3].Value = Info.CSleep;
            param[4] = new SqlParameter("@Cfood", SqlDbType.NVarChar, 200);
            param[4].Value = Info.Cfood;
            param[5] = new SqlParameter("@CTr", SqlDbType.NVarChar, 200);
            param[5].Value = Info.CTr;
            param[6] = new SqlParameter("@CTrs", SqlDbType.NVarChar, 200);
            param[6].Value = Info.CTrs;
            param[7] = new SqlParameter("@LogIDS", SqlDbType.NVarChar, 1000);
            param[7].Value = Info.LogIDS;
            param[8] = new SqlParameter("@AlbumID", SqlDbType.NVarChar, 1000);
            param[8].Value = Info.AlbumID;
            param[9] = new SqlParameter("@MapParam", SqlDbType.NVarChar, 100);
            param[9].Value = Info.MapParam;
            param[10] = new SqlParameter("@HID", SqlDbType.Int, 4);
            param[10].Value = Info.HID;
            param[11] = new SqlParameter("@CID", SqlDbType.Int, 4);
            param[11].Value = Info.CID;
            return param;
        }
    }
}
