using System;
using System.Collections.Generic;
using System.Text;
using NetSNS.DALFactory;
using NetSNS.Model;
using System.Data;
using System.Data.SqlClient;
using NetSNS.DALProfile;

namespace NetSNS.DALSQLServer
{
    public class CarATCComment : DbBase, ICarATCComment
    {
        /// <summary>
        /// ӻϢ
        /// </summary>
        /// <param name="caratccommentinfo"></param>
        /// <returns></returns>
        public int Add(CarATCCommentInfo caratccommentinfo)
        {
            SqlParameter[] parm = getParameters(caratccommentinfo);
            string sql = "insert into NT_CarATCComment(Content,ATCID,UserID,CreatTime,isLock,IP) values(@Content,@ATCID,@UserID,@CreatTime,@isLock,@IP)";
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, parm);
        }

        /// <summary>
        /// ȡϢ
        /// </summary>
        /// <param name="ID">ID</param>
        /// <returns></returns>
        public CarATCCommentInfo GetInfo(int ID)
        {
            CarATCCommentInfo caratccommentinfo = new CarATCCommentInfo();
            SqlParameter parm = new SqlParameter("@ID", SqlDbType.Int, 4);
            parm.Value = ID;
            string sql = "select ID,Content,ATCID,UserID,CreatTime,isLock,IP from NT_CarATCComment where ID=@ID";
            IDataReader dr = DbHelper.ExecuteReader(CommandType.Text, sql, parm);
            if (dr.Read())
            {
                caratccommentinfo.ID=dr.GetInt32(0);
                caratccommentinfo.Content = dr.GetString(1);
                caratccommentinfo.ATCID = dr.GetInt32(2);
                caratccommentinfo.UserID = dr.GetInt32(3);
                caratccommentinfo.CreatTime = dr.GetDateTime(4);
                caratccommentinfo.isLock = (EnumIsLock)dr.GetInt32(5);
                caratccommentinfo.IP = dr.GetString(6);
            }
            else
            {
                caratccommentinfo = null;
            }
            dr.Close();
            return caratccommentinfo;
        }
        /// <summary>
        /// ɾ
        /// </summary>
        /// <param name="ID">ID</param>
        /// <returns></returns>
        public int Delete(int ID)
        {
            SqlParameter parm = new SqlParameter("@ID", SqlDbType.Int, 4);
            parm.Value = ID;
            string sql = "delete from NT_CarATCComment where ID=@ID";
            return DbHelper.ExecuteNonQuery(CommandType.Text,sql,parm);
        }
        /// <summary>
        /// »Ϣ
        /// </summary>
        /// <param name="caratccommentinfo">Ϣʵ</param>
        /// <returns></returns>
        public int Update(CarATCCommentInfo caratccommentinfo)
        {
            SqlParameter[] parm = getParameters(caratccommentinfo);
            string sql = "update NT_CarATCComment set Content=@Content,ATCID=@ATCID,UserID=@UserID,CreatTime=@CreatTime,isLock=@isLock,IP=@IP where ID=@ID";
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, parm);
        }
        /// <summary>
        /// SQL
        /// </summary>
        /// <param name="Info">ʵ</param>
        /// <returns></returns>
        private SqlParameter[] getParameters(CarATCCommentInfo Info)
        {
            SqlParameter[] param = new SqlParameter[7];
            param[0] = new SqlParameter("@ID", SqlDbType.Int, 4);
            param[0].Value = Info.ID;
            param[1] = new SqlParameter("@Content", SqlDbType.NVarChar, 200);
            param[1].Value = Info.Content;
            param[2] = new SqlParameter("@ATCID", SqlDbType.Int, 4);
            param[2].Value = Info.ATCID;
            param[3] = new SqlParameter("@UserID", SqlDbType.Int, 4);
            param[3].Value = Info.UserID;
            param[4] = new SqlParameter("@CreatTime", SqlDbType.DateTime, 8);
            param[4].Value = Info.CreatTime;
            param[5] = new SqlParameter("@isLock", SqlDbType.Int, 4);
            param[5].Value = (int)Info.isLock;
            param[6] = new SqlParameter("@IP", SqlDbType.NVarChar, 15);
            param[6].Value = Info.IP;
            return param;
        }
    }
}
