using System;
using System.Collections.Generic;
using System.Text;
using NetSNS.DALFactory;
using NetSNS.Model;
using System.Data.SqlClient;
using System.Data;
using NetSNS.DALProfile;

namespace NetSNS.DALSQLServer
{
    public class CarATCMember : DbBase, ICarATCMember
    {
        /// <summary>
        /// ӻ
        /// </summary>
        /// <param name="ATCMemberInfo">Ϣ</param>
        /// <returns></returns>
        public int Add(CarATCMemberInfo ATCMemberInfo)
        {
            SqlParameter[] parm = getParameters(ATCMemberInfo);
            string sql = "insert into NT_CarATCMember(HID,UserID,Islock,HDesc,PNum,TEL,Mobile,LinkMEN,CarType,CarPro) values(@HID,@UserID,@Islock,@HDesc,@PNum,@TEL,@Mobile,@LinkMEN,@CarType,@CarPro)";
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, parm);
        }
        /// <summary>
        /// ȡñԱ
        /// </summary>
        /// <param name="ID">Զ</param>
        /// <returns></returns>
        public CarATCMemberInfo GetInfo(int ID)
        {
            CarATCMemberInfo ATCMemberInfo = new CarATCMemberInfo();
            SqlParameter param = new SqlParameter("@ID", SqlDbType.Int, 4);
            param.Value = ID;
            string sql = "select ID,HID,UserID,Islock,HDesc,PNum,TEL,Mobile,LinkMEN,CarType,CarPro from NT_CarATCMember where ID=@ID";
            IDataReader dr = DbHelper.ExecuteReader(CommandType.Text, sql, param);
            if (dr.Read())
            {
                ATCMemberInfo.ID=dr.GetInt32(0);
                ATCMemberInfo.HID=dr.GetInt32(1);
                ATCMemberInfo.UserID = dr.GetInt32(2);
                ATCMemberInfo.Islock = (EnumIsLock)dr.GetInt32(3);
                ATCMemberInfo.HDesc = dr.GetString(4);
                ATCMemberInfo.PNum = dr.GetString(5);
                ATCMemberInfo.TEL = dr.GetString(6);
                ATCMemberInfo.Mobile = dr.GetString(7);
                ATCMemberInfo.LinkMEN = dr.GetString(8);
                ATCMemberInfo.CarType = dr.GetString(9);
                ATCMemberInfo.CarPro = dr.GetString(10);
            }
            else
            {
                ATCMemberInfo = null;
            }
            dr.Close();
            return ATCMemberInfo;
        }
        /// <summary>
        /// ĳĳԱ
        /// </summary>
        /// <param name="hid">ID</param>
        /// <returns></returns>
        public List<CarATCMemberInfo> InfoList(int hid)
        {
            List<CarATCMemberInfo> list = new List<CarATCMemberInfo>();           
            SqlParameter param = new SqlParameter("@HID", SqlDbType.Int, 4);
            param.Value = hid;
            string sql = "select ID,HID,UserID,Islock,HDesc,PNum,TEL,Mobile,LinkMEN,CarType,CarPro from NT_CarATCMember where HID=@HID";
            IDataReader dr = DbHelper.ExecuteReader(CommandType.Text, sql, param);
            if (dr.Read())
            {
                CarATCMemberInfo ATCMemberInfo = new CarATCMemberInfo();
                ATCMemberInfo.ID = dr.GetInt32(0);
                ATCMemberInfo.HID = dr.GetInt32(1);
                ATCMemberInfo.UserID = dr.GetInt32(2);
                ATCMemberInfo.Islock = (EnumIsLock)dr.GetInt32(3);
                ATCMemberInfo.HDesc = dr.GetString(4);
                ATCMemberInfo.PNum = dr.GetString(5);
                ATCMemberInfo.TEL = dr.GetString(6);
                ATCMemberInfo.Mobile = dr.GetString(7);
                ATCMemberInfo.LinkMEN = dr.GetString(8);
                ATCMemberInfo.CarType = dr.GetString(9);
                ATCMemberInfo.CarPro = dr.GetString(10);
                list.Add(ATCMemberInfo);
            }            
            dr.Close();
            return list;
        }
        /// <summary>
        /// ɾԱ
        /// </summary>
        /// <param name="UserID">ûID</param>
        /// <param name="HID">ID</param>
        /// <returns></returns>
        public int Delete(int UserID, int HID)
        {
            SqlParameter param = new SqlParameter("@UserID", SqlDbType.Int, 4);
            param.Value = UserID;

            SqlParameter param1 = new SqlParameter("@HID", SqlDbType.Int, 4);
            param1.Value = HID;

            string sql = "delete from NT_CarATCMember where UserID=@UserID and HID=@HID ";
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, param, param1);
        }
        /// <summary>
        /// ɾԱ
        /// </summary>
        /// <param name="ID">Զ</param>
        /// <returns></returns>
        public int Delete(int ID)
        {
            SqlParameter param = new SqlParameter("@ID", SqlDbType.Int, 4);
            param.Value = ID;
            string sql = "delete from NT_CarATCMember where ID=@ID";
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, param);
        }
        /// <summary>
        /// »
        /// </summary>
        /// <param name="ATCMemberInfo">Ϣʵ</param>
        /// <returns></returns>
        public int Update(CarATCMemberInfo ATCMemberInfo)
        {
            SqlParameter[] parm = getParameters(ATCMemberInfo);
            string sql = "update NT_CarATCMember set HID=@HID,UserID=@UserID,Islock=@Islock,HDesc=@HDesc,PNum=@PNum,TEL=@TEL,Mobile=@Mobile,LinkMEN=@LinkMEN,CarType=@CarType,CarPro=@CarPro where ID=@ID";
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, parm);
        }
        /// <summary>
        /// ǷĳĳԱ
        /// </summary>
        /// <param name="userid">ûID</param>
        /// <param name="hid">ID</param>
        /// <returns></returns>
        public bool IsMember(int userid, int hid)
        {
            SqlParameter param1 = new SqlParameter("@userid", SqlDbType.Int, 4);
            param1.Value = userid;
            SqlParameter param2 = new SqlParameter("@hid", SqlDbType.Int, 4);
            param2.Value = hid;
            string sql = "select * from NT_CarATCMember where userid=@userid and hid=@hid";
            IDataReader dr = DbHelper.ExecuteReader(CommandType.Text, sql, param1, param2);
            bool ibool = false;
            if (dr.Read())
                ibool = true;
            dr.Dispose();
            return ibool;
        }
        /// <summary>
        /// SQL
        /// </summary>
        /// <param name="Info">ʵ</param>
        /// <returns></returns>
        private SqlParameter[] getParameters(CarATCMemberInfo Info)
        {
            SqlParameter[] param = new SqlParameter[11];
            param[0] = new SqlParameter("@ID", SqlDbType.Int, 4);
            param[0].Value = Info.ID;
            param[1] = new SqlParameter("@HID", SqlDbType.Int, 4);
            param[1].Value = Info.HID;
            param[2] = new SqlParameter("@UserID", SqlDbType.Int, 4);
            param[2].Value = Info.UserID;
            param[3] = new SqlParameter("@Islock", SqlDbType.Int, 4);
            param[3].Value = (int)Info.Islock;
            param[4] = new SqlParameter("@HDesc", SqlDbType.NVarChar, 200);
            param[4].Value = Info.HDesc;
            param[5] = new SqlParameter("@PNum", SqlDbType.NVarChar, 50);
            param[5].Value = Info.PNum;
            param[6] = new SqlParameter("@TEL", SqlDbType.NVarChar, 30);
            param[6].Value = Info.TEL;
            param[7] = new SqlParameter("@Mobile", SqlDbType.NVarChar, 30);
            param[7].Value = Info.Mobile;
            param[8] = new SqlParameter("@LinkMEN", SqlDbType.NVarChar, 10);
            param[8].Value = Info.LinkMEN;
            param[9] = new SqlParameter("@CarType", SqlDbType.NVarChar, 30);
            param[9].Value = Info.CarType;
            param[10] = new SqlParameter("@CarPro", SqlDbType.NVarChar, 10);
            param[10].Value = Info.CarPro;
            return param;
        }
    }
}
