using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Common;
using System.Data.SqlClient;
using NetSNS.DALProfile;
using NetSNS.DALFactory;
using NetSNS.Model;
using NetSNS.Config;

namespace NetSNS.DALSQLServer
{
    /// <summary>
    /// ѻ
    /// </summary>
    public class CarClub : DbBase, ICarClub
    {
        /// <summary>
        /// һѻ
        /// </summary>
        /// <param name="Info">ѻʵ</param>
        /// <returns>ӳɹسѻ</returns>
        public int Add(CarClubInfo Info)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();
            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                SqlParameter[] param = getParameters(Info);

                //Ⱥ
                SqlParameter[] groupparam = new SqlParameter[7];
                groupparam[0] = new SqlParameter("@GroupName", SqlDbType.NVarChar, 15);
                groupparam[0].Value = Info.clubName;
                groupparam[1] = new SqlParameter("@UserID", SqlDbType.Int, 4);
                groupparam[1].Value = Info.UserID;
                groupparam[2] = new SqlParameter("@NetWork", SqlDbType.Int, 4);
                groupparam[2].Value = Info.Province;
                groupparam[3] = new SqlParameter("@Portrait", SqlDbType.NVarChar, 255);
                groupparam[3].Value = "/images/grouppic.jpg";
                groupparam[4] = new SqlParameter("@Publicity", SqlDbType.Int, 4);
                groupparam[4].Value = (int)EnumGroupPrivacy.ForWholeSite;
                groupparam[5] = new SqlParameter("@PostTime", SqlDbType.DateTime, 8);
                groupparam[5].Value = DateTime.Now;
                groupparam[6] = new SqlParameter("@PostIP", SqlDbType.NVarChar, 15);
                groupparam[6].Value = NetSNS.Common.Public.GetClientIP();
                string Sql = "Insert Into [NT_UserGroup]([GroupName]," +
                             "[UserID],[Members],[Bulletin],[NetWork],[Portrait],[Publicity],[State],[PostTime],[PostIP]) " +
                             "Values" +
                             "(@GroupName,@UserID,1,@GroupName,@NetWork,@Portrait,@Publicity,0,@PostTime,@PostIP);" +
                             "Select @@IDENTITY";
                int GroupID = Convert.ToInt32(DbHelper.ExecuteScalar(trans, CommandType.Text, Sql, groupparam));

                //ȺԱ
                Sql = "Insert Into [NT_GroupMember]([GroupID],[UserID],[JoinTime],[Grade]) " +
                      "Values(" + GroupID + "," + Info.UserID + ",'" + DateTime.Now + "',0)";
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);

                //
                SqlParameter[] albumparam = new SqlParameter[7];
                albumparam[0] = new SqlParameter("@UserID", SqlDbType.Int, 4);
                albumparam[0].Value = Info.UserID;
                albumparam[1] = new SqlParameter("@Title", SqlDbType.NVarChar, 50);
                albumparam[1].Value = Info.clubName;
                albumparam[2] = new SqlParameter("@Description", SqlDbType.NVarChar, 255);
                albumparam[2].Value = Info.clubName;
                albumparam[3] = new SqlParameter("@ImagesCount", SqlDbType.Int, 4);
                albumparam[3].Value = 0;
                albumparam[4] = new SqlParameter("@CreateTime", SqlDbType.DateTime, 8);
                albumparam[4].Value = DateTime.Now;
                albumparam[5] = new SqlParameter("@Privacy", SqlDbType.Int, 4);
                albumparam[5].Value = (int)EnumPrivacy.ForWholeSite;
                albumparam[6] = new SqlParameter("@GroupID", SqlDbType.Int, 4);
                albumparam[6].Value = GroupID;
                Sql = "Insert Into [NT_Album]" +
                      "([UserID],[Title],[Description],[ImagesCount],[CreateTime],[Privacy],[GroupID]) " +
                      "Values(@UserID,@Title,@Description,@ImagesCount,@CreateTime,@Privacy,@GroupID);";
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, albumparam);

                //ӳѻ
                Sql = "Insert Into [NT_CarClub]([UserID],[clubName],[clubDesc],[clubAnnounce]" +
                      ",[ischeck],[GroupID],[privacyFlag],[Province],[City],[CreatTime],[isLock],[isRec]) Values(" +
                      "@UserID,@clubName,@clubDesc,@clubAnnounce,@ischeck," + GroupID + ",@privacyFlag," +
                      "@Province,@City,@CreatTime,@isLock,@isRec);" +
                      "Select @@IDENTITY";
                int ClubID = Convert.ToInt32(DbHelper.ExecuteScalar(trans, CommandType.Text, Sql, param));

                //ӳѻԱ
                Sql = "Insert Into [NT_CarClubUser]([UserID],[ClubID],[isAdmin],[State]) Values(" + Info.UserID + "," + ClubID + ",1,0)";
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                trans.Commit();
                return ClubID;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// ޸ĳѻ
        /// </summary>
        /// <param name="Info">ѻʵ</param>
        /// <returns>޸ĳɹ1</returns>
        public int Edit(CarClubInfo Info)
        {
            SqlParameter[] param = getParameters(Info);
            string Sql = "Update [NT_CarClub] Set [clubDesc]=@clubDesc,[clubAnnounce]=@clubAnnounce," +
                         "[privacyFlag]=@privacyFlag,[Province]=@Province,[City]=@City " +
                         "Where [id]=@id And [UserID]=@UserID";
            return Convert.ToInt32(DbHelper.ExecuteNonQuery(CommandType.Text, Sql, param));
        }

        /// <summary>
        /// ɾѻ(̨)
        /// </summary>
        /// <param name="ID">ѻ</param>
        /// <returns>ɾɹ1</returns>
        public int Del(int ID)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();
            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                //ɾ
                string Sql = "Delete From [NT_CarATCComment] Where [ATCID] In (Select [HID] From [NT_CarATC] Where [CID]=" + ID + ")";
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);

                //ɾ
                Sql = "Delete From [NT_CarATCMember] Where [HID] In (Select [HID] From [NT_CarATC] Where [CID]=" + ID + ")";
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);

                //ɾճ
                Sql = "Delete From [NT_CarATCCal] Where [CID]=" + ID;
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);

                //ɾ
                Sql = "Delete From [NT_CarATC] Where [CID]=" + ID;
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);

                //ɾѳԱ
                Sql = "Delete From [NT_CarClubUser] Where [ClubID]=" + ID;
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);

                //ɾѻ
                Sql = "Delete From [NT_CarClub] Where [id]=" + ID;
                int n = DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);

                trans.Commit();
                return n;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// ɾѻ(ǰ̨)
        /// </summary>
        /// <param name="ID">ѻ</param>
        /// <param name="UserID">Ա</param>
        /// <returns>ɾɹ1</returns>
        public int Del(int ID, int UserID)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();
            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                //жǷڴ˼¼
                string Sql = "Select Count([id]) From [NT_CarClub] Where [id]=" + ID + " And [UserID]=" + UserID;
                int n = Convert.ToInt32(DbHelper.ExecuteScalar(trans, CommandType.Text, Sql, null));
                if (n > 0)
                {
                    //ɾ
                    Sql = "Delete From [NT_CarATCComment] Where [ATCID] In (Select [HID] From [NT_CarATC] Where [CID]=" + ID + ")";
                    DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);

                    //ɾ
                    Sql = "Delete From [NT_CarATCMember] Where [HID] In (Select [HID] From [NT_CarATC] Where [CID]=" + ID + ")";
                    DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);

                    //ɾճ
                    Sql = "Delete From [NT_CarATCCal] Where [CID]=" + ID;
                    DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);

                    //ɾ
                    Sql = "Delete From [NT_CarATC] Where [CID]=" + ID;
                    DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);

                    //ɾѳԱ
                    Sql = "Delete From [NT_CarClubUser] Where [ClubID]=" + ID;
                    DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);

                    //ɾѻ
                    Sql = "Delete From [NT_CarClub] Where [id]=" + ID;
                    DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                }
                trans.Commit();
                return n;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// ѻ
        /// </summary>
        /// <param name="ID">ѻ</param>
        /// <returns>ɹ1</returns>
        public int Lock(int ID)
        {
            string Sql = "Update [NT_CarClub] Set [IsLock]=1 Where [ID]=" + ID;
            return Convert.ToInt32(DbHelper.ExecuteNonQuery(CommandType.Text, Sql, null));
        }

        /// <summary>
        /// ѻ
        /// </summary>
        /// <param name="ID">ѻ</param>
        /// <returns>ɹ1</returns>
        public int UnLock(int ID)
        {
            string Sql = "Update [NT_CarClub] Set [IsLock]=0 Where [ID]=" + ID;
            return Convert.ToInt32(DbHelper.ExecuteNonQuery(CommandType.Text, Sql, null));
        }

        /// <summary>
        /// Ƽѻ
        /// </summary>
        /// <param name="ID">ѻ</param>
        /// <returns>Ƽɹ1</returns>
        public int Rec(int ID)
        {
            string Sql = "Update [NT_CarClub] Set [isRec]=1 Where [ID]=" + ID;
            return Convert.ToInt32(DbHelper.ExecuteNonQuery(CommandType.Text, Sql, null));
        }

        /// <summary>
        /// ȡƼѻ
        /// </summary>
        /// <param name="ID">ѻ</param>
        /// <returns>ȡɹ1</returns>
        public int UnRec(int ID)
        {
            string Sql = "Update [NT_CarClub] Set [isRec]=0 Where [ID]=" + ID;
            return Convert.ToInt32(DbHelper.ExecuteNonQuery(CommandType.Text, Sql, null));
        }

        /// <summary>
        /// ѻϢ
        /// </summary>
        /// <param name="ID">ѻ</param>
        /// <returns>سѻʵ</returns>
        public CarClubInfo Info(int ID)
        {
            CarClubInfo info = new CarClubInfo();
            string Sql = "Select [id],[clubName],[clubDesc],[clubAnnounce]," +
                         "[ischeck],[GroupID],[privacyFlag],[Province],[City],[CreatTime],[isLock],[isRec],[UserID] " +
                         "From " +
                         "[NT_CarClub] " +
                         "Where [id]=" + ID;
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, Sql, null);
            if (rd.Read())
            {
                info.id = Convert.ToInt32(rd["id"].ToString());
                if (rd["clubName"] != DBNull.Value) info.clubName = rd["clubName"].ToString();
                if (rd["clubDesc"] != DBNull.Value) info.clubDesc = rd["clubDesc"].ToString();
                if (rd["clubAnnounce"] != DBNull.Value) info.clubAnnounce = rd["clubAnnounce"].ToString();
                info.ischeck = (EnumIsLock)Convert.ToInt32(rd["ischeck"].ToString());
                info.GroupID = Convert.ToInt32(rd["GroupID"].ToString());
                info.privacyFlag = (EnumCarClubPrivacy)Convert.ToInt32(rd["privacyFlag"].ToString());
                info.Province = Convert.ToInt32(rd["Province"].ToString());
                info.City = Convert.ToInt32(rd["City"].ToString());
                info.CreatTime = Convert.ToDateTime(rd["CreatTime"].ToString());
                info.isLock = (EnumIsLock)Convert.ToInt32(rd["isLock"].ToString());
                info.isRec = Convert.ToInt32(rd["isRec"].ToString());
                info.UserID = Convert.ToInt32(rd["UserID"].ToString());
            }
            rd.Close();
            return info;
        }
        /// <summary>
        /// Ƽѻб
        /// </summary>
        /// <returns></returns>
        public List<CarClubInfo> RecommendClubList()
        {
            List<CarClubInfo> infolist = new List<CarClubInfo>();
            string Sql = "Select [id],[clubName],[clubDesc],[clubAnnounce]," +
                         "[ischeck],[GroupID],[privacyFlag],[Province],[City],[CreatTime],[isLock],[isRec],[UserID] " +
                         "From " +
                         "[NT_CarClub] " +
                         " where isRec=1 ";
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, Sql, null);
            while (rd.Read())
            {
                CarClubInfo info = new CarClubInfo();
                info.id = Convert.ToInt32(rd["id"].ToString());
                if (rd["clubName"] != DBNull.Value) info.clubName = rd["clubName"].ToString();
                if (rd["clubDesc"] != DBNull.Value) info.clubDesc = rd["clubDesc"].ToString();
                if (rd["clubAnnounce"] != DBNull.Value) info.clubAnnounce = rd["clubAnnounce"].ToString();
                info.ischeck = (EnumIsLock)Convert.ToInt32(rd["ischeck"].ToString());
                info.GroupID = Convert.ToInt32(rd["GroupID"].ToString());
                info.privacyFlag = (EnumCarClubPrivacy)Convert.ToInt32(rd["privacyFlag"].ToString());
                info.Province = Convert.ToInt32(rd["Province"].ToString());
                info.City = Convert.ToInt32(rd["City"].ToString());
                info.CreatTime = Convert.ToDateTime(rd["CreatTime"].ToString());
                info.isLock = (EnumIsLock)Convert.ToInt32(rd["isLock"].ToString());
                info.isRec = Convert.ToInt32(rd["isRec"].ToString());
                info.UserID = Convert.ToInt32(rd["UserID"].ToString());
                infolist.Add(info);
            }
            rd.Close();
            return infolist;
        }

        /// <summary>
        /// ȡóѻͷ
        /// </summary>
        /// <param name="clubID">ѻID</param>
        /// <returns></returns>
        public string GetClubPic(int clubID)
        {
            SqlParameter param = new SqlParameter("@clubID", SqlDbType.Int, 4);
            param.Value = clubID;
            string sql = "select Portrait from NT_UserGroup where Groupid=(select groupid from NT_CarClub where id=@clubID)";
            string rs=string.Empty;
            try
            {
                rs = Convert.ToString(DbHelper.ExecuteScalar(CommandType.Text, sql, param));
            }
            catch { }
            return rs;
        }
        /// <summary>
        /// ȡѻƬ
        /// </summary>
        /// <param name="num"></param>
        /// <returns></returns>
        public List<PhotoInfo> NewPhotos(int num)
        {
            List<PhotoInfo> list = new List<PhotoInfo>();
            string sql = "Select top " + num + " [PhotoID],[AlbumID],[Description],[Views],[FileSize]," +
                         "[State],[IsCover],[Comments],[PostTime],[PostIP],[IsLock],[PhotoType],[Width],[Height],[UploadUser]," +
                         "[FilePath] " +
                         "From " +
                         "[NT_Photo] where AlbumID in ((select AlbumID from Nt_Album where GroupID in (select GroupID from NT_carClub)) union (select AlbumID from nt_CarAtcCal)) order by [PhotoID] desc ";
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, sql, null);
            while (rd.Read())
            {
                PhotoInfo info = new PhotoInfo();
                info.PhotoID = Convert.ToInt32(rd["PhotoID"].ToString());
                info.AlbumID = Convert.ToInt32(rd["AlbumID"].ToString());
                if (rd["Description"] != DBNull.Value) info.Description = rd["Description"].ToString();
                info.FileSize = Convert.ToInt32(rd["FileSize"].ToString());
                info.State = Convert.ToInt32(rd["State"].ToString());
                info.IsCover = Convert.ToBoolean(rd["IsCover"].ToString());
                info.Comments = Convert.ToInt32(rd["Comments"].ToString());
                info.PostTime = Convert.ToDateTime(rd["PostTime"].ToString());
                if (rd["PostIP"] != DBNull.Value) info.PostIP = rd["PostIP"].ToString();
                info.IsLock = (EnumIsLock)Convert.ToInt32(Convert.ToBoolean(rd["IsLock"].ToString()));
                info.PhotoType = Convert.ToInt32(rd["PhotoType"].ToString());
                info.Width = Convert.ToInt32(rd["Width"].ToString());
                info.Height = Convert.ToInt32(rd["Height"].ToString());
                info.UploadUser = Convert.ToInt32(rd["UploadUser"].ToString());
                info.Views = Convert.ToInt32(rd["Views"].ToString());
                if (rd["FilePath"] != DBNull.Value) info.FilePath = rd["FilePath"].ToString();
                list.Add(info);
            }
            rd.Dispose();
            return list;
        }
        /// <summary>
        /// ³ѻ
        /// </summary>
        /// <param name="num"></param>
        /// <returns></returns>
        public List<CarClubInfo> NewClub(int num)
        {
            List<CarClubInfo> list = new List<CarClubInfo>();
            string wstr = string.Empty;
            if (num != 0)
                wstr = " top " + num + " ";
            string sql = "Select " + wstr + " [id],[clubName],[clubDesc],[clubAnnounce]," +
                         "[ischeck],[GroupID],[privacyFlag],[Province],[City],[CreatTime],[isLock],[isRec],[UserID] " +
                         "From " +
                         "[NT_CarClub] " +
                         " order by id desc ";
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, sql, null);
            while (rd.Read())
            {
                CarClubInfo info = new CarClubInfo();
                info.id = Convert.ToInt32(rd["id"].ToString());
                if (rd["clubName"] != DBNull.Value) info.clubName = rd["clubName"].ToString();
                if (rd["clubDesc"] != DBNull.Value) info.clubDesc = rd["clubDesc"].ToString();
                if (rd["clubAnnounce"] != DBNull.Value) info.clubAnnounce = rd["clubAnnounce"].ToString();
                info.ischeck = (EnumIsLock)Convert.ToInt32(rd["ischeck"].ToString());
                info.GroupID = Convert.ToInt32(rd["GroupID"].ToString());
                info.privacyFlag = (EnumCarClubPrivacy)Convert.ToInt32(rd["privacyFlag"].ToString());
                info.Province = Convert.ToInt32(rd["Province"].ToString());
                info.City = Convert.ToInt32(rd["City"].ToString());
                info.CreatTime = Convert.ToDateTime(rd["CreatTime"].ToString());
                info.isLock = (EnumIsLock)Convert.ToInt32(rd["isLock"].ToString());
                info.isRec = Convert.ToInt32(rd["isRec"].ToString());
                info.UserID = Convert.ToInt32(rd["UserID"].ToString());
                list.Add(info);
            }
            rd.Close();
            return list;
        }
        /// <summary>
        /// ҵĳѻ
        /// </summary>
        /// <param name="UserID">ûID</param>
        /// <param name="num"></param>
        /// <returns></returns>
        public List<CarClubInfo> MyClub(int UserID, int num)
        {
            List<CarClubInfo> list = new List<CarClubInfo>();
            string wstr = string.Empty;
            if (num != 0)
                wstr = " top " + num + " ";
            string sql = "Select " + wstr + " [id],[clubName],[clubDesc],[clubAnnounce]," +
                         "[ischeck],[GroupID],[privacyFlag],[Province],[City],[CreatTime],[isLock],[isRec],[UserID] " +
                         "From " +
                         "[NT_CarClub] " +
                         " where id in (select clubid from NT_CarClubUser where userid=" + UserID + ") order by id desc ";
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, sql, null);
            while (rd.Read())
            {
                CarClubInfo info = new CarClubInfo();
                info.id = Convert.ToInt32(rd["id"].ToString());
                if (rd["clubName"] != DBNull.Value) info.clubName = rd["clubName"].ToString();
                if (rd["clubDesc"] != DBNull.Value) info.clubDesc = rd["clubDesc"].ToString();
                if (rd["clubAnnounce"] != DBNull.Value) info.clubAnnounce = rd["clubAnnounce"].ToString();
                info.ischeck = (EnumIsLock)Convert.ToInt32(rd["ischeck"].ToString());
                info.GroupID = Convert.ToInt32(rd["GroupID"].ToString());
                info.privacyFlag = (EnumCarClubPrivacy)Convert.ToInt32(rd["privacyFlag"].ToString());
                info.Province = Convert.ToInt32(rd["Province"].ToString());
                info.City = Convert.ToInt32(rd["City"].ToString());
                info.CreatTime = Convert.ToDateTime(rd["CreatTime"].ToString());
                info.isLock = (EnumIsLock)Convert.ToInt32(rd["isLock"].ToString());
                info.isRec = Convert.ToInt32(rd["isRec"].ToString());
                info.UserID = Convert.ToInt32(rd["UserID"].ToString());
                list.Add(info);
            }
            rd.Close();
            return list;
        }
        /// <summary>
        /// 캯
        /// </summary>
        /// <param name="Info">ѻʵ</param>
        /// <returns>SQL</returns>
        private SqlParameter[] getParameters(CarClubInfo Info)
        {
            SqlParameter[] param = new SqlParameter[13];

            param[0] = new SqlParameter("@id", SqlDbType.Int, 4);
            param[0].Value = Info.id;
            param[1] = new SqlParameter("@clubName", SqlDbType.NVarChar, 100);
            param[1].Value = Info.clubName;
            param[2] = new SqlParameter("@clubDesc", SqlDbType.NVarChar, 2000);
            param[2].Value = Info.clubDesc;

            param[3] = new SqlParameter("@clubAnnounce", SqlDbType.NVarChar, 200);
            param[3].Value = Info.clubAnnounce;
            param[4] = new SqlParameter("@ischeck", SqlDbType.Int, 4);
            param[4].Value = Info.ischeck;
            param[5] = new SqlParameter("@GroupID", SqlDbType.Int, 4);
            param[5].Value = Info.GroupID;
            /** Ҫ
            param[6] = new SqlParameter("@AlbumID", SqlDbType.Int, 4);
            param[6].Value = Info.AlbumID;*/
            param[6] = new SqlParameter("@privacyFlag", SqlDbType.Int, 4);
            param[6].Value = (int)Info.privacyFlag;
            param[7] = new SqlParameter("@Province", SqlDbType.Int, 4);
            param[7].Value = Info.Province;

            param[8] = new SqlParameter("@City", SqlDbType.Int, 4);
            param[8].Value = Info.City;
            param[9] = new SqlParameter("@CreatTime", SqlDbType.DateTime, 8);
            param[9].Value = Info.CreatTime;
            param[10] = new SqlParameter("@isLock", SqlDbType.Int, 4);
            param[10].Value = (int)Info.isLock;

            param[11] = new SqlParameter("@isRec", SqlDbType.Int, 4);
            param[11].Value = Info.isRec;
            param[12] = new SqlParameter("@UserID", SqlDbType.Int, 4);
            param[12].Value = Info.UserID;
            return param;
        }
    }
}
