using System;
using System.Collections.Generic;
using System.Data;
using System.Collections;
using System.Data.Common;
using System.Data.SqlClient;
using NetSNS.DALProfile;
using NetSNS.DALFactory;
using NetSNS.Model;
using NetSNS.Config;

namespace NetSNS.DALSQLServer
{
    /// <summary>
    /// ᾰ
    /// </summary>
    public class CarClubAreaIntro : DbBase, ICarClubAreaIntro
    {
        /// <summary>
        /// ӳѾ
        /// </summary>
        /// <param name="Info">Ѿʵ</param>
        /// <returns>Ѵڴƾͷ-1,ӳɹ1</returns>
        public int Add(CarClubAreaIntroInfo Info)
        {
            SqlParameter[] param = getParameters(Info);
            string Sql = "Select Count([ID]) From [NT_CarClubAreaIntro] Where [AreaName]=@AreaName";
            int n = Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, Sql, param));
            if (n == 0)
            {
                Sql = "Insert Into [NT_CarClubAreaIntro]([AreaName],[Intro]) Values(@AreaName,@Intro)";
                return Convert.ToInt32(DbHelper.ExecuteNonQuery(CommandType.Text, Sql, param));
            }
            else
            {
                return -1;
            }
        }

        /// <summary>
        /// ޸ĳѾ
        /// </summary>
        /// <param name="Info">Ѿʵ</param>
        /// <returns>Ѵڴƾͷ-1,޸ĳɹ1</returns>
        public int Edit(CarClubAreaIntroInfo Info)
        {
            SqlParameter[] param = getParameters(Info);
            string Sql = "Select Count([ID]) From [NT_CarClubAreaIntro] Where [AreaName]=@AreaName And [ID]!=@ID";
            int n = Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, Sql, param));
            if (n == 0)
            {
                Sql = "Update [NT_CarClubAreaIntro] Set [AreaName]=@AreaName,[Intro]=@Intro Where [ID]=@ID";
                return Convert.ToInt32(DbHelper.ExecuteNonQuery(CommandType.Text, Sql, param));
            }
            else
            {
                return -1;
            }
        }

        /// <summary>
        /// ɾѾ
        /// </summary>
        /// <param name="ID">Ѿ</param>
        /// <returns>ɾɹ1</returns>
        public int Del(int ID)
        {
            string Sql = "Delete From [NT_CarClubAreaIntro] Where [ID]=" + ID;
            return Convert.ToInt32(DbHelper.ExecuteNonQuery(CommandType.Text, Sql, null));
        }

        /// <summary>
        /// ȡб
        /// </summary>
        /// <returns>ؾб</returns>
        public List<CarClubAreaIntroInfo> List()
        {
            List<CarClubAreaIntroInfo> list = new List<CarClubAreaIntroInfo>();
            CarClubAreaIntroInfo info = new CarClubAreaIntroInfo();
            string Sql = "Select [ID],[AreaName],[Intro] From [NT_CarClubAreaIntro]";
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, Sql, null);
            if (rd.Read())
            {
                info.ID = Convert.ToInt32(rd["ID"].ToString());
                if (rd["AreaName"] != DBNull.Value) info.AreaName = rd["AreaName"].ToString();
                if (rd["Intro"] != DBNull.Value) info.Intro = rd["Intro"].ToString();
                list.Add(info);
            }
            rd.Close();
            return list;
        }

        /// <summary>
        /// ѾϢ
        /// </summary>
        /// <param name="ID">Ѿܱ</param>
        /// <returns>سѾʵ</returns>
        public CarClubAreaIntroInfo Info(int ID)
        {
            CarClubAreaIntroInfo info = new CarClubAreaIntroInfo();
            string Sql = "Select [ID],[AreaName],[Intro] " +
                         "From " +
                         "[NT_CarClubAreaIntro] " +
                         "Where [ID]=" + ID;
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, Sql, null);
            if (rd.Read())
            {
                info.ID = Convert.ToInt32(rd["ID"].ToString());
                if (rd["AreaName"] != DBNull.Value) info.AreaName = rd["AreaName"].ToString();
                if (rd["Intro"] != DBNull.Value) info.Intro = rd["Intro"].ToString();
            }
            rd.Close();
            return info;
        }

        /// <summary>
        /// 캯
        /// </summary>
        /// <param name="Info">Ѿʵ</param>
        /// <returns>SQL</returns>
        private SqlParameter[] getParameters(CarClubAreaIntroInfo Info)
        {
            SqlParameter[] param = new SqlParameter[3];

            param[0] = new SqlParameter("@ID", SqlDbType.Int, 4);
            param[0].Value = Info.ID;
            param[1] = new SqlParameter("@AreaName", SqlDbType.NVarChar, 100);
            param[1].Value = Info.AreaName;
            param[2] = new SqlParameter("@Intro", SqlDbType.NText);
            param[2].Value = Info.Intro;

            return param;
        }
    }
}
