using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Common;
using System.Data.SqlClient;
using NetSNS.DALProfile;
using NetSNS.DALFactory;
using NetSNS.Model;
using NetSNS.Config;

namespace NetSNS.DALSQLServer
{
    /// <summary>
    /// ѻԱ
    /// </summary>
    public class CarClubUser : DbBase, ICarClubUser
    {
        /// <summary>
        /// ӳѻԱ
        /// </summary>
        /// <param name="Info">ѻԱʵ</param>
        /// <returns>ӳɹ1</returns>
        public int Add(CarClubUserInfo Info)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();
            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                SqlParameter[] param = getParameters(Info);
                //жǷѴڴ˼¼
                string Sql = "Select Count([ID]) From [NT_CarClubUser] Where [UserID]=@UserID And [ClubID]=@ClubID";
                int n = Convert.ToInt32(DbHelper.ExecuteScalar(trans, CommandType.Text, Sql, param));
                if (n == 0)
                {
                    Sql = "Insert Into [NT_CarClubUser]([UserID],[ClubID],[isAdmin],[State]) Values(@UserID,@ClubID,@isAdmin,@State)";
                    n = Convert.ToInt32(DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, param));
                }
                //ȺԱ
                if (Info.State == 0)
                {
                    Sql = "Select [GroupID] From [NT_CarClub] Where [id]=" + Info.ClubID;
                    int GroupID = Convert.ToInt32(DbHelper.ExecuteScalar(trans, CommandType.Text, Sql, null));
                    //ӵȺԱ
                    Sql = "Select Count([ID]) From [NT_GroupMember] Where [GroupID]=" + GroupID + " And [UserID]=" + Info.UserID;
                    int count = Convert.ToInt32(DbHelper.ExecuteScalar(trans, CommandType.Text, Sql, null));
                    if (count == 0)
                    {
                        Sql = "Insert Into [NT_GroupMember]([GroupID],[UserID],[JoinTime],[Grade]) " +
                              "Values" +
                              "(" + GroupID + "," + Info.UserID + ",'" + DateTime.Now + "',2)";
                        DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                    }
                    Sql = "Update [NT_UserGroup] Set [Members]=[Members]+1 Where [GroupID]=" + GroupID;
                    DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                }
                trans.Commit();
                return n;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// ɾѻԱ
        /// </summary>
        /// <param name="UserID">û</param>
        /// <param name="ClubID">ѻ</param>
        /// <returns>ɾɹ1</returns>
        public int Del(int UserID, int ClubID)
        {
            string Sql = "Delete From [NT_CarClubUser] Where [UserID]=" + UserID + " And [ClubID]=" + ClubID;
            return Convert.ToInt32(DbHelper.ExecuteNonQuery(CommandType.Text, Sql, null));
        }

        /// <summary>
        /// óѻԱ
        /// </summary>
        /// <param name="UserID">Ա</param>
        /// <param name="ClubID">ѻ</param>
        /// <returns>óɹ1</returns>
        public int SetAdmin(int UserID, int ClubID)
        {
            string Sql = "Update [NT_CarClubUser] Set [isAdmin]=1 Where [UserID]=" + UserID + " And [ClubID]=" + ClubID;
            return Convert.ToInt32(DbHelper.ExecuteNonQuery(CommandType.Text, Sql, null));
        }

        /// <summary>
        /// ɾѻԱ
        /// </summary>
        /// <param name="UserID">Ա</param>
        /// <param name="ClubID">ѻ</param>
        /// <returns>óɹ1</returns>
        public int DelAdmin(int UserID, int ClubID)
        {
            string Sql = "Update [NT_CarClubUser] Set [isAdmin]=0 Where [UserID]=" + UserID + " And [ClubID]=" + ClubID;
            return Convert.ToInt32(DbHelper.ExecuteNonQuery(CommandType.Text, Sql, null));
        }

        /// <summary>
        /// ͨû
        /// </summary>
        /// <param name="UserID">Ա</param>
        /// <param name="ClubID">ѻ</param>
        /// <returns>˳ɹ1</returns>
        public int Adopt(int UserID, int ClubID)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();
            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                string Sql = "Update [NT_CarClubUser] Set [State]=0 Where [UserID]=" + UserID + " And [ClubID]=" + ClubID;
                int n = Convert.ToInt32(DbHelper.ExecuteNonQuery(CommandType.Text, Sql, null));

                Sql = "Select [GroupID] From [NT_CarClub] Where [id]=" + ClubID;
                int GroupID = Convert.ToInt32(DbHelper.ExecuteScalar(trans, CommandType.Text, Sql, null));

                //ӵȺԱ
                Sql = "Select Count([ID]) From [NT_GroupMember] Where [GroupID]=" + GroupID + " And [UserID]=" + UserID;
                int count = Convert.ToInt32(DbHelper.ExecuteScalar(trans, CommandType.Text, Sql, null));
                if (count == 0)
                {
                    Sql = "Insert Into [NT_GroupMember]([GroupID],[UserID],[JoinTime],[Grade]) " +
                          "Values" +
                          "(" + GroupID + "," + UserID + ",'" + DateTime.Now + "',2)";
                    DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                }
                Sql = "Update [NT_UserGroup] Set [Members]=[Members]+1 Where [GroupID]=" + GroupID;
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);

                return n;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// ˻ԱǲǹԱ
        /// </summary>
        /// <param name="UserID">Ա</param>
        /// <param name="ClubID">ѻ</param>
        /// <returns></returns>
        public bool isAdmin(int UserID, int ClubID)
        {
            bool tf = false;
            string Sql = "Select Count([ID]) From [NT_CarClubUser] Where [UserID]=" + UserID + " And isAdmin=1 And [ClubID]=" + ClubID;
            int n = Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, Sql, null));
            if (n > 0)
                tf = true;
            return tf;
        }

        /// <summary>
        /// ˻ԱǲǴ˳ѻԱ
        /// </summary>
        /// <param name="UserID">Ա</param>
        /// <param name="ClubID">ѻ</param>
        /// <returns></returns>
        public bool isClubUser(int UserID, int ClubID)
        {
            bool tf = false;
            string Sql = "Select Count([ID]) From [NT_CarClubUser] Where [UserID]=" + UserID + " And [ClubID]=" + ClubID;
            int n = Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, Sql, null));
            if (n > 0)
                tf = true;
            return tf;
        }

        /// <summary>
        /// ˻Աͨû
        /// </summary>
        /// <param name="UserID">Ա</param>
        /// <param name="ClubID">ѻ</param>
        /// <returns></returns>
        public bool IsAdopt(int UserID, int ClubID)
        {
            bool tf = false;
            string Sql = "Select [State] From [NT_CarClubUser] Where [UserID]=" + UserID + " And [ClubID]=" + ClubID;
            int n = Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, Sql, null));
            if (n == 0)
                tf = true;
            return tf;
        }


        /// <summary>
        /// ѻԱ
        /// </summary>
        /// <param name="ID">ѻ</param>
        /// <returns>سѻԱ</returns>
        public int Count(int ClubID)
        {
            string Sql = "Select Count([ID]) From [NT_CarClubUser] Where [ClubID]=" + ClubID + " And [State]=0";
            return Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, Sql, null));
        }

        /// <summary>
        /// û˶ٸѻ
        /// </summary>
        /// <param name="UserID">Ա</param>
        /// <returns>ظ</returns>
        public int UserClubCount(int UserID)
        {
            string Sql = "Select Count([ID]) From [NT_CarClubUser] Where [UserID]=" + UserID;
            return Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, Sql, null));
        }

        /// <summary>
        /// ȡùԱб
        /// </summary>
        /// <param name="ClubID">ѻ</param>
        /// <returns>ݱ</returns>
        public DataTable AdminList(int ClubID)
        {
            string Sql = "Select a.[UserID],b.[UserName],c.[Name] From " +
                         "[NT_CarClubUser] As a Inner Join [NT_User] As b On a.[UserID]=b.[UserID] " +
                         "Inner Join [NT_Dict_Area] as c On b.[Province]=c.[ID] " +
                         "Where a.[ClubID]=" + ClubID + " And a.[State]=0 And a.[isAdmin]=1";
            return DbHelper.ExecuteTable(CommandType.Text, Sql, null);
        }

        /// <summary>
        /// ȡóԱб
        /// </summary>
        /// <param name="ClubID">ѻ</param>
        /// <returns>ݱ</returns>
        public DataTable UserList(int ClubID)
        {
            string Sql = "Select a.[UserID],b.[UserName],c.[Name],d.[FilePath] From " +
                         "[NT_CarClubUser] as a Inner Join [NT_User] as b ON a.[userid]=b.[userid] " +
                         "Inner Join [NT_Dict_Area] as c ON b.[Province]=c.[id] " +
                         "Left Join [Nt_Photo] as d On b.[Portrait]=d.[PhotoID] And d.[IsLock]=0 " +
                         "Where a.[ClubID]=" + ClubID + " And  a.[State]=0";
            return DbHelper.ExecuteTable(CommandType.Text, Sql, null);
        }


        /// <summary>
        /// ѻԱϢ
        /// </summary>
        /// <param name="ID">ѻԱ</param>
        /// <returns>سѻԱʵ</returns>
        public CarClubUserInfo Info(int ID)
        {
            CarClubUserInfo info = new CarClubUserInfo();
            string Sql = "Select [ID],[UserID],[ClubID],[isAdmin],[State]" +
                         "From " +
                         "[NT_CarClubUser] " +
                         "Where [ID]=" + ID;
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, Sql, null);
            if (rd.Read())
            {
                info.ID = Convert.ToInt32(rd["ID"].ToString());
                info.UserID = Convert.ToInt32(rd["UserID"].ToString());
                info.ClubID = Convert.ToInt32(rd["ClubID"].ToString());
                info.isAdmin = Convert.ToInt32(rd["isAdmin"].ToString());
                info.State = Convert.ToInt32(rd["State"].ToString());
            }
            rd.Close();
            return info;
        }

        /// <summary>
        /// 캯
        /// </summary>
        /// <param name="Info">ѻԱʵ</param>
        /// <returns>SQL</returns>
        private SqlParameter[] getParameters(CarClubUserInfo Info)
        {
            SqlParameter[] param = new SqlParameter[5];

            param[0] = new SqlParameter("@ID", SqlDbType.Int, 4);
            param[0].Value = Info.ID;
            param[1] = new SqlParameter("@UserID", SqlDbType.Int, 4);
            param[1].Value = Info.UserID;
            param[2] = new SqlParameter("@ClubID", SqlDbType.Int, 4);
            param[2].Value = Info.ClubID;
            param[3] = new SqlParameter("@isAdmin", SqlDbType.Int, 4);
            param[3].Value = Info.isAdmin;
            param[4] = new SqlParameter("@State", SqlDbType.Int, 4);
            param[4].Value = Info.State;

            return param;
        }
    }
}
