using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Common;
using System.Data.SqlClient;
using NetSNS.DALProfile;
using NetSNS.DALFactory;
using NetSNS.Model;
using NetSNS.Config;

namespace NetSNS.DALSQLServer
{
    /// <summary>
    /// ̼
    /// </summary>
    public class Company : DbBase, ICompany
    {
        /// <summary>
        /// ̼Ϣ
        /// </summary>
        /// <param name="Info">̼ʵ</param>
        /// <returns>ظ-1ɹ1</returns>
        public int Add(CompanyInfo Info)
        {
            SqlParameter[] param = getParameters(Info);
            string Sql = "Select Count([ID]) From [NT_Company] Where [ComPanyName]=@ComPanyName And [Province]=@Province";
            int n = Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, Sql, param));
            if (n > 0)
                return -1;
            Sql = "Insert Into [NT_Company]([ComPanyName],[Intro],[Tel],[Contact],[Address],[Province]) Values" +
                  "(@ComPanyName,@Intro,@Tel,@Contact,@Address,@Province)";
            return Convert.ToInt32(DbHelper.ExecuteNonQuery(CommandType.Text, Sql, param));
        }

        /// <summary>
        /// ޸̼Ϣ
        /// </summary>
        /// <param name="Info">̼ʵ</param>
        /// <returns>ظ-1ɹ1</returns>
        public int Edit(CompanyInfo Info)
        {
            SqlParameter[] param = getParameters(Info);
            string Sql = "Select Count([ID]) From [NT_Company] Where [ComPanyName]=@ComPanyName And [Province]=@Province And [ID]!=@ID";
            int n = Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, Sql, param));
            if (n > 0)
                return -1;
            Sql = "Update [NT_Company] " +
                  "Set " +
                  "[ComPanyName]=@ComPanyName,[Intro]=@Intro,[Tel]=@Tel,[Contact]=@Contact,[Address]=@Address,[Province]=@Province " +
                  "Where [ID]=@ID";
            return Convert.ToInt32(DbHelper.ExecuteNonQuery(CommandType.Text, Sql, param));
        }

        /// <summary>
        /// ɾ̼
        /// </summary>
        /// <param name="ID">̼ұ</param>
        public void Del(int ID)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();
            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                //ɾ̼ұ
                string Sql = "Delete From [NT_Company] Where [ID]=" + ID;
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);

                //ɾ
                Sql = "Delete From [NT_Ads] Where [CompanyID]=" + ID;
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);

                trans.Commit();
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// ƥб
        /// </summary>
        /// <param name="key">ؼ</param>
        /// <returns>б</returns>
        public List<CompanyInfo> List(string key)
        {
            List<CompanyInfo> list = new List<CompanyInfo>();
            string Sql = "Select [ID],[ComPanyName],[Intro],[Tel],[Contact],[Address],[Province] From [NT_Company] "+
                         "Where [ComPanyName] Like '%" + key + "%'";
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, Sql, null);
            while (rd.Read())
            {
                CompanyInfo info = new CompanyInfo();
                info.ID = Convert.ToInt32(rd["ID"].ToString());
                if (rd["ComPanyName"] != DBNull.Value) info.ComPanyName = rd["ComPanyName"].ToString();
                if (rd["Intro"] != DBNull.Value) info.Intro = rd["Intro"].ToString();
                if (rd["Tel"] != DBNull.Value) info.Tel = rd["Tel"].ToString();
                if (rd["Contact"] != DBNull.Value) info.Contact = rd["Contact"].ToString();
                if (rd["Address"] != DBNull.Value) info.Address = rd["Address"].ToString();
                info.Province = Convert.ToInt32(rd["Province"].ToString());
                list.Add(info);
            }
            rd.Close();
            return list;
        }

        /// <summary>
        /// Ϣ
        /// </summary>
        /// <param name="ID"></param>
        /// <returns>عʵ</returns>
        public CompanyInfo Info(int ID)
        {
            CompanyInfo info = new CompanyInfo();
            string Sql = "Select [ID],[ComPanyName],[Intro],[Tel],[Contact],[Address],[Province] " +
                         "From " +
                         "[NT_Company] " +
                         "Where [ID]=" + ID;
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, Sql, null);
            if (rd.Read())
            {
                info.ID = Convert.ToInt32(rd["ID"].ToString());
                if (rd["ComPanyName"] != DBNull.Value) info.ComPanyName = rd["ComPanyName"].ToString();
                if (rd["Intro"] != DBNull.Value) info.Intro = rd["Intro"].ToString();
                if (rd["Tel"] != DBNull.Value) info.Tel = rd["Tel"].ToString();
                if (rd["Contact"] != DBNull.Value) info.Contact = rd["Contact"].ToString();
                if (rd["Address"] != DBNull.Value) info.Address = rd["Address"].ToString();
                info.Province = Convert.ToInt32(rd["Province"].ToString());
            }
            rd.Close();
            return info;
        }

        /// <summary>
        /// 캯
        /// </summary>
        /// <param name="Info">̼ʵ</param>
        /// <returns>SQL</returns>
        private SqlParameter[] getParameters(CompanyInfo Info)
        {
            SqlParameter[] param = new SqlParameter[7];

            param[0] = new SqlParameter("@ID", SqlDbType.Int, 4);
            param[0].Value = Info.ID;
            param[1] = new SqlParameter("@ComPanyName", SqlDbType.NVarChar, 100);
            param[1].Value = Info.ComPanyName;
            param[2] = new SqlParameter("@Intro", SqlDbType.NText);
            param[2].Value = Info.Intro;

            param[3] = new SqlParameter("@Tel", SqlDbType.NVarChar, 50);
            param[3].Value = Info.Tel;
            param[4] = new SqlParameter("@Contact", SqlDbType.NVarChar, 50);
            param[4].Value = Info.Contact;
            param[5] = new SqlParameter("@Address", SqlDbType.NVarChar, 200);
            param[5].Value = Info.Address;

            param[6] = new SqlParameter("@Province", SqlDbType.Int, 4);
            param[6].Value = Info.Province;
            return param;
        }
    }
}
