﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.Common;
using System.Data.SqlClient;
using NetSNS.Config;
using NetSNS.DALProfile;
using NetSNS.Model;
using NetSNS.Common;

namespace NetSNS.DALSQLServer
{
    /// <summary>
    /// 数据库公共处理基类
    /// </summary>
    public class DbBase : IDbBase, ICommon
    {
        /// <summary>
        /// 建立SqlCommand对象
        /// </summary>
        /// <returns></returns>
        DbCommand IDbBase.CreateCommand()
        {
            return new SqlCommand();
        }
        /// <summary>
        /// 建立SqlConnection对象
        /// </summary>
        /// <returns></returns>
        DbConnection IDbBase.CreateConnection()
        {
            return new SqlConnection();
        }
        /// <summary>
        /// 创建SqlDataAdapter对象
        /// </summary>
        /// <returns></returns>
        DbDataAdapter IDbBase.CreateDataAdapter()
        {
            return new SqlDataAdapter();
        }
        /// <summary>
        /// 建立SqlParameter对象
        /// </summary>
        /// <returns></returns>
        DbParameter IDbBase.CreateParameter()
        {
            return new SqlParameter();
        }
        /// <summary>
        /// 构造函数
        /// </summary>
        public DbBase()
        {
            DbHelper.Provider = this;
        }

        /// <summary>
        /// 写用户日志
        /// </summary>
        /// <param name="trans"></param>
        /// <param name="action">操作类型</param>
        /// <param name="userid">操作人</param>
        /// <param name="description">操作描述</param>
        /// <param name="correspondid">被操作的ID</param>
        /// <returns></returns>
        //public int UserLog(SqlTransaction trans, EnumUserAction action, int userid, string description, params int[] correspondid)
        //{
        //    return UserLog(trans, action, userid,description, 0, correspondid);
        //}

        /// <summary>
        /// 写用户日志
        /// </summary>
        /// <param name="trans"></param>
        /// <param name="action">操作类型</param>
        /// <param name="userid">操作人</param>
        /// <param name="description">操作描述</param>
        /// <param name="correspondid">被操作的ID   信息ID，用户ID</param>
        /// <returns></returns>
        public int UserLog(SqlTransaction trans, EnumUserAction action, int userid, string description, params int[] correspondid)
        {
            string SqlLog = "insert into NT_UserLog (UserID,ActionType,LogTime,LogIP,Description,CorrespondInfo,CorreUserID) values (";
            SqlLog += userid + "," + (int)action + ",'" + DateTime.Now + "','" + Public.GetClientIP() + "',@Description,";
            switch (correspondid.Length)
            {
                case 1:
                    SqlLog += correspondid[0] + ",0";
                    break;
                case 2:
                    SqlLog += correspondid[0] + "," + correspondid[1];
                    break;
                default:
                    SqlLog += correspondid[0] + ",0";
                    break;
            }
            SqlLog += ")";
            SqlParameter Param = new SqlParameter("@Description", SqlDbType.NVarChar, 255);
            if (description != null && description.Trim() != string.Empty)
                Param.Value = description;
            else
                Param.Value = DBNull.Value;
            if (trans == null)
                return DbHelper.ExecuteNonQuery(CommandType.Text, SqlLog, Param);
            else
                return DbHelper.ExecuteNonQuery(trans, CommandType.Text, SqlLog, Param);
        }
        /// <summary>
        /// 管理员操作日志
        /// </summary>
        /// <param name="Trans"></param>
        /// <param name="action"></param>
        /// <returns></returns>
        public int AdminLog(SqlTransaction Trans, EnumAdminAction action)
        {
            return 0;
        }
        /// <summary>
        /// 发送一个请求
        /// </summary>
        /// <param name="trans"></param>
        /// <param name="reqtype"></param>
        /// <param name="sender"></param>
        /// <param name="receiver"></param>
        /// <param name="correspondid"></param>
        /// <returns></returns>
        public int SendRequest(SqlTransaction trans, EnumRequestType reqtype, int sender, int receiver, params int[] correspondid)
        {
            string Sql = "insert into NT_Request (Receiver,Demander,RequestType,Content,PostTime,PostIP,ReplyResult,CorrespondInfo) values (";
            Sql += receiver + "," + sender + "," + (int)reqtype + ",'','" + DateTime.Now + "','" + Public.GetClientIP() + "'," + (int)EnumReply.NoneReply + ",";
            if (correspondid != null && correspondid.Length == 1)
                Sql += correspondid[0];
            else
                Sql += "null";
            Sql += ")";
            if (trans == null)
                return DbHelper.ExecuteNonQuery(CommandType.Text, Sql, null);
            else
                return DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
        }
        /// <summary>
        /// 发送一个通知
        /// </summary>
        /// <param name="trans"></param>
        /// <param name="notifytype"></param>
        /// <param name="sender">发送通知的人（引发通知的人）</param>
        /// <param name="receiver"></param>
        /// <param name="notice">可以为空</param>
        /// <param name="correspondid"></param>
        /// <returns></returns>
        public int Notify(SqlTransaction trans, EnumNotifyType notifytype, int sender, int receiver, string notice, params int[] correspondid)
        {
            string Sql = "insert into NT_Notice (Receiver,Content,IsRead,MsgType,PostTime,PostIP,Sender,Correspond,IsLock) values (";
            Sql += receiver + ",@Content,0," + (int)notifytype + ",'" + DateTime.Now + "','" + Public.GetClientIP() + "'," + sender + ",";
            if (correspondid != null && correspondid.Length == 1)
                Sql += correspondid[0];
            else
                Sql += "null";
            Sql += ",0)";
            SqlParameter Param = new SqlParameter("@Content", SqlDbType.NVarChar, 255);
            if (notice != null && notice.Trim() != string.Empty)
                Param.Value = notice;
            else
                Param.Value = DBNull.Value;
            if (trans == null)
                return DbHelper.ExecuteNonQuery(CommandType.Text, Sql, Param);
            else
                return DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, Param);
        }

        /// <summary>
        /// 检查用户是否具有某种权限
        /// </summary>
        /// <param name="cn">已打开的数据库连接对象</param>
        /// <param name="privacy">权限类型</param>
        /// <param name="guest">等待验证的是否有权限的用户ID</param>
        /// <param name="host">主体者的ID</param>
        /// <returns>guest有权限返回true,否则返回false</returns>
        public bool CheckPrivacy(SqlConnection cn, EnumPrivacy privacy, int guest, int host)
        {
            if (guest == host)
                return true;
            switch (privacy)
            {
                case EnumPrivacy.ForWholeSite:
                    return true;
                case EnumPrivacy.ForNetWorkAndFriends:
                    if (Friend.IsFriends(cn, host, guest))
                        return true;
                    else
                        return false;
                case EnumPrivacy.ForFriends:
                    if (Friend.IsInSameNetwork(cn, host, guest))
                        return true;
                    else
                    {
                        if (Friend.IsFriends(cn, host, guest))
                            return true;
                        else
                            return false;
                    }
                case EnumPrivacy.ForOwner:
                    if (guest == host)
                        return true;
                    else
                        return false;
                default:
                    return false;
            }
        }
    }
}
