using System;
using System.Collections.Generic;
using System.Text;
using NetSNS.DALFactory;
using System.Data;
using System.Data.SqlClient;
using NetSNS.DALProfile;
using NetSNS.Model;
using NetSNS.Config;

namespace NetSNS.DALSQLServer
{
    public class Financial : DbBase, IFinancial
    {
        /// <summary>
        /// ӼͥԱ
        /// </summary>
        /// <param name="ID">Ա</param>
        /// <param name="UserID">Ա</param>
        /// <param name="Name"></param>
        /// <param name="Sex">Ա</param>
        /// <param name="Birthday"></param>
        /// <param name="bl">ʶtrue ӣfalse:</param>
        /// <returns></returns>
        public int InsertUpDateFamily(int ID,int UserID,string Name, int Sex, string Birthday,bool bl)
        {
            SqlParameter[] param = new SqlParameter[5];
            param[0] = new SqlParameter("@Name", SqlDbType.NVarChar, 50);
            param[0].Value = Name;
            param[1] = new SqlParameter("@Sex", SqlDbType.Int, 4);
            param[1].Value = Sex;
            param[2] = new SqlParameter("@Birthday", SqlDbType.DateTime,8);
            param[2].Value = Birthday;
            param[3] = new SqlParameter("@ID", SqlDbType.Int, 4);
            param[3].Value = ID;
            param[4] = new SqlParameter("@UserID", SqlDbType.Int,4);
            param[4].Value = UserID;
            string sql = string.Empty;

            if (bl)
            {
                sql = "select Name from NT_Family where Name=@Name";
            }
            else
            {
                sql = "select Name from NT_Family where Name=@Name and ID<>@ID";
            }

            object obj = DbHelper.ExecuteScalar(CommandType.Text, sql, param);//ǷڸüͥԱ¼
            if (!Convert.IsDBNull(obj) && obj != null)
            {
                return 2;
            }
            
            sql = "update NT_Family set Name=@Name,Sex=@Sex,Birthday=@Birthday where ID=@ID";

            if (bl)
            {
                sql = "insert into NT_Family(UserID,Name,Sex,Birthday) values(@UserID,@Name,@Sex,@Birthday)";
            }
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, param);
        }

        /// <summary>
        /// ɾͥ
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public int DelFamily(int ID)
        {
            SqlParameter param = new SqlParameter("@ID", ID);
            string sql = "delete from NT_Family where ID=@ID";
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, param);
        }

        /// <summary>
        /// ݼͥԱŻȡԱϢ
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public IDataReader getFamilyByID(int ID)
        {
            SqlParameter param = new SqlParameter("@ID", ID);
            string sql = "select ID,Name,Sex,Birthday from NT_Family where ID=@ID";
            return DbHelper.ExecuteReader(CommandType.Text, sql, param);
        }

        /// <summary>
        /// ɾϢ
        /// </summary>
        /// <param name="ID">ͱ</param>
        /// <param name="value"></param>
        /// <param name="flag"></param>
        /// <returns></returns>
        public int LockDelFinancial(int ID, int value, int flag)
        {
            SqlConnection cn = new SqlConnection(DBConfig.CnString);
            cn.Open();
            try
            {
                SqlParameter param = new SqlParameter("@ID", ID);
                string sql = "";
                if (flag == 0)//ɾ
                {
                    //жϵǷʹù
                    sql = "select ExpenditureOne,ExpenditureTwo from NT_Financial where ExpenditureOne=@ID or ExpenditureTwo=@ID";
                    object obj = DbHelper.ExecuteScalar(cn, CommandType.Text, sql, param);

                    if (!Convert.IsDBNull(obj) && obj != null)
                    {
                        //Ѿù
                        return 2;
                    }

                    sql = "select ID from NT_FinancialType where ParentID=@ID";//жǷ
                    object objs = DbHelper.ExecuteScalar(cn, CommandType.Text, sql, param);

                    if (!Convert.IsDBNull(objs) && objs != null)
                    {
                        //
                        return 3;
                    }

                    sql = "delete  from NT_FinancialType where ID=@ID";
                }
                else if (flag == 1)//
                {
                    sql = "update NT_FinancialType set IsLock=" + value + " where ID=@ID";
                }
                return DbHelper.ExecuteNonQuery(cn, CommandType.Text, sql, param);
            }
            finally
            {
                if (cn.State == ConnectionState.Open)
                    cn.Close();
            }
        }

        /// <summary>
        /// ȡƷ
        /// </summary>
        /// <param name="ID">ID</param>
        /// <returns></returns>
        public DataTable getFinancialType(int ID)
        {
            SqlParameter param = new SqlParameter("@ID", ID);
            string sql = "select ID,UserID,ParentID,Name,Type,IsLock from NT_FinancialType where ParentID=@ID";
            return DbHelper.ExecuteTable(CommandType.Text, sql, param);
        }

        /// <summary>
        /// ݱŶȡƷ
        /// </summary>
        /// <param name="ID">ͱ</param>
        /// <returns></returns>
        public IDataReader getFinancialByID(int ID)
        {
            SqlParameter param = new SqlParameter("@ID", ID);
            string sql = "select ID,UserID,ParentID,Name,Type,IsLock from NT_FinancialType where ID=@ID";
            return DbHelper.ExecuteReader(CommandType.Text, sql, param);
        }

        /// <summary>
        /// Ӹ
        /// </summary>
        /// <param name="ID"></param>
        /// <param name="ParentID">ID</param>
        /// <param name="Name"></param>
        /// <param name="Type">0֧1</param>
        /// <param name="bl">trueӣfalse:</param>
        /// <returns></returns>
        public int AddUpFinancialType(int ID,int UserID,int ParentID,string Name,int Type,bool bl)
        {
            SqlConnection cn = new SqlConnection(DBConfig.CnString);
            cn.Open();
            try
            {
                //жǷظ
                string sql = null;
                SqlParameter[] param = new SqlParameter[5];
                param[0] = new SqlParameter("@ID", SqlDbType.Int, 4);
                param[0].Value = ID;
                param[1] = new SqlParameter("@ParentID", SqlDbType.Int, 4);
                param[1].Value = ParentID;
                param[2] = new SqlParameter("@Name", SqlDbType.NVarChar,50);
                param[2].Value = Name;
                param[3] = new SqlParameter("@Type", SqlDbType.Int, 4);
                param[3].Value = Type;
                param[4] = new SqlParameter("@UserID", SqlDbType.Int, 4);
                param[4].Value = UserID;

                if (bl)//
                {
                    sql = "select Name from NT_FinancialType where Name=@Name";
                    object obj = DbHelper.ExecuteScalar(cn, CommandType.Text, sql, param);//Ƿڸͼ¼
                    if (!Convert.IsDBNull(obj) && obj != null)
                    {
                        return 2;
                    }
                    else
                    {
                        sql = "insert into NT_FinancialType(UserID,ParentID,Name,Type,IsLock) values(@UserID,@ParentID,@Name,@Type,0)";
                    }
                }
                else//޸
                {
                    sql = "select Name from NT_FinancialType where Name=@Name and ID<>@ID";
                    object obj = DbHelper.ExecuteScalar(cn, CommandType.Text, sql, param);//Ƿڸͼ¼
                    if (!Convert.IsDBNull(obj) && obj != null)
                    {
                        return 2;
                    }
                    else
                    {
                        sql = "update NT_FinancialType set Name=@Name,Type=@Type where ID=@ID";
                    }
                }
                return DbHelper.ExecuteNonQuery(cn, CommandType.Text, sql, param);
            }
            finally
            {
                if (cn.State == ConnectionState.Open)
                    cn.Close();
            }
        }

        /// <summary>
        /// ɾˮ
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public int DelFinancial(int ID)
        {
            SqlParameter param = new SqlParameter("@ID", ID);
            string sql = "delete from NT_Financial where ID=@ID";
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, param);
        }

        /// <summary>
        /// ˮ
        /// <param name="bl">ʶtrue ӣfalse:</param>
        /// <returns></returns>
        public int InsertUpDateFinancial(NetSNS.Model.FinancialInfo Info, bool bl)
        {
            SqlConnection sqlConn = new SqlConnection(DBConfig.CnString);
            sqlConn.Open();
            SqlTransaction trans = sqlConn.BeginTransaction();
            try
            {
                SqlParameter[] param = getParameters(Info);
                string sql = string.Empty;
                EnumUserAction action = EnumUserAction.Financial;

                sql = "update NT_Financial set ExpenditureOne=@ExpenditureOne,ExpenditureTwo=@ExpenditureTwo,Amount=@Amount,Type=@Type,Family=@Family,UseTime=@UseTime,Note=@Note where ID=@ID";

                if (bl)
                {
                    sql = "insert into NT_Financial(UserID,ExpenditureOne,ExpenditureTwo,Amount,Type,Family,UseTime,Note) values(@UserID,@ExpenditureOne,@ExpenditureTwo,@Amount,@Type,@Family,@UseTime,@Note)";
                }
                int n=DbHelper.ExecuteNonQuery(trans,CommandType.Text, sql, param);

                if (n == 1)
                {
                    if (bl)
                    {
                        sql = "select top 1 ID from NT_Financial where UserID=@UserID order by ID desc";
                        int id = int.Parse(Convert.ToString(DbHelper.ExecuteScalar(trans, CommandType.Text, sql, param)));
                        n = UserLog(trans, action, Info.UserID, "ˮ", id);
                    }
                }
                trans.Commit();
                return n;
            }
            catch (SqlException sqlEx)
            {
                trans.Rollback();
                throw sqlEx;
            }
            finally
            {
                if (sqlConn.State == ConnectionState.Open)
                    sqlConn.Close();
            }
        }

        /// <summary>
        /// 캯 
        /// </summary>
        /// <param name="Info">Ϣ</param>
        /// <returns>SQL</returns>
        private SqlParameter[] getParameters(NetSNS.Model.FinancialInfo Info)
        {
            SqlParameter[] param = new SqlParameter[9];

            param[0] = new SqlParameter("@ID", SqlDbType.Int, 4);
            param[0].Value = Info.ID;
            param[1] = new SqlParameter("@UserID", SqlDbType.Int,4);
            param[1].Value = Info.UserID;
            param[2] = new SqlParameter("@ExpenditureOne", SqlDbType.Int, 4);
            param[2].Value = Info.ExpenditureOne;
            param[3] = new SqlParameter("@ExpenditureTwo", SqlDbType.Int, 4);
            param[3].Value = Info.ExpenditureTwo;
            param[4] = new SqlParameter("@Amount", SqlDbType.NVarChar,50);
            param[4].Value = Info.Amount;
            param[5] = new SqlParameter("@Type", SqlDbType.Int,4);
            param[5].Value = Info.Type;
            param[6] = new SqlParameter("@Family", SqlDbType.Int, 4);
            param[6].Value = Info.Family;
            param[7] = new SqlParameter("@UseTime", SqlDbType.DateTime,8);
            param[7].Value = Info.UseTime;
            param[8] = new SqlParameter("@Note", SqlDbType.NVarChar, 100);
            param[8].Value = Info.Note;
            return param;
        }

        /// <summary>
        /// ȡˮ
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public IDataReader getFinancial(int ID)
        {
            SqlParameter param = new SqlParameter("@ID", ID);
            string sql = "select UserID,ExpenditureOne,ExpenditureTwo,Amount,Type,Family,UseTime,Note from NT_Financial where ID=@ID";
            return DbHelper.ExecuteReader(CommandType.Text, sql, param);
        }

        /// <summary>
        /// ݻԱŶȡƷ
        /// </summary>
        /// <param name="ID">ID</param>
        /// <param name="UserID">Ա</param>
        /// <returns></returns>
        public DataTable getFinancialByUserID(int ID,int UserID)
        {
            SqlParameter[] param = new SqlParameter[2];
            param[0] = new SqlParameter("@ID", SqlDbType.Int, 4);
            param[0].Value =ID;
            param[1] = new SqlParameter("@UserID", SqlDbType.Int, 4);
            param[1].Value =UserID;

            string sql = "select ID,UserID,ParentID,Name,Type,IsLock from NT_FinancialType where (UserID=@UserID or UserID=0) and ParentID=@ID";
            return DbHelper.ExecuteTable(CommandType.Text,sql,param);
        }

        /// <summary>
        /// ݻԱŶȡͥԱ
        /// </summary>
        /// <param name="UserID"></param>
        /// <returns></returns>
        public DataTable getFamilyByUserID(int UserID)
        {
            SqlParameter param = new SqlParameter("@UserID", UserID);
            string sql = "select ID,Name,Sex,Birthday from NT_Family where UserID=@UserID";
            return DbHelper.ExecuteTable(CommandType.Text, sql, param);
        }

        /// <summary>
        /// ȡˮϢ̬ʾʱã
        /// </summary>
        /// <param name="ID">ˮʱ</param>
        /// <returns></returns>
        public IDataReader getFinancialDByID(int ID)
        {
            SqlParameter[] param = new SqlParameter[1];
            param[0] = new SqlParameter("@ID", SqlDbType.Int, 4);
            param[0].Value = ID;
            string sql = "select a.ID,LogTime=a.UseTime,a.Note,a.Amount,a.Type,Name=case a.Type when '0' then '֧' when '1' then '' end,FamilyName=(select b.Name from NT_Family b where b.ID=a.Family),ExpenditureTwo=(select c.Name from NT_FinancialType c where c.ID=a.ExpenditureTwo) from NT_Financial a  where ID=@ID  order by a.ID desc";
            return DbHelper.ExecuteReader(CommandType.Text, sql, param);
        }
    }
}
