using System;
using System.Collections.Generic;
using System.Text;
using NetSNS.DALFactory;
using NetSNS.Model;
using System.Data.SqlClient;
using System.Data;
using NetSNS.DALProfile;

namespace NetSNS.DALSQLServer
{
    public class FootPrint:DbBase,IFootPrint
    {
        /// <summary>
        /// ӻ㼣
        /// </summary>
        /// <param name="info">㼣ʵ</param>
        /// <returns></returns>
        public int Add(PrintFootInfo info)
        {
            SqlParameter[] parm = getParameters(info);
            string sql = "insert into NT_FootPrint(X,Y,Name,Content,ArrivedTime,AddTime,Zoom,UserID) values(@X,@Y,@Name,@Content,@ArrivedTime,@AddTime,@Zoom,@UserID)";
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, parm);
        }
        /// <summary>
        /// ɾ㼣
        /// </summary>
        /// <param name="ID">㼣</param>
        /// <returns></returns>
        public int Delete(int ID)
        {
            SqlParameter param = new SqlParameter("@ID", SqlDbType.Int, 4);
            param.Value = ID;
            string sql = "delete from NT_FootPrint where ID=@ID";
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, param);
        }
        /// <summary>
        /// ȡĳ˻㼣
        /// </summary>
        /// <param name="UserID">ûID</param>
        /// <returns></returns>
        public List<PrintFootInfo> List(int UserID)
        {
            List<PrintFootInfo> list = new List<PrintFootInfo>();
            SqlParameter param = new SqlParameter("@UserID", SqlDbType.Int, 4);
            param.Value = UserID;
            string sql = "select ID,X,Y,Name,Content,ArrivedTime,AddTime,Zoom,UserID from NT_FootPrint where UserID=@UserID";
            IDataReader dr = DbHelper.ExecuteReader(CommandType.Text, sql, param);
            while (dr.Read())
            {
                PrintFootInfo info = new PrintFootInfo();
                info.ID = dr.GetInt32(0);
                info.X = dr.IsDBNull(1) ? "" : dr.GetString(1);
                info.Y = dr.IsDBNull(2) ? "" : dr.GetString(2);
                info.Name = dr.IsDBNull(3) ? "" : dr.GetString(3);
                info.Content = dr.IsDBNull(4) ? "" : dr.GetString(4);
                info.ArrivedTime = dr.GetDateTime(5);
                info.AddTime = dr.GetDateTime(6);
                info.Zoom = dr.IsDBNull(7) ? 0 : dr.GetInt32(7);
                info.UserID = dr.IsDBNull(8) ? 0 : dr.GetInt32(8);
                list.Add(info);
            }
            return list;
        }
        /// <summary>
        /// ȡĳ㼣Ϣ
        /// </summary>
        /// <param name="ID">㼣</param>
        /// <returns></returns>
        public PrintFootInfo GetInfo(int ID)
        {
            SqlParameter param = new SqlParameter("@ID", SqlDbType.Int, 4);
            param.Value = ID;
            PrintFootInfo info = new PrintFootInfo();
            string sql = "select ID,X,Y,Name,Content,ArrivedTime,AddTime,Zoom,UserID from NT_FootPrint where ID=@ID";
            IDataReader dr = DbHelper.ExecuteReader(CommandType.Text, sql, param);
            if (dr.Read())
            {
                info.ID = dr.GetInt32(0);
                info.X = dr.IsDBNull(1) ? "" : dr.GetString(1);
                info.Y = dr.IsDBNull(2) ? "" : dr.GetString(2);
                info.Name = dr.IsDBNull(3) ? "" : dr.GetString(3);
                info.Content = dr.IsDBNull(4) ? "" : dr.GetString(4);
                info.ArrivedTime = dr.GetDateTime(5);
                info.AddTime = dr.GetDateTime(6);
                info.Zoom = dr.IsDBNull(7) ? 0 : dr.GetInt32(7);
                info.UserID = dr.IsDBNull(8) ? 0 : dr.GetInt32(8);
            }
            return info;
        }
        /// <summary>
        /// ǷѴڴ
        /// </summary>
        /// <param name="userid">ûID</param>
        /// <param name="x"></param>
        /// <param name="y">γ</param>
        /// <returns></returns>
        public bool Exist(int userid, string x, string y)
        {
            SqlParameter[] param = new SqlParameter[3];
            param[0] = new SqlParameter("@UserId", SqlDbType.Int, 4);
            param[0].Value = userid;
            param[1] = new SqlParameter("@X", SqlDbType.NVarChar, 50);
            param[1].Value = x;
            param[2] = new SqlParameter("@Y", SqlDbType.NVarChar, 50);
            param[2].Value = y;
            string sql = "select count(id) from NT_FootPrint where userid=@UserId and x=@X and Y=@Y";
            int tn = Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, sql, param));
            return tn > 0 ? true : false;
        }
        /// <summary>
        /// SQL
        /// </summary>
        /// <param name="Info">ʵ</param>
        /// <returns></returns>
        private SqlParameter[] getParameters(PrintFootInfo Info)
        {
            SqlParameter[] param = new SqlParameter[9];
            param[0] = new SqlParameter("@ID", SqlDbType.Int, 4);
            param[0].Value = Info.ID;
            param[1] = new SqlParameter("@X", SqlDbType.NVarChar, 50);
            param[1].Value = Info.X;
            param[2] = new SqlParameter("@Y", SqlDbType.NVarChar, 50);
            param[2].Value = Info.Y;
            param[3] = new SqlParameter("@Name", SqlDbType.NVarChar, 50);
            param[3].Value = Info.Name;
            param[4] = new SqlParameter("@Content", SqlDbType.NVarChar, 2000);
            param[4].Value = Info.Content;
            param[5] = new SqlParameter("@ArrivedTime", SqlDbType.DateTime, 8);
            param[5].Value = Info.ArrivedTime;
            param[6] = new SqlParameter("@AddTime", SqlDbType.DateTime, 8);
            param[6].Value = Info.AddTime;
            param[7] = new SqlParameter("@Zoom", SqlDbType.Int, 4);
            param[7].Value = Info.Zoom;
            param[8] = new SqlParameter("@UserID", SqlDbType.Int, 4);
            param[8].Value = Info.UserID;
            return param;
        }
    }
}
