//===========================================================
//==               (c)2008  NETSNS 1.0                     ==
//==            website:www.aspxcms.com                    ==
//==         qq:6458450,Email:qwsf01115@163.com            ==
//==               Code By Xi.Deng                         ==
//===========================================================
using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Common;
using System.Data.SqlClient;
using NetSNS.DALProfile;
using NetSNS.DALFactory;
using NetSNS.Model;
using NetSNS.Config;

namespace NetSNS.DALSQLServer
{
    /// <summary>
    /// Ⱥ
    /// </summary>
    public class GroupDiscuss : DbBase, IGroupDiscuss
    {
        /// <summary>
        /// 
        /// </summary>
        /// <param name="Info">Ⱥʵ</param>
        /// <returns>ӳɹ1</returns>
        public int Add(GroupDiscussInfo Info)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();

            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                try
                {
                    SqlParameter[] param = getParameters(Info);
                    string Sql = "Insert Into [NT_GroupDiscuss]([GroupID]," +
                                 "[UserID],[Topic],[Content],[DiscussType],[BelongTopic],[PostTime],[PostIP],[Replys]," +
                                 "[State],[TopNum],[SeriesNum])Values" +
                                 "(@GroupID,@UserID,@Topic,@Content,@DiscussType,@BelongTopic,@PostTime,@PostIP,@Replys,@State," +
                                 "@TopNum,@SeriesNum)" +
                                 "Select @@IDENTITY";
                    int ID = Convert.ToInt32(DbHelper.ExecuteScalar(trans, CommandType.Text, Sql, param));

                    int n = UserLog(trans, EnumUserAction.AddTopic, Info.UserID, "", ID);
                    trans.Commit();
                    User us = new User();
                    us.updateinte(Info.UserID, 2, 0, 0, "Ⱥ鷢");
                    return n;
                }
                catch (SqlException e)
                {
                    trans.Rollback();
                    throw e;
                }
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// ޸Ϣ
        /// </summary>
        /// <param name="Content"></param>
        /// <param name="UserID">Ա</param>
        /// <param name="ID">ظ</param>
        /// <returns>޸ĳɹ1</returns>
        public int Edit(string Content, int UserID, int ID)
        {
            SqlParameter[] param = new SqlParameter[5];
            param[0] = new SqlParameter("@Content", SqlDbType.NVarChar, 4000);
            param[0].Value = Content;
            param[1] = new SqlParameter("@UserID", SqlDbType.Int, 4);
            param[1].Value = UserID;
            param[2] = new SqlParameter("@ID", SqlDbType.Int, 4);
            param[2].Value = ID;
            param[3] = new SqlParameter("@LastModifyTime", SqlDbType.DateTime, 8);
            param[3].Value = DateTime.Now;
            param[4] = new SqlParameter("@LastModifyIP", SqlDbType.VarChar, 15);
            param[4].Value = NetSNS.Common.Public.GetClientIP();

            string Sql = "Update [NT_GroupDiscuss] " +
                         "Set " +
                         "[Content]=@Content,[LastModifyTime]=@LastModifyTime,[LastModifyIP]=@LastModifyIP " +
                         "Where " +
                         "[ID]=@ID And [UserID]=@UserID";
            return DbHelper.ExecuteNonQuery(CommandType.Text, Sql, param);
        }

        /// <summary>
        /// ɾ(̨)
        /// </summary>
        /// <param name="ID"></param>
        /// <returns>ɾɹ1</returns>
        public int Del(int ID)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();

            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                GroupDiscussInfo Info = new GroupDiscussInfo();
                GroupDiscuss discuss = new GroupDiscuss();
                Info = discuss.Info(ID);
                //־
                int n = UserLog(trans, EnumUserAction.DelReply, 0, "ɾظ", ID);
                //Ⱥ־״̬Ϊ
                string Sql = "Update [NT_UserLog] " +
                      "Set " +
                      "[IsLock]=" + (int)EnumIsLock.Lock + " " +
                      "Where " +
                      "([CorrespondInfo]=" + ID + " And " +
                            "([ActionType]=" + (int)EnumUserAction.AddTopic + " Or " +
                                "[ActionType]=" + (int)EnumUserAction.ReTopic + " Or [ActionType]=" + (int)EnumUserAction.DelTopic + " " +
                                " Or [ActionType]=" + (int)EnumUserAction.DelReply + "))";
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);

                if (ID == Info.BelongTopic)
                    Sql = "Delete From [NT_GroupDiscuss]  Where [BelongTopic]=" + ID;
                else
                    Sql = "Update [NT_GroupDiscuss] Set [State]=3 Where [ID]=" + ID;
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);

                trans.Commit();
                return n;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// ɾ(ǰ̨)
        /// </summary>
        /// <param name="ID"></param>
        /// <param name="UserID">Ա</param>
        /// <returns>Ӱ¼</returns>
        public int Del(int ID, int UserID)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();

            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                GroupDiscussInfo Info = new GroupDiscussInfo();
                GroupDiscuss discuss = new GroupDiscuss();
                Info = discuss.Info(ID);
                string Sql = "";
                int n = 0;
                bool tf = false;
                if (Info.BelongTopic == 0)
                {
                    tf = true;
                    Sql = "Delete From [NT_GroupDiscuss]  Where [ID]=" + ID;
                }
                else
                {
                    Sql = "Update [NT_GroupDiscuss] Set [State]=3 Where [ID]=" + ID + " And [UserID]=" + UserID;
                }
                n = Convert.ToInt32(DbHelper.ExecuteScalar(trans, CommandType.Text, Sql, null));
                if (n > 0)
                {
                    //־
                    if (tf)
                        n = UserLog(trans, EnumUserAction.DelTopic, UserID, "ɾ", ID);
                    else
                        n = UserLog(trans, EnumUserAction.DelReply, UserID, "ɾظ", ID);
                    //Ⱥ־״̬Ϊ
                    Sql = "Update [NT_UserLog] " +
                          "Set " +
                          "[IsLock]=" + EnumIsLock.Lock + " " +
                          "Where " +
                          "([CorrespondInfo]=" + ID + " And " +
                                "([ActionType]=" + (int)EnumUserAction.AddTopic + " Or " +
                                    "[ActionType]=" + (int)EnumUserAction.ReTopic + " Or [ActionType]=" + (int)EnumUserAction.DelTopic + "" +
                                    " Or [ActionType]=" + (int)EnumUserAction.DelReply + "))";
                    DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                    if (tf)
                    {
                        //ɾ
                        Sql = "Delete From [NT_GroupDiscuss] " +
                              "Where " +
                              "[BelongTopic]=" + ID;
                        DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                    }
                }
                trans.Commit();
                User us = new User();
                us.updateinte(UserID, 2, 0, 1, "ɾ");

                return n;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// ظ
        /// </summary>
        /// <param name="Info">Ⱥʵ</param>
        /// <returns>ظɹ1</returns>
        public int Replay(GroupDiscussInfo Info)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();

            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                GroupDiscussInfo tempinfo = this.Info(Info.BelongTopic);

                SqlParameter[] param = getParameters(Info);
                string Sql = "Insert Into [NT_GroupDiscuss]([GroupID],[Topic]," +
                             "[UserID],[Content],[DiscussType],[BelongTopic],[PostTime],[PostIP]," +
                             "[SeriesNum],[Replys],[State],[ReplyTack])" +
                             "Values" +
                             "(@GroupID,@Topic,@UserID,@Content,@DiscussType,@BelongTopic,@PostTime,@PostIP," +
                             "@SeriesNum,@Replys,@State,@ReplyTack)" +
                             "Select @@IDENTITY";
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, param);

                Sql = "Update [NT_GroupDiscuss] Set [LastPostTime]=@LastPostTime,[LastPostIP]=@LastPostIP," +
                      "[LastPoster]=@UserID,[Replys]=[Replys]+1 Where ID=@BelongTopic";
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, param);

                //жǷѷ⣬֪ͨ
                if (tempinfo.UserID != Info.UserID)
                    Notify(trans, EnumNotifyType.ReGroupTopic, Info.UserID, tempinfo.UserID, "ظ", Info.BelongTopic);

                int n = UserLog(trans, EnumUserAction.ReTopic, Info.UserID, "ظ", Info.BelongTopic);
                trans.Commit();
                User us = new User();
                us.updateinte(Info.UserID, 1, 0, 0, "ظ");
                return n;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="ID"></param>
        /// <returns>ɹ1</returns>
        public int Lock(int ID)
        {
            string Sql = "Update [NT_GroupDiscuss] " +
                         "Set [State]=" + EnumIsLock.Lock + " Where [BelongTopic]=" + ID;
            return DbHelper.ExecuteNonQuery(CommandType.Text, Sql, null);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="ID"></param>
        /// <returns>ɹ1</returns>
        public int UnLock(int ID)
        {
            string Sql = "Update [NT_GroupDiscuss] " +
                         "Set [State]=" + EnumIsLock.UnLock + " Where [BelongTopic]=" + ID;
            return DbHelper.ExecuteNonQuery(CommandType.Text, Sql, null);
        }

        /// <summary>
        /// ö
        /// </summary>
        /// <param name="ID"></param>
        /// <returns>öɹ1</returns>
        public int Top(int ID)
        {
            string Sql = "Update [NT_GroupDiscuss] " +
                         "Set [TopNum]=1 Where [ID]=" + ID;
            return DbHelper.ExecuteNonQuery(CommandType.Text, Sql, null);
        }

        /// <summary>
        /// ȡö
        /// </summary>
        /// <param name="ID"></param>
        /// <returns>ȡöɹ1</returns>
        public int UnTop(int ID)
        {
            string Sql = "Update [NT_GroupDiscuss] " +
                         "Set [TopNum]=0 Where [ID]=" + ID;
            return DbHelper.ExecuteNonQuery(CommandType.Text, Sql, null);
        }

        /// <summary>
        /// ȡϢ
        /// </summary>
        /// <param name="ID">ӱ</param>
        /// <returns>Ⱥʵ</returns>
        public GroupDiscussInfo Info(int ID)
        {
            GroupDiscussInfo info = new GroupDiscussInfo();
            string Sql = "Select [ID],[GroupID],[UserID],[Topic],[Content],[DiscussType]," +
                         "[LastModifyTime],[BelongTopic],[PostTime],[PostIP],[LastPostTime],[LastPostIP],[LastPoster],[Replys],[State]," +
                         "[LastModifyIP],[ReplyID],[ReplyTack],[SeriesNum],[TopNum]" +
                         "From " +
                         "[NT_GroupDiscuss] " +
                         "Where [ID]=" + ID;
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, Sql, null);
            if (rd.Read())
            {
                info.ID = Convert.ToInt32(rd["ID"].ToString());
                info.GroupID = Convert.ToInt32(rd["GroupID"].ToString());
                info.UserID = Convert.ToInt32(rd["UserID"].ToString());
                if (rd["Topic"] != DBNull.Value) info.Topic = rd["Topic"].ToString();
                if (rd["Content"] != DBNull.Value) info.Content = rd["Content"].ToString();
                info.DiscussType = Convert.ToInt32(rd["DiscussType"].ToString());
                if (rd["LastModifyTime"] != DBNull.Value) info.LastModifyTime = Convert.ToDateTime(rd["LastModifyTime"].ToString());
                info.BelongTopic = Convert.ToInt32(rd["BelongTopic"].ToString());
                info.PostTime = Convert.ToDateTime(rd["PostTime"].ToString());
                if (rd["PostIP"] != DBNull.Value) info.PostIP = rd["PostIP"].ToString();
                if (rd["LastPostTime"] != DBNull.Value) info.LastPostTime = Convert.ToDateTime(rd["LastPostTime"].ToString());
                if (rd["LastPostIP"] != DBNull.Value) info.LastPostIP = rd["LastPostIP"].ToString();
                if (rd["LastPoster"] != DBNull.Value) info.LastPoster = Convert.ToInt32(rd["LastPoster"].ToString());
                info.Replys = Convert.ToInt32(rd["Replys"].ToString());
                info.State = Convert.ToInt32(rd["State"].ToString());
                if (rd["LastModifyIP"] != DBNull.Value) info.LastModifyIP = rd["LastModifyIP"].ToString();
                if (rd["ReplyID"] != DBNull.Value) info.ReplyID = Convert.ToInt32(rd["ReplyID"].ToString());
                if (rd["ReplyTack"] != DBNull.Value) info.ReplyTack = rd["ReplyTack"].ToString();
                if (rd["SeriesNum"] != DBNull.Value) info.SeriesNum = Convert.ToInt32(rd["SeriesNum"].ToString());
                info.TopNum = Convert.ToInt32(rd["TopNum"].ToString());
            }
            rd.Close();
            return info;
        }

        /// <summary>
        /// ȡϢ
        /// </summary>
        /// <param name="GroupID">Ⱥ</param>
        /// <returns>Ⱥʵ</returns>
        public GroupDiscussInfo GroupNewTopic(int GroupID)
        {
            GroupDiscussInfo info = new GroupDiscussInfo();
            string Sql = "Select Top 1 [ID],[GroupID],[UserID],[Topic],[Content],[DiscussType]," +
                         "[LastModifyTime],[BelongTopic],[PostTime],[PostIP],[LastPostTime],[LastPostIP],[LastPoster],[Replys],[State]," +
                         "[LastModifyIP],[ReplyID],[ReplyTack],[SeriesNum],[TopNum]" +
                         "From " +
                         "[NT_GroupDiscuss] " +
                         "Where [GroupID]=" + GroupID + " And BelongTopic=0 Order By [ID] Desc";
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, Sql, null);
            if (rd.Read())
            {
                info.ID = Convert.ToInt32(rd["ID"].ToString());
                info.GroupID = Convert.ToInt32(rd["GroupID"].ToString());
                info.UserID = Convert.ToInt32(rd["UserID"].ToString());
                if (rd["Topic"] != DBNull.Value) info.Topic = rd["Topic"].ToString();
                if (rd["Content"] != DBNull.Value) info.Content = rd["Content"].ToString();
                info.DiscussType = Convert.ToInt32(rd["DiscussType"].ToString());
                if (rd["LastModifyTime"] != DBNull.Value) info.LastModifyTime = Convert.ToDateTime(rd["LastModifyTime"].ToString());
                info.BelongTopic = Convert.ToInt32(rd["BelongTopic"].ToString());
                info.PostTime = Convert.ToDateTime(rd["PostTime"].ToString());
                if (rd["PostIP"] != DBNull.Value) info.PostIP = rd["PostIP"].ToString();
                if (rd["LastPostTime"] != DBNull.Value) info.LastPostTime = Convert.ToDateTime(rd["LastPostTime"].ToString());
                if (rd["LastPostIP"] != DBNull.Value) info.LastPostIP = rd["LastPostIP"].ToString();
                if (rd["LastPoster"] != DBNull.Value) info.LastPoster = Convert.ToInt32(rd["LastPoster"].ToString());
                info.Replys = Convert.ToInt32(rd["Replys"].ToString());
                info.State = Convert.ToInt32(rd["State"].ToString());
                if (rd["LastModifyIP"] != DBNull.Value) info.LastModifyIP = rd["LastModifyIP"].ToString();
                if (rd["ReplyID"] != DBNull.Value) info.ReplyID = Convert.ToInt32(rd["ReplyID"].ToString());
                if (rd["ReplyTack"] != DBNull.Value) info.ReplyTack = rd["ReplyTack"].ToString();
                if (rd["SeriesNum"] != DBNull.Value) info.SeriesNum = Convert.ToInt32(rd["SeriesNum"].ToString());
                info.TopNum = Convert.ToInt32(rd["TopNum"].ToString());
            }
            rd.Close();
            return info;
        }



        /// <summary>
        /// 캯
        /// </summary>
        /// <param name="Info">Ⱥʵ</param>
        /// <returns>SQL</returns>
        private SqlParameter[] getParameters(GroupDiscussInfo Info)
        {
            SqlParameter[] param = new SqlParameter[20];

            param[0] = new SqlParameter("@ID", SqlDbType.Int, 4);
            param[0].Value = Info.ID;
            param[1] = new SqlParameter("@GroupID", SqlDbType.Int, 4);
            param[1].Value = Info.GroupID;
            param[2] = new SqlParameter("@UserID", SqlDbType.Int, 4);
            param[2].Value = Info.UserID;

            param[3] = new SqlParameter("@Topic", SqlDbType.NVarChar, 40);
            param[3].Value = Info.Topic;
            param[4] = new SqlParameter("@Content", SqlDbType.NVarChar, 4000);
            param[4].Value = Info.Content;
            param[5] = new SqlParameter("@DiscussType", SqlDbType.Int, 4);
            param[5].Value = Info.DiscussType;

            param[6] = new SqlParameter("@BelongTopic", SqlDbType.Int, 4);
            param[6].Value = Info.BelongTopic;
            param[7] = new SqlParameter("@PostTime", SqlDbType.DateTime, 8);
            param[7].Value = Info.PostTime;
            param[8] = new SqlParameter("@PostIP", SqlDbType.VarChar, 15);
            param[8].Value = Info.PostIP;

            param[9] = new SqlParameter("@LastPostTime", SqlDbType.DateTime, 8);
            param[9].Value = Info.LastPostTime;
            param[10] = new SqlParameter("@LastPostIP", SqlDbType.VarChar, 15);
            param[10].Value = Info.LastPostIP;
            param[11] = new SqlParameter("@LastPoster", SqlDbType.Int, 4);
            param[11].Value = Info.LastPoster;

            param[12] = new SqlParameter("@Replys", SqlDbType.Int, 4);
            param[12].Value = Info.Replys;
            param[13] = new SqlParameter("@State", SqlDbType.Int, 4);
            param[13].Value = Info.State;
            param[14] = new SqlParameter("@LastModifyTime", SqlDbType.DateTime, 8);
            param[14].Value = Info.LastModifyTime;

            param[15] = new SqlParameter("@LastModifyIP", SqlDbType.VarChar, 15);
            param[15].Value = Info.LastModifyIP;
            param[16] = new SqlParameter("@ReplyID", SqlDbType.Int, 4);
            param[16].Value = Info.ReplyID;
            param[17] = new SqlParameter("@ReplyTack", SqlDbType.NVarChar, 100);
            param[17].Value = Info.ReplyTack;

            param[18] = new SqlParameter("@SeriesNum", SqlDbType.Int, 4);
            param[18].Value = Info.SeriesNum;
            param[19] = new SqlParameter("@TopNum", SqlDbType.Int, 4);
            param[19].Value = Info.TopNum;
            return param;
        }
    }
}
