//===========================================================
//==               (c)2008  NETSNS 1.0                     ==
//==            website:www.aspxcms.com                    ==
//==         qq:6458450,Email:qwsf01115@163.com            ==
//==               Code By Xi.Deng                         ==
//===========================================================
using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Common;
using System.Data.SqlClient;
using NetSNS.DALProfile;
using NetSNS.DALFactory;
using NetSNS.Model;
using NetSNS.Config;

namespace NetSNS.DALSQLServer
{
    /// <summary>
    /// Ⱥ
    /// </summary>
    public class GroupInvite : DbBase, IGroupInvite
    {
        /// <summary>
        /// ()Ⱥ
        /// </summary>
        /// <param name="Info">Ⱥʵ</param>
        /// <returns>ӳɹ1</returns>
        public int Add(GroupInviteInfo Info)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();

            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                int n = 0;
                SqlParameter[] param = getParameters(Info);
                string Sql = "Select Count([ID]) From [NT_GroupInvite] Where [GroupID]=@GroupID And " +
                             "[JoinUserID]=@JoinUserID And [UserID]=@UserID";
                int cnt = Convert.ToInt32(DbHelper.ExecuteScalar(trans, CommandType.Text, Sql, param));

                if (cnt > 0)
                {
                    Sql = "Update [NT_GroupInvite] Set [Response]=0 " +
                          "Where [GroupID]=@GroupID And [JoinUserID]=@JoinUserID And [UserID]=@UserID";
                }
                else
                {
                    Sql = "Insert Into [NT_GroupInvite]([GroupID],[JoinUserID]," +
                          "[UserID],[Postscript],[PostTime],[PostIP],[InviteFlag]) " +
                          "Values(@GroupID,@JoinUserID,@UserID,@Postscript,@PostTime,@PostIP,@InviteFlag)";
                }
                n = Convert.ToInt32(DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, param));
                trans.Commit();
                return n;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// ظ()Ⱥ
        /// </summary>
        /// <param name="Info">Ⱥʵ</param>
        /// <returns>ظɹ1</returns>
        public int Reponse(GroupInviteInfo Info)
        {
            SqlParameter[] param = getParameters(Info);
            string Sql = "Update  [NT_GroupInvite] " +
                         "Set [Response]=@Response,[RespTime]=@RespTime,[RespIP]=@RespIP " +
                         "Where [GroupID]=@GroupID And [JoinUserID]=@JoinUserID";
            return DbHelper.ExecuteNonQuery(CommandType.Text, Sql, param);
        }

        /// <summary>
        /// 캯
        /// </summary>
        /// <param name="Info">Ⱥʵ</param>
        /// <returns>SQL</returns>
        private SqlParameter[] getParameters(GroupInviteInfo Info)
        {
            SqlParameter[] param = new SqlParameter[11];

            param[0] = new SqlParameter("@ID", SqlDbType.Int, 4);
            param[0].Value = Info.ID;
            param[1] = new SqlParameter("@GroupID", SqlDbType.Int, 4);
            param[1].Value = Info.GroupID;
            param[2] = new SqlParameter("@JoinUserID", SqlDbType.Int, 4);
            param[2].Value = Info.JoinUserID;

            param[3] = new SqlParameter("@UserID", SqlDbType.Int, 4);
            param[3].Value = Info.UserID;
            param[4] = new SqlParameter("@Postscript", SqlDbType.NVarChar, 255);
            param[4].Value = Info.Postscript;
            param[5] = new SqlParameter("@PostTime", SqlDbType.DateTime, 8);
            param[5].Value = Info.PostTime;

            param[6] = new SqlParameter("@PostIP", SqlDbType.VarChar, 15);
            param[6].Value = Info.PostIP;
            param[7] = new SqlParameter("@Response", SqlDbType.Int, 4);
            param[7].Value = Info.Response;
            param[8] = new SqlParameter("@RespTime", SqlDbType.DateTime, 8);
            param[8].Value = Info.RespTime;

            param[9] = new SqlParameter("@RespIP", SqlDbType.VarChar, 15);
            param[9].Value = Info.RespIP;
            param[10] = new SqlParameter("@InviteFlag", SqlDbType.Bit);
            param[10].Value = Info.InviteFlag;

            return param;
        }
    }
}
