//===========================================================
//==               (c)2008  NETSNS 1.0                     ==
//==            website:www.aspxcms.com                    ==
//==         qq:6458450,Email:qwsf01115@163.com            ==
//==               Code By Xi.Deng                         ==
//===========================================================
using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Common;
using System.Data.SqlClient;
using NetSNS.DALProfile;
using NetSNS.DALFactory;
using NetSNS.Model;
using NetSNS.Config;

namespace NetSNS.DALSQLServer
{
    /// <summary>
    /// ȺԱ
    /// </summary>
    public class GroupMember : DbBase, IGroupMember
    {
        /// <summary>
        /// Ⱥ
        /// </summary>
        /// <param name="Info">ȺԱʵ</param>
        /// <returns>ɹ1</returns>
        public int Join(GroupMemberInfo Info)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();

            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                int n = 0;
                SqlParameter[] param = getParameters(Info);
                string checkSql = "Select Count([ID]) From [NT_GroupMember] Where [GroupID]=@GroupID And [UserID]=@UserID";
                int count = Convert.ToInt32(DbHelper.ExecuteScalar(trans, CommandType.Text, checkSql, param));
                if (count == 0)
                {
                    string Sql = "Insert Into [NT_GroupMember]([GroupID],[UserID],[JoinTime],[Grade]) " +
                                 "Values" +
                                 "(@GroupID,@UserID,@JoinTime,@Grade)";
                    DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, param);

                    Sql = "Update [NT_UserGroup] Set [Members]=[Members]+1 Where [GroupID]=@GroupID";
                    DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, param);

                    n = UserLog(trans, EnumUserAction.JoinGroup, Info.UserID, "һȺ", Info.GroupID);
                }
                trans.Commit();
                return n;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// ˳һȺ
        /// </summary>
        /// <param name="UserID">Ա</param>
        /// <param name="GroupID">Ⱥ</param>
        /// <returns></returns>
        public int Out(int UserID, int GroupID)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();

            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                //ɾȺԱ
                string Sql = "Delete From [NT_GroupMember] " +
                             "Where " +
                             "[GroupID]=" + GroupID + " And [UserID]=" + UserID + "";
                int n = DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                if (n > 0)
                {
                    UserLog(trans, EnumUserAction.OutGroup, UserID, "˳һȺ", GroupID);
                    //ɾȺ־״̬
                    Sql = "Update [NT_UserLog] Set [IsLock]=" + (int)EnumIsLock.Lock + " " +
                          "Where " +
                          "([UserID]=" + UserID + " And [CorrespondInfo]=" + GroupID + " And " +
                                "([ActionType]=" + (int)EnumUserAction.JoinGroup + " Or " +
                                "[ActionType]=" + (int)EnumUserAction.ExitGroup + "  Or " +
                                "[ActionType]=" + (int)EnumUserAction.AddGroup + " Or " +
                                "[ActionType]=" + (int)EnumUserAction.OutGroup + ")) ";
                    DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                    //ȺԱ
                    Sql = "Update [NT_UserGroup] Set [Members]=[Members]-1 Where [GroupID]=" + GroupID;
                    DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                    //ɾȺ
                    Sql = "Delete From [NT_GroupInvite] " +
                          "Where [GroupID]=" + GroupID + " And ([UserID]=" + UserID + " Or [JoinUserID]=" + UserID + ")";
                    DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                    //ɾȺ۱
                    Sql = "Delete From [NT_GroupDiscuss] Where [UserID]=" + UserID + " And [GroupID]=" + GroupID + "";
                    DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                    //ɾ֪ͨ
                    Sql = "Delete From [NT_Notice] Where [Receiver]=" + UserID + " " +
                          "And [MsgType]=" + (int)EnumNotifyType.GroupAdmin + " And [Correspond]=" + GroupID;
                    DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                }
                trans.Commit();
                return n;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// ȺԱΪԱ
        /// </summary>
        /// <param name="GroupUserID">ȺԱ</param>
        /// <param name="GroupID"></param>
        /// <param name="UserID">Ⱥ</param>
        /// <returns>óɹ1</returns>
        public int SetAdmin(int GroupUserID, int GroupID, int UserID)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();

            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                string Sql = "Update [NT_GroupMember] " +
                             "Set " +
                             "[Grade]=" + (int)EnumGroupGrade.Admin + " " +
                             "Where [UserID]=" + GroupUserID + " And " +
                                "[GroupID]=(Select [GroupID] From [NT_UserGroup] Where " +
                                    "[GroupID]=" + GroupID + " And [UserID]=" + UserID + ")";
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);

                int n = Notify(trans, EnumNotifyType.GroupAdmin, UserID, GroupUserID, "ΪȺԱ", GroupID);
                trans.Commit();
                return n;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// ɾȺԱ
        /// </summary>
        /// <param name="GroupUserID">ȺԱ</param>
        /// <param name="GroupID"></param>
        /// <param name="UserID">Ⱥ</param>
        /// <returns>óɹ1</returns>
        public int DelAdmin(int GroupUserID, int GroupID, int UserID)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();

            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                string Sql = "Update [NT_GroupMember] " +
                             "Set " +
                             "[Grade]=" + (int)EnumGroupGrade.Common + " " +
                             "Where [UserID]=" + GroupUserID + " And " +
                                "[GroupID]=(Select [GroupID] From [NT_UserGroup] Where " +
                                    "[GroupID]=" + GroupID + " And [UserID]=" + UserID + ")";
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                //ɾ֪ͨ
                Sql = "Delete From [NT_Notice] Where [Receiver]=" + GroupUserID + " " +
                      "And [MsgType]=" + (int)EnumNotifyType.GroupAdmin + " And [Correspond]=" + GroupID + " And [Sender]=" + UserID;
                int n = DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                trans.Commit();
                return n;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// Աְ
        /// </summary>
        /// <param name="UserID">Ա</param>
        /// <param name="GroupID">Ⱥ</param>
        /// <returns>ְɹ1</returns>
        public int QuitGroup(int UserID, int GroupID)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();

            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                string Sql = "Update [NT_GroupMember] " +
                             "Set " +
                             "[Grade]=" + (int)EnumGroupGrade.Common + " " +
                             "Where [UserID]=" + UserID + " And " +
                                "[GroupID]=" + GroupID;
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                //ɾ֪ͨ
                Sql = "Delete From [NT_Notice] Where " +
                      "[MsgType]=" + (int)EnumNotifyType.GroupAdmin + " And [Correspond]=" + GroupID + " And [Receiver]=" + UserID;
                int n = DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                trans.Commit();
                return n;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// ȡȺȼ͵ȺԱб
        /// </summary>
        /// <param name="Grade"></param>
        /// <param name="GroupID"></param>
        /// <returns></returns>
        public DataTable GroupMemberGradeList(int Grade, int GroupID)
        {
            string Sql = "";
            switch (Grade)
            {
                case 0:
                    Sql = "Select a.[UserID],a.[Grade],b.[UserName],c.[Name] From [NT_GroupMember] As a Inner Join NT_User As b " +
                          "On a.[UserID]=b.[UserID] Inner Join [NT_Dict_Area] As c On b.[Province]=c.[ID] Where " +
                          "a.[GroupID]=" + GroupID + " And a.[Grade]<>3 Order By a.[Grade] Asc";
                    break;
                case 1:
                    Sql = "Select a.[JoinUserID],b.[UserName],c.[Name] From " +
                          "[NT_GroupInvite] As a Inner Join [NT_User] As b On a.[JoinUserID]=b.[UserID]" +
                          "Inner Join [NT_Dict_Area] As c On b.[Province]=c.[ID] " +
                          "Where a.[Response]=0 And a.[GroupID]=" + GroupID;
                    break;
                case 2:
                    Sql = "Select a.[UserID],a.[Grade],b.[UserName],c.[Name] From [NT_GroupMember] As a Inner Join NT_User As b " +
                          "On a.[UserID]=b.[UserID] Inner Join [NT_Dict_Area] As c On b.[Province]=c.[ID] Where " +
                          "a.[GroupID]=" + GroupID + " And (a.[Grade]=0 Or a.[Grade]=1) Order By a.[Grade] Asc";
                    break;

                case 3:
                    Sql = "Select a.[UserID],a.[Grade],b.[UserName],c.[Name] From [NT_GroupMember] As a Inner Join " +
                          "[NT_User] As b On a.[UserID]=b.[UserID] Inner Join [NT_Dict_Area] As c On b.[Province]=c.[ID] " +
                          "Where a.[GroupID]=" + GroupID + " And a.[Grade]=3 Order By a.[ID] Desc";
                    break;
            }
            return DbHelper.ExecuteTable(CommandType.Text, Sql, null);
        }

        /// <summary>
        /// ȡλԱ
        /// </summary>
        /// <param name="GroupID">Ⱥ</param>
        /// <returns>ݱ</returns>
        public DataTable Top6GroupMemberList(int GroupID)
        {
            string Sql = "Select a.[UserID],b.[UserName],c.[FilePath] From [NT_GroupMember] As a Inner Join [NT_User] " +
                         "As b On a.[UserID]=b.[UserID] Left Join [Nt_Photo] As c On b.[Portrait]=c.[PhotoID] " +
                         "And c.[IsLock]=0 Where a.[GroupID]=" + GroupID + " Order By [JoinTime] Desc";
            return DbHelper.ExecuteTable(CommandType.Text, Sql, null);
        }

        /// <summary>
        /// ԱǲǴĳԱ
        /// </summary>
        /// <param name="UserID">Ա</param>
        /// <param name="GroupID">Ⱥ</param>
        /// <returns>Ƿtrue򷵻false</returns>
        public bool IsGroupMember(int UserID, int GroupID)
        {
            bool tf = false;
            if (UserID == 0)
                return tf;
            string Sql = "Select Count([ID]) From [NT_GroupMember] Where " +
                         "[GroupID]=" + GroupID + " And [UserID]=" + UserID + " And [Grade]<>3";
            int n = Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, Sql, null));
            if (n > 0)
                tf = true;
            return tf;
        }

        /// <summary>
        /// ԱǲǴĹԱ
        /// </summary>
        /// <param name="UserID">Ա</param>
        /// <param name="GroupID">Ⱥ</param>
        /// <returns>Ƿtrue򷵻false</returns>
        public bool IsGroupAdmin(int UserID, int GroupID)
        {
            bool tf = false;
            string Sql = "Select Count([ID]) From [NT_GroupMember] Where " +
                         "[GroupID]=" + GroupID + " And [UserID]=" + UserID + " And [Grade]=1";
            int n = Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, Sql, null));
            if (n > 0)
                tf = true;
            return tf;
        }

        /// <summary>
        /// ȡȺǷ
        /// </summary>
        /// <param name="UserID">Ա</param>
        /// <returns>ݱ</returns>
        public DataTable getGroupRequest(int UserID)
        {
            string Sql = "Select a.GroupID,a.GroupName,a.Portrait,b.Postscript,b.UserID,b.ID,c.UserName From " +
                         "NT_UserGroup as a inner Join NT_GroupInvite as b on a.GroupID=b.GroupID " +
                         "inner Join NT_User as c on b.UserID=c.UserID Where b.Response=0 And b.JoinUserID=" + UserID;
            return DbHelper.ExecuteTable(CommandType.Text, Sql, null);
        }

        /// <summary>
        /// ȡȺԱϢ
        /// </summary>
        /// <param name="ID">¼</param>
        /// <returns></returns>
        public GroupMemberInfo Info(int ID)
        {
            GroupMemberInfo info = new GroupMemberInfo();

            string Sql = "Select [ID],[GroupID],[UserID],[JoinTime],[Grade] " +
                         "From " +
                         "[NT_UserGroup] " +
                         "Where [ID]=" + ID;
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, Sql, null);
            if (rd.Read())
            {
                info.ID = Convert.ToInt32(rd["ID"].ToString());
                info.GroupID = Convert.ToInt32(rd["GroupID"].ToString());
                info.UserID = Convert.ToInt32(rd["UserID"].ToString());
                info.JoinTime = Convert.ToDateTime(rd["JoinTime"].ToString());
                info.Grade = (EnumGroupGrade)Convert.ToInt32(rd["Grade"].ToString());
            }
            rd.Close();
            return info;
        }

        /// <summary>
        /// 캯
        /// </summary>
        /// <param name="Info">Ⱥʵ</param>
        /// <returns>SQL</returns>
        private SqlParameter[] getParameters(GroupMemberInfo Info)
        {
            SqlParameter[] param = new SqlParameter[5];

            param[0] = new SqlParameter("@ID", SqlDbType.Int, 4);
            param[0].Value = Info.ID;
            param[1] = new SqlParameter("@GroupID", SqlDbType.Int, 4);
            param[1].Value = Info.GroupID;
            param[2] = new SqlParameter("@UserID", SqlDbType.Int, 4);
            param[2].Value = Info.UserID;

            param[3] = new SqlParameter("@JoinTime", SqlDbType.DateTime, 8);
            param[3].Value = Info.JoinTime;
            param[4] = new SqlParameter("@Grade", SqlDbType.Int, 4);
            param[4].Value = (int)Info.Grade;

            return param;
        }
    }
}
