using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Common;
using System.Data.SqlClient;
using NetSNS.DALProfile;
using NetSNS.DALFactory;
using NetSNS.Model;
using NetSNS.Config;

namespace NetSNS.DALSQLServer
{
    public class Help :DbBase,IHelp
    {
        //ȡ
        public DataTable getHelp(string ID)
        {
            SqlParameter param = new SqlParameter("@ID", ID);
            string sql = "select ID,SN,Title,Content from NT_Help where SN=@ID";
            return DbHelper.ExecuteTable(CommandType.Text, sql, param);
        }

        /// <summary>
        /// ޸İϢ
        /// </summary>
        /// <param name="ID"></param>
        /// <param name="title"></param>
        /// <param name="Content"></param>
        /// <param name="flag">0ӣ1޸</param>
        /// <returns></returns>
        public int UpdateAdd(NetSNS.Model.helpInfo info,int flag)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();
            try
            {
                int n = 2;
                string sql = "";
                SqlParameter[] param = getHelpParameters(info);
                if (flag == 0)
                {
                    sql = "select ID from NT_Help where SN=@SN";
                    DataTable dt = DbHelper.ExecuteTable(Conn,CommandType.Text, sql, param);
                    if (dt == null || dt.Rows.Count <= 0)
                    {
                        sql = "insert into NT_Help(SN,Title,Content) values(@SN,@Title,@Content)";
                        n = DbHelper.ExecuteNonQuery(Conn,CommandType.Text, sql, param);
                    }
                    else
                    {
                        n = 2;
                    }
                }
                else
                {
                    sql = "select ID from NT_Help where SN=@SN and ID<>@ID";
                    DataTable dt = DbHelper.ExecuteTable(Conn,CommandType.Text, sql, param);
                    if (dt == null || dt.Rows.Count <= 0)
                    {
                        sql = "update NT_Help set SN=@SN,Title=@Title,Content=@Content where ID=@ID";
                        n = DbHelper.ExecuteNonQuery(Conn,CommandType.Text, sql, param);
                    }
                    else
                    {
                        n = 2;
                    }
                }
                return n;
            }
            catch (SqlException e)
            {
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// ɾ
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public int DeleteHelp(int ID)
        {
            SqlParameter param = new SqlParameter("@ID", ID);
            string sql = "delete from NT_Help where ID=@ID";
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, param);
        }

        /// <summary>
        /// 캯
        /// </summary>
        /// <param name="Info">Ϣ</param>
        /// <returns>SQL</returns>
        private SqlParameter[] getHelpParameters(NetSNS.Model.helpInfo Info)
        {
            SqlParameter[] param = new SqlParameter[4];
            param[0] = new SqlParameter("@ID", SqlDbType.Int, 4);
            param[0].Value = Info.ID;
            param[1] = new SqlParameter("@SN", SqlDbType.NChar, 20);
            param[1].Value = Info.SN;
            param[2] = new SqlParameter("@Title", SqlDbType.NVarChar, 50);
            param[2].Value = Info.Title;
            param[3] = new SqlParameter("@Content", SqlDbType.NVarChar, 4000);
            param[3].Value = Info.Content;
            return param;
        }

    }
}
