//===========================================================
//==               (c)2008  NETSNS 1.0                     ==
//==            website:www.aspxcms.com                    ==
//==         qq:6458450,Email:qwsf01115@163.com            ==
//==               Code By Xi.Deng                         ==
//===========================================================
using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Common;
using System.Data.SqlClient;
using NetSNS.DALProfile;
using NetSNS.DALFactory;
using NetSNS.Model;
using NetSNS.Config;

namespace NetSNS.DALSQLServer
{
    /// <summary>
    /// ˽
    /// </summary>
    public class Letter : DbBase, ILetter
    {
        /// <summary>
        /// ˽
        /// </summary>
        /// <param name="Info">˽ʵ</param>
        /// <returns>ӳɹ1</returns>
        public int Add(LetterInfo Info)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();
            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                SqlParameter[] param = getParameters(Info);
                //˽ű
                string Sql = "Insert Into [NT_Letter]" +
                             "([Sender],[Receiver],[Title],[Content],[PostTime],[PostIP],[TopicID],[IsReply],[LtType]," +
                             "[RelativeID],[IsRead])" +
                             "Values(@Sender,@Receiver,@Title,@Content,@PostTime,@PostIP,@TopicID,@IsReply,@LtType,@RelativeID,@IsRead);" +
                             "Select @@IDENTITY";
                int LetterID = Convert.ToInt32(DbHelper.ExecuteScalar(trans, CommandType.Text, Sql, param));

                //ռ
                Sql = "Insert Into [NT_Inbox]" +
                      "([UserID],[LetterID]) " +
                      "Values(" + Info.Receiver + "," + LetterID + ")";
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);

                //ӷ
                Sql = "Insert Into [NT_Outbox]" +
                      "([UserID],[LetterID]) " +
                      "Values(" + Info.Sender + "," + LetterID + ")";
                int n = DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                trans.Commit();
                return n;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }


        /// <summary>
        /// ɾ˽
        /// </summary>
        /// <param name="dType">,0Ϊ,1Ϊռ</param>
        /// <param name="LetterID">˽ű</param>
        /// <returns>ɾɹ1</returns>
        public int Del(int dType, int LetterID, int UserID)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();
            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                string Sql = "";
                int n = 0;

                if (dType == 0)
                {
                    //ռǷ񻹴ڴ˼¼
                    Sql = "Select Count([ID]) From [NT_Inbox] Where [LetterID]=" + LetterID;
                    n = Convert.ToInt32(DbHelper.ExecuteScalar(trans, CommandType.Text, Sql, null));
                    if (n == 0)
                    {
                        //δҵ¼ռ¼ѱɾʱɾ˽ű¼
                        Sql = "Delete From  [NT_Letter] " +
                              "Where ([ID]=" + LetterID + " Or [TopicID]=" + LetterID + ") And " +
                              "([Sender]=" + UserID + " Or [Receiver]=" + UserID + ")";
                        DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                    }
                    //ɾ
                    Sql = "Delete From  [NT_Outbox] Where [LetterID]=" + LetterID + " And UserID=" + UserID;
                    DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                }
                else
                {
                    //ҷǷ񻹴ڴ˼¼
                    Sql = "Select Count([ID]) From [NT_Outbox] Where [LetterID]=" + LetterID;
                    n = Convert.ToInt32(DbHelper.ExecuteScalar(trans, CommandType.Text, Sql, null));
                    if (n == 0)
                    {
                        //δҵ¼¼ѱɾʱɾ˽ű¼
                        Sql = "Delete From  [NT_Letter] " +
                              "Where ([ID]=" + LetterID + " Or [TopicID]=" + LetterID + ") And " +
                              "([Sender]=" + UserID + " Or [Receiver]=" + UserID + ")";
                        DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                    }
                    else
                    {
                        //ǷĶ״̬ΪѶ
                        Sql = "Update [NT_Letter] Set [IsRead]=1 Where [ID]=" + LetterID + " Or [TopicID]=" + LetterID;
                        DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                    }
                    //ɾռ
                    Sql = "Delete From  [NT_Inbox] Where [LetterID]=" + LetterID + " And UserID=" + UserID;
                    DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                }
                trans.Commit();
                return n;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// ظ˽
        /// </summary>
        /// <param name="Info">˽ʵ</param>
        /// <returns>ظɹ1</returns>
        public int Reply(LetterInfo info)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();
            bool tf = false;
            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                SqlParameter[] param = getParameters(info);
                string Sql = "Select [Receiver] From  [NT_Letter] Where [ID]=" + info.TopicID;
                int Receiver = Convert.ToInt32(DbHelper.ExecuteScalar(trans, CommandType.Text, Sql, null));
                if (Receiver == info.Sender)
                {
                    Sql = "Select [Sender] From  [NT_Letter] Where [ID]=" + info.TopicID;
                    Receiver = Convert.ToInt32(DbHelper.ExecuteScalar(trans, CommandType.Text, Sql, null));
                }
                //˽ű
                Sql = "Insert Into [NT_Letter]" +
                      "([Sender],[Receiver],[Title],[Content],[PostTime],[PostIP],[TopicID],[IsReply],[LtType]," +
                      "[RelativeID],[IsRead])" +
                      "Values(@Sender," + Receiver + ",@Title,@Content,@PostTime,@PostIP,@TopicID,@IsReply,@LtType,@RelativeID,@IsRead);";
                int n = DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, param);

                Sql = "Select Count([ID]) From [NT_Inbox] Where UserID=" + Receiver + " And [LetterID]=" + info.TopicID;
                int tempcnt = Convert.ToInt32(DbHelper.ExecuteScalar(trans, CommandType.Text, Sql, null));
                if (tempcnt > 0)
                {
                    //ռ
                    Sql = "Insert Into [NT_Inbox]([UserID],[LetterID]) " +
                          "Values(" + info.Receiver + "," + info.TopicID + ")";
                    DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                }
                else
                {
                    //ռ
                    Sql = "Insert Into [NT_Inbox]([UserID],[LetterID]) " +
                          "Values(" + Receiver + "," + info.TopicID + ")";
                    DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                }

                //ӷ
                Sql = "Insert Into [NT_Outbox]([UserID],[LetterID]) Values(" + info.Sender + "," + info.TopicID + ")";
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);

                //ǽ߻ظ˽ţ˽״̬Ϊѻظ
                Sql = "Select Count([ID]) From [NT_Letter] Where [Receiver]=" + info.Sender + " And [ID]=" + info.TopicID;
                int cnt = Convert.ToInt32(DbHelper.ExecuteScalar(trans, CommandType.Text, Sql, null));
                if (cnt == 1)
                {
                    Sql = "Update [NT_Letter] Set [IsReply]=1 Where [ID]=" + info.TopicID + " And [Receiver]=" + info.Sender;
                    DbHelper.ExecuteScalar(trans, CommandType.Text, Sql, param);
                }

                trans.Commit();
                return n;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// ȡ»ظ
        /// </summary>
        /// <param name="LetterID">˽ű</param>
        /// <param name="isMy">Ƿѻظ</param>
        /// <param name="UserID">û</param>
        /// <returns>»ظ</returns>
        public string getNewReContent(int LetterID, bool isMy, int UserID)
        {
            string Temp = "";
            if (isMy)
                Temp = " And [Sender]=" + UserID;
            string Sql = "Select Content From [NT_Letter] " +
                         "Where ([TopicID]=" + LetterID + " Or [ID]=" + LetterID + ") " + Temp + " Order By [ID] Desc";
            return Convert.ToString(DbHelper.ExecuteScalar(CommandType.Text, Sql, null));
        }

        /// <summary>
        /// ȡµĻظǷĶ
        /// </summary>
        /// <param name="LetterID">˽ű</param>
        /// <param name="UserID">û</param>
        /// <returns>0Ϊδ1ΪѶ</returns>
        public int getNewReCNT(int LetterID, int UserID)
        {
            string Sql = "Select Count([ID]) From [NT_Letter] " +
                         "Where [IsRead]=0 And ([TopicID]=" + LetterID + " Or [ID]=" + LetterID + ") And [Receiver]=" + UserID;
            int n = Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, Sql, null));
            if (n > 0)
                return 0;
            else
                return 1;
        }

        /// <summary>
        /// յϢΪѶ״̬
        /// </summary>
        /// <param name="LetterID">˽ű</param>
        /// <param name="UserID">û</param>
        /// <returns>ɹ1</returns>
        public int Read(int LetterID, int UserID)
        {
            string Sql = "Update [NT_Letter] Set [IsRead]=1 " +
                         "Where ([TopicID]=" + LetterID + " Or [ID]=" + LetterID + ") And [Receiver]=" + UserID;
            return DbHelper.ExecuteNonQuery(CommandType.Text, Sql, null);
        }

        /// <summary>
        /// ȡ
        /// </summary>
        /// <param name="UserID">Ա</param>
        /// <returns>δʼ¼</returns>
        public int InBoxCount(int UserID)
        {
            string Sql = "Select Count([ID]) From  [NT_Letter]  Where [IsRead]=0 And [Receiver]=" + UserID;
            return Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, Sql, null));
        }

        /// <summary>
        /// ֪ͨ״̬
        /// </summary>
        /// <param name="UserID">Ա</param>
        public void UpdateNoticeMode(int UserID)
        {
            string Sql = "Update NT_Notice Set IsRead=1 Where Receiver=" + UserID;
            DbHelper.ExecuteNonQuery(CommandType.Text, Sql, null);
        }

        /// <summary>
        /// ˽Ϣ
        /// </summary>
        /// <param name="PhotoID">˽ű</param>
        /// <returns>˽ʵ</returns>
        public LetterInfo Info(int ID)
        {
            LetterInfo info = new LetterInfo();
            string Sql = "Select [ID],[Sender],[Receiver]," +
                         "[Title],[Content],[PostTime],[PostIP],[TopicID],[IsReply],[LtType],[RelativeID],[IsRead] " +
                         "From " +
                         "[NT_Letter] " +
                         "Where [ID]=" + ID;
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, Sql, null);
            if (rd.Read())
            {
                info.ID = Convert.ToInt32(rd["ID"].ToString());
                info.Sender = Convert.ToInt32(rd["Sender"].ToString());
                info.Receiver = Convert.ToInt32(rd["Receiver"].ToString());
                if (rd["Title"] != DBNull.Value) info.Title = rd["Title"].ToString();
                if (rd["Content"] != DBNull.Value) info.Content = rd["Content"].ToString();
                info.PostTime = Convert.ToDateTime(rd["PostTime"].ToString());
                if (rd["PostIP"] != DBNull.Value) info.PostIP = rd["PostIP"].ToString();
                info.TopicID = Convert.ToInt32(rd["TopicID"].ToString());
                info.IsReply = Convert.ToBoolean(rd["IsReply"].ToString());
                info.LtType = Convert.ToInt32(rd["LtType"].ToString());
                info.RelativeID = Convert.ToInt32(rd["RelativeID"].ToString());
                info.IsRead = Convert.ToInt32(rd["IsRead"].ToString());
            }
            return info;
        }

        /// <summary>
        /// 캯
        /// </summary>
        /// <param name="Info">˽ʵ</param>
        /// <returns>SQL</returns>
        private SqlParameter[] getParameters(LetterInfo Info)
        {
            SqlParameter[] param = new SqlParameter[12];

            param[0] = new SqlParameter("@ID", SqlDbType.Int, 4);
            param[0].Value = Info.ID;
            param[1] = new SqlParameter("@Sender", SqlDbType.Int, 4);
            param[1].Value = Info.Sender;
            param[2] = new SqlParameter("@Receiver", SqlDbType.Int, 4);
            param[2].Value = Info.Receiver;

            param[3] = new SqlParameter("@Title", SqlDbType.NVarChar, 100);
            param[3].Value = Info.Title;
            param[4] = new SqlParameter("@Content", SqlDbType.NVarChar, 1000);
            param[4].Value = Info.Content;
            param[5] = new SqlParameter("@PostTime", SqlDbType.DateTime, 8);
            param[5].Value = Info.PostTime;

            param[6] = new SqlParameter("@PostIP", SqlDbType.VarChar, 15);
            param[6].Value = Info.PostIP;
            param[7] = new SqlParameter("@TopicID", SqlDbType.Int, 4);
            param[7].Value = Info.TopicID;
            param[8] = new SqlParameter("@IsReply", SqlDbType.Bit);
            param[8].Value = Info.IsReply;

            param[9] = new SqlParameter("@LtType", SqlDbType.Int, 4);
            param[9].Value = Info.LtType;
            param[10] = new SqlParameter("@RelativeID", SqlDbType.Int, 4);
            param[10].Value = Info.RelativeID;
            param[11] = new SqlParameter("@IsRead", SqlDbType.Int, 4);
            param[11].Value = Info.IsRead;

            return param;
        }
    }
}
