using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using NetSNS.DALProfile;
using NetSNS.DALFactory;
using NetSNS.Config;
using NetSNS.Model;

namespace NetSNS.DALSQLServer
{
    public class Manager : DbBase, IManager
    {
        /// <summary>
        /// ¼
        /// </summary>
        /// <param name="userId"></param>
        /// <param name="password"></param>
        /// <returns></returns>
        EnumLoginState IManager.CheckLogin(int adminId, string password)
        {
            SqlConnection cn = new SqlConnection(DBConfig.CnString);
            cn.Open();
            try
            {
                string pwd = string.Empty;
                EnumUserState us = EnumUserState.Lock;
                bool exist = false;
                string Sql = "select Password,State from NT_Admin where AdminID=" + adminId;
                IDataReader rd = DbHelper.ExecuteReader(cn, CommandType.Text, Sql, null);
                if (rd.Read())
                {
                    pwd = rd.GetString(0);
                    us = (EnumUserState)rd.GetInt32(1);
                    exist = true;
                }
                rd.Close();
                if (!exist || pwd == string.Empty || pwd != password)
                    return EnumLoginState.Err_NameOrPwdError;
                if (us == EnumUserState.Register)
                    return EnumLoginState.Err_UnActivation;
                else if (us == EnumUserState.Lock)
                    return EnumLoginState.Err_Locked;
                return EnumLoginState.Succeed;
            }
            finally
            {
                if (cn.State == ConnectionState.Open)
                    cn.Close();
            }
        }
        /// <summary>
        /// ¼
        /// </summary>
        /// <param name="Email">û</param>
        /// <param name="Password"></param>
        /// <returns></returns>
        EnumLoginState IManager.Login(string loginName, string md5Password, out int adminId, out string trueName)
        {
            adminId = -1;
            trueName = string.Empty;
            SqlConnection cn = new SqlConnection(DBConfig.CnString);
            cn.Open();
            try
            {
                string pwd = string.Empty;
                EnumUserState state = EnumUserState.Lock;
                SqlParameter param = new SqlParameter("@LoginName", loginName);
                bool exist = false;
                int headpic = 0;
                string Sql = "select AdminID,TrueName,Password,State from NT_Admin where LoginName=@LoginName";
                IDataReader rd = DbHelper.ExecuteReader(cn, CommandType.Text, Sql, param);
                if (rd.Read())
                {
                    adminId = rd.GetInt32(0);
                    trueName = rd.GetString(1);
                    pwd = rd.GetString(2);
                    state = (EnumUserState)rd.GetInt32(3);
                    exist = true;
                }
                rd.Close();
                if (!exist || pwd == string.Empty || pwd != md5Password)
                    return EnumLoginState.Err_NameOrPwdError;
                else if (state == EnumUserState.Lock)
                    return EnumLoginState.Err_Locked;
                Sql = "update NT_Admin set LastLoginTime='" + DateTime.Now + "',LastLoginIP='" + NetSNS.Common.Public.GetClientIP() + "',LoginTimes=LoginTimes+1 where AdminID=" + adminId;
                DbHelper.ExecuteNonQuery(cn, CommandType.Text, Sql, null);
                return EnumLoginState.Succeed;
            }
            finally
            {
                if (cn.State == ConnectionState.Open)
                    cn.Close();
            }
        }
        /// <summary>
        /// ޸
        /// </summary>
        /// <param name="adminId"></param>
        /// <param name="oldPassword">δmd5ľ</param>
        /// <param name="newPassword">δmd5</param>
        /// <returns>0,ɹ,1,ùԱID,2</returns>
        int IManager.ChangePasswrod(int adminId, string oldPassword, string newPassword)
        {
            SqlConnection cn = new SqlConnection(DBConfig.CnString);
            cn.Open();
            try
            {
                string Sql = "select Password from NT_Admin where AdminID=" + adminId;
                object obj = DbHelper.ExecuteScalar(cn, CommandType.Text, Sql, null);
                if (obj == null)
                {
                    return 1;
                }
                if ((string)obj != Common.Input.MD5(oldPassword, false))
                    return 2;
                Sql = "update NT_Admin set Password='" + Common.Input.MD5(newPassword, false) + "' where AdminID=" + adminId;
                int n = DbHelper.ExecuteNonQuery(cn, CommandType.Text, Sql, null);
                if (n > 0)
                    return 0;
                else
                    return 3;
            }
            finally
            {
                if (cn.State == ConnectionState.Open)
                    cn.Close();
            }
        }
    }
}
