using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using NetSNS.DALFactory;
using NetSNS.DALProfile;
using NetSNS.Config;
using NetSNS.Model;

namespace NetSNS.DALSQLServer
{
    public class MiniBlog : DbBase, IMiniBlog
    {
        /// <summary>
        /// ռ
        /// </summary>
        /// <param name="UserID">ûID</param>
        /// <param name="Content"></param>
        /// <returns></returns>
        public int SaveMini(int userId, string content, string mType)
        {
            SqlConnection cn = new SqlConnection(DBConfig.CnString);
            cn.Open();
            SqlTransaction trans = cn.BeginTransaction();
            try
            {
                string sql = "insert into NT_MiniBlog (UserID,Content,PostTime,PostIP,IsLock,mType,isRec) values (" + userId + ",@Content,'" + DateTime.Now.ToString() + "','" + NetSNS.Common.Public.GetClientIP() + "',0,'" + mType + "',0);SELECT @@IDENTITY";
                SqlParameter param = new SqlParameter("@Content", SqlDbType.NVarChar, 1000);
                param.Value = content;
                int id = Convert.ToInt32(DbHelper.ExecuteScalar(trans, CommandType.Text, sql, param));
                int n = UserLog(trans, EnumUserAction.MiniBlog, userId, string.Empty, id);
                trans.Commit();
                //ӻ
                User us = new User();
                us.updateinte(userId, 2, 0, 0, "ռ");
                return n;
            }
            catch
            {
                trans.Rollback();
                throw;
            }
            finally
            {
                if (cn.State == ConnectionState.Open)
                    cn.Close();
            }
        }
        /// <summary>
        /// ɾռ
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public int DeleteMini(int userId, int miniId, bool isAdmin)
        {
            SqlConnection cn = new SqlConnection(DBConfig.CnString);
            cn.Open();
            try
            {
                string Sql;
                if (!isAdmin)
                {
                    Sql = "select count(ID) from NT_MiniBlog where ID=" + miniId + " and UserID=" + userId;
                    int n = (int)DbHelper.ExecuteScalar(cn, CommandType.Text, Sql, null);
                    if (n < 1)
                    {
                        throw new Exception("Բ,ûɾռǵȨ");
                    }
                }
                SqlTransaction trans = cn.BeginTransaction();
                try
                {
                    Sql = "delete from NT_MiniBlog where ID=" + miniId;
                    int m = DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                    Sql = "delete from NT_MiniBLogComment where MiniBlogID=" + miniId;
                    m += DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                    trans.Commit();
                    User us = new User();
                    us.updateinte(userId, 2, 0, 1, "ɾռ");
                    return m;
                }
                catch
                {
                    trans.Rollback();
                    throw;
                }
            }
            finally
            {
                if (cn.State == ConnectionState.Open)
                    cn.Close();
            }
        }
        /// <summary>
        /// ȡMiniBlogInfoʵ
        /// </summary>
        /// <param name="MiniID"></param>
        /// <returns></returns>
        public MiniBlogInfo GetMiniInfo(int MiniID)
        {
            MiniBlogInfo MiniInfo = new MiniBlogInfo();
            MiniInfo.ID = MiniID;
            string sql = "select * from NT_MiniBlog where ID=" + MiniID.ToString();
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, sql, null);
            if (rd.Read())
            {
                MiniInfo.UserID = Convert.ToInt32(rd["UserID"].ToString());
                MiniInfo.Content = Convert.ToString(rd["Content"].ToString());
                MiniInfo.PostTime = Convert.ToDateTime(rd["PostTime"].ToString());
                MiniInfo.PostIP = Convert.ToString(rd["PostIP"].ToString());
                MiniInfo.IsLock = Convert.ToBoolean(rd["IsLock"].ToString());
            }
            rd.Close();
            return MiniInfo;
        }
        /// <summary>
        /// ȡû󷢲ռ
        /// </summary>
        /// <param name="vistor"></param>
        /// <param name="owner"></param>
        /// <returns></returns>
        public MiniBlogInfo GetLastInfo(int vistor, int owner)
        {
            MiniBlogInfo info = new MiniBlogInfo();
            info.ID = -1;
            SqlConnection cn = new SqlConnection(DBConfig.CnString);
            cn.Open();
            try
            {
                string Sql = "select PrivMiniBlog from NT_UserSetting where UserID=" + owner;
                EnumPrivacy prv = (EnumPrivacy)Convert.ToInt32(DbHelper.ExecuteScalar(cn, CommandType.Text, Sql, null));
                if (!CheckPrivacy(cn, prv, vistor, owner))
                    return info;
                Sql = "select ID,Content,PostTime from NT_MiniBlog where UserID=" + owner + " and IsLock=0 order by PostTime Desc";
                IDataReader rd = DbHelper.ExecuteReader(cn, CommandType.Text, Sql, null);
                if (rd.Read())
                {
                    info.ID = rd.GetInt32(0);
                    info.Content = rd.GetString(1);
                    info.PostTime = rd.GetDateTime(2);
                }
                rd.Close();
                return info;
            }
            finally
            {
                if (cn.State == ConnectionState.Open)
                    cn.Close();
            }
        }
        /// <summary>
        /// Ƿв鿴־Ȩ
        /// </summary>
        /// <param name="hostId"></param>
        /// <param name="guestId"></param>
        /// <returns></returns>
        public bool CheckAuthority(int hostId, int guestId)
        {
            SqlConnection cn = new SqlConnection(DBConfig.CnString);
            cn.Open();
            try
            {
                EnumPrivacy priv = EnumPrivacy.ForFriends;
                string Sql = "select PrivMiniBlog from NT_UserSetting where UserID=" + hostId;
                IDataReader rd = DbHelper.ExecuteReader(cn, CommandType.Text, Sql, null);
                if (rd.Read())
                {
                    if (!rd.IsDBNull(0)) priv = (EnumPrivacy)rd.GetInt32(0);
                }
                rd.Close();
                return CheckPrivacy(cn, priv, guestId, hostId);
            }
            finally
            {
                if (cn.State == ConnectionState.Open)
                    cn.Close();
            }
        }
        /// <summary>
        /// õռǵ
        /// </summary>
        /// <param name="Mid">ռǵID</param>
        /// <returns></returns>
        public IDataReader GetMiniComment(int Mid)
        {
            string sql = "select ID,Commentator,MiniBlogID,Content,CommentID,PostTime from NT_MiniBlogComment where islock!=1 and MiniBlogID=" + Mid;
            return DbHelper.ExecuteReader(CommandType.Text, sql, null);
        }

        /// <summary>
        /// õ㲩͵
        /// </summary>
        /// <param name="mid">㲩ID</param>
        /// <returns></returns>
        public int GetMiniCount(int mid)
        {
            string sql = "select count(id) from NT_MiniBlogComment where islock!=1 and MiniBlogID=" + mid;
            return Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, sql, null));
        }
        /// <summary>
        /// ռ
        /// </summary>
        /// <param name="mid">۵ID</param>
        /// <param name="Content"></param>
        /// <param name="UserID">û</param>
        /// <param name="CommentID">ID</param>
        public void SaveMiniComment(int mid, string Content, int UserID, int CommentID)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();
            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                SqlParameter[] param = new SqlParameter[7];
                param[0] = new SqlParameter("@mid", SqlDbType.Int, 4);
                param[0].Value = mid;
                param[1] = new SqlParameter("@Content", SqlDbType.NVarChar, 100);
                param[1].Value = Content;
                param[2] = new SqlParameter("@UserID", SqlDbType.Int, 4);
                param[2].Value = UserID;
                param[3] = new SqlParameter("@CommentID", SqlDbType.Int, 4);
                param[3].Value = CommentID;
                param[4] = new SqlParameter("@PostTime", SqlDbType.DateTime, 8);
                param[4].Value = DateTime.Now;
                param[5] = new SqlParameter("@PostIP", SqlDbType.NVarChar, 15);
                param[5].Value = NetSNS.Common.Public.GetClientIP();
                param[6] = new SqlParameter("@isLock", SqlDbType.Bit);
                param[6].Value = 0;
                string sql = "insert into NT_MiniBlogComment(Commentator,MiniBlogID,Content,CommentID,PostTime,PostIP,isLock) values (@UserID,@mid,@Content,@CommentID,@PostTime,@PostIP,@isLock);";
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, sql, param);

                sql = "update NT_MiniBlog set Comments=Comments+1 where ID=" + mid;
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, sql, null);
                //ݲIDҵ
                string mSQL = "select UserID from NT_MiniBlog where ID=@mid";
                int mUserID = Convert.ToInt32(DbHelper.ExecuteScalar(trans, CommandType.Text, mSQL, param));
                //˵֪ͨ,Լ֪ͨԼ
                if (mUserID != UserID)
                {
                    Notify(trans, EnumNotifyType.MiniComment, UserID, mUserID, "ռ", mid);
                }
                trans.Commit();
                User us = new User();
                us.updateinte(UserID, 1, 0, 0, "ռ");
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }
        /// <summary>
        /// ɾռ
        /// </summary>
        /// <param name="bid"></param>
        public void DelMiniComent(int bid)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();
            string Sql = "select MiniBlogID from NT_MiniBlogComment where ID=" + bid;
            int blogid = (int)DbHelper.ExecuteScalar(Conn, CommandType.Text, Sql, null);
            string ubsql = "select Commentator from NT_MiniBlogComment where ID=" + bid;
            int UserID = (int)DbHelper.ExecuteScalar(Conn, CommandType.Text, ubsql, null);
            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                string sql = "delete from NT_MiniBlogComment where ID=" + bid;
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, sql, null);

                sql = "update NT_MiniBlog set Comments=Comments-1 where ID=" + blogid;
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, sql, null);
                trans.Commit();
                User us = new User();
                us.updateinte(UserID, 1, 0, 1, "ɾռ");
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }


        }

        /// <summary>
        /// ȡµĶMINIBLOG
        /// </summary>
        /// <param name="Num"></param>
        /// <returns></returns>
        public List<MiniBlogInfo> List(int Num)
        {
            List<MiniBlogInfo> list = new List<MiniBlogInfo>();
            string sql = "select Top " + Num + " a.ID, a.UserID, b.Content, b.PostTime, b.PostIP,b.IsLock from (SELECT UserID, MAX(ID) AS ID FROM NT_MiniBlog  GROUP BY UserID) As a inner join NT_User c on a.UserID=c.UserID INNER JOIN NT_MiniBlog b ON b.ID = a.ID Left Join NT_Photo d on c.Portrait=d.PhotoID Where not d.FilePath is null ORDER BY newid() DESC";
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, sql, null);
            while (rd.Read())
            {
                MiniBlogInfo info = new MiniBlogInfo();
                info.ID = Convert.ToInt32(rd["ID"].ToString()); ;
                info.UserID = Convert.ToInt32(rd["UserID"].ToString());
                info.Content = Convert.ToString(rd["Content"].ToString());
                info.PostTime = Convert.ToDateTime(rd["PostTime"].ToString());
                info.PostIP = Convert.ToString(rd["PostIP"].ToString());
                info.IsLock = Convert.ToBoolean(rd["IsLock"].ToString());
                list.Add(info);
            }
            rd.Close();
            return list;
        }



        #region Ա̨
        /// <summary>
        /// 㲩
        /// </summary>
        /// <param name="searchCondition">:1.;2.־</param>
        /// <param name="keyword">ؼ</param>
        /// <param name="orderType">ʽ:1.;2.;3.</param>
        /// <returns></returns>
        public DataTable Search(int searchCondition, string keyword, int orderType, int pageIndex, int pageSize, out int recordCount, out int pageCount)
        {
            string AllFields = "a.ID,a.UserID,a.Content,a.PostTime,a.IsLock,a.Comments,a.isRec,b.UserName";
            string TablesAndWhere = "NT_MiniBlog a inner join NT_User b on a.UserID=b.UserID";
            if (keyword != null && keyword.Trim() != string.Empty)
            {
                string _key = keyword.Replace("'", "''");
                if (searchCondition == 1)
                    TablesAndWhere += " where b.UserName like '%" + _key + "%'";
                else if (searchCondition == 2)
                    TablesAndWhere += " where a.Content like '%" + _key + "%'";
            }
            string IndexField = "a.ID";
            string OrderFields = "order by a.ID Desc";
            switch (orderType)
            {
                case 1:
                    OrderFields = "order by a.PostTime Desc";
                    break;
                case 2:
                    OrderFields = "order by b.UserName Desc";
                    break;
                case 3:
                    OrderFields = "order by a.Comments Desc";
                    break;
            }
            return Pagination.ProcPage(AllFields, TablesAndWhere, IndexField, OrderFields, pageIndex, pageSize, out recordCount, out pageCount);
        }

        public void updateMiniRec(int ID, int NUM)
        {
            string sql = "update NT_MiniBlog set isRec=" + NUM + " where ID=" + ID;
            DbHelper.ExecuteNonQuery(CommandType.Text, sql, null);
        }

        /// <summary>
        /// ռ
        /// </summary>
        /// <param name="userId"></param>
        /// <param name="blogId"></param>
        /// <param name="lockSate"></param>
        public int ChangeLock(int userId, int miniBlogId, bool lockSate)
        {
            int newLock = 0;
            if (lockSate)
                newLock = 1;
            SqlConnection cn = new SqlConnection(DBConfig.CnString);
            cn.Open();
            SqlTransaction trans = cn.BeginTransaction();
            try
            {
                string Sql = "update NT_MiniBlog set IsLock=" + newLock + " where ID=" + miniBlogId;
                int n = DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                Sql = "update NT_MiniBlogComment set IsLock=" + newLock + " where MiniBlogID=" + miniBlogId;
                n += DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                trans.Commit();
                return n;
            }
            catch
            {
                trans.Rollback();
                throw;
            }
            finally
            {
                if (cn.State == ConnectionState.Open)
                    cn.Close();
            }
        }
        #endregion
    }
}
