using System;
using System.Collections.Generic;
using System.Text;
using NetSNS.DALFactory;
using System.Data;
using System.Data.SqlClient;
using NetSNS.DALProfile;
using NetSNS.Config;
using NetSNS.Model;

namespace NetSNS.DALSQLServer
{
    public class Movie : DbBase, IMovie
    {
        /// <summary>
        /// ȡŵӰ
        /// </summary>
        /// <returns>ݱ</returns>
        public DataTable RandMovie()
        {
            string sql = "Select Top 4 * From [NT_Movie] Order By NewID()";
            return DbHelper.ExecuteTable(CommandType.Text, sql, null);
        }

        /// <summary>
        /// ȡú뿴ĵӰ
        /// </summary>
        /// <param name="UsreID">Ա</param>
        /// <returns>ݱ</returns>
        public DataTable FriendThinkLookMovie(int UsreID)
        {
            string Sql = "Select Top 200 a.MovieID,a.Title," +
                         "(Select Count(ID) From NT_MovieComment Where UserID In " +
                         "(Select FriendID From NT_Friend Where UserID=" + UsreID + ") And Score=0) As Cnt " +
                         "From NT_Movie AS a INNER JOIN NT_MovieComment AS b " +
                         "ON a.[MovieID]=b.[MovieID] INNER JOIN NT_User AS c " +
                         "ON b.[UserID]=c.[UserID] where b.[UserID] In (Select FriendID From NT_Friend Where UserID=" + UsreID + ") " +
                         "And a.Score=0";
            return DbHelper.ExecuteTable(CommandType.Text, Sql, null);
        }

        /// <summary>
        /// ȡѶĳӰ
        /// </summary>
        /// <param name="UserID">Ա</param>
        /// <param name="MovieID">Ӱ</param>
        /// <returns>ݱ</returns>
        public DataTable FriendMovieComm(int UserID, int MovieID)
        {
            string Sql = "Select a.MovieID,a.Title,a.PosterFile,b.Score,b.Comment,c.UserID,c.UserName,d.FilePath " +
                         "From NT_Movie AS a INNER JOIN NT_MovieComment AS b ON a.[MovieID]=b.[MovieID] " +
                         "INNER JOIN NT_User AS c ON b.[UserID]=c.[UserID] " +
                         "Left Join Nt_Photo As d On c.Portrait=d.PhotoID And d.IsLock=0 where b.[UserID] In " +
                         "(Select FriendID From NT_Friend Where UserID=" + UserID + ") And b.Score>0 " +
                         "And a.MovieID=" + MovieID + " order by b.[PostTime] desc";
            return DbHelper.ExecuteTable(CommandType.Text, Sql, null);
        }

        /// <summary>
        /// ȡ뿴ĵӰ
        /// </summary>
        /// <param name="UserID">Ա</param>
        /// <returns>ݱ</returns>
        public DataTable MyThinkLookMovie(int UserID)
        {
            string Sql = "Select Top 200 a.MovieID,a.Title " +
                         "From NT_Movie AS a INNER JOIN NT_MovieComment AS b " +
                         "ON a.[MovieID]=b.[MovieID] where b.[UserID]=" + UserID + " " +
                         "And b.Score=0";
            return DbHelper.ExecuteTable(CommandType.Text, Sql, null);
        }

        /// <summary>
        /// ȡúа
        /// </summary>
        /// <param name="UserID">Ա</param>
        /// <returns>ݱ</returns>
        public DataTable getTopFriendMovie(int UserID)
        {
            string Sql = "select a.userid,count(id) as cnt,b.Username from NT_MOVIECOMMENT" +
                         " as a inner join Nt_User as b on a.UserID=b.UserID where " +
                         "((a.UserID In(Select FriendID From Nt_Friend Where userID=" + UserID + ")) or " +
                         "a.UserID=" + UserID + ") and a.Score>0 group by a.userid,b.Username order by cnt desc";
            DataTable dt = DbHelper.ExecuteTable(CommandType.Text, Sql, null);
            dt.Columns.Add("Num", typeof(System.Int32));
            for (int i = 0; i < dt.Rows.Count; i++)
            {
                dt.Rows[i]["Num"] = i + 1;
            }
            return dt;
        }

        /// <summary>
        /// ӵӰ
        /// </summary>
        /// <param name="SortName"></param>
        /// <returns>ӳɹ1</returns>
        public int AddMovieSort(string SortName)
        {
            SqlParameter param = new SqlParameter("@SortName", SqlDbType.NVarChar, 50);
            param.Value = SortName;
            string Sql = "Insert Into NT_Dict_MovieSort(SortName) values(@SortName)";
            return DbHelper.ExecuteNonQuery(CommandType.Text, Sql, param);
        }

        /// <summary>
        /// ȡõӰб
        /// </summary>
        /// <returns>ݱ</returns>
        public DataTable getDictMovieSortList()
        {
            string Sql = "Select ID,SortName From NT_Dict_MovieSort";
            return DbHelper.ExecuteTable(CommandType.Text, Sql, null);
        }

        /// <summary>
        /// ޸ĵӰ
        /// </summary>
        /// <param name="SortName"></param>
        /// <param name="ID">ͱ</param>
        /// <returns>޸ĳɹ1</returns>
        public int EditMovieSort(string SortName, int ID)
        {
            SqlParameter param = new SqlParameter("@SortName", SqlDbType.NVarChar, 50);
            param.Value = SortName;
            string Sql = "Update NT_Dict_MovieSort Set SortName=@SortName Where ID=" + ID;
            return DbHelper.ExecuteNonQuery(CommandType.Text, Sql, param);
        }

        /// <summary>
        /// ȡõӰϢ
        /// </summary>
        /// <param name="ID">Ӱͱ</param>
        /// <returns>صӰʵ</returns>
        public Dict_MovieSortInfo MovieSortInfo(int ID)
        {
            Dict_MovieSortInfo Info = new Dict_MovieSortInfo();
            string Sql = "select ID,SortName from NT_Dict_MovieSort where ID=" + ID;
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, Sql, null);
            while (rd.Read())
            {
                Info.ID = Convert.ToInt32(rd["ID"]);
                if (rd["SortName"] != DBNull.Value) Info.SortName = rd["SortName"].ToString();
            }
            rd.Close();
            return Info;
        }

        /// <summary>
        /// ȡõӰӦĵӰ
        /// </summary>
        /// <param name="SortID">ͱ</param>
        /// <returns>ݱ</returns>
        public DataTable getMoviePostFileForSort(int SortID)
        {
            string Sql = "Select PosterFile From NT_Movie Where MovieID In(Select MovieID From NT_MovieSort Where SortID=" + SortID + ")";
            return DbHelper.ExecuteTable(CommandType.Text, Sql, null);
        }

        /// <summary>
        /// ȡõӰӦĵӰ
        /// </summary>
        /// <param name="SortID">ͱ</param>
        /// <returns>ݱ</returns>
        public DataTable getMovieUpFileForSort(int SortID)
        {
            string Sql = "Select FileName From NT_MoviePoster Where MovieID In(Select MovieID From NT_MovieSort Where SortID=" + SortID + ")";
            return DbHelper.ExecuteTable(CommandType.Text, Sql, null);
        }

        /// <summary>
        /// ɾӰ
        /// </summary>
        /// <param name="ID">ͱ</param>
        /// <returns>ɾɹ1</returns>
        public int DelMovieSort(int ID)
        {
            SqlConnection sqlConn = new SqlConnection(DBConfig.CnString);
            sqlConn.Open();
            SqlTransaction trans = sqlConn.BeginTransaction();
            try
            {
                string Sql = "Delete From NT_Dict_MovieSort Where ID=" + ID;
                int n = DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                Sql = "Delete From NT_Movie Where MovieID In(Select MovieID From NT_MovieSort Where SortID=" + ID + ")";
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                Sql = "Delete From NT_MovieComment Where MovieID In(Select MovieID From NT_MovieSort Where SortID=" + ID + ")";
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                Sql = "Delete From NT_MoviePoster Where MovieID In(Select MovieID From NT_MovieSort Where SortID=" + ID + ")";
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                Sql = "Delete From NT_MovieSort Where SortID=" + ID;
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                trans.Commit();
                return n;
            }
            catch (SqlException sqlEX)
            {
                trans.Rollback();
                throw sqlEX;
            }
            finally
            {
                if (sqlConn.State == ConnectionState.Open)
                {
                    sqlConn.Close();
                }
            }
        }

        /// <summary>
        /// ȡõӰ
        /// </summary>
        /// <param name="MovieID">Ӱ</param>
        /// <returns>ݱ</returns>
        public DataTable getMovieGut(int MovieID)
        {
            string Sql = "Select a.id,a.SortName from NT_Dict_MovieSort as a inner join " +
                         "NT_MovieSort as b on a.id=b.SortID where b.movieid=" + MovieID;
            return DbHelper.ExecuteTable(CommandType.Text, Sql, null);
        }

        /// <summary>
        /// ӵӰ
        /// </summary>
        /// <param name="Info">Ӱʵ</param>
        /// <returns>ӳɹصӰ</returns>
        public int AddMovie(MovieInfo Info)
        {
            SqlParameter[] param = getMovieParameters(Info);
            string Sql = "Insert Into NT_Movie(Title,Director,Billing,YearOnShow,Gut,Comments,Seen," +
                         "Wanna,Wonna,Score,PosterFile,zt_dy,zt_dy1,zt_url,zt_url1,IsRec) " +
                         "Values(@Title,@Director,@Billing,@YearOnShow,@Gut,@Comments,@Seen,@Wanna,@Wonna,@Score," +
                         "@PosterFile,@ztdy,@ztdy1,@zturl,@zturl1,@IsRec);" +
                         "Select @@IDENTITY";
            return Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, Sql, param));
        }

        /// <summary>
        /// ޸ĵӰ
        /// </summary>
        /// <param name="Info">Ӱʵ</param>
        /// <returns>޸ĳɹ1</returns>
        public int EditMovie(MovieInfo Info)
        {

            SqlConnection sqlConn = new SqlConnection(DBConfig.CnString);
            sqlConn.Open();
            SqlTransaction trans = sqlConn.BeginTransaction();
            try
            {
                SqlParameter[] param = getMovieParameters(Info);
                string Sql = "";
                if (Info.PosterFile == "")
                    Sql = "Update NT_Movie Set Title=@Title,Director=@Director,Billing=@Billing," +
                          "YearOnShow=@YearOnShow,Gut=@Gut," +
                          "zt_dy=@ztdy,zt_dy1=@ztdy1,zt_url=@zturl,zt_url1=@zturl1,IsRec=@IsRec,AddTime='" + DateTime.Now + "' Where MovieID=@MovieID";
                else
                    Sql = "Update NT_Movie Set Title=@Title,Director=@Director,Billing=@Billing," +
                          "YearOnShow=@YearOnShow,Gut=@Gut,PosterFile=@PosterFile," +
                          "zt_dy=@ztdy,zt_dy1=@ztdy1,zt_url=@zturl,zt_url1=@zturl1,IsRec=@IsRec,AddTime='" + DateTime.Now + "' Where MovieID=@MovieID";
                int n = Convert.ToInt32(DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, param));

                Sql = "Delete From NT_MovieSort Where MovieID=" + Info.MovieID;
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                trans.Commit();
                return n;
            }
            catch (SqlException sqlEX)
            {
                trans.Rollback();
                throw sqlEX;
            }
            finally
            {
                if (sqlConn.State == ConnectionState.Open)
                {
                    sqlConn.Close();
                }
            }
        }

        /// <summary>
        /// ƼӰ
        /// </summary>
        /// <param name="MovieID">Ӱ</param>
        /// <returns></returns>
        public int RecMovie(int MovieID)
        {
            string Sql = "Update NT_Movie Set IsRec=1 Where MovieID=" + MovieID;
            return Convert.ToInt32(DbHelper.ExecuteNonQuery(CommandType.Text, Sql, null));
        }

        /// <summary>
        /// ȡƼӰ
        /// </summary>
        /// <param name="MovieID">Ӱ</param>
        /// <returns></returns>
        public int UnRecMovie(int MovieID)
        {
            string Sql = "Update NT_Movie Set IsRec=0 Where MovieID=" + MovieID;
            return Convert.ToInt32(DbHelper.ExecuteNonQuery(CommandType.Text, Sql, null));
        }


        /// <summary>
        /// ɾӰ
        /// </summary>
        /// <param name="MovieID">Ӱ</param>
        /// <returns>ɾɹ1</returns>
        public int DelMovie(int MovieID)
        {
            SqlConnection sqlConn = new SqlConnection(DBConfig.CnString);
            sqlConn.Open();
            SqlTransaction trans = sqlConn.BeginTransaction();
            try
            {
                string Sql = "Delete From NT_Movie Where MovieID=" + MovieID;
                int n = DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                Sql = "Delete From NT_MovieSort Where MovieID=" + MovieID;
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                Sql = "Delete From NT_MovieComment Where MovieID=" + MovieID;
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                Sql = "Delete From NT_MoviePoster Where MovieID=" + MovieID;
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                trans.Commit();
                return n;
            }
            catch (SqlException sqlEX)
            {
                trans.Rollback();
                throw sqlEX;
            }
            finally
            {
                if (sqlConn.State == ConnectionState.Open)
                {
                    sqlConn.Close();
                }
            }
        }

        /// <summary>
        /// ӵӰ
        /// </summary>
        /// <param name="Info">Ӱʵ</param>
        /// <returns>ӳɹ1</returns>
        public int AddSortForMovie(MovieSortInfo Info)
        {
            SqlParameter[] param = getMovieSortParameters(Info);
            string Sql = "Insert Into NT_MovieSort(MovieID,SortID,PostTime,PostIP,CreatorID) " +
                         "Values(@MovieID,@SortID,@PostTime,@PostIP,@CreatorID)";
            return Convert.ToInt32(DbHelper.ExecuteNonQuery(CommandType.Text, Sql, param));
        }

        /// <summary>
        /// ȡõӰӦĵӰͱ
        /// </summary>
        /// <param name="movieid">Ӱ</param>
        /// <returns>ݱ</returns>
        public DataTable getSortForMovie(int movieid)
        {
            string Sql = "Select SortID From NT_MovieSort Where MovieID=" + movieid;
            return DbHelper.ExecuteTable(CommandType.Text, Sql, null);
        }

        /// <summary>
        /// ȡõӰӦĵӰ
        /// </summary>
        /// <param name="SortID">Ӱͱ</param>
        /// <returns>ݱ</returns>
        public DataTable getMovieForSort(int SortID)
        {
            string Sql = "Select MovieID From NT_MovieSort Where SortID=" + SortID;
            return DbHelper.ExecuteTable(CommandType.Text, Sql, null);
        }

        /// <summary>
        /// ȡûԱϴĴ˵Ӱַ
        /// </summary>
        /// <param name="movieid">Ӱ</param>
        /// <returns>ݱ</returns>
        public DataTable getMoviePoster(int movieid)
        {
            string Sql = "Select FileName From NT_MoviePoster Where MovieID=" + movieid;
            return DbHelper.ExecuteTable(CommandType.Text, Sql, null);
        }

        /// <summary>
        /// ޸ĵӰ
        /// </summary>
        /// <param name="MovieID">Ӱ</param>
        /// <param name="PosterFile">ַ</param>
        /// <returns>޸ĳɹ1</returns>
        public int SetPosterFile(int MovieID, string PosterFile)
        {
            SqlParameter param = new SqlParameter("@PosterFile", SqlDbType.NVarChar, 255);
            param.Value = PosterFile;
            string Sql = "Update NT_Movie Set PosterFile=@PosterFile Where MovieID=" + MovieID;
            return Convert.ToInt32(DbHelper.ExecuteNonQuery(CommandType.Text, Sql, param));
        }


        /// <summary>
        /// 
        /// </summary>
        /// <param name="UserID">ûID</param>
        /// <param name="MovieID">ӰID</param>
        /// <returns></returns>
        public int SaveComment(int UserID, int MovieID, string Comment)
        {
            SqlConnection sqlConn = new SqlConnection(DBConfig.CnString);
            sqlConn.Open();
            SqlTransaction trans = sqlConn.BeginTransaction();
            try
            {
                SqlParameter param = new SqlParameter("@Comment", SqlDbType.NVarChar, 255);
                param.Value = Comment;
                string sqlIsExist = "select ID from NT_MovieComment where UserID=" + UserID + " and MovieID=" + MovieID;
                int ID = Convert.ToInt32(DbHelper.ExecuteScalar(trans, CommandType.Text, sqlIsExist, null));
                if (ID > 0)//й£insert¼¼
                {
                    string sqlUpdate = "update NT_MovieComment " +
                                       "set Comment=@Comment,PostTime='" + DateTime.Now.ToString() + "'," +
                                       "PostIP='" + NetSNS.Common.Public.GetClientIP() + "' where ID=" + ID;
                    DbHelper.ExecuteNonQuery(trans, CommandType.Text, sqlUpdate, param);
                }
                else
                {
                    string sqlInsert = "insert into NT_MovieComment" +
                                        "(MovieID,UserID,Score,Comment,PostTime,PostIP) " +
                                        "values" +
                                        " (" + MovieID + "," + UserID + ",0,@Comment," +
                                        "'" + DateTime.Now.ToString() + "','" + NetSNS.Common.Public.GetClientIP() + "');Select @@IDENTITY";
                    int cid = Convert.ToInt32(DbHelper.ExecuteScalar(trans, CommandType.Text, sqlInsert, param));
                    int num = UserLog(trans, EnumUserAction.MovieComment, UserID, "˵Ӱ", cid);
                }
                trans.Commit();
                return 1;
            }
            catch (SqlException sqlEX)
            {
                trans.Rollback();
                throw sqlEX;
            }
            finally
            {
                if (sqlConn.State == ConnectionState.Open)
                {
                    sqlConn.Close();
                }
            }
        }

        /// <summary>
        /// ȡõӰķ
        /// </summary>
        /// <param name="UserID">Ա</param>
        /// <param name="MovieID">Ӱ</param>
        /// <returns>ڴ˼¼ط,ڷ-2</returns>
        public int getScore(int UserID, int MovieID)
        {
            string Sql = "Select Count(ID) From NT_MovieComment Where MovieID=" + MovieID + " And UserID=" + UserID;
            int n = Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, Sql, null));
            if (n > 0)
            {
                Sql = "Select Score From NT_MovieComment Where MovieID=" + MovieID + " And UserID=" + UserID;
                n = Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, Sql, null));
            }
            else
                n = -2;
            return n;
        }

        /// <summary>
        /// ȡѶĳӰ
        /// </summary>
        /// <param name="UserID">Ա</param>
        /// <param name="MovieID">Ӱ</param>
        /// <returns>Ϣ</returns>
        public string getComment(int UserID, int MovieID)
        {
            string s_Comment = null;
            string Sql = "Select Count(ID) From NT_MovieComment Where MovieID=" + MovieID + " And UserID=" + UserID;
            int n = Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, Sql, null));
            if (n > 0)
            {
                Sql = "Select Comment From NT_MovieComment Where MovieID=" + MovieID + " And UserID=" + UserID;
                s_Comment = Convert.ToString(DbHelper.ExecuteScalar(CommandType.Text, Sql, null));
            }
            return s_Comment;
        }

        /// <summary>
        /// Ӱ
        /// </summary>
        /// <param name="UserID">ûID</param>
        /// <param name="MovieID">ӰID</param>
        /// <param name="Score">Ӱ</param>
        /// <returns></returns>
        public int SaveScore(int UserID, int MovieID, int Score)
        {
            string sqlIsExist = "select ID from NT_MovieComment " +
                                "where UserID=" + UserID + " and MovieID=" + MovieID;
            int ID = Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, sqlIsExist, null));

            string Sql = "Select score From NT_MovieComment Where MovieID=" + MovieID + " And UserID=" + UserID;
            int score = Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, Sql, null));
            if (score <= 0)
            {
                Sql = "update NT_Movie set Seen=Seen+1 where MovieID=" + MovieID;
                DbHelper.ExecuteNonQuery(CommandType.Text, Sql, null);
            }

            if (ID > 0)//й£insert¼¼
            {
                string sqlScore = "update NT_MovieComment set Score=" + Score + " where ID=" + ID;
                DbHelper.ExecuteNonQuery(CommandType.Text, sqlScore, null);
            }
            else
            {
                string sqlScore = "insert into NT_MovieComment" +
                                  "(MovieID,UserID,Score,Comment,PostTime,PostIP) " +
                                  "values " +
                                  "(" + MovieID + "," + UserID + "," + Score + ",''," +
                                  "'" + DateTime.Now.ToString() + "','" + NetSNS.Common.Public.GetClientIP() + "')";
                DbHelper.ExecuteNonQuery(CommandType.Text, sqlScore, null);
            }

            //µӰƽ                
            UpdateScore(MovieID);
            return 1;
        }

        /// <summary>
        /// µӰ
        /// </summary>
        /// <param name="MovieID"></param>
        protected void UpdateScore(int MovieID)
        {
            string sqlGetScore = "select Score from NT_MovieComment where Score>0 And MovieID=" + MovieID;
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, sqlGetScore, null);
            int num = 0;
            int i = 0;
            while (rd.Read())
            {
                num += Convert.ToInt32(rd["Score"]);
                i++;
            }
            rd.Close();
            if (num != 0)
                num = num / i;
            string sqlUpAve = "update NT_Movie set Score=" + num + " where MovieID=" + MovieID;
            DbHelper.ExecuteNonQuery(CommandType.Text, sqlUpAve, null);
        }

        /// <summary>
        /// ¿
        /// </summary>
        /// <param name="trans"></param>
        protected void UpdateSeen(SqlTransaction trans, int MovieID, int UserID)
        {
            string Sql = "Select score From NT_MovieComment Where MovieID=" + MovieID + " And UserID=" + UserID;
            int score = Convert.ToInt32(DbHelper.ExecuteScalar(trans, CommandType.Text, Sql, null));
            if (score >= 1)
            {
                Sql = "update NT_Movie set Seen=Seen-1 where MovieID=" + MovieID;
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
            }
        }


        /// <summary>
        /// 뿴õӰ
        /// </summary>
        /// <param name="MovieID">ӰID</param>
        /// <param name="UserID">Ա</param>
        /// <param name="tag">trueΪ1falseΪ1</param>
        /// <returns></returns>
        public int UpdateWanna(int MovieID, int UserID, bool tag)
        {
            SqlConnection sqlConn = new SqlConnection(DBConfig.CnString);
            sqlConn.Open();
            SqlTransaction trans = sqlConn.BeginTransaction();
            try
            {
                string Sql = "Select Count(ID) From NT_MovieComment Where MovieID=" + MovieID + " And UserID=" + UserID;
                int n = Convert.ToInt32(DbHelper.ExecuteScalar(trans, CommandType.Text, Sql, null));
                if (tag)
                {
                    //Ƿڼ¼
                    if (n > 0)
                    {
                        UpdateSeen(trans, MovieID, UserID);
                        //״̬
                        Sql = "Update NT_MovieComment Set Score=0 Where MovieID=" + MovieID + " And UserID=" + UserID;
                        DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                    }
                    else
                    {
                        //ڼ¼ֱ
                        Sql = "Insert Into NT_MovieComment(MovieID,UserID,Score,PostTime,PostIP) Values" +
                              "(" + MovieID + "," + UserID + ",0,'" + DateTime.Now + "','" + NetSNS.Common.Public.GetClientIP() + "')";
                        DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                    }
                    //뿴
                    Sql = "update NT_Movie set Wanna=Wanna+1 where MovieID=" + MovieID;
                    DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                }
                else
                {
                    UpdateSeen(trans, MovieID, UserID);
                    //״̬
                    Sql = "Update NT_MovieComment Set Score=-3 Where MovieID=" + MovieID + " And UserID=" + UserID;
                    DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                    //뿴
                    Sql = "update NT_Movie set Wanna=Wanna-1 where MovieID=" + MovieID;
                    DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                }
                trans.Commit();
                UpdateScore(MovieID);
                return n;
            }
            catch (SqlException sqlEX)
            {
                trans.Rollback();
                throw sqlEX;
            }
            finally
            {
                if (sqlConn.State == ConnectionState.Open)
                {
                    sqlConn.Close();
                }
            }
        }
        /// <summary>
        /// ²뿴õӰ
        /// </summary>
        /// <param name="MovieID">ӰID</param>
        /// <param name="tag">trueΪ1falseΪ1</param>
        /// <returns></returns>
        public int UpdateWonna(int MovieID, int UserID, bool tag)
        {
            SqlConnection sqlConn = new SqlConnection(DBConfig.CnString);
            sqlConn.Open();
            SqlTransaction trans = sqlConn.BeginTransaction();
            try
            {
                string Sql = "Select Count(ID) From NT_MovieComment Where MovieID=" + MovieID + " And UserID=" + UserID;
                int n = Convert.ToInt32(DbHelper.ExecuteScalar(trans, CommandType.Text, Sql, null));
                if (tag)
                {
                    //Ƿڼ¼
                    if (n > 0)
                    {
                        UpdateSeen(trans, MovieID, UserID);
                        //״̬
                        Sql = "Update NT_MovieComment Set Score=-1 Where MovieID=" + MovieID + " And UserID=" + UserID;
                        DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                    }
                    else
                    {
                        //ڼ¼ֱ
                        Sql = "Insert Into NT_MovieComment(MovieID,UserID,Score,PostTime,PostIP) Values" +
                              "(" + MovieID + "," + UserID + ",-1,'" + DateTime.Now + "','" + NetSNS.Common.Public.GetClientIP() + "')";
                        DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                    }
                    //²뿴
                    Sql = "update NT_Movie set Wonna=Wonna+1 where MovieID=" + MovieID;
                    DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                }
                else
                {
                    UpdateSeen(trans, MovieID, UserID);
                    //״̬
                    Sql = "Update NT_MovieComment Set Score=-3 Where MovieID=" + MovieID + " And UserID=" + UserID;
                    DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                    //²뿴
                    Sql = "update NT_Movie set Wonna=Wonna-1 where MovieID=" + MovieID;
                    DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                }
                trans.Commit();
                UpdateScore(MovieID);
                return n;
            }
            catch (SqlException sqlEX)
            {
                trans.Rollback();
                throw sqlEX;
            }
            finally
            {
                if (sqlConn.State == ConnectionState.Open)
                {
                    sqlConn.Close();
                }
            }
        }

        /// <summary>
        /// ϴӰ
        /// </summary>
        /// <param name="Info">Ӱʵ</param>
        /// <returns>ϴɹ1</returns>
        public int AddMoviePoster(MoviePosterInfo Info)
        {
            SqlParameter[] param = getMoviePosterParameters(Info);
            string Sql = "Insert Into NT_MoviePoster([MovieID],[UserID],[PostTime],[PostIP],[FileName]) Values" +
                         "(@MovieID,@UserID,@PostTime,@PostIP,@FileName)";
            return Convert.ToInt32(DbHelper.ExecuteNonQuery(CommandType.Text, Sql, param));
        }

        /// <summary>
        /// ȡӰʵ
        /// </summary>
        /// <param name="MovieID">ӰID</param>
        /// <returns></returns>
        public MovieInfo GetMovieInfo(int MovieID)
        {
            MovieInfo MovInfo = new MovieInfo();
            MovInfo.MovieID = MovieID;
            string sql = "select * from NT_Movie where MovieID=" + MovieID;
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, sql, null);
            if (rd.Read())
            {
                MovInfo.Title = Convert.ToString(rd["Title"]);
                MovInfo.Director = Convert.ToString(rd["Director"]);
                MovInfo.Billing = Convert.ToString(rd["Billing"]);
                MovInfo.YearOnShow = Convert.ToInt32(rd["YearOnShow"]);
                MovInfo.Gut = Convert.ToString(rd["Gut"]);
                MovInfo.Comments = Convert.ToInt32(rd["Comments"]);
                MovInfo.Seen = Convert.ToInt32(rd["Seen"]);
                MovInfo.Wanna = Convert.ToInt32(rd["Wanna"]);
                MovInfo.Wonna = Convert.ToInt32(rd["Wonna"]);
                MovInfo.Score = Convert.ToInt32(rd["Score"]);
                MovInfo.PosterFile = Convert.ToString(rd["PosterFile"]);
                MovInfo.zt_dy = Convert.ToString(rd["zt_dy"]);
                MovInfo.zt_dy1 = Convert.ToString(rd["zt_dy1"]);
                MovInfo.zt_url = Convert.ToString(rd["zt_url"]);
                MovInfo.zt_url1 = Convert.ToString(rd["zt_url1"]);
                MovInfo.IsRec = Convert.ToInt32(rd["IsRec"]);
            }
            rd.Close();
            return MovInfo;
        }

        /// <summary>
        /// ȡӰʵ
        /// </summary>
        /// <param name="ID">Ӱ</param>
        /// <returns>صӰʵ</returns>
        public MoviePosterInfo getMoviePosterInfo(int ID)
        {
            MoviePosterInfo Info = new MoviePosterInfo();
            Info.ID = ID;
            string sql = "select ID,MovieID,UserID,PostTime,PostIP,FileName from NT_MoviePoster where ID=" + ID;
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, sql, null);
            if (rd.Read())
            {
                Info.MovieID = Convert.ToInt32(rd["MovieID"]);
                Info.UserID = Convert.ToInt32(rd["UserID"]);
                if (rd["PostTime"] != DBNull.Value) Info.PostTime = Convert.ToDateTime(rd["PostTime"]);
                if (rd["PostIP"] != DBNull.Value) Info.PostIP = Convert.ToString(rd["PostIP"]);
                if (rd["FileName"] != DBNull.Value) Info.FileName = Convert.ToString(rd["FileName"]);
            }
            rd.Close();
            return Info;
        }

        /// <summary>
        /// ɾӰ
        /// </summary>
        /// <param name="ID">Ӱ</param>
        /// <returns>ɾɹ1</returns>
        public int DelMoviePoster(int ID)
        {
            string Sql = "Delete From NT_MoviePoster Where ID=" + ID;
            return Convert.ToInt32(DbHelper.ExecuteNonQuery(CommandType.Text, Sql, null));
        }

        /// <summary>
        /// 캯
        /// </summary>
        /// <param name="Info">˽ʵ</param>
        /// <returns>SQL</returns>
        private SqlParameter[] getMovieParameters(MovieInfo Info)
        {
            SqlParameter[] param = new SqlParameter[17];

            param[0] = new SqlParameter("@MovieID", SqlDbType.Int, 4);
            param[0].Value = Info.MovieID;
            param[1] = new SqlParameter("@Title", SqlDbType.NVarChar, 50);
            param[1].Value = Info.Title;
            param[2] = new SqlParameter("@Director", SqlDbType.NVarChar, 255);
            param[2].Value = Info.Director;

            param[3] = new SqlParameter("@Billing", SqlDbType.NVarChar, 255);
            param[3].Value = Info.Billing;
            param[4] = new SqlParameter("@YearOnShow", SqlDbType.Int, 4);
            param[4].Value = Info.YearOnShow;
            param[5] = new SqlParameter("@Gut", SqlDbType.NVarChar, 4000);
            param[5].Value = Info.Gut;

            param[6] = new SqlParameter("@Comments", SqlDbType.Int, 4);
            param[6].Value = Info.Comments;
            param[7] = new SqlParameter("@Seen", SqlDbType.Int, 4);
            param[7].Value = Info.Seen;
            param[8] = new SqlParameter("@Wanna", SqlDbType.Int, 4);
            param[8].Value = Info.Wanna;

            param[9] = new SqlParameter("@Wonna", SqlDbType.Int, 4);
            param[9].Value = Info.Wonna;
            param[10] = new SqlParameter("@Score", SqlDbType.Int, 4);
            param[10].Value = Info.Score;
            param[11] = new SqlParameter("@PosterFile", SqlDbType.NVarChar, 50);
            param[11].Value = Info.PosterFile;

            param[12] = new SqlParameter("@ztdy", SqlDbType.NVarChar, 50);
            param[12].Value = Info.zt_dy;
            param[13] = new SqlParameter("@ztdy1", SqlDbType.NVarChar, 50);
            param[13].Value = Info.zt_dy1;
            param[14] = new SqlParameter("@zturl", SqlDbType.NText);
            param[14].Value = Info.zt_url;
            param[15] = new SqlParameter("@zturl1", SqlDbType.NText);
            param[15].Value = Info.zt_url1;
            param[16] = new SqlParameter("@IsRec", SqlDbType.Int, 4);
            param[16].Value = Info.IsRec;
            return param;
        }


        /// <summary>
        /// 캯
        /// </summary>
        /// <param name="Info">Ӱʵ</param>
        /// <returns>SQL</returns>
        private SqlParameter[] getMoviePosterParameters(MoviePosterInfo Info)
        {
            SqlParameter[] param = new SqlParameter[6];

            param[0] = new SqlParameter("@ID", SqlDbType.Int, 4);
            param[0].Value = Info.ID;
            param[1] = new SqlParameter("@MovieID", SqlDbType.Int, 4);
            param[1].Value = Info.MovieID;
            param[2] = new SqlParameter("@UserID", SqlDbType.Int, 4);
            param[2].Value = Info.UserID;

            param[3] = new SqlParameter("@PostTime", SqlDbType.DateTime, 8);
            param[3].Value = Info.PostTime;
            param[4] = new SqlParameter("@PostIP", SqlDbType.VarChar, 15);
            param[4].Value = Info.PostIP;
            param[5] = new SqlParameter("@FileName", SqlDbType.NVarChar, 255);
            param[5].Value = Info.FileName;

            return param;
        }

        /// <summary>
        /// ӵӰ
        /// </summary>
        /// <param name="Info">Ӱʵ</param>
        /// <returns>SQL</returns>
        private SqlParameter[] getMovieSortParameters(MovieSortInfo Info)
        {
            SqlParameter[] param = new SqlParameter[5];

            param[0] = new SqlParameter("@MovieID", SqlDbType.Int, 4);
            param[0].Value = Info.MovieID;
            param[1] = new SqlParameter("@SortID", SqlDbType.Int, 4);
            param[1].Value = Info.SortID;
            param[2] = new SqlParameter("@PostTime", SqlDbType.DateTime, 8);
            param[2].Value = Info.PostTime;

            param[3] = new SqlParameter("@PostIP", SqlDbType.VarChar, 15);
            param[3].Value = Info.PostIP;
            param[4] = new SqlParameter("@CreatorID", SqlDbType.Int, 4);
            param[4].Value = Info.CreatorID;

            return param;
        }

        //public IDataReader getMovieInfo(int MovieID)
        //{
        //    string sql = "select * from NT_Movie where MovieID=" + MovieID;
        //    return DbHelper.ExecuteReader(CommandType.Text, sql, null);
        //}
    }
}
