using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using NetSNS.DALFactory;
using NetSNS.DALProfile;
using NetSNS.Config;
using NetSNS.Model;

namespace NetSNS.DALSQLServer
{
    public class Notepad : DbBase, INotepad
    {
        /// <summary>
        /// ȡ±
        /// </summary>
        /// <param name="UserID">Ա</param>
        /// <returns></returns>
        public string GetContent(int UserID)
        {
            string sql = "select Content from NT_NotePad where UserID=" + UserID;
            return Convert.ToString(DbHelper.ExecuteScalar(CommandType.Text, sql, null));
        }
        /// <summary>
        /// ±Ϣ
        /// </summary>
        /// <param name="UserID">ûID</param>
        /// <param name="Content"></param>
        /// <returns></returns>
        public int SaveNote(int UserID, string Content)
        {
            SqlConnection sqlConn = new SqlConnection(DBConfig.CnString);
            sqlConn.Open();
            try
            {
                string sql = "select Count(ID) from NT_NotePad where UserID=@UserID";
                SqlParameter[] param = new SqlParameter[2];
                param[0] = new SqlParameter("@Content", SqlDbType.NVarChar, 4000);
                param[0].Value = Content;
                param[1] = new SqlParameter("@UserID", SqlDbType.Int, 4);
                param[1].Value = UserID;
                int n = Convert.ToInt32(DbHelper.ExecuteScalar(sqlConn, CommandType.Text, sql, param));
                if (n > 0)
                {
                    string sqlUpdate = "update NT_NotePad set Content=@Content where UserID=" + UserID.ToString();
                    n = DbHelper.ExecuteNonQuery(sqlConn, CommandType.Text, sqlUpdate, param);
                }
                else
                {
                    string sqlInsert = "insert into NT_NotePad (UserID,Content,LastPostTime,LastPostIP,IsLock) values (@UserID,@Content,'" + DateTime.Now.ToString() + "','" + NetSNS.Common.Public.GetClientIP() + "',0)";
                    n = DbHelper.ExecuteNonQuery(sqlConn, CommandType.Text, sqlInsert, param);
                }
                return n;
            }
            catch (SqlException sqlEx)
            {
                throw sqlEx;
            }
            finally
            {
                if (sqlConn.State == ConnectionState.Open)
                    sqlConn.Close();
            }
        }
        /// <summary>
        /// ȡNotepadʵ
        /// </summary>
        /// <param name="MiniID">NotepadID</param>
        /// <returns></returns>
        public NotePadInfo GetNoteInfo(int NoteID)
        {
            NotePadInfo NoteInfo = new NotePadInfo();
            NoteInfo.ID = NoteID;
            string sql = "select * from NT_NotePad where ID=" + NoteID.ToString();
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, sql, null);
            if (rd.Read())
            {
                NoteInfo.UserID = Convert.ToInt32(rd["UserID"].ToString());
                NoteInfo.Content = Convert.ToString(rd["Content"].ToString());
                NoteInfo.LastPostTime = Convert.ToDateTime(rd["LastPostTime"].ToString());
                NoteInfo.LastPostIP = Convert.ToString(rd["LastPostIP"].ToString());
                NoteInfo.IsLock = Convert.ToBoolean(rd["IsLock"].ToString());
            }
            rd.Close();
            return NoteInfo;
        }
        /// <summary>
        /// Ƿв鿴Ȩ
        /// </summary>
        /// <param name="guest"></param>
        /// <param name="masterid"></param>
        /// <returns></returns>
        bool INotepad.Authority(int guest, int masterid)
        {
            return true;
        }
    }
}
