using System;
using System.Collections.Generic;
using System.Text;
using NetSNS.DALFactory;
using NetSNS.Model;
using System.Data.SqlClient;
using NetSNS.DALProfile;
using System.Data;
using NetSNS.Config;
namespace NetSNS.DALSQLServer
{
    public class OnlineUser : DbBase, IOnlineUser
    {
        /// <summary>
        /// Ƿ
        /// </summary>
        /// <param name="userid">ûID</param>
        /// <returns></returns>
        public bool IsOnline(int userid)
        {
            SqlParameter parm = new SqlParameter("@userid", SqlDbType.Int, 4);
            parm.Value = userid;
            string sql = "select count(*) from NT_OnlineUser where userid=@userid";
            int ri = Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, sql, parm));
            if (ri > 0)
                return true;
            return false;
        }
        /// <summary>
        /// ȡõ½Ϣ
        /// </summary>
        /// <returns></returns>
        public OnlineUserInfo getInfo(int id)
        {
            OnlineUserInfo info = new OnlineUserInfo();
            SqlParameter parm = new SqlParameter("@id", SqlDbType.Int, 4);
            parm.Value = id;
            string sql = "select userid,username,lastip,lasturl,id,lasttime from NT_OnlineUser where id=@id";
            IDataReader dr = DbHelper.ExecuteReader(CommandType.Text, sql, parm);
            if (dr.Read())
            {
                info.UserID = dr.IsDBNull(0) ? 0 : dr.GetInt32(0);
                info.UserName = dr.IsDBNull(1) ? "" : dr.GetString(1);
                info.LastIP = dr.IsDBNull(2) ? "" : dr.GetString(2);
                info.LastURL = dr.IsDBNull(3) ? "" : dr.GetString(3);
                info.ID = dr.IsDBNull(4) ? 0 : dr.GetInt32(4);
                info.LastTime = dr.IsDBNull(5) ? DateTime.MinValue : dr.GetDateTime(5);
            }
            return info;
        }
        /// <summary>
        /// ȡõ½Ϣ
        /// </summary>
        /// <returns></returns>
        public OnlineUserInfo getInfo(int userid,bool isuserid)
        {
            if (!isuserid)
                return getInfo(userid);
            OnlineUserInfo info = new OnlineUserInfo();
            SqlParameter parm = new SqlParameter("@userid", SqlDbType.Int, 4);
            parm.Value = userid;
            string sql = "select userid,username,lastip,lasturl,id,lasttime from NT_OnlineUser where userid=@userid";
            IDataReader dr = DbHelper.ExecuteReader(CommandType.Text, sql, parm);
            if (dr.Read())
            {
                info.UserID = dr.IsDBNull(0) ? 0 : dr.GetInt32(0);
                info.UserName = dr.IsDBNull(1) ? "" : dr.GetString(1);
                info.LastIP = dr.IsDBNull(2) ? "" : dr.GetString(2);
                info.LastURL = dr.IsDBNull(3) ? "" : dr.GetString(3);
                info.ID = dr.IsDBNull(4) ? 0 : dr.GetInt32(4);
                info.LastTime = dr.IsDBNull(5) ? DateTime.MinValue : dr.GetDateTime(5);
            }
            return info;
        }
        /// <summary>
        /// û
        /// </summary>
        /// <param name="info"></param>
        /// <returns></returns>
        public int Add(OnlineUserInfo info)
        {
            SqlParameter[] parm = getParameters(info);
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();
            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                string sql = "delete from NT_OnlineUser where LastIP=@LastIP";
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, sql, parm);
                sql = "insert into NT_OnlineUser(userid,username,lastip,lasturl,lasttime) values(@UserID,@UserName,@LastIP,@LastUrl,@LastTime)";
                int rn = DbHelper.ExecuteNonQuery(trans, CommandType.Text, sql, parm);                
                trans.Commit();
                return rn;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }              
        }
        /// <summary>
        /// û
        /// </summary>
        /// <param name="info"></param>
        /// <returns></returns>
        public int Update(OnlineUserInfo info)
        {
            SqlParameter[] parm = getParameters(info);
            string sql = "update NT_OnlineUser set UserID=@UserID,UserName=@UserName,LastIP=@LastIP,LastUrl=@LastUrl,LastTime=@LastTime where UserID=@UserID and LastIP=@LastIP";
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, parm);
        }
        /// <summary>
        /// ɾû
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public int Delete(int id)
        {
            SqlParameter parm = new SqlParameter("@id", SqlDbType.Int, 4);
            parm.Value = id;
            string sql = "delete from NT_OnlineUser where id=@id";
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, parm);
        }
        /// <summary>
        /// ɾû
        /// </summary>
        /// <param name="userid"></param>
        /// <param name="isuserid"></param>
        /// <returns></returns>
        public int Delete(int userid,bool isuserid)
        {
            if (!isuserid)
                return Delete(userid);
            SqlParameter parm = new SqlParameter("@userid", SqlDbType.Int, 4);
            parm.Value = userid;
            string sql = "delete from NT_OnlineUser where userid=@userid";
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, parm);
        }
        /// <summary>
        /// ȡ
        /// </summary>
        /// <returns></returns>
        public int Count()
        {
            string sql = "select count(*) from NT_OnlineUser";
            return Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text,sql,null));
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="userid"></param>
        /// <param name="lastip"></param>
        /// <returns></returns>
        public bool CheckOnline(int userid, string lastip)
        {
            SqlParameter[] param = new SqlParameter[2];
            param[0] = new SqlParameter("@UserID", SqlDbType.Int, 4);
            param[0].Value = userid;
            param[1] = new SqlParameter("@LastIP", SqlDbType.NVarChar, 18);
            param[1].Value = lastip;
            string sql = "select count(*) from NT_OnlineUser where UserID=@UserID and LastIP=@LastIP";
            int rn = Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, sql, param));
            return rn > 0 ? true : false;
        }
        /// <summary>
        /// ɾû
        /// </summary>
        public void DeleteExpires()
        {
            SqlParameter param = new SqlParameter("@LastTime", SqlDbType.DateTime, 8);
            param.Value = DateTime.Now.AddMinutes(-20);
            string sql = "delete from NT_OnlineUser where LastTime<@LastTime";
            DbHelper.ExecuteNonQuery(CommandType.Text, sql, param);
        }
        /// <summary>
        /// б
        /// </summary>
        /// <returns></returns>
        public List<OnlineUserInfo> OnlineList()
        {
            List<OnlineUserInfo> infolist = new List<OnlineUserInfo>();
            SqlParameter param = new SqlParameter("@LastTime", SqlDbType.DateTime, 8);
            param.Value = DateTime.Now.AddMinutes(-20);
            string sql = "select userid,username,lastip,lasturl,id,lasttime from NT_OnlineUser where  where LastTime>@LastTime";
            IDataReader dr = DbHelper.ExecuteReader(CommandType.Text, sql, param);
            while (dr.Read())
            {
                OnlineUserInfo info = new OnlineUserInfo();
                info.UserID = dr.IsDBNull(0) ? 0 : dr.GetInt32(0);
                info.UserName = dr.IsDBNull(1) ? "" : dr.GetString(1);
                info.LastIP = dr.IsDBNull(2) ? "" : dr.GetString(2);
                info.LastURL = dr.IsDBNull(3) ? "" : dr.GetString(3);
                info.ID = dr.IsDBNull(4) ? 0 : dr.GetInt32(4);
                info.LastTime = dr.IsDBNull(5) ? DateTime.MinValue : dr.GetDateTime(5);
                infolist.Add(info);
            }
            dr.Dispose();
            return infolist;
        }
        /// <summary>
        /// SQL
        /// </summary>
        /// <param name="Info">ǰûϢʵ</param>
        /// <returns></returns>
        private SqlParameter[] getParameters(OnlineUserInfo Info)
        {
            SqlParameter[] param = new SqlParameter[6];
            param[0] = new SqlParameter("@ID", SqlDbType.Int, 4);
            param[0].Value = Info.ID;
            param[1] = new SqlParameter("@UserID", SqlDbType.Int, 4);
            param[1].Value = Info.UserID;
            param[2] = new SqlParameter("@UserName", SqlDbType.NVarChar, 50);
            param[2].Value = Info.UserName;
            param[3] = new SqlParameter("@LastIP", SqlDbType.NVarChar, 18);
            param[3].Value = Info.LastIP;
            param[4] = new SqlParameter("@LastUrl", SqlDbType.NVarChar, 256);
            param[4].Value = Info.LastURL;
            param[5] = new SqlParameter("@LastTime", SqlDbType.DateTime, 8);
            param[5].Value = Info.LastTime;           
            return param;
        }
    }
}
