//===========================================================
//==               (c)2008  NETSNS 1.0                     ==
//==            website:www.aspxcms.com                    ==
//==         qq:6458450,Email:qwsf01115@163.com            ==
//==               Code By Xi.Deng                         ==
//===========================================================
using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Common;
using System.Data.SqlClient;
using NetSNS.DALProfile;
using NetSNS.DALFactory;
using NetSNS.Model;
using NetSNS.Config;

namespace NetSNS.DALSQLServer
{
    /// <summary>
    /// Ƭ
    /// </summary>
    public class Photo : DbBase, IPhoto
    {
        /// <summary>
        /// Ƭ
        /// </summary>
        /// <param name="Info">Ƭʵ</param>
        /// <returns>ӳɹ1</returns>
        public int Add(PhotoInfo Info)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();

            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                SqlParameter[] param = getParameters(Info);
                string Sql = "Insert Into [NT_Photo]" +
                             "([AlbumID],[UploadUser],[Description],[Views],[FileSize],[State],[IsCover],[Comments],[PostTime]," +
                             "[PostIP],[IsLock],[PhotoType],[Width],[Height],[FilePath]) " +
                             "Values(@AlbumID,@UploadUser,@Description,@Views,@FileSize,@State,@IsCover,@Comments,@PostTime," +
                             "@PostIP,@IsLock,@PhotoType,@Width,@Height,@FilePath);" +
                             "Select @@IDENTITY";
                int PhotoID = Convert.ToInt32(DbHelper.ExecuteScalar(trans, CommandType.Text, Sql, param));

                //Ƭ
                Sql = "Update [NT_Album] set [ImagesCount]=[ImagesCount]+1 where [AlbumID]=@AlbumID";
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, param);

                //ȡƬ÷
                if (Info.PhotoType == 1)
                {
                    Sql = "Select [ImagesCount] from [NT_Album] where  [AlbumID]=@AlbumID";
                    int photoCount = Convert.ToInt32(DbHelper.ExecuteScalar(trans, CommandType.Text, Sql, param));
                    if (photoCount == 1)
                    {
                        Sql = "Update  [NT_Photo] set iscover=1 where PhotoID=" + PhotoID;
                        DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                    }
                }
                int n = 0;
                if (Info.PhotoType == 1)
                {
                    n = UserLog(trans, EnumUserAction.AddPhoto, Info.UploadUser, "ϴƬ", PhotoID);
                }
                else
                {
                    //»Աͷַ
                    Sql = "Update [NT_User] Set [Portrait]=" + PhotoID + " Where [UserID]=@UploadUser";
                    DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, param);
                    n = UserLog(trans, EnumUserAction.UpdateHead, Info.UploadUser, "ͷ", PhotoID);
                }
                trans.Commit();
                if (Info.PhotoType == 1)
                {
                    User us = new User();
                    us.updateinte(Info.UploadUser, 2, 0, 0, "ϴƬ");
                }
                return n;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// ޸Ƭ
        /// </summary>
        /// <param name="Info">Ƭʵ</param>
        /// <returns>޸ĳɹ1</returns>
        public int Edit(PhotoInfo Info)
        {
            SqlParameter[] param = getParameters(Info);
            string Sql = "Update [NT_Photo] " +
                         "Set [Description]=@Description,[IsCover]=@IsCover,[AlbumID]=@AlbumID " +
                         "Where [PhotoID]=@PhotoID And [UploadUser]=@UploadUser";
            return DbHelper.ExecuteNonQuery(CommandType.Text, Sql, param);
        }

        /// <summary>
        /// Ƭ鿴
        /// </summary>
        /// <param name="PhotoID">Ƭ</param>
        /// <returns>ӳɹ1</returns>
        public int AddViews(int PhotoID)
        {
            string Sql = "Update [NT_Photo] Set [Views]=[Views]+1 Where [PhotoID]=" + PhotoID;
            return DbHelper.ExecuteNonQuery(CommandType.Text, Sql, null);
        }

        /// <summary>
        /// Ƭ۴
        /// </summary>
        /// <param name="PhotoID">Ƭ</param>
        /// <returns>ӳɹ1</returns>
        public int AddComm(int PhotoID)
        {
            string Sql = "Update [NT_Photo] Set [Comments]=[Comments]+1 Where [PhotoID]=" + PhotoID;
            return DbHelper.ExecuteNonQuery(CommandType.Text, Sql, null);
        }


        /// <summary>
        /// ȡƬ鿴
        /// </summary>
        /// <param name="PhotoID">Ƭ</param>
        /// <returns>ز鿴</returns>
        public int ViewsCount(int PhotoID)
        {
            string Sql = "Select [Views] From [NT_Photo] Where [PhotoID]=" + PhotoID;
            return Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, Sql, null));
        }

        /// <summary>
        /// ȡƬ۴
        /// </summary>
        /// <param name="PhotoID">Ƭ</param>
        /// <returns>Ƭ۴</returns>
        public int CommCount(int PhotoID)
        {
            string Sql = "Select Count([PhotoID]) From [NT_Photo] Where [PhotoID]=" + PhotoID;
            return Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, Sql, null));
        }

        /// <summary>
        /// ɾƬ(̨)
        /// </summary>
        /// <param name="PhotoID">Ƭ</param>
        /// <returns>ɾɹ1</returns>
        public int Del(int PhotoID)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();
            Photo p = new Photo();
            PhotoInfo pi = p.Info(PhotoID);
            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                //־
                int n = UserLog(trans, EnumUserAction.DelPhoto, 0, "ɾƬ", PhotoID);
                //Ⱥ־״̬Ϊ
                string Sql = "Update [NT_UserLog] " +
                      "Set " +
                      "[IsLock]=" + (int)EnumIsLock.Lock + " " +
                      "Where " +
                      "([CorrespondInfo] In" +
                            "(Select [ID] From [NT_PhotoLasso] Where [PhotoID] =" + PhotoID + ") And " +
                                "([ActionType]=" + (int)EnumUserAction.AddLasso + " Or [ActionType]=" + (int)EnumUserAction.DelLasso + ")) " +
                      "Or " +
                      "([CorrespondInfo]=" + PhotoID + " And " +
                                "([ActionType]=" + (int)EnumUserAction.AddPhoto + " Or [ActionType]=" + (int)EnumUserAction.DelPhoto + " Or " +
                                    "[ActionType]=" + (int)EnumUserAction.UpdateHead + ")) ";
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);

                //ɾ֪ͨ
                Sql = "Delete From [NT_Notice] Where [MsgType]=" + (int)EnumNotifyType.PhotoComm + " And [Correspond]=" + PhotoID;
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);

                //ɾƬ۱
                Sql = "Delete From [NT_PhotoComment] Where [PhotoID]=" + PhotoID;
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                //ɾƬȦ˱
                Sql = "Delete From [NT_PhotoLasso] Where [PhotoID]=" + PhotoID;
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                //ӦƬ
                Sql = "Update [NT_Album] set ImagesCount=ImagesCount-1 where AlbumID=" + pi.AlbumID + "";
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                //ɾƬ
                Sql = "Delete From [NT_Photo] Where [PhotoID]=" + PhotoID;
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);

                trans.Commit();
                return n;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// ɾƬ(ǰ̨)
        /// </summary>
        /// <param name="PhotoID">Ƭ</param>
        /// <param name="UploadUser">Ƭϴ߱</param>
        /// <returns></returns>
        public int Del(int PhotoID, int UploadUser)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();
            Photo p = new Photo();
            PhotoInfo pi = p.Info(PhotoID);
            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                //ɾƬ
                string Sql = "Delete From [NT_Photo] Where [PhotoID]=" + PhotoID + " And [UploadUser]=" + UploadUser;
                int n = DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                if (n > 0)
                {
                    //־
                    UserLog(trans, EnumUserAction.DelPhoto, 0, "ɾƬ", PhotoID);
                    //Ⱥ־״̬Ϊ
                    Sql = "Update [NT_UserLog] " +
                          "Set " +
                          "[IsLock]=" + (int)EnumIsLock.Lock + " " +
                          "Where " +
                          "([CorrespondInfo] In" +
                                "(Select [ID] From [NT_PhotoLasso] Where [PhotoID] =" + PhotoID + ") And " +
                                    "([ActionType]=" + (int)EnumUserAction.AddLasso + " Or [ActionType]=" + (int)EnumUserAction.DelLasso + ")) " +
                          "Or " +
                          "([CorrespondInfo]=" + PhotoID + " And " +
                                    "([ActionType]=" + (int)EnumUserAction.AddPhoto + " Or [ActionType]=" + (int)EnumUserAction.DelPhoto + " Or " +
                                        "[ActionType]=" + (int)EnumUserAction.UpdateHead + ")) ";
                    DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);

                    //ӦƬ
                    Sql = "Update [NT_Album] set ImagesCount=ImagesCount-1 where AlbumID=" + pi.AlbumID + "";
                    DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);

                    //ɾ֪ͨ
                    Sql = "Delete From [NT_Notice] where [MsgType]=" + (int)EnumNotifyType.PhotoComm + " And [Correspond]=" + PhotoID;
                    DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);

                    //ɾƬ۱
                    Sql = "Delete From [NT_PhotoComment] Where [PhotoID]=" + PhotoID;
                    DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                    //ɾƬȦ˱
                    Sql = "Delete From [NT_PhotoLasso] Where [PhotoID]=" + PhotoID;
                    DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                }

                trans.Commit();
                User us = new User();
                us.updateinte(UploadUser, 2, 0, 1, "ɾƬ");
                return n;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// ȡûԱǰͷַ
        /// </summary>
        /// <param name="UserID">Ա</param>
        /// <returns>ͷַ</returns>
        public string NonceHead(int UserID)
        {
            string Sql = "Select [Portrait] From [NT_User] Where [UserID]=" + UserID;
            return Convert.ToString(DbHelper.ExecuteScalar(CommandType.Text, Sql, null));
        }

        /// <summary>
        /// ƬϢ
        /// </summary>
        /// <param name="PhotoID">Ƭ</param>
        /// <returns>Ƭʵ</returns>
        public PhotoInfo Info(int PhotoID)
        {
            PhotoInfo info = new PhotoInfo();
            string Sql = "Select [PhotoID],[AlbumID],[Description],[Views],[FileSize]," +
                         "[State],[IsCover],[Comments],[PostTime],[PostIP],[IsLock],[PhotoType],[Width],[Height],[UploadUser]," +
                         "[FilePath] " +
                         "From " +
                         "[NT_Photo] " +
                         "Where [PhotoID]=" + PhotoID;
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, Sql, null);
            if (rd.Read())
            {
                info.PhotoID = Convert.ToInt32(rd["PhotoID"].ToString());
                info.AlbumID = Convert.ToInt32(rd["AlbumID"].ToString());
                if (rd["Description"] != DBNull.Value) info.Description = rd["Description"].ToString();
                info.FileSize = Convert.ToInt32(rd["FileSize"].ToString());
                info.State = Convert.ToInt32(rd["State"].ToString());
                info.IsCover = Convert.ToBoolean(rd["IsCover"].ToString());
                info.Comments = Convert.ToInt32(rd["Comments"].ToString());
                info.PostTime = Convert.ToDateTime(rd["PostTime"].ToString());
                if (rd["PostIP"] != DBNull.Value) info.PostIP = rd["PostIP"].ToString();
                info.IsLock = (EnumIsLock)Convert.ToInt32(Convert.ToBoolean(rd["IsLock"].ToString()));
                info.PhotoType = Convert.ToInt32(rd["PhotoType"].ToString());
                info.Width = Convert.ToInt32(rd["Width"].ToString());
                info.Height = Convert.ToInt32(rd["Height"].ToString());
                info.UploadUser = Convert.ToInt32(rd["UploadUser"].ToString());
                info.Views = Convert.ToInt32(rd["Views"].ToString());
                if (rd["FilePath"] != DBNull.Value) info.FilePath = rd["FilePath"].ToString();
            }
            rd.Dispose();
            return info;
        }

        /// <summary>
        /// ƬϢб
        /// </summary>
        /// <param name="AlbumID"></param>
        /// <param name="UserID">û</param>
        /// <returns>Ƭ</returns>
        public List<PhotoInfo> InfoList(int AlbumID, int UserID)
        {
            string Sql = "Select [PhotoID],[AlbumID],[Description],[Views],[FileSize]," +
                         "[State],[IsCover],[Comments],[PostTime],[PostIP],[IsLock],[PhotoType],[Width],[Height],[UploadUser]," +
                         "[FilePath] " +
                         "From " +
                         "[NT_Photo] where IsLock=0 and PhotoType=1 ";

            if (AlbumID != 0)
            {
                Sql += " and [AlbumID]=" + AlbumID;
            }
            if (UserID != 0)
            {
                Sql += " and [UploadUser]=" + UserID;
            }
            Sql += " order by [PhotoID] desc";
            List<PhotoInfo> infolist = new List<PhotoInfo>();
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, Sql, null);
            while (rd.Read())
            {
                PhotoInfo info = new PhotoInfo();
                info.PhotoID = Convert.ToInt32(rd["PhotoID"].ToString());
                info.AlbumID = Convert.ToInt32(rd["AlbumID"].ToString());
                if (rd["Description"] != DBNull.Value) info.Description = rd["Description"].ToString();
                info.FileSize = Convert.ToInt32(rd["FileSize"].ToString());
                info.State = Convert.ToInt32(rd["State"].ToString());
                info.IsCover = Convert.ToBoolean(rd["IsCover"].ToString());
                info.Comments = Convert.ToInt32(rd["Comments"].ToString());
                info.PostTime = Convert.ToDateTime(rd["PostTime"].ToString());
                if (rd["PostIP"] != DBNull.Value) info.PostIP = rd["PostIP"].ToString();
                info.IsLock = (EnumIsLock)Convert.ToInt32(Convert.ToBoolean(rd["IsLock"].ToString()));
                info.PhotoType = Convert.ToInt32(rd["PhotoType"].ToString());
                info.Width = Convert.ToInt32(rd["Width"].ToString());
                info.Height = Convert.ToInt32(rd["Height"].ToString());
                info.UploadUser = Convert.ToInt32(rd["UploadUser"].ToString());
                info.Views = Convert.ToInt32(rd["Views"].ToString());
                if (rd["FilePath"] != DBNull.Value) info.FilePath = rd["FilePath"].ToString();
                infolist.Add(info);
            }
            rd.Dispose();
            return infolist;
        }
        /// <summary>
        /// ƬϢб
        /// </summary>
        /// <param name="AlbumID"></param>
        /// <returns>Ƭ</returns>
        public List<PhotoInfo> InfoList(int AlbumID)
        {
            string Sql = "Select [PhotoID],[AlbumID],[Description],[Views],[FileSize]," +
                         "[State],[IsCover],[Comments],[PostTime],[PostIP],[IsLock],[PhotoType],[Width],[Height],[UploadUser]," +
                         "[FilePath] " +
                         "From " +
                         "[NT_Photo] where IsLock=0 and PhotoType=1 ";


            Sql += " and [AlbumID]=" + AlbumID;

            Sql += " order by [PhotoID] desc";
            List<PhotoInfo> infolist = new List<PhotoInfo>();
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, Sql, null);
            while (rd.Read())
            {
                PhotoInfo info = new PhotoInfo();
                info.PhotoID = Convert.ToInt32(rd["PhotoID"].ToString());
                info.AlbumID = Convert.ToInt32(rd["AlbumID"].ToString());
                if (rd["Description"] != DBNull.Value) info.Description = rd["Description"].ToString();
                info.FileSize = Convert.ToInt32(rd["FileSize"].ToString());
                info.State = Convert.ToInt32(rd["State"].ToString());
                info.IsCover = Convert.ToBoolean(rd["IsCover"].ToString());
                info.Comments = Convert.ToInt32(rd["Comments"].ToString());
                info.PostTime = Convert.ToDateTime(rd["PostTime"].ToString());
                if (rd["PostIP"] != DBNull.Value) info.PostIP = rd["PostIP"].ToString();
                info.IsLock = (EnumIsLock)Convert.ToInt32(Convert.ToBoolean(rd["IsLock"].ToString()));
                info.PhotoType = Convert.ToInt32(rd["PhotoType"].ToString());
                info.Width = Convert.ToInt32(rd["Width"].ToString());
                info.Height = Convert.ToInt32(rd["Height"].ToString());
                info.UploadUser = Convert.ToInt32(rd["UploadUser"].ToString());
                info.Views = Convert.ToInt32(rd["Views"].ToString());
                if (rd["FilePath"] != DBNull.Value) info.FilePath = rd["FilePath"].ToString();
                infolist.Add(info);
            }
            rd.Dispose();
            return infolist;
        }

        /// <summary>
        /// ͷƬϢб
        /// </summary>
        /// <param name="AlbumID"></param>
        /// <param name="UserID">û</param>
        /// <returns>Ƭ</returns>
        public List<PhotoInfo> HeadInfoList(int AlbumID, int UserID)
        {
            string Sql = "Select [PhotoID],[AlbumID],[Description],[Views],[FileSize]," +
                         "[State],[IsCover],[Comments],[PostTime],[PostIP],[IsLock],[PhotoType],[Width],[Height],[UploadUser]," +
                         "[FilePath] " +
                         "From " +
                         "[NT_Photo] where IsLock=0 and PhotoType=0 ";

            if (AlbumID != 0)
            {
                Sql += " and [AlbumID]=" + AlbumID;
            }
            if (UserID != 0)
            {
                Sql += " and [UploadUser]=" + UserID;
            }
            Sql += " order by [PhotoID] desc";
            List<PhotoInfo> infolist = new List<PhotoInfo>();
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, Sql, null);
            while (rd.Read())
            {
                PhotoInfo info = new PhotoInfo();
                info.PhotoID = Convert.ToInt32(rd["PhotoID"].ToString());
                info.AlbumID = Convert.ToInt32(rd["AlbumID"].ToString());
                if (rd["Description"] != DBNull.Value) info.Description = rd["Description"].ToString();
                info.FileSize = Convert.ToInt32(rd["FileSize"].ToString());
                info.State = Convert.ToInt32(rd["State"].ToString());
                info.IsCover = Convert.ToBoolean(rd["IsCover"].ToString());
                info.Comments = Convert.ToInt32(rd["Comments"].ToString());
                info.PostTime = Convert.ToDateTime(rd["PostTime"].ToString());
                if (rd["PostIP"] != DBNull.Value) info.PostIP = rd["PostIP"].ToString();
                info.IsLock = (EnumIsLock)Convert.ToInt32(Convert.ToBoolean(rd["IsLock"].ToString()));
                info.PhotoType = Convert.ToInt32(rd["PhotoType"].ToString());
                info.Width = Convert.ToInt32(rd["Width"].ToString());
                info.Height = Convert.ToInt32(rd["Height"].ToString());
                info.UploadUser = Convert.ToInt32(rd["UploadUser"].ToString());
                info.Views = Convert.ToInt32(rd["Views"].ToString());
                if (rd["FilePath"] != DBNull.Value) info.FilePath = rd["FilePath"].ToString();
                infolist.Add(info);
            }
            rd.Dispose();
            return infolist;
        }
        /// <summary>
        /// 캯
        /// </summary>
        /// <param name="Info">Ƭʵ</param>
        /// <returns>SQL</returns>
        private SqlParameter[] getParameters(PhotoInfo Info)
        {
            SqlParameter[] param = new SqlParameter[18];

            param[0] = new SqlParameter("@PhotoID", SqlDbType.Int, 4);
            param[0].Value = Info.PhotoID;
            param[1] = new SqlParameter("@AlbumID", SqlDbType.Int, 4);
            param[1].Value = Info.AlbumID;
            param[2] = new SqlParameter("@Description", SqlDbType.NVarChar, 1000);
            param[2].Value = Info.Description;

            param[3] = new SqlParameter("@Views", SqlDbType.Int, 4);
            param[3].Value = Info.Views;
            param[4] = new SqlParameter("@FilePath", SqlDbType.NVarChar, 255);
            param[4].Value = Info.FilePath;
            param[5] = new SqlParameter("@FileSize", SqlDbType.Int, 4);
            param[5].Value = Info.FileSize;

            param[6] = new SqlParameter("@State", SqlDbType.Int, 4);
            param[6].Value = Info.State;
            param[7] = new SqlParameter("@IsCover", SqlDbType.Bit);
            param[7].Value = Info.IsCover;
            param[8] = new SqlParameter("@Comments", SqlDbType.Int, 4);
            param[8].Value = Info.Comments;

            param[9] = new SqlParameter("@PostTime", SqlDbType.DateTime, 8);
            param[9].Value = Info.PostTime;
            param[10] = new SqlParameter("@PostIP", SqlDbType.VarChar, 15);
            param[10].Value = Info.PostIP;
            param[11] = new SqlParameter("@IsLock", SqlDbType.Bit);
            param[11].Value = Info.IsLock;

            param[12] = new SqlParameter("@PhotoType", SqlDbType.Int, 4);
            param[12].Value = Info.PhotoType;
            param[13] = new SqlParameter("@Width", SqlDbType.Int, 4);
            param[13].Value = Info.Width;
            param[14] = new SqlParameter("@Height", SqlDbType.Int, 4);
            param[14].Value = Info.Height;

            param[15] = new SqlParameter("@UploadUser", SqlDbType.Int, 4);
            param[15].Value = Info.UploadUser;

            return param;
        }

        /// <summary>
        /// ͬһƬ
        /// </summary>
        /// <param name="photoID">ƬID</param>
        /// <returns></returns>
        public int PhotoCount(int photoID)
        {
            string Sql = "select Count(*) from [NT_Photo] where AlbumID=(select AlbumID from [NT_Photo] where PhotoID=" + photoID + ")";
            return Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, Sql, null));
        }


        /// <summary>
        /// ͬһһƬID
        /// </summary>
        /// <param name="photoID">ƬID</param>
        /// <returns></returns>
        public int NextPhotoID(int photoID)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();

            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                int returnValue = 0;
                string Sql = "select  top 1 PhotoID from [NT_Photo] where AlbumID=(select AlbumID from [NT_Photo] where PhotoID=" + photoID + ") and PhotoID>" + photoID + " order by PhotoID asc";
                object dresult = DbHelper.ExecuteScalar(trans, CommandType.Text, Sql, null);
                if (!Convert.IsDBNull(dresult) && dresult != null)
                {
                    returnValue = Convert.ToInt32(dresult);
                }
                else
                {
                    Sql = "select  top 1 PhotoID from [NT_Photo] where AlbumID=(select AlbumID from [NT_Photo] where PhotoID=" + photoID + ")  order by PhotoID asc";
                    dresult = DbHelper.ExecuteScalar(trans, CommandType.Text, Sql, null);
                    if (!Convert.IsDBNull(dresult) && dresult != null)
                    {
                        returnValue = Convert.ToInt32(dresult);
                    }
                }
                trans.Commit();
                return returnValue;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// ͬһһƬID
        /// </summary>
        /// <param name="photoID">ƬID</param>
        /// <returns></returns>
        public int PrePhotoID(int photoID)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();

            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                int returnValue = 0;
                string Sql = "select top 1 PhotoID from [NT_Photo] where AlbumID=(select AlbumID from [NT_Photo] where PhotoID=" + photoID + ") and PhotoID<" + photoID + " order by PhotoID desc";
                object dresult = DbHelper.ExecuteScalar(trans, CommandType.Text, Sql, null);
                if (!Convert.IsDBNull(dresult) && dresult != null)
                {
                    returnValue = Convert.ToInt32(dresult);
                }
                else
                {
                    Sql = "select  top 1 PhotoID from [NT_Photo] where AlbumID=(select AlbumID from [NT_Photo] where PhotoID=" + photoID + ")  order by PhotoID desc";
                    dresult = DbHelper.ExecuteScalar(trans, CommandType.Text, Sql, null);
                    if (!Convert.IsDBNull(dresult) && dresult != null)
                    {
                        returnValue = Convert.ToInt32(dresult);
                    }
                }
                trans.Commit();
                return returnValue;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }


        /// <summary>
        /// Ƭλеĵڼ
        /// </summary>
        /// <param name="photoID"></param>
        /// <returns></returns>
        public int TheNumber(int photoID)
        {
            int i = 0;
            string Sql = "select PhotoID from [NT_Photo] where AlbumID=(select AlbumID from [NT_Photo] where PhotoID=" + photoID + ") order by PhotoID asc";
            IDataReader dr = DbHelper.ExecuteReader(CommandType.Text, Sql, null);
            while (dr.Read())
            {
                i++;
                if (Convert.ToInt32(dr[0]) == photoID)
                {
                    break;
                }
            }
            dr.Dispose();
            return i;
        }


        /// <summary>
        /// ÷Ƭ
        /// </summary>
        /// <param name="photoID">Ƭ</param>
        /// <param name="UserID">Ա</param>
        /// <param name="tf">trueͷ</param>
        public void SetCover(int photoID, int UserID, bool tf)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();

            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                string Sql = "update [NT_Photo] set Iscover=(1) where PhotoID=" + photoID;
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                Sql = "update [NT_Photo] set Iscover=(0) where PhotoID<>" + photoID + " and AlbumID=(select AlbumID from [NT_Photo] where PhotoID=" + photoID + ")";
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);

                if (tf)
                {
                    //»Աͷַ
                    Sql = "Update [NT_User] Set [Portrait]=" + photoID + " Where [UserID]=" + UserID;
                    DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                }
                trans.Commit();
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="PhotoID">ƬID</param>
        /// <returns></returns>
        public int Lock(int PhotoID)
        {
            string Sql = "update [NT_Photo] set IsLock=(1) where PhotoID=" + PhotoID;
            return DbHelper.ExecuteNonQuery(CommandType.Text, Sql, null);
        }

        /// <summary>
        /// ͷĿ
        /// </summary>
        /// <param name="PhotoID">Ƭid</param>
        /// <param name="UserID">ûID</param>
        /// <returns></returns>
        public int HeadCount(int PhotoID, int UserID)
        {
            string Sql = "select count(*) from [NT_Photo] where PhotoType=0 and UploadUser=" + UserID;
            return Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, Sql, null));
        }


        /// <summary>
        /// ͷһƬ
        /// </summary>
        /// <param name="photoID">ƬID</param>
        /// <param name="UserID">ûID</param>
        /// <returns></returns>
        public int NextPhotoID(int photoID, int UserID)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();

            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                int returnValue = 0;
                string Sql = "select  top 1 PhotoID from [NT_Photo] where AlbumID=(select AlbumID from [NT_Photo] where PhotoID=" + photoID + ") and PhotoID>" + photoID + "  and PhotoType=0 and UploadUser=" + UserID + " order by PhotoID asc";
                object dresult = DbHelper.ExecuteScalar(trans, CommandType.Text, Sql, null);
                if (!Convert.IsDBNull(dresult) && dresult != null)
                {
                    returnValue = Convert.ToInt32(dresult);
                }
                else
                {
                    Sql = "select  top 1 PhotoID from [NT_Photo] where AlbumID=(select AlbumID from [NT_Photo] where PhotoID=" + photoID + ")  and PhotoType=0 and UploadUser=" + UserID + " order by PhotoID asc";
                    dresult = DbHelper.ExecuteScalar(trans, CommandType.Text, Sql, null);
                    if (!Convert.IsDBNull(dresult) && dresult != null)
                    {
                        returnValue = Convert.ToInt32(dresult);
                    }
                }
                trans.Commit();
                return returnValue;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }


        /// <summary>
        /// ͬһһƬID,ͷ
        /// </summary>
        /// <param name="photoID">ƬID</param>
        /// <param name="UserID">ûID</param>
        /// <returns></returns>
        public int PrePhotoID(int photoID, int UserID)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();

            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                int returnValue = 0;
                string Sql = "select top 1 PhotoID from [NT_Photo] where AlbumID=(select AlbumID from [NT_Photo] where PhotoID=" + photoID + ") and PhotoID<" + photoID + " and PhotoType=0 and UploadUser=" + UserID + " order by PhotoID desc";
                object dresult = DbHelper.ExecuteScalar(trans, CommandType.Text, Sql, null);
                if (!Convert.IsDBNull(dresult) && dresult != null)
                {
                    returnValue = Convert.ToInt32(dresult);
                }
                else
                {
                    Sql = "select  top 1 PhotoID from [NT_Photo] where AlbumID=(select AlbumID from [NT_Photo] where PhotoID=" + photoID + ") and PhotoType=0 and UploadUser=" + UserID + "  order by PhotoID desc";
                    dresult = DbHelper.ExecuteScalar(trans, CommandType.Text, Sql, null);
                    if (!Convert.IsDBNull(dresult) && dresult != null)
                    {
                        returnValue = Convert.ToInt32(dresult);
                    }
                }
                trans.Commit();
                return returnValue;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// Ƭλеĵڼ,ͷ
        /// </summary>
        /// <param name="photoID">ƬID</param>
        /// <param name="UserID">ûID</param>
        /// <returns></returns>
        public int TheNumber(int photoID, int UserID)
        {
            int i = 0;
            string Sql = "select PhotoID from [NT_Photo] where AlbumID=(select AlbumID from [NT_Photo] where PhotoID=" + photoID + ") and PhotoID<" + photoID + " and PhotoType=0 and UploadUser=" + UserID + "  order by PhotoID asc";
            IDataReader dr = DbHelper.ExecuteReader(CommandType.Text, Sql, null);
            while (dr.Read())
            {
                i++;
                if (Convert.ToInt32(dr[0]) == photoID)
                {
                    break;
                }
            }
            dr.Dispose();
            return i;
        }

        /// <summary>
        /// ȺƬ
        /// </summary>
        /// <param name="GroupID">ȺID</param>
        /// <returns></returns>
        public List<PhotoInfo> GroupInfoList(int GroupID)
        {
            string Sql = "Select top 12 [PhotoID],[AlbumID],[Description],[Views],[FileSize]," +
                         "[State],[IsCover],[Comments],[PostTime],[PostIP],[IsLock],[PhotoType],[Width],[Height],[UploadUser]," +
                         "[FilePath] " +
                         "From " +
                         "[NT_Photo] where IsLock=0 and PhotoType=1 ";


            Sql += " and AlbumID in (select AlbumID from NT_Album where GroupID=" + GroupID + ")";

            Sql += " order by [PhotoID] desc";
            List<PhotoInfo> infolist = new List<PhotoInfo>();
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, Sql, null);
            while (rd.Read())
            {
                PhotoInfo info = new PhotoInfo();
                info.PhotoID = Convert.ToInt32(rd["PhotoID"].ToString());
                info.AlbumID = Convert.ToInt32(rd["AlbumID"].ToString());
                if (rd["Description"] != DBNull.Value) info.Description = rd["Description"].ToString();
                info.FileSize = Convert.ToInt32(rd["FileSize"].ToString());
                info.State = Convert.ToInt32(rd["State"].ToString());
                info.IsCover = Convert.ToBoolean(rd["IsCover"].ToString());
                info.Comments = Convert.ToInt32(rd["Comments"].ToString());
                info.PostTime = Convert.ToDateTime(rd["PostTime"].ToString());
                if (rd["PostIP"] != DBNull.Value) info.PostIP = rd["PostIP"].ToString();
                info.IsLock = (EnumIsLock)Convert.ToInt32(Convert.ToBoolean(rd["IsLock"].ToString()));
                info.PhotoType = Convert.ToInt32(rd["PhotoType"].ToString());
                info.Width = Convert.ToInt32(rd["Width"].ToString());
                info.Height = Convert.ToInt32(rd["Height"].ToString());
                info.UploadUser = Convert.ToInt32(rd["UploadUser"].ToString());
                info.Views = Convert.ToInt32(rd["Views"].ToString());
                if (rd["FilePath"] != DBNull.Value) info.FilePath = rd["FilePath"].ToString();
                infolist.Add(info);
            }
            rd.Dispose();
            return infolist;
        }
    }
}
