//===========================================================
//==               (c)2008  NETSNS 1.0                     ==
//==            website:www.aspxcms.com                    ==
//==         qq:6458450,Email:qwsf01115@163.com            ==
//==               Code By Xi.Deng                         ==
//===========================================================
using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Common;
using System.Data.SqlClient;
using NetSNS.DALProfile;
using NetSNS.DALFactory;
using NetSNS.Model;
using NetSNS.Config;

namespace NetSNS.DALSQLServer
{
    /// <summary>
    /// Ƭ
    /// </summary>
    public class PhotoComment : DbBase, IPhotoComment
    {
        /// <summary>
        /// Ƭ
        /// </summary>
        /// <param name="Info">Ƭʵ</param>
        /// <returns>ӳɹ1</returns>
        public int Add(PhotoCommentInfo Info, int UserID)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();
            try
            {
                Photo photo = new Photo();
                PhotoInfo photoinfo = new PhotoInfo();
                photoinfo = photo.Info(Info.PhotoID);
                Album album = new Album();
                AlbumInfo albuminfo = new AlbumInfo();
                albuminfo = album.Info(photoinfo.AlbumID);

                if (!CheckPrivacy(Conn, albuminfo.Privacy, Info.UserID, albuminfo.UserID))
                    return 0;

                photo.AddComm(Info.PhotoID);

                SqlTransaction trans = Conn.BeginTransaction();
                try
                {
                    SqlParameter[] param = getParameters(Info);
                    string Sql = "Insert Into [NT_PhotoComment]" +
                                 "([PhotoID],[UserID],[Content],[PostTime],[PostIP],[IsLock],[CommentID]) " +
                                 "Values(@PhotoID,@UserID,@Content,@PostTime,@PostIP,@IsLock,@CommentID)" +
                                 "Select @@IDENTITY";
                    int ID = Convert.ToInt32(DbHelper.ExecuteScalar(trans, CommandType.Text, Sql, param));
                    int nums = 0;
                    if (UserID != Info.UserID)
                    {
                        nums = Notify(trans, EnumNotifyType.PhotoComm, Info.UserID, photoinfo.UploadUser, " {AlbumID=" + photoinfo.AlbumID.ToString() + "} е", Info.PhotoID);
                    }
                    trans.Commit();
                    User us = new User();
                    us.updateinte(UserID, 1, 0, 0,"Ƭ");

                    return nums;
                }
                catch (SqlException e)
                {
                    trans.Rollback();
                    throw e;
                }
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// ɾƬ(̨)
        /// </summary>
        /// <param name="ID">۱</param>
        /// <returns>ɾɹ1</returns>
        public int Del(int ID)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();

            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                string Sql = "Select [PhotoID] From [NT_PhotoComment] Where [ID]=" + ID;
                int PhotoID = Convert.ToInt32(DbHelper.ExecuteScalar(trans, CommandType.Text, Sql, null));

                Sql = "Delete From [NT_PhotoComment] Where [ID]=" + ID;
                int n = DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);

                Sql = "Update [NT_Photo] Set [Comments]=[Comments]-1 Where [PhotoID]=" + PhotoID;
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                trans.Commit();

                return n;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// ɾƬ(ǰ̨)
        /// </summary>
        /// <param name="ID">۱</param>
        /// <param name="UserID">Ա</param>
        /// <returns>ɾɹ1</returns>
        public int Del(int ID, int UserID)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();

            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                string Sql = "Select [PhotoID] From [NT_PhotoComment] Where [ID]=" + ID;
                int PhotoID = Convert.ToInt32(DbHelper.ExecuteScalar(trans, CommandType.Text, Sql, null));

                Sql = "Delete From [NT_PhotoComment] Where ([ID]=" + ID + " or CommentID=" + ID + ") And [UserID]=" + UserID;
                int n = DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                Sql = "Update [NT_Photo] Set [Comments]=[Comments]-1 Where [PhotoID]=" + PhotoID;
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                trans.Commit();
                User us = new User();
                us.updateinte(UserID, 1, 0, 1,"ɾƬ");
                return n;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// ȡƬϢ
        /// </summary>
        /// <param name="ID">۱</param>
        /// <returns>Ƭʵ</returns>
        public PhotoCommentInfo Info(int ID)
        {
            PhotoCommentInfo info = new PhotoCommentInfo();
            string Sql = "Select [ID],[PhotoID],[UserID],[Content],[PostTime],[PostIP],[IsLock],[CommentID] " +
                         "From " +
                         "[NT_PhotoComment] " +
                         "Where [ID]=" + ID;
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, Sql, null);
            if (rd.Read())
            {
                info.ID = Convert.ToInt32(rd["ID"].ToString());
                info.PhotoID = Convert.ToInt32(rd["PhotoID"].ToString());
                info.UserID = Convert.ToInt32(rd["UserID"].ToString());
                if (rd["Content"] != DBNull.Value) info.Content = rd["Content"].ToString();
                info.PostTime = Convert.ToDateTime(rd["PostTime"].ToString());
                if (rd["PostIP"] != DBNull.Value) info.PostIP = rd["PostIP"].ToString();
                string islock = rd["IsLock"].ToString().ToLower();
                if (islock == "true")
                {
                    info.IsLock = EnumIsLock.Lock;
                }
                else
                {
                    info.IsLock = EnumIsLock.UnLock;
                }
                info.CommentID = Convert.ToInt32(rd["CommentID"].ToString());
            }
            rd.Close();
            return info;
        }


        /// <summary>
        /// ȡƬϢб
        /// </summary>
        /// <param name="PhotoID">Ƭid</param>
        /// <returns></returns>
        public List<PhotoCommentInfo> InfoList(int PhotoID)
        {
            List<PhotoCommentInfo> infolist = new List<PhotoCommentInfo>();
            string Sql = "Select [ID],[PhotoID],[UserID],[Content],[PostTime],[PostIP],[IsLock],CommentID " +
                         "From " +
                         "[NT_PhotoComment] " +
                         "Where [PhotoID]=" + PhotoID;
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, Sql, null);
            while (rd.Read())
            {
                PhotoCommentInfo info = new PhotoCommentInfo();
                info.ID = Convert.ToInt32(rd["ID"].ToString());
                info.PhotoID = Convert.ToInt32(rd["PhotoID"].ToString());
                info.UserID = Convert.ToInt32(rd["UserID"].ToString());
                if (rd["Content"] != DBNull.Value) info.Content = rd["Content"].ToString();
                info.PostTime = Convert.ToDateTime(rd["PostTime"].ToString());
                if (rd["PostIP"] != DBNull.Value) info.PostIP = rd["PostIP"].ToString();
                string islock = rd["IsLock"].ToString().ToLower();
                if (islock == "true")
                {
                    info.IsLock = EnumIsLock.Lock;
                }
                else
                {
                    info.IsLock = EnumIsLock.UnLock;
                }
                info.CommentID = Convert.ToInt32(rd["CommentID"].ToString());
                infolist.Add(info);
            }
            rd.Close();
            return infolist;
        }
        /// <summary>
        /// ȡƬظ
        /// </summary>
        /// <param name="PhotoID">ID</param>
        /// <returns></returns>
        public List<PhotoCommentInfo> CommentList(int CommentID)
        {
            List<PhotoCommentInfo> infolist = new List<PhotoCommentInfo>();
            string Sql = "Select [ID],[PhotoID],[UserID],[Content],[PostTime],[PostIP],[IsLock],CommentID " +
                         "From " +
                         "[NT_PhotoComment] " +
                         "Where [CommentID]=" + CommentID;
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, Sql, null);
            while (rd.Read())
            {
                PhotoCommentInfo info = new PhotoCommentInfo();
                info.ID = Convert.ToInt32(rd["ID"].ToString());
                info.PhotoID = Convert.ToInt32(rd["PhotoID"].ToString());
                info.UserID = Convert.ToInt32(rd["UserID"].ToString());
                if (rd["Content"] != DBNull.Value) info.Content = rd["Content"].ToString();
                info.PostTime = Convert.ToDateTime(rd["PostTime"].ToString());
                if (rd["PostIP"] != DBNull.Value) info.PostIP = rd["PostIP"].ToString();
                string islock = rd["IsLock"].ToString().ToLower();
                if (islock == "true")
                {
                    info.IsLock = EnumIsLock.Lock;
                }
                else
                {
                    info.IsLock = EnumIsLock.UnLock;
                }
                info.CommentID = Convert.ToInt32(rd["CommentID"].ToString());
                infolist.Add(info);
            }
            rd.Close();
            return infolist;
        }


        /// <summary>
        /// 캯
        /// </summary>
        /// <param name="Info">Ƭʵ</param>
        /// <returns>SQL</returns>
        private SqlParameter[] getParameters(PhotoCommentInfo Info)
        {
            SqlParameter[] param = new SqlParameter[8];

            param[0] = new SqlParameter("@ID", SqlDbType.Int, 4);
            param[0].Value = Info.ID;
            param[1] = new SqlParameter("@PhotoID", SqlDbType.Int, 4);
            param[1].Value = Info.PhotoID;
            param[2] = new SqlParameter("@UserID", SqlDbType.Int, 4);
            param[2].Value = Info.UserID;

            param[3] = new SqlParameter("@Content", SqlDbType.NVarChar, 1000);
            param[3].Value = Info.Content;
            param[4] = new SqlParameter("@PostTime", SqlDbType.DateTime, 8);
            param[4].Value = Info.PostTime;
            param[5] = new SqlParameter("@PostIP", SqlDbType.NVarChar, 15);
            param[5].Value = Info.PostIP;

            param[6] = new SqlParameter("@IsLock", SqlDbType.Bit);
            param[6].Value = Info.IsLock;
            param[7] = new SqlParameter("@CommentID", SqlDbType.Int, 4);
            param[7].Value = Info.CommentID;
            return param;
        }
    }
}
