//===========================================================
//==               (c)2008  NETSNS 1.0                     ==
//==            website:www.aspxcms.com                    ==
//==         qq:6458450,Email:qwsf01115@163.com            ==
//==               Code By Xi.Deng                         ==
//===========================================================
using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Common;
using System.Data.SqlClient;
using NetSNS.DALProfile;
using NetSNS.DALFactory;
using NetSNS.Model;
using NetSNS.Config;

namespace NetSNS.DALSQLServer
{
    /// <summary>
    /// ƬȦ
    /// </summary>
    public class PhotoLasso : DbBase, IPhotoLasso
    {
        /// <summary>
        /// ƬȦϢ
        /// </summary>
        /// <param name="Info">ƬȦʵ</param>
        /// <returns>ӳɹ1</returns>
        public int Add(PhotoLassoInfo Info)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();

            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                SqlParameter[] param = getParameters(Info);
                string Sql = "select Count(*) from [NT_PhotoLasso] where PhotoID=@PhotoID and FriendID=@FriendID";
                int Cnum = Convert.ToInt32(DbHelper.ExecuteScalar(trans, CommandType.Text, Sql, param));
                if (Cnum > 0)
                {
                    trans.Commit();
                    return 0;
                }
                Sql = "Insert Into [NT_PhotoLasso]" +
                             "([PhotoID],[FriendID],[UserID],[PosX],[PosY],[PosW],[PosH],[PostTime],[PostIP],[IsLock],[Description])" +
                             "Values" +
                             "(@PhotoID,@FriendID,@UserID,@PosX,@PosY,@PosW,@PosH,@PostTime,@PostIP,@IsLock,@Description)";
                DbHelper.ExecuteScalar(trans, CommandType.Text, Sql, param);

                int n = 0;
                if (Info.FriendID == Info.UserID)
                {
                    n = UserLog(trans, EnumUserAction.AddLasso, Info.UserID, "ƬȦԼ", Info.PhotoID, Info.FriendID);
                    Notify(trans, EnumNotifyType.LassoOneself, Info.UserID, Info.FriendID, "ƬȦԼ", Info.PhotoID);
                }
                else
                {
                    n = UserLog(trans, EnumUserAction.AddLasso, Info.UserID, "ƬбȦ˳", Info.PhotoID, Info.FriendID);
                    Notify(trans, EnumNotifyType.LassoOther, Info.UserID, Info.FriendID, "Ƭб{UserID=" + Info.UserID + "}Ȧ˳", Info.PhotoID);
                }
                trans.Commit();
                return n;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// ɾƬȦ
        /// </summary>
        /// <param name="ID"></param>
        /// <param name="UserID">û</param>
        /// <param name="FriendID">Ȧѱ</param>
        /// <returns>ɾɹ1</returns>
        public int Del(int ID, int UserID, int FriendID)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();

            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                //ɾƬȦ˱
                string Sql = "Delete From [NT_PhotoLasso] " +
                             "Where [ID]=" + ID + " And ([UserID]=" + UserID + " Or [FriendID]=" + FriendID + ")";
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                //־
                int n = UserLog(trans, EnumUserAction.DelLasso, UserID, "ɾȦ", ID, FriendID);
                //Ⱥ־״̬Ϊ
                Sql = "Update [NT_UserLog] Set [IsLock]=" + (int)EnumIsLock.Lock + " Where [CorrespondInfo]=" + ID + " " +
                      "And ([ActionType]=" + (int)EnumUserAction.DelLasso + " Or [ActionType]=" + (int)EnumUserAction.AddLasso + ")";
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);

                trans.Commit();
                return n;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// ȡƬȦϢ
        /// </summary>
        /// <param name="ID">ƬȦ˱</param>
        /// <returns>ƬȦʵ</returns>
        public PhotoLassoInfo Info(int ID)
        {
            PhotoLassoInfo info = new PhotoLassoInfo();
            string Sql = "Select [ID],[PhotoID],[FriendID],[UserID],[PosX],[PosY],[PosW],[PosH],[PostTime],[PostIP],[IsLock],[Description] " +
                         "From " +
                         "[NT_PhotoLasso] " +
                         "Where [ID]=" + ID;
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, Sql, null);
            if (rd.Read())
            {
                info.ID = Convert.ToInt32(rd["ID"].ToString());
                info.PhotoID = Convert.ToInt32(rd["PhotoID"].ToString());
                info.FriendID = Convert.ToInt32(rd["FriendID"].ToString());
                info.UserID = Convert.ToInt32(rd["UserID"].ToString());
                info.PosX = Convert.ToInt32(rd["PosX"].ToString());
                info.PosY = Convert.ToInt32(rd["PosY"].ToString());
                try
                {
                    info.PosW = Convert.ToInt32(rd["PosW"].ToString());
                    info.PosH = Convert.ToInt32(rd["PosH"].ToString());
                }
                catch { };
                info.PostTime = Convert.ToDateTime(rd["PostTime"].ToString());
                if (rd["PostIP"] != DBNull.Value) info.PostIP = rd["PostIP"].ToString();
                if (rd["IsLock"].ToString() == "true")
                {
                    info.IsLock = EnumIsLock.Lock;
                }
                else
                {
                    info.IsLock = EnumIsLock.UnLock;
                }
                if (rd["Description"] != DBNull.Value) info.Description = rd["Description"].ToString();
            }
            rd.Dispose();
            return info;
        }

        /// <summary>
        /// ȡӦƬȦϢ
        /// </summary>
        /// <param name="PhotoID">ƬID</param>
        /// <returns></returns>
        public List<PhotoLassoInfo> InfoList(int PhotoID)
        {
            List<PhotoLassoInfo> infolist = new List<PhotoLassoInfo>();
            string Sql = "Select [ID],[PhotoID],[FriendID],[UserID],[PosX],[PosY],[PosW],[PosH],[PostTime],[PostIP],[IsLock],[Description] " +
                         "From " +
                         "[NT_PhotoLasso] " +
                         "Where IsLock=(0) and [PhotoID]=" + PhotoID;
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, Sql, null);
            while (rd.Read())
            {
                PhotoLassoInfo info = new PhotoLassoInfo();
                info.ID = Convert.ToInt32(rd["ID"].ToString());
                info.PhotoID = Convert.ToInt32(rd["PhotoID"].ToString());
                info.FriendID = Convert.ToInt32(rd["FriendID"].ToString());
                info.UserID = Convert.ToInt32(rd["UserID"].ToString());
                info.PosX = Convert.ToInt32(rd["PosX"].ToString());
                info.PosY = Convert.ToInt32(rd["PosY"].ToString());
                try
                {
                    info.PosW = Convert.ToInt32(rd["PosW"].ToString());
                    info.PosH = Convert.ToInt32(rd["PosH"].ToString());
                }
                catch { };
                info.PostTime = Convert.ToDateTime(rd["PostTime"].ToString());
                if (rd["PostIP"] != DBNull.Value) info.PostIP = rd["PostIP"].ToString();
                if (rd["IsLock"].ToString() == "true")
                {
                    info.IsLock = EnumIsLock.Lock;
                }
                else
                {
                    info.IsLock = EnumIsLock.UnLock;
                }
                if (rd["Description"] != DBNull.Value) info.Description = rd["Description"].ToString();
                infolist.Add(info);
            }
            rd.Dispose();
            return infolist;

        }

        /// <summary>
        /// ȡȦϢ
        /// </summary>
        /// <param name="AlbumID">ID</param>
        /// <returns></returns>
        public List<PhotoLassoInfo> AlbumLasso(int AlbumID)
        {
            List<PhotoLassoInfo> infolist = new List<PhotoLassoInfo>();
            string Sql = "Select [ID],[PhotoID],[FriendID],[UserID],[PosX],[PosY],[PosW],[PosH],[PostTime],[PostIP],[IsLock],[Description] " +
                         "From " +
                         "[NT_PhotoLasso] " +
                         "Where  IsLock=(0) and [PhotoID] in (Select PhotoID from [NT_Photo] where AlbumID=" + AlbumID + ")";
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, Sql, null);
            while (rd.Read())
            {
                PhotoLassoInfo info = new PhotoLassoInfo();
                info.ID = Convert.ToInt32(rd["ID"].ToString());
                info.PhotoID = Convert.ToInt32(rd["PhotoID"].ToString());
                info.FriendID = Convert.ToInt32(rd["FriendID"].ToString());
                info.UserID = Convert.ToInt32(rd["UserID"].ToString());
                info.PosX = Convert.ToInt32(rd["PosX"].ToString());
                info.PosY = Convert.ToInt32(rd["PosY"].ToString());
                try
                {
                    info.PosW = Convert.ToInt32(rd["PosW"].ToString());
                    info.PosH = Convert.ToInt32(rd["PosH"].ToString());
                }
                catch { };
                info.PostTime = Convert.ToDateTime(rd["PostTime"].ToString());
                if (rd["PostIP"] != DBNull.Value) info.PostIP = rd["PostIP"].ToString();
                if (rd["IsLock"].ToString() == "true")
                {
                    info.IsLock = EnumIsLock.Lock;
                }
                else
                {
                    info.IsLock = EnumIsLock.UnLock;
                }
                if (rd["Description"] != DBNull.Value) info.Description = rd["Description"].ToString();
                infolist.Add(info);
            }
            rd.Dispose();
            return infolist;
        }


        /// <summary>
        /// ȡӦƬȦϢ
        /// </summary>
        /// <param name="PhotoID">ûID</param>
        /// <returns></returns>
        public List<PhotoLassoInfo> FriendInfoList(int UserID)
        {
            List<PhotoLassoInfo> infolist = new List<PhotoLassoInfo>();
            string Sql = "Select [ID],[PhotoID],[FriendID],[UserID],[PosX],[PosY],[PosW],[PosH],[PostTime],[PostIP],[IsLock],[Description] " +
                         "From " +
                         "[NT_PhotoLasso] " +
                         "Where  IsLock=(0) and [FriendID] in (select FriendID from [NT_Friend] where UserID=" + UserID + ")";
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, Sql, null);
            while (rd.Read())
            {
                PhotoLassoInfo info = new PhotoLassoInfo();
                info.ID = Convert.ToInt32(rd["ID"].ToString());
                info.PhotoID = Convert.ToInt32(rd["PhotoID"].ToString());
                info.FriendID = Convert.ToInt32(rd["FriendID"].ToString());
                info.UserID = Convert.ToInt32(rd["UserID"].ToString());
                info.PosX = Convert.ToInt32(rd["PosX"].ToString());
                info.PosY = Convert.ToInt32(rd["PosY"].ToString());
                try
                {
                    info.PosW = Convert.ToInt32(rd["PosW"].ToString());
                    info.PosH = Convert.ToInt32(rd["PosH"].ToString());
                }
                catch { };
                info.PostTime = Convert.ToDateTime(rd["PostTime"].ToString());
                if (rd["PostIP"] != DBNull.Value) info.PostIP = rd["PostIP"].ToString();
                if (rd["IsLock"].ToString() == "true")
                {
                    info.IsLock = EnumIsLock.Lock;
                }
                else
                {
                    info.IsLock = EnumIsLock.UnLock;
                }
                if (rd["Description"] != DBNull.Value) info.Description = rd["Description"].ToString();
                infolist.Add(info);
            }
            rd.Dispose();
            return infolist;

        }

        /// <summary>
        /// ȡĳ˱ȦƬȦϢ
        /// </summary>
        /// <param name="UserID">Ƭû</param>
        /// <param name="isSelf">ǷԼ</param>
        /// <returns></returns>
        public List<PhotoLassoInfo> UserInfoList(int UserID, bool isSelf)
        {
            List<PhotoLassoInfo> infolist = new List<PhotoLassoInfo>();
            string Sql = string.Empty;
            if (isSelf)
            {
                Sql = "Select [ID],[PhotoID],[FriendID],[UserID],[PosX],[PosY],[PosW],[PosH],[PostTime],[PostIP],[IsLock],[Description] " +
                         "From " +
                         "[NT_PhotoLasso] " +
                         "Where  IsLock=(0) and [FriendID]=" + UserID + " and PhotoID in (select PhotoID from [NT_Photo] where UserID=" + UserID + " )";
            }
            else
            {
                Sql = "Select [ID],[PhotoID],[FriendID],[UserID],[PosX],[PosY],[PosW],[PosH],[PostTime],[PostIP],[IsLock],[Description] " +
                         "From " +
                         "[NT_PhotoLasso] " +
                         "Where  IsLock=(0) and [FriendID]=" + UserID + " and PhotoID not in (select PhotoID from [NT_Photo] where UserID=" + UserID + " )";
            }
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, Sql, null);
            while (rd.Read())
            {
                PhotoLassoInfo info = new PhotoLassoInfo();
                info.ID = Convert.ToInt32(rd["ID"].ToString());
                info.PhotoID = Convert.ToInt32(rd["PhotoID"].ToString());
                info.FriendID = Convert.ToInt32(rd["FriendID"].ToString());
                info.UserID = Convert.ToInt32(rd["UserID"].ToString());
                info.PosX = Convert.ToInt32(rd["PosX"].ToString());
                info.PosY = Convert.ToInt32(rd["PosY"].ToString());
                try
                {
                    info.PosW = Convert.ToInt32(rd["PosW"].ToString());
                    info.PosH = Convert.ToInt32(rd["PosH"].ToString());
                }
                catch { };
                info.PostTime = Convert.ToDateTime(rd["PostTime"].ToString());
                if (rd["PostIP"] != DBNull.Value) info.PostIP = rd["PostIP"].ToString();
                if (rd["IsLock"].ToString() == "true")
                {
                    info.IsLock = EnumIsLock.Lock;
                }
                else
                {
                    info.IsLock = EnumIsLock.UnLock;
                }
                if (rd["Description"] != DBNull.Value) info.Description = rd["Description"].ToString();
                infolist.Add(info);
            }
            rd.Dispose();
            return infolist;
        }
        /// <summary>
        /// 캯
        /// </summary>
        /// <param name="Info">ƬȦʵ</param>
        /// <returns>SQL</returns>
        private SqlParameter[] getParameters(PhotoLassoInfo Info)
        {
            SqlParameter[] param = new SqlParameter[12];

            param[0] = new SqlParameter("@ID", SqlDbType.Int, 4);
            param[0].Value = Info.ID;
            param[1] = new SqlParameter("@PhotoID", SqlDbType.Int, 4);
            param[1].Value = Info.PhotoID;
            param[2] = new SqlParameter("@FriendID", SqlDbType.Int, 4);
            param[2].Value = Info.FriendID;

            param[3] = new SqlParameter("@UserID", SqlDbType.Int, 4);
            param[3].Value = Info.UserID;
            param[4] = new SqlParameter("@PosX", SqlDbType.Int, 4);
            param[4].Value = Info.PosX;
            param[5] = new SqlParameter("@PosY", SqlDbType.Int, 4);
            param[5].Value = Info.PosY;

            param[6] = new SqlParameter("@PostTime", SqlDbType.DateTime, 8);
            param[6].Value = Info.PostTime;
            param[7] = new SqlParameter("@PostIP", SqlDbType.VarChar, 15);
            param[7].Value = Info.PostIP;
            param[8] = new SqlParameter("@IsLock", SqlDbType.Bit);
            param[8].Value = (int)Info.IsLock;

            param[9] = new SqlParameter("@Description", SqlDbType.NVarChar, 50);
            param[9].Value = Info.Description;

            param[10] = new SqlParameter("@PosW", SqlDbType.Int, 4);
            param[10].Value = Info.PosW;
            param[11] = new SqlParameter("@PosH", SqlDbType.Int, 4);
            param[11].Value = Info.PosH;

            return param;
        }
    }
}
