using System;
using System.Collections.Generic;
using System.Text;
using NetSNS.DALFactory;
using System.Data;
using System.Data.SqlClient;
using NetSNS.DALProfile;
using NetSNS.Model;
using NetSNS.Config;

namespace NetSNS.DALSQLServer
{
    public class Props : DbBase, IProps
    {
        /// <summary>
        /// б
        /// </summary>
        /// <returns></returns>
        public DataTable getProps()
        {
            string sql = "select PropsName,Role,Integral,Currency,Path,Total,Sales,IsLock,Type from NT_Props where Islock=0 order by ID desc";
            return DbHelper.ExecuteTable(CommandType.Text,sql,null);
        }

        /// <summary>
        /// ݵ߱ŶϢ
        /// </summary>
        /// <param name="ID">߱</param>
        /// <returns></returns>
        public IDataReader getPropsbyId(int ID)
        {
            SqlParameter param = new SqlParameter("@ID", ID);
            string sql = "select PropsName,Role,Integral,Currency,Path,Total,Sales,IsLock,Type,Pvalue from NT_Props where ID=@ID order by ID desc";
            return DbHelper.ExecuteReader(CommandType.Text,sql,param);
        }

        /// <summary>
        /// ݻԱŶӵеĵϢ
        /// </summary>
        /// <param name="ID">Ա</param>
        /// <returns></returns>
        public DataTable getPropsbyUserID(int ID)
        {
            SqlParameter param = new SqlParameter("@ID", ID);
            string sql = "select a.ID,a.PropsName,a.Role,a.Integral,a.Currency,a.Path,a.Islock,a.Total,a.Sales,b.UserID,b.Total,a.Type from NT_Props a inner join NT_UserProps b on a.ID=b.PropsID where b.UserID=@ID and a.IsLock=0 order by a.ID desc";
            return DbHelper.ExecuteTable(CommandType.Text, sql, param);
        }
        
        /// <summary>
        /// ɾ
        /// </summary>
        /// <param name="ID">߱</param>
        /// <returns></returns>
        public int DelProps(int ID)
        {
            SqlParameter param = new SqlParameter("@ID", ID);
            string sql = "delete from NT_Props where ID=@ID";
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, param);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="ID">߱</param>
        /// <returns></returns>
        public int LockProps(int ID,int value)
        {
            SqlParameter[] param = new SqlParameter[2];
            param[0] = new SqlParameter("@ID", SqlDbType.Int, 4);
            param[0].Value = ID;
            param[1] = new SqlParameter("@value", SqlDbType.Int, 4);
            param[1].Value = value;
            string sql = "update NT_Props set Islock=@value where ID=@ID";
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, param);
        }

        /// <summary>
        /// /µ
        /// </summary>
        /// <param name="ID">߱</param>
        /// <returns></returns>
        public int AddUpdateProps(NetSNS.Model.PropsInfo Info, int flag)
        {
            SqlParameter[] param = getParameters(Info);
            string sql = string.Empty;

            if (flag == 0)//
            {
                sql = "insert into NT_Props(PropsName,Role,Integral,Currency,Path,Total,Sales,IsLock,Type,Pvalue) values(@PropsName,@Role,@Integral,@Currency,@Path,@Total,@Sales,0,@Type,@Pvalue)";
            }
            else if (flag == 1)//޸
            {
                sql = "update NT_Props set PropsName=@PropsName,Role=@Role,Integral=@Integral,Currency=@Currency,Path=@Path,Total=@Total,Type=@Type,Pvalue=@Pvalue where ID=@ID";
            }
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, param);
        }
        /// <summary>
        /// ȡõϢ
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public PropsInfo GetPropsInfo(int ID)
        {
            PropsInfo info = new PropsInfo();
            SqlParameter param = new SqlParameter("@ID", ID);
            string sql = "select PropsName,Role,Currency,Path,Total,Sales,IsLock,Type,Integral,ID,Pvalue from NT_Props where ID=@ID order by ID desc";
            IDataReader dr = DbHelper.ExecuteReader(CommandType.Text, sql, param);
            if (dr.Read())
            {
                info.PropsName = dr.GetString(0);
                if (!dr.IsDBNull(1)) info.Role = dr.GetString(1);
                info.Currency = dr.GetInt32(2);
                info.Path = dr.GetString(3);
                info.Total = dr.GetInt32(4);
                info.Sales = dr.GetInt32(5);
                info.Islock = Convert.ToInt32(dr.GetBoolean(6));
                info.Type = dr.GetInt32(7);
                info.Integral = dr.GetInt32(8);
                info.ID = dr.GetInt32(9);
                if (!dr.IsDBNull(10)) info.Pvalue = dr.GetInt32(10);
            }
            dr.Dispose();
            return info;
        }
        /// <summary>
        /// 캯 
        /// </summary>
        /// <param name="Info">Ϣ</param>
        /// <returns>SQL</returns>
        private SqlParameter[] getParameters(NetSNS.Model.PropsInfo Info)
        {
            SqlParameter[] param = new SqlParameter[11];

            param[0] = new SqlParameter("@ID", SqlDbType.Int,4);
            param[0].Value = Info.ID;
            param[1] = new SqlParameter("@PropsName", SqlDbType.NVarChar,100);
            param[1].Value = Info.PropsName;
            param[2] = new SqlParameter("@Role", SqlDbType.NVarChar,200);
            param[2].Value = Info.Role;
            param[3] = new SqlParameter("@Integral", SqlDbType.Int, 4);
            param[3].Value = Info.Integral;
            param[4] = new SqlParameter("@Currency", SqlDbType.Int, 4);
            param[4].Value = Info.Currency;
            param[5] = new SqlParameter("@Path", SqlDbType.NVarChar, 100);
            param[5].Value = Info.Path;
            param[6] = new SqlParameter("@Total", SqlDbType.Int, 4);
            param[6].Value = Info.Total;
            param[7] = new SqlParameter("@Sales", SqlDbType.Int, 4);
            param[7].Value = Info.Sales;
            param[8] = new SqlParameter("@Islock", SqlDbType.Bit,1);
            param[8].Value = Info.Islock;
            param[9] = new SqlParameter("@Type", SqlDbType.Int, 1);
            param[9].Value = Info.Type;
            param[10] = new SqlParameter("@Pvalue", SqlDbType.Int, 4);
            param[10].Value = Info.Pvalue;
            return param;
        }

        /// <summary>
        /// ûֻ߷ҹ
        /// </summary>
        /// <param name="integral">ûֻ߷</param>
        /// <param name="fg">true false</param>
        /// <returns></returns>
        public int getBuyProps(int userID,int integral,int PropsID,int num,bool fg)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();
            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                SqlParameter[] param = new SqlParameter[3];
                param[0] = new SqlParameter("@userID", SqlDbType.Int, 4);
                param[0].Value = userID;
                param[1] = new SqlParameter("@PropsID", SqlDbType.Int, 4);
                param[1].Value = PropsID;
                param[2] = new SqlParameter("@num", SqlDbType.Int, 4);
                param[2].Value = num;

                string sql = "select integral,inteyb from NT_User where UserID=@userID";
                int temp = 0;
                int n = 0;
                string sqlstr = string.Empty;

                IDataReader dt = DbHelper.ExecuteReader(CommandType.Text, sql, param);
                while (dt.Read())//ȡԱĻ
                {
                    if (fg)
                    {
                        temp = int.Parse(dt["integral"].ToString());
                    }
                    else
                    {
                        temp = int.Parse(dt["inteyb"].ToString());
                    }
                }

                if (temp >= integral * num)
                {
                    int s = temp - (integral * num);
                    //жϸõߵ
                    sql = "select Total from dbo.NT_Props where ID=@PropsID";
                    IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, sql, param);
                    while (rd.Read())
                    {
                        if (int.Parse(rd["Total"].ToString())< num)                       
                        {
                            n = 3;
                            return n;
                        }
                    }

                    //ҵĵ
                    sqlstr = "select count(ID) from NT_UserProps where UserID=@userID and PropsID=@PropsID";//жϸûǷѾõ
                    if (Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, sqlstr, param)) > 0)
                    {
                        sqlstr = "update dbo.NT_UserProps set Total=Total+@num where UserID=@userID and PropsID=@PropsID";
                    }
                    else
                    {
                        sqlstr = "insert dbo.NT_UserProps(UserID,PropsID,Total) values(@userID,@PropsID,@num)";
                    }

                    if (DbHelper.ExecuteNonQuery(trans, CommandType.Text, sqlstr, param) == 1)
                    {
                        //۳ԱӦĻֻ
                        if (fg)
                        {
                            sql = "update NT_User set integral=" + s + " where UserID=@userID";
                        }
                        else
                        {
                            sql = "update NT_User set inteyb=" + s + " where UserID=@userID";
                        }
                        n = DbHelper.ExecuteNonQuery(trans, CommandType.Text, sql, param);
                    }

                    //µ߱
                    if (n == 1)
                    {
                        sql = "update dbo.NT_Props set Total=Total-@num,Sales=Sales+@num where ID=@PropsID";
                        n = DbHelper.ExecuteNonQuery(trans, CommandType.Text, sql, param);
                    }
                }
                else
                {
                    n = 2;
                }
                trans.Commit();
                return n;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// ʹõ
        /// </summary>
        /// <param name="PropsID"></param>
        /// <returns></returns>
        public int UseProps(int PropsID, string Name, int UserID, int type)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();
            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                SqlParameter[] param = new SqlParameter[3];
                param[0] = new SqlParameter("@PropsID", SqlDbType.Int, 4);
                param[0].Value = PropsID;
                param[1] = new SqlParameter("@UserID", SqlDbType.Int, 4);
                param[1].Value = UserID;
                param[2] = new SqlParameter("@Name", SqlDbType.NVarChar, 50);
                param[2].Value = Name;
                int n = 0;
                int UseUserID = UserID;
                string sql = null;

                //жϸûǷ
                sql = "select UserID,UserName from NT_User where UserName=@Name";
                IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, sql, param);

                while (!rd.Read())
                {
                    UseUserID=int.Parse(rd["UserID"].ToString());
                    n = 2;
                    return n;
                }
                //µ
                sql = "update NT_UserProps set Total=Total-1 where UserID=@UserID and PropsID=@PropsID";
                n = DbHelper.ExecuteNonQuery(trans,CommandType.Text, sql, param);
                
                if (n == 1)
                {
                    sql = "delete from NT_UserProps where UserID=@userID and PropsID=@PropsID and Total=0";
                    n = DbHelper.ExecuteNonQuery(trans,CommandType.Text, sql, param);
                }

                if (type == (int)EnumPropsType.RedEnvelope)//ʹú
                {
                    Random rand = new Random();
                    sql = "update NT_User set integral=integral+" + rand.Next(500, 1000) + " where UserID=" + UseUserID;
                    n = DbHelper.ExecuteNonQuery(trans, CommandType.Text, sql, param);
                }
                trans.Commit();
                return n;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// ͵߸
        /// </summary>
        /// <param name="Name">ͻԱ</param>
        /// <param name="num">͵</param>
        /// <param name="PropsID">߱</param>
        /// <returns></returns>
        public int userGift(int userID,string Name, int num,int PropsID)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();
            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                SqlParameter[] param = new SqlParameter[4];
                param[0] = new SqlParameter("@Name", SqlDbType.NVarChar,50);
                param[0].Value = Name;
                param[1] = new SqlParameter("@num", SqlDbType.Int, 4);
                param[1].Value = num;
                param[2] = new SqlParameter("@PropsID", SqlDbType.Int, 4);
                param[2].Value = PropsID;
                param[3] = new SqlParameter("@userID", SqlDbType.Int, 4);
                param[3].Value = userID;
                int n = 0;

                //жϸûǷ
                string sql = "select UserID,UserName from NT_User where UserName=@Name";
                IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, sql, param);

                while (!rd.Read())
                {
                    n = 2;
                    return n;
                }
                int acceptID=int.Parse(rd["UserID"].ToString());
                //жϸûǷѾõ
                string sqlstr = "select count(ID) from NT_UserProps where UserID=" + acceptID + " and PropsID=@PropsID";
                if (Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, sqlstr, param)) > 0)
                {
                    sqlstr = "update dbo.NT_UserProps set Total=Total+@num where UserID=" + acceptID + " and PropsID=@PropsID";
                }
                else
                {
                    sqlstr = "insert dbo.NT_UserProps(UserID,PropsID,Total) values(" + acceptID + ",@PropsID,@num)";
                }

                if (DbHelper.ExecuteNonQuery(trans, CommandType.Text, sqlstr, param) == 1)
                {
                    sqlstr = "update NT_UserProps set Total=Total-@num where UserID=@userID and PropsID=@PropsID";
            
                    if (DbHelper.ExecuteNonQuery(trans, CommandType.Text, sqlstr, param) == 1)
                    {
                        sql = "delete from NT_UserProps where UserID=@userID and PropsID=@PropsID and Total=0";
                        DbHelper.ExecuteNonQuery(trans, CommandType.Text, sql, param);
                        //֪ͨ
                        Notify(trans, EnumNotifyType.GiveProps, userID, acceptID, "˵߸", userID);
                        n = 1;
                    }
                }
            
                trans.Commit();
                return n;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="UserID">Ա</param>
        /// <param name="OrderID"></param>
        /// <param name="Name">Ʒ</param>
        /// <param name="Description">Ʒ˵</param>
        /// <param name="Price">۸</param>
        /// <returns></returns>
        public int AddOrders(int UserID,string Name,string Description,int Price,string OrderID)
        {
            SqlParameter[] param = new SqlParameter[5];
            param[0] = new SqlParameter("@UserID", SqlDbType.Int, 4);
            param[0].Value = UserID;
            param[1] = new SqlParameter("@Name", SqlDbType.NVarChar, 100);
            param[1].Value = Name;
            param[2] = new SqlParameter("@Description", SqlDbType.NVarChar, 200);
            param[2].Value = Description;
            param[3] = new SqlParameter("@Price", SqlDbType.Int, 4);
            param[3].Value = Price;
            param[4] = new SqlParameter("@OrderID", SqlDbType.NVarChar, 100);
            param[4].Value = OrderID;
            string sql = "insert into NT_Order(UserID,OrderID,Name,Description,Price,State,CreateTime) values(@UserID,@OrderID,@Name,@Description,@Price,1,getdate())";
            return DbHelper.ExecuteNonQuery(CommandType.Text,sql,param);
        }

        /// <summary>
        /// ¶֧״̬
        /// </summary>
        /// <param name="UserID"></param>
        /// <param name="OrderID"></param>
        /// <returns></returns>
        public int UpdateOrders(int UserID, string OrderID)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();
            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                int n = 0;
                SqlParameter[] param = new SqlParameter[2];
                param[0] = new SqlParameter("@UserID", SqlDbType.Int, 4);
                param[0].Value = UserID;
                param[1] = new SqlParameter("@OrderID", SqlDbType.NVarChar, 100);
                param[1].Value = OrderID;
                string sql = "update NT_Order set State=0 where UserID=@UserID and OrderID=@OrderID";
                if (DbHelper.ExecuteNonQuery(trans,CommandType.Text, sql, param) == 1)
                {
                    string sqlsel = "select Price from NT_Order where UserID=@UserID and OrderID=@OrderID";
                    int price = Convert.ToInt32(DbHelper.ExecuteScalar(trans, CommandType.Text, sqlsel, param));

                    string strsql = "update NT_User set inteyb=inteyb+" + price + " where UserID=@UserID";
                    n = DbHelper.ExecuteNonQuery(trans, CommandType.Text, strsql, param);
                }
                trans.Commit();
                return n;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// ɾ
        /// </summary>
        /// <param name="Id"></param>
        /// <returns></returns>
        public int delOrder(int Id)
        {
            SqlParameter param = new SqlParameter("@ID", Id);
            string sql = "delete from NT_Order where ID=@ID";
            return DbHelper.ExecuteNonQuery(CommandType.Text,sql,param);
        }
    }
}