using System;
using System.Collections.Generic;
using System.Text;
using NetSNS.DALFactory.Quanzi;
using System.Data;
using NetSNS.Model;
using System.Data.SqlClient;
using NetSNS.DALProfile;

namespace NetSNS.DALSQLServer.Quanzi
{
    public class Ranking:DbBase,IRanking 
    {
        /// <summary>
        /// ʵȦ
        /// </summary>
        /// <param name="UserID">ûID</param>
        /// <param name="num"></param>
        /// <returns></returns>
        public List<UserGroupInfo> LastVisitQuan(int UserID, int num)
        {
            List<UserGroupInfo> list = new List<UserGroupInfo>();
            string topstr = string.Empty;
            if (num != 0)
            {
                topstr = " top " + num + "";
            }
            SqlParameter param = new SqlParameter("@UserID", UserID);
            string sql = "SELECT  " + topstr + "   A.GroupID, B.Type, A.Hot, A.Ding, A.GroupName, A.UserID, A.Members, A.Bulletin, A.NetWork, A.Portrait, A.Publicity, A.State, A.PostTime, A.PostIP"
            + " FROM         NT_UserGroup AS A INNER JOIN "
            + "         Nt_GroupType AS B ON B.GroupID = A.GroupID INNER JOIN"
            + "          Nt_GroupVisit AS c ON c.GroupID = A.GroupID"
            + " WHERE     (c.UserID = 1)"
            + " ORDER BY c.ID DESC";
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, sql, param);
            while (rd.Read())
            {
                UserGroupInfo info = new UserGroupInfo();
                info.GroupID = Convert.ToInt32(rd["GroupID"].ToString());
                if (rd["GroupName"] != DBNull.Value) info.GroupName = rd["GroupName"].ToString();
                info.UserID = Convert.ToInt32(rd["UserID"].ToString());
                info.Members = Convert.ToInt32(rd["Members"].ToString());
                if (rd["Bulletin"] != DBNull.Value) info.Bulletin = rd["Bulletin"].ToString();
                info.NetWork = Convert.ToInt32(rd["NetWork"].ToString());
                if (rd["Portrait"] != DBNull.Value) info.Portrait = rd["Portrait"].ToString();
                info.Publicity = (EnumGroupPrivacy)Convert.ToInt32(rd["Publicity"].ToString());
                info.State = Convert.ToInt32(rd["State"].ToString());
                info.PostTime = Convert.ToDateTime(rd["PostTime"].ToString());
                if (rd["PostIP"] != DBNull.Value) info.PostIP = rd["PostIP"].ToString();
                if (rd["Type"] != DBNull.Value) info.Type = Convert.ToInt32(rd["Type"]);
                info.TypeStr = NetSNS.Config.GroupConfig.GetGroupType(info.Type);
                if (rd["Hot"] != DBNull.Value) info.Hot = Convert.ToInt32(rd["Hot"]);
                if (rd["Ding"] != DBNull.Value) info.Ding = Convert.ToInt32(rd["Ding"]);
                list.Add(info);
            }
            rd.Dispose();
            return list;
        }
        /// <summary>
        /// ܻӭȦ
        /// </summary>
        /// <param name="num"></param>
        /// <returns></returns>
        public List<UserGroupInfo> FavoriteQuan(int num)
        {
            List<UserGroupInfo> list = new List<UserGroupInfo>();
            string topstr = string.Empty;
            if (num != 0)
            {
                topstr = " top " + num + "";
            }            
            string sql = "select " + topstr + " A.[GroupID],B.[Type],Hot,Ding,[GroupName],[UserID],[Members],[Bulletin],[NetWork],[Portrait],[Publicity],[State],[PostTime],[PostIP] From [NT_UserGroup] A inner Join Nt_GroupType B on B.GroupID=A.GroupID order by Ding desc";
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, sql, null);
            while (rd.Read())
            {
                UserGroupInfo info = new UserGroupInfo();
                info.GroupID = Convert.ToInt32(rd["GroupID"].ToString());
                if (rd["GroupName"] != DBNull.Value) info.GroupName = rd["GroupName"].ToString();
                info.UserID = Convert.ToInt32(rd["UserID"].ToString());
                info.Members = Convert.ToInt32(rd["Members"].ToString());
                if (rd["Bulletin"] != DBNull.Value) info.Bulletin = rd["Bulletin"].ToString();
                info.NetWork = Convert.ToInt32(rd["NetWork"].ToString());
                if (rd["Portrait"] != DBNull.Value) info.Portrait = rd["Portrait"].ToString();
                info.Publicity = (EnumGroupPrivacy)Convert.ToInt32(rd["Publicity"].ToString());
                info.State = Convert.ToInt32(rd["State"].ToString());
                info.PostTime = Convert.ToDateTime(rd["PostTime"].ToString());
                if (rd["PostIP"] != DBNull.Value) info.PostIP = rd["PostIP"].ToString();
                if (rd["Type"] != DBNull.Value) info.Type = Convert.ToInt32(rd["Type"]);
                info.TypeStr = NetSNS.Config.GroupConfig.GetGroupType(info.Type);
                if (rd["Hot"] != DBNull.Value) info.Hot = Convert.ToInt32(rd["Hot"]);
                if (rd["Ding"] != DBNull.Value) info.Ding = Convert.ToInt32(rd["Ding"]);
                list.Add(info);
            }
            rd.Dispose();
            return list;
        }
        /// <summary>
        /// ܻӭȦ
        /// </summary>
        /// <param name="GroupType">Ȧ</param>
        /// <param name="num"></param>
        /// <returns></returns>
        public List<UserGroupInfo> FavoriteQuan(int GroupType,int num)
        {
            List<UserGroupInfo> list = new List<UserGroupInfo>();
            string topstr = string.Empty;
            if (num != 0)
            {
                topstr = " top " + num + "";
            }
            string sql = "select " + topstr + " A.[GroupID],B.[Type],Hot,Ding,[GroupName],[UserID],[Members],[Bulletin],[NetWork],[Portrait],[Publicity],[State],[PostTime],[PostIP] From [NT_UserGroup] A inner Join Nt_GroupType B on B.GroupID=A.GroupID where B.[Type]=" + GroupType + " order by Ding desc";
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, sql, null);
            while (rd.Read())
            {
                UserGroupInfo info = new UserGroupInfo();
                info.GroupID = Convert.ToInt32(rd["GroupID"].ToString());
                if (rd["GroupName"] != DBNull.Value) info.GroupName = rd["GroupName"].ToString();
                info.UserID = Convert.ToInt32(rd["UserID"].ToString());
                info.Members = Convert.ToInt32(rd["Members"].ToString());
                if (rd["Bulletin"] != DBNull.Value) info.Bulletin = rd["Bulletin"].ToString();
                info.NetWork = Convert.ToInt32(rd["NetWork"].ToString());
                if (rd["Portrait"] != DBNull.Value) info.Portrait = rd["Portrait"].ToString();
                info.Publicity = (EnumGroupPrivacy)Convert.ToInt32(rd["Publicity"].ToString());
                info.State = Convert.ToInt32(rd["State"].ToString());
                info.PostTime = Convert.ToDateTime(rd["PostTime"].ToString());
                if (rd["PostIP"] != DBNull.Value) info.PostIP = rd["PostIP"].ToString();
                if (rd["Type"] != DBNull.Value) info.Type = Convert.ToInt32(rd["Type"]);
                info.TypeStr = NetSNS.Config.GroupConfig.GetGroupType(info.Type);
                if (rd["Hot"] != DBNull.Value) info.Hot = Convert.ToInt32(rd["Hot"]);
                if (rd["Ding"] != DBNull.Value) info.Ding = Convert.ToInt32(rd["Ding"]);
                list.Add(info);
            }
            rd.Dispose();
            return list;
        }
        /// <summary>
        /// ŵȦ
        /// </summary>
        /// <param name="num"></param>
        /// <returns></returns>
        public List<UserGroupInfo> HotQuan(int num)
        {
            List<UserGroupInfo> list = new List<UserGroupInfo>();
            string topstr = string.Empty;
            if (num != 0)
            {
                topstr = " top " + num + "";
            }           
            string sql = "select " + topstr + " A.[GroupID],B.[Type],Hot,Ding,[GroupName],[UserID],[Members],[Bulletin],[NetWork],[Portrait],[Publicity],[State],[PostTime],[PostIP] From [NT_UserGroup] A inner Join Nt_GroupType B on B.GroupID=A.GroupID order by Hot desc";
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, sql, null);
            while (rd.Read())
            {
                UserGroupInfo info = new UserGroupInfo();
                info.GroupID = Convert.ToInt32(rd["GroupID"].ToString());
                if (rd["GroupName"] != DBNull.Value) info.GroupName = rd["GroupName"].ToString();
                info.UserID = Convert.ToInt32(rd["UserID"].ToString());
                info.Members = Convert.ToInt32(rd["Members"].ToString());
                if (rd["Bulletin"] != DBNull.Value) info.Bulletin = rd["Bulletin"].ToString();
                info.NetWork = Convert.ToInt32(rd["NetWork"].ToString());
                if (rd["Portrait"] != DBNull.Value) info.Portrait = rd["Portrait"].ToString();
                info.Publicity = (EnumGroupPrivacy)Convert.ToInt32(rd["Publicity"].ToString());
                info.State = Convert.ToInt32(rd["State"].ToString());
                info.PostTime = Convert.ToDateTime(rd["PostTime"].ToString());
                if (rd["PostIP"] != DBNull.Value) info.PostIP = rd["PostIP"].ToString();
                if (rd["Type"] != DBNull.Value) info.Type = Convert.ToInt32(rd["Type"]);
                info.TypeStr = NetSNS.Config.GroupConfig.GetGroupType(info.Type);
                if (rd["Hot"] != DBNull.Value) info.Hot = Convert.ToInt32(rd["Hot"]);
                if (rd["Ding"] != DBNull.Value) info.Ding = Convert.ToInt32(rd["Ding"]);
                list.Add(info);
            }
            rd.Dispose();
            return list;
        }
        /// <summary>
        /// ŵȦ
        /// </summary>
        /// <param name="GroupType">Ȧ</param>
        /// <param name="num"></param>
        /// <returns></returns>
        public List<UserGroupInfo> HotQuan(int GroupType,int num)
        {
            List<UserGroupInfo> list = new List<UserGroupInfo>();
            string topstr = string.Empty;
            if (num != 0)
            {
                topstr = " top " + num + "";
            }
            string sql = "select " + topstr + " A.[GroupID],B.[Type],Hot,Ding,[GroupName],[UserID],[Members],[Bulletin],[NetWork],[Portrait],[Publicity],[State],[PostTime],[PostIP] From [NT_UserGroup] A inner Join Nt_GroupType B on B.GroupID=A.GroupID where B.[Type]=" + GroupType + " order by Hot desc";
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, sql, null);
            while (rd.Read())
            {
                UserGroupInfo info = new UserGroupInfo();
                info.GroupID = Convert.ToInt32(rd["GroupID"].ToString());
                if (rd["GroupName"] != DBNull.Value) info.GroupName = rd["GroupName"].ToString();
                info.UserID = Convert.ToInt32(rd["UserID"].ToString());
                info.Members = Convert.ToInt32(rd["Members"].ToString());
                if (rd["Bulletin"] != DBNull.Value) info.Bulletin = rd["Bulletin"].ToString();
                info.NetWork = Convert.ToInt32(rd["NetWork"].ToString());
                if (rd["Portrait"] != DBNull.Value) info.Portrait = rd["Portrait"].ToString();
                info.Publicity = (EnumGroupPrivacy)Convert.ToInt32(rd["Publicity"].ToString());
                info.State = Convert.ToInt32(rd["State"].ToString());
                info.PostTime = Convert.ToDateTime(rd["PostTime"].ToString());
                if (rd["PostIP"] != DBNull.Value) info.PostIP = rd["PostIP"].ToString();
                if (rd["Type"] != DBNull.Value) info.Type = Convert.ToInt32(rd["Type"]);
                info.TypeStr = NetSNS.Config.GroupConfig.GetGroupType(info.Type);
                if (rd["Hot"] != DBNull.Value) info.Hot = Convert.ToInt32(rd["Hot"]);
                if (rd["Ding"] != DBNull.Value) info.Ding = Convert.ToInt32(rd["Ding"]);
                list.Add(info);
            }
            rd.Dispose();
            return list;
        }
        /// <summary>
        /// ȦӷID,,Ȧ
        /// </summary>
        /// <returns></returns>
        public DataTable QuanClass()
        {
            DataTable dt = new DataTable();
            dt.Columns.Add("ID", typeof(int));
            dt.Columns.Add("ClassName", typeof(string));
            dt.Columns.Add("Num", typeof(int));
            Dictionary<int, string> dic = NetSNS.Config.GroupConfig.GroupType;
            foreach (KeyValuePair<int, string> dd in dic)
            {
                int key = dd.Key;
                string value = dd.Value;
                string sql = "Select Count(*) from NT_UserGroup A inner join Nt_GroupType B on A.GroupID=B.GroupID where [Type]=" + key + "";
                int n = Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, sql, null));
                DataRow dr = dt.NewRow();
                dr["ID"] = key;
                dr["ClassName"] = value;
                dr["Num"] = n;
                dt.Rows.Add(dr);
            }
            return dt;
        }
        /// <summary>
        /// Ȧ
        /// </summary>
        /// <param name="num"></param>
        /// <returns></returns>
        public List<UserGroupInfo> NewQuan(int num)
        {
            List<UserGroupInfo> list = new List<UserGroupInfo>();
            string topstr = string.Empty;
            if (num != 0)
            {
                topstr = " top " + num + "";
            }            
            string sql = "select " + topstr + " A.[GroupID],B.[Type],Hot,Ding,[GroupName],[UserID],[Members],[Bulletin],[NetWork],[Portrait],[Publicity],[State],[PostTime],[PostIP] From [NT_UserGroup] A inner Join Nt_GroupType B on B.GroupID=A.GroupID order by A.GroupID desc";
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, sql, null);
            while (rd.Read())
            {
                UserGroupInfo info = new UserGroupInfo();
                info.GroupID = Convert.ToInt32(rd["GroupID"].ToString());
                if (rd["GroupName"] != DBNull.Value) info.GroupName = rd["GroupName"].ToString();
                info.UserID = Convert.ToInt32(rd["UserID"].ToString());
                info.Members = Convert.ToInt32(rd["Members"].ToString());
                if (rd["Bulletin"] != DBNull.Value) info.Bulletin = rd["Bulletin"].ToString();
                info.NetWork = Convert.ToInt32(rd["NetWork"].ToString());
                if (rd["Portrait"] != DBNull.Value) info.Portrait = rd["Portrait"].ToString();
                info.Publicity = (EnumGroupPrivacy)Convert.ToInt32(rd["Publicity"].ToString());
                info.State = Convert.ToInt32(rd["State"].ToString());
                info.PostTime = Convert.ToDateTime(rd["PostTime"].ToString());
                if (rd["PostIP"] != DBNull.Value) info.PostIP = rd["PostIP"].ToString();
                if (rd["Type"] != DBNull.Value) info.Type = Convert.ToInt32(rd["Type"]);
                info.TypeStr = NetSNS.Config.GroupConfig.GetGroupType(info.Type);
                if (rd["Hot"] != DBNull.Value) info.Hot = Convert.ToInt32(rd["Hot"]);
                if (rd["Ding"] != DBNull.Value) info.Ding = Convert.ToInt32(rd["Ding"]);
                list.Add(info);
            }
            rd.Dispose();
            return list;
        }
        /// <summary>
        /// Ȧ
        /// </summary>
        /// <param name="GroupType">Ȧ</param>
        /// <param name="num"></param>
        /// <returns></returns>
        public List<UserGroupInfo> NewQuan(int GroupType,int num)
        {
            List<UserGroupInfo> list = new List<UserGroupInfo>();
            string topstr = string.Empty;
            if (num != 0)
            {
                topstr = " top " + num + "";
            }
            string sql = "select " + topstr + " A.[GroupID],B.[Type],Hot,Ding,[GroupName],[UserID],[Members],[Bulletin],[NetWork],[Portrait],[Publicity],[State],[PostTime],[PostIP] From [NT_UserGroup] A inner Join Nt_GroupType B on B.GroupID=A.GroupID where B.[Type]=" + GroupType + " order by A.GroupID desc";
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, sql, null);
            while (rd.Read())
            {
                UserGroupInfo info = new UserGroupInfo();
                info.GroupID = Convert.ToInt32(rd["GroupID"].ToString());
                if (rd["GroupName"] != DBNull.Value) info.GroupName = rd["GroupName"].ToString();
                info.UserID = Convert.ToInt32(rd["UserID"].ToString());
                info.Members = Convert.ToInt32(rd["Members"].ToString());
                if (rd["Bulletin"] != DBNull.Value) info.Bulletin = rd["Bulletin"].ToString();
                info.NetWork = Convert.ToInt32(rd["NetWork"].ToString());
                if (rd["Portrait"] != DBNull.Value) info.Portrait = rd["Portrait"].ToString();
                info.Publicity = (EnumGroupPrivacy)Convert.ToInt32(rd["Publicity"].ToString());
                info.State = Convert.ToInt32(rd["State"].ToString());
                info.PostTime = Convert.ToDateTime(rd["PostTime"].ToString());
                if (rd["PostIP"] != DBNull.Value) info.PostIP = rd["PostIP"].ToString();
                if (rd["Type"] != DBNull.Value) info.Type = Convert.ToInt32(rd["Type"]);
                info.TypeStr = NetSNS.Config.GroupConfig.GetGroupType(info.Type);
                if (rd["Hot"] != DBNull.Value) info.Hot = Convert.ToInt32(rd["Hot"]);
                if (rd["Ding"] != DBNull.Value) info.Ding = Convert.ToInt32(rd["Ding"]);
                list.Add(info);
            }
            rd.Dispose();
            return list;
        }
        /// <summary>
        /// µȦ
        /// </summary>
        /// <param name="num"></param>
        /// <returns></returns>
        public List<UserGroupInfo> LastUpdateQuan(int num)
        {
            List<UserGroupInfo> list = new List<UserGroupInfo>();
            string topstr = string.Empty;
            if (num != 0)
            {
                topstr = " top " + num + "";
            }
            string sql = "select " + topstr + " A.[GroupID],B.[Type],Hot,Ding,A.[GroupName],A.[UserID],[Members],[Bulletin],[NetWork],[Portrait],[Publicity],A.[State],A.[PostTime],A.[PostIP] From [NT_UserGroup] A inner join (select GroupID,Max(ID) as ID from NT_GroupDiscuss Group by GroupID) C on C.GroupID=A.GroupID inner Join Nt_GroupType B on B.GroupID=A.GroupID order by C.ID desc";
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, sql, null);
            while (rd.Read())
            {
                UserGroupInfo info = new UserGroupInfo();
                info.GroupID = Convert.ToInt32(rd["GroupID"].ToString());
                if (rd["GroupName"] != DBNull.Value) info.GroupName = rd["GroupName"].ToString();
                info.UserID = Convert.ToInt32(rd["UserID"].ToString());
                info.Members = Convert.ToInt32(rd["Members"].ToString());
                if (rd["Bulletin"] != DBNull.Value) info.Bulletin = rd["Bulletin"].ToString();
                info.NetWork = Convert.ToInt32(rd["NetWork"].ToString());
                if (rd["Portrait"] != DBNull.Value) info.Portrait = rd["Portrait"].ToString();
                info.Publicity = (EnumGroupPrivacy)Convert.ToInt32(rd["Publicity"].ToString());
                info.State = Convert.ToInt32(rd["State"].ToString());
                info.PostTime = Convert.ToDateTime(rd["PostTime"].ToString());
                if (rd["PostIP"] != DBNull.Value) info.PostIP = rd["PostIP"].ToString();
                if (rd["Type"] != DBNull.Value) info.Type = Convert.ToInt32(rd["Type"]);
                info.TypeStr = NetSNS.Config.GroupConfig.GetGroupType(info.Type);
                if (rd["Hot"] != DBNull.Value) info.Hot = Convert.ToInt32(rd["Hot"]);
                if (rd["Ding"] != DBNull.Value) info.Ding = Convert.ToInt32(rd["Ding"]);
                list.Add(info);
            }
            rd.Dispose();
            return list;
        }
        /// <summary>
        /// µȦ
        /// </summary>
        /// <param name="GroupType">Ȧ</param>
        /// <param name="num"></param>
        /// <returns></returns>
        public List<UserGroupInfo> LastUpdateQuan(int GroupType,int num)
        {
            List<UserGroupInfo> list = new List<UserGroupInfo>();
            string topstr = string.Empty;
            if (num != 0)
            {
                topstr = " top " + num + "";
            }
            string sql = "select " + topstr + "  A.[GroupID],B.[Type],Hot,Ding,A.[GroupName],A.[UserID],[Members],[Bulletin],[NetWork],[Portrait],[Publicity],A.[State],A.[PostTime],A.[PostIP] From [NT_UserGroup] A inner join (select GroupID,Max(ID) as ID from NT_GroupDiscuss Group by GroupID) C on C.GroupID=A.GroupID inner Join Nt_GroupType B on B.GroupID=A.GroupID where B.[Type]=" + GroupType + " order by C.ID desc";
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, sql, null);
            while (rd.Read())
            {
                UserGroupInfo info = new UserGroupInfo();
                info.GroupID = Convert.ToInt32(rd["GroupID"].ToString());
                if (rd["GroupName"] != DBNull.Value) info.GroupName = rd["GroupName"].ToString();
                info.UserID = Convert.ToInt32(rd["UserID"].ToString());
                info.Members = Convert.ToInt32(rd["Members"].ToString());
                if (rd["Bulletin"] != DBNull.Value) info.Bulletin = rd["Bulletin"].ToString();
                info.NetWork = Convert.ToInt32(rd["NetWork"].ToString());
                if (rd["Portrait"] != DBNull.Value) info.Portrait = rd["Portrait"].ToString();
                info.Publicity = (EnumGroupPrivacy)Convert.ToInt32(rd["Publicity"].ToString());
                info.State = Convert.ToInt32(rd["State"].ToString());
                info.PostTime = Convert.ToDateTime(rd["PostTime"].ToString());
                if (rd["PostIP"] != DBNull.Value) info.PostIP = rd["PostIP"].ToString();
                if (rd["Type"] != DBNull.Value) info.Type = Convert.ToInt32(rd["Type"]);
                info.TypeStr = NetSNS.Config.GroupConfig.GetGroupType(info.Type);
                if (rd["Hot"] != DBNull.Value) info.Hot = Convert.ToInt32(rd["Hot"]);
                if (rd["Ding"] != DBNull.Value) info.Ding = Convert.ToInt32(rd["Ding"]);
                list.Add(info);
            }
            rd.Dispose();
            return list;
        }
        /// <summary>
        /// ʵû
        /// </summary>
        /// <param name="GroupID"></param>
        /// <param name="num"></param>
        /// <returns></returns>
        public List<UserInfo> LastVisitUser(int GroupID,int num)
        {
            List<UserInfo> list = new List<UserInfo>();
            string topstr = string.Empty;
            if (num != 0)
            {
                topstr = " top " + num + "";
            }
            SqlParameter param = new SqlParameter("@GroupID", GroupID);
            string sql = "Select distinct " + topstr + " UserID from Nt_GroupVisit where GroupID=@GroupID";
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, sql, param);
            while (rd.Read())
            {
                try
                {
                    UserInfo info = new User().GetUserInfo(Convert.ToInt32(rd[0]));
                    list.Add(info);
                }
                catch { }               
            }
            rd.Dispose();
            return list;
        }
        /// <summary>
        /// û
        /// </summary>
        /// <param name="GroupID"></param>
        /// <param name="num"></param>
        /// <returns></returns>
        public List<UserInfo> LastJoinUser(int GroupID, int num)
        {
            List<UserInfo> list = new List<UserInfo>();
            string topstr = string.Empty;
            if (num != 0)
            {
                topstr = " top " + num + "";
            }
            SqlParameter param = new SqlParameter("@GroupID", GroupID);
            string sql = "Select " + topstr + " UserID from NT_GroupMember where GroupID=@GroupID Order by ID desc";
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, sql, param);
            while (rd.Read())
            {
                try
                {
                    UserInfo info = new User().GetUserInfo(Convert.ToInt32(rd[0]));
                    list.Add(info);
                }
                catch { }
            }
            rd.Dispose();
            return list;
        }
    }
}
