//===========================================================
//==               (c)2008  NETSNS 1.0                     ==
//==            website:www.aspxcms.com                    ==
//==         qq:6458450,Email:qwsf01115@163.com            ==
//==               Code By Xi.Deng                         ==
//===========================================================
using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Common;
using System.Data.SqlClient;
using NetSNS.DALProfile;
using NetSNS.DALFactory;
using NetSNS.Model;
using NetSNS.Config;

namespace NetSNS.DALSQLServer
{
    /// <summary>
    /// 
    /// </summary>
    public class Share : DbBase, IShare
    {
        /// <summary>
        /// 
        /// </summary>
        /// <param name="Info">ʵ</param>
        /// <returns>ӳɹ1</returns>
        public int Add(ShareInfo Info)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();
            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                SqlParameter[] param = getParameters(Info);
                string Sql = "Insert Into [NT_Share]" +
                             "([UserID],[Title],[Description],[ShareType],[URL],[CaseID],[IsLock],[PostTime],[PostIP],[Comments],[Privacy],[FriendIDGroup]) " +
                             "Values(@UserID,@Title,@Description,@ShareType,@URL,@CaseID,@IsLock,@PostTime,@PostIP,@Comments,@Privacy,@FriendIDGroup);" +
                             "Select @@IDENTITY";
                int ID = Convert.ToInt32(DbHelper.ExecuteScalar(trans, CommandType.Text, Sql, param));

                //˽ű
                Sql = "Insert Into [NT_Letter]" +
                      "([Sender],[Receiver],[Title],[Content],[PostTime],[PostIP],[TopicID],[IsReply],[LtType],[RelativeID],[isRead])" +
                      "Values(@UserID,0,@Title,@Description,@PostTime,@PostIP,0,0,1," + ID + ",0);" +
                      "Select @@IDENTITY";
                int LetterID = Convert.ToInt32(DbHelper.ExecuteScalar(trans, CommandType.Text, Sql, param));

                //ӷ
                Sql = "Insert Into [NT_Outbox]" +
                      "([UserID],[LetterID]) " +
                      "Values(" + Info.UserID + "," + LetterID + ")";
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                int n = 0;
                switch (Info.ShareType)
                {
                    case EnumShareType.ShareAlbum:
                        n = UserLog(trans, EnumUserAction.ShareAlbum, Info.UserID, "һ", ID);
                        break;
                    case EnumShareType.ShareBlog:
                        n = UserLog(trans, EnumUserAction.ShareBlog, Info.UserID, "һ־", ID);
                        break;
                    case EnumShareType.SharePhoto:
                        n = UserLog(trans, EnumUserAction.SharePhoto, Info.UserID, "һƬ", ID);
                        break;
                    case EnumShareType.ShareViode:
                        n = UserLog(trans, EnumUserAction.ShareViode, Info.UserID, "һƵ", ID);
                        break;
                    case EnumShareType.ShareWeb:
                        n = UserLog(trans, EnumUserAction.ShareWeb, Info.UserID, "һҳ", ID);
                        break;
                    case EnumShareType.ShareFriend:
                        SqlParameter Param1 = new SqlParameter("@ID", ID);
                        string sqlS = "select CaseID from NT_Share where ID=@ID";
                        int CID = Convert.ToInt32(DbHelper.ExecuteScalar(trans, CommandType.Text, sqlS, Param1));
                        n = UserLog(trans, EnumUserAction.ShareFriend, Info.UserID, "һ", CID);//GetCaseID(ID)
                        break;
                }
                trans.Commit();
                User us = new User();
                us.updateinte(Info.UserID, 2, 0, 0,"˷");

                return n;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// ɾ(̨)
        /// </summary>
        /// <param name="ID"></param>
        /// <param name="UserID">û</param>
        /// <returns>ɾɹ1</returns>
        public int Del(int ID)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();

            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                string Sql = "Delete From [NT_Share] Where [ID]=" + ID;
                int n = DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                if (n > 0)
                {
                    //־
                    n = UserLog(trans, EnumUserAction.DelShare, 0, "ɾ", ID);
                    //Ⱥ־״̬Ϊ
                    Sql = "Update [NT_UserLog] " +
                          "Set " +
                          "[IsLock]=" + EnumIsLock.Lock + " " +
                          "Where " +
                          "([CorrespondInfo]=" + ID + " And " +
                                "([ActionType]=" + EnumUserAction.DelShare + " Or [ActionType]=" + EnumUserAction.AddShare + ")) Or " +
                                "(([CorrespondInfo] In (Select [ID] From [NT_] Where [ShareID]=" + ID + ") And " +
                                "([ActionType]=" + EnumUserAction.DelShareComm + " Or [ActionType]=" + EnumUserAction.AddShareComm + ")))";
                    DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                    //ɾ۱
                    Sql = "Delete From [NT_ShareComment] Where [ShareID]=" + ID;
                    DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                }
                trans.Commit();
                return n;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }


        /// <summary>
        /// ɾ(ǰ̨)
        /// </summary>
        /// <param name="ID"></param>
        /// <param name="UserID">û</param>
        /// <returns>ɾɹ1</returns>
        public int Del(int ID, int UserID)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();

            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                string Sql = "Delete From [NT_Share] Where [UserID]=" + UserID + " And [ID]=" + ID;
                int n = DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                if (n > 0)
                {
                    //־
                    n = UserLog(trans, EnumUserAction.DelShare, UserID, "ɾ", ID);
                    //Ⱥ־״̬Ϊ
                    //Sql = "Update [NT_UserLog] " +
                    //      "Set " +
                    //      "[IsLock]=" + EnumIsLock.Lock + " " +
                    //      "Where " +
                    //      "([CorrespondInfo]=" + ID + " And " +
                    //            "([ActionType]=" + (int)EnumUserAction.DelShare + " Or [ActionType]=" + EnumUserAction.AddShare + ")) Or " +
                    //            "(([CorrespondInfo] In (Select [ID] From [NT_Share] Where [ShareID]=" + ID + ") And " +
                    //            "([ActionType]=" + EnumUserAction.DelShareComm + " Or [ActionType]=" + EnumUserAction.AddShareComm + ")))";
                    //DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                    //ɾ۱
                    Sql = "Delete From [NT_ShareComment] Where [ShareID]=" + ID;
                    DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                }
                trans.Commit();
                User us = new User();
                us.updateinte(UserID, 2, 0, 1,"ɾ");
                return n;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// ȡ÷
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public int CommentsCount(int ID)
        {
            string Sql = "Select count(id) From [NT_ShareComment] Where [ShareID]=" + ID;
            return Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, Sql, null));
        }

        /// <summary>
        /// ۴
        /// </summary>
        /// <param name="ID"></param>
        public void AddComments(int ID)
        {
            string Sql = "Update [NT_Share] Set [Comments]=[Comments]+1 Where [ID]=" + ID;
            DbHelper.ExecuteNonQuery(CommandType.Text, Sql, null);
        }

        /// <summary>
        /// ȡ÷Ϣ
        /// </summary>
        /// <param name="ID"></param>
        /// <returns>طʵ</returns>
        public ShareInfo Info(int ID)
        {
            ShareInfo info = new ShareInfo();
            string Sql = "Select [ID],[UserID],[Title]," +
                         "[Description],[ShareType],[Url],[CaseID],[IsLock],[PostTime],[PostIP],[Comments],[Privacy],[FriendIDGroup] " +
                         "From " +
                         "[NT_Share] " +
                         "Where [ID]=" + ID;
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, Sql, null);
            if (rd.Read())
            {
                info.ID = Convert.ToInt32(rd["ID"].ToString());
                info.UserID = Convert.ToInt32(rd["UserID"].ToString());
                if (rd["Title"] != DBNull.Value) info.Title = rd["Title"].ToString();
                if (rd["Url"] != DBNull.Value) info.Url = rd["Url"].ToString();
                if (rd["Description"] != DBNull.Value) info.Description = rd["Description"].ToString();
                //if (rd["FriendIDGroup"] != DBNull.Value) info.FriendIDGroup = rd["FriendIDGroup"].ToString();
                info.FriendIDGroup = Convert.ToInt32(rd["FriendIDGroup"].ToString());
                info.ShareType = (EnumShareType)Convert.ToInt32(rd["ShareType"].ToString());
                info.CaseID = Convert.ToInt32(rd["CaseID"].ToString());
                if (rd["IsLock"].ToString() == "1")
                {
                    info.IsLock = EnumIsLock.Lock;
                }
                else
                {
                    info.IsLock = EnumIsLock.UnLock;
                }
                info.PostTime = Convert.ToDateTime(rd["PostTime"].ToString());
                if (rd["PostIP"] != DBNull.Value) info.PostIP = rd["PostIP"].ToString();
                info.Comments = Convert.ToInt32(rd["Comments"].ToString());
                info.Privacy = (EnumPrivacy)Convert.ToInt32(rd["Privacy"].ToString());
            }
            rd.Close();
            return info;
        }

        /// <summary>
        /// 캯
        /// </summary>
        /// <param name="Info">ʵ</param>
        /// <returns>SQL</returns>
        private SqlParameter[] getParameters(ShareInfo Info)
        {
            SqlParameter[] param = new SqlParameter[13];

            param[0] = new SqlParameter("@ID", SqlDbType.Int, 4);
            param[0].Value = Info.ID;
            param[1] = new SqlParameter("@UserID", SqlDbType.Int, 4);
            param[1].Value = Info.UserID;
            param[2] = new SqlParameter("@Title", SqlDbType.NVarChar, 50);
            param[2].Value = Info.Title;

            param[3] = new SqlParameter("@Description", SqlDbType.NVarChar, 1000);
            param[3].Value = Info.Description;
            param[4] = new SqlParameter("@ShareType", SqlDbType.Int, 4);
            param[4].Value = Info.ShareType;
            param[5] = new SqlParameter("@CaseID", SqlDbType.Int, 4);
            param[5].Value = Info.CaseID;

            param[6] = new SqlParameter("@IsLock", SqlDbType.Bit);
            param[6].Value = Info.IsLock;
            param[7] = new SqlParameter("@PostTime", SqlDbType.DateTime, 8);
            param[7].Value = Info.PostTime;
            param[8] = new SqlParameter("@PostIP", SqlDbType.VarChar, 15);
            param[8].Value = Info.PostIP;

            param[9] = new SqlParameter("@Comments", SqlDbType.Int, 4);
            param[9].Value = Info.Comments;
            param[10] = new SqlParameter("@Privacy", SqlDbType.Int, 4);
            param[10].Value = Info.Privacy;
            param[11] = new SqlParameter("@URL", SqlDbType.NVarChar, 200);
            param[11].Value = Info.Url;
            param[12] = new SqlParameter("@FriendIDGroup", SqlDbType.NVarChar, 500);
            param[12].Value = Info.FriendIDGroup;

            return param;
        }

        /// <summary>
        /// õƬ
        /// </summary>
        /// <param name="ID">ID</param>
        /// <returns>ͼƬ</returns>
        public int AlbumCount(int ID)
        {
            SqlParameter param = new SqlParameter("@ID", ID);
            string sql = "select count(PhotoID) from [NT_Photo] where AlbumID=@ID and isLock=0";
            return Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, sql, param));
        }

        /// <summary>
        /// ÷ͷ///ûã
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public string AlbumIndexPic(int ID)
        {
            string IndexPicStr = "#0";
            SqlParameter param = new SqlParameter("@ID", ID);
            string sql = "select count(PhotoID) from [NT_Photo] where AlbumID=@ID and isLock=0";
            int TMPIndexPic = Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, sql, param));
            if (TMPIndexPic > 0)
            {
                string asql = "select top 1 FilePath from [NT_Photo] where AlbumID=@ID order by PhotoID desc";
                IndexPicStr = Convert.ToString(DbHelper.ExecuteScalar(CommandType.Text, asql, param));
            }
            return IndexPicStr;
        }

        /// <summary>
        /// ͷͼƬ  ///ûã
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public string PhotoURL(int ID)
        {
            SqlParameter param = new SqlParameter("@ID", ID);
            string sql = "select FilePath from [NT_Photo] where PhotoID=@ID";
            return Convert.ToString(DbHelper.ExecuteScalar(CommandType.Text, sql, param));
        }


        /// <summary>
        /// б
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public IDataReader ShareCommentList(int ID)
        {
            SqlParameter param = new SqlParameter("@ID", ID);
            string sql = "select * from [NT_ShareComment] where ShareID=@ID";
            return DbHelper.ExecuteReader(CommandType.Text, sql, param);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="ID"></param>
        /// <param name="UserID"></param>
        /// <param name="Content"></param>
        /// <param name="isLock"></param>
        public void PostComment(int ID, int UserID, string Content, int isLock)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();

            SqlTransaction trans = Conn.BeginTransaction();
            try
            {

                string sql = "insert into NT_shareComment (ShareID,UserID,Content,PostTime,PostIP,IsLock) values (" + ID + "," + UserID + ",'" + Content.ToString() + "','" + DateTime.Now + "','" + NetSNS.Common.Public.GetClientIP() + "'," + isLock + ")";
                int n = DbHelper.ExecuteNonQuery(trans, CommandType.Text, sql, null);
                if (n > 0)
                {
                    int userNum = UserLog(trans, EnumUserAction.AddShareComm, UserID, "˷", ID);
                    trans.Commit();
                }
            }
            catch (SqlException e)
            {
                trans.Rollback();
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// ɾ
        /// </summary>
        /// <param name="ID"></param>
        /// <param name="Userid"></param>
        public void DelComment(int ID, int Userid)
        {
            string sql = "delete from NT_shareComment where ID=" + ID + " and UserID=" + Userid + "";
            DbHelper.ExecuteNonQuery(CommandType.Text, sql, null);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="info"></param>
        public void AddShareTable(ShareInfo info)
        {

        }

        public string GetURLAddress(int Id)
        {
            SqlParameter Param = new SqlParameter("@ID", Id);
            string sql = "select URL from NT_Share where ID=@ID";
            return Convert.ToString(DbHelper.ExecuteScalar(CommandType.Text, sql, Param));
        }

        /// <summary>
        /// õûID
        /// </summary>
        /// <param name="id">ID</param>
        /// <returns></returns>
        public int GetCaseID(int id)
        {
            SqlParameter Param = new SqlParameter("@ID", id);
            string sql = "select CaseID from NT_Share where ID=@ID";
            return Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, sql, Param));
        }
    }
}
