using System;
using System.Collections.Generic;
using System.Text;
using NetSNS.DALFactory;
using System.Data;
using System.Data.SqlClient;
using NetSNS.DALProfile;
using NetSNS.Model;
using NetSNS.Config;

namespace NetSNS.DALSQLServer
{
    public class Space: DbBase,ISpace
    {
        #region 
        /// <summary>
        /// 
        /// </summary>
        /// <param name="Id"></param>
        /// <param name="RuserId">߻Ա</param>
        /// <param name="flag"></param>
        /// <returns></returns>
        public DataTable getUserInfo(int Id,int flag)
        {
            string sql = null;
            SqlParameter param = new SqlParameter("@ID", Id);
            switch (flag)
            {
                case 0://ݻԱŻȡԱϢ
                    sql = "select a.UserID,a.UserName,a.Click,a.integral,Pro=a.Province,citys=a.City,VocName=(select VocName from NT_Dict_Vocation where ID=(select Vocation from NT_UserInfo where UserID=a.UserID)),Province=(select Name from NT_Dict_Area where id=a.Province),City=(select Name from NT_Dict_Area where id=a.City),Sex=(select Sex=case Sex when 0 then 'Ů' when 1 then '' end from NT_UserInfo where UserID=a.UserID),Birthday=(select Birthday from NT_UserInfo where UserID=a.UserID),BirthidayDisplay=(select BirthidayDisplay from NT_UserInfo where UserID=a.UserID),Constellation=(select Constellation from NT_Constellation where Id=(select Constellation from NT_UserInfo where UserID=a.UserID)),HomeProv=(select Name from NT_Dict_Area where id=(select HomeProv from NT_UserInfo where UserID=a.UserID)),HomeCity=(select Name from NT_Dict_Area where id=(select HomeCity from NT_UserInfo where UserID=a.UserID)),Photo=(select FilePath from NT_Photo where PhotoID=a.Portrait and PhotoType=0) from NT_User a where a.UserId=@ID";
                    break;
                case 1://ݻԱŶȡҵĺϢ
                    sql = "select  a.UserID,a.UserName,a.Portrait,FilePath=(select FilePath from NT_Photo where PhotoID=a.Portrait ) from NT_User a where a.UserID in (select b.FriendID from NT_Friend b where b.UserID=@ID) order by a.LastLoginTime desc";
                    break;
                case 2://ݻԱŶȡ䷢ռ
                    sql = "select ID,Content,PostTime from NT_MiniBlog where UserID=@ID and IsLock=0 order by PostTime desc";
                    break;
                case 3://ݻԱŶȡԱ
                    sql = "select top 3 ID,Num=(select count(*) from NT_Share where UserId=@ID and IsLock=0),Title,Description,ShareType,CaseID,PostTime,Comments,Privacy from NT_Share where UserId=@ID and IsLock=0 order by PostTime desc";
                    break;
                case 4://ݻԱŶȡȺϢ
                    sql = "select a.GroupID,a.GroupName,a.UserID,a.Members,a.Portrait from NT_UserGroup a where a.GroupID In(Select c.GroupID From NT_GroupMember as c Where c.UserID=@ID) order by a.PostTime desc";
                    break;
                case 5://ݻԱŶȡӰ
                    sql = "select b.UserID,a.MovieID,a.Title,a.PosterFile,b.Score,b.Comment,b.PostTime from NT_Movie a inner join NT_MovieComment b on b.MovieID=a.MovieID where UserID=@ID order by b.PostTime desc";
                    break;
                case 6://ݻԱŶȡϢ
                    sql = "select AlbumID,Title,ImagesCount,LastUploadTime,Privacy from NT_Album where UserID=@ID order by LastUploadTime desc";
                    break;
                case 7://Ŷȡͼ
                    sql = "select AlbumID,FilePath from NT_Photo where AlbumID=@ID and IsCover=0 and PhotoType=1 and IsLock=0";
                    break;
                case 8://ݻԱŶȡ־
                    sql = "select a.ID,a.Title,a.Content,a.PostTime,a.Reads,Comments=(select count(ID) from NT_BlogComment where BlogID=a.ID ),a.PicPath,a.LastModTime,a.Privacy from dbo.NT_Blog a where a.UserID=@ID and a.IsLock=0 order by a.PostTime desc";
                    break;
                case 9://ȡԱϢ
                    sql = "select ID,Company,Description,IsStill,JoinYear,JoinMonth,LeaveYear,LeaveMonth from NT_UserCareer where UserID=@ID order by PostTime desc";
                    break;
                case 10://ȡԱѧУϢ
                    sql = "select a.ID,a.UserID,a.DegreeID,a.SchoolID,SchoolName=(select SchoolName from NT_Dict_School where SchoolID=a.SchoolID),Name=(select Name from NT_Dict_Academy where ID=a.AcademyID),a.MatriculationYear,a.AcademyID from NT_UserEducation a where a.UserID=@ID and a.IsLock=0";
                    break;
                case 11://ȡԱϵϢͰ
                    sql = "select a.Sex,a.Birthday,a.Constellation,a.MSN,a.GTalk,a.QQ,a.Skype,a.Mobile,a.Tel,a.Addr,a.WebSite,a.Favourite,a.FavMusics,a.FavMovies,a.FavCartoons,a.FavGames,a.FavSports,a.FavBooks,a.AppreciateMen,a.FavAdages,a.Presentation,b.Email,a.MobilePrivacy,a.EmailPrivacy,a.MSNPrivacy,a.GTalkPrivacy,a.QQPrivacy,a.SkypePrivacy,a.TelPrivacy,a.AddrPrivacy,a.WebSitePrivacy from NT_UserInfo a inner join NT_User b on a.UserID=b.UserID where a.UserID=@ID";
                    break;
                case 12://ȡԱϢ
                    sql = "select a.ID,a.Sender,a.Content,a.PostTime,b.UserName,Province=(select Name from NT_Dict_Area where id=b.Province) from NT_LeaveWord a inner join NT_User b on a.Sender=b.UserID where a.Receiver=@ID and a.IsLock=0 order by a.PostTime desc";
                    break;
                case 13://ȡԱ˶̬
                    sql = "select ID,UserID,ActionType,LogTime,Description,Remark,CorrespondInfo,CorreUserID from NT_UserLog where UserID=@ID and isLock=0 and IsDel=0 order by LogTime desc";
                    break;
                case 14://һȡ
                    sql = "select ID,ParentID,Name from NT_Dict_Area where IsLock=0 and ParentID=@ID";
                    break;
                case 15://ѧУŶȡԺϵϢ
                    sql = "select ID,Name from NT_Dict_Academy where SchoolID=@ID and IsLock=0";
                    break;
                case 16://־Ŷȡ־
                    sql = "select ID,Title,Content,Comments,PicPath from dbo.NT_Blog where ID=@ID and IsLock=0";
                    break;
                case 17://ݷIDȡ־Ϣ
                    sql = "select a.Description,a.Comments,a.Privacy ,b.ID,b.Title,b.Content,b.Comments,b.PicPath from NT_Share a inner join NT_Blog b on a.CaseID=b.ID where a.CaseID=@ID and a.ShareType=4 and b.IsLock=0";
                    break;
                case 18://ݵӰ۱ŶȡϢ
                    sql = "select a.MovieID,a.Title,a.PosterFile,b.Score,b.Comment,b.PostTime from NT_Movie a inner join NT_MovieComment b on b.MovieID=a.MovieID  where b.ID=@ID";
                    break;
                case 19://ȡϴƬ
                    sql = "select a.AlbumID,a.Title,b.FilePath,b.PhotoID from NT_Album a inner join NT_Photo b on a.AlbumID=b.AlbumID where b.PhotoID=@ID";
                    break;
                case 20://ȡռ
                    sql = "select ID,Content,Comments from dbo.NT_MiniBlog where ID=@ID";
                    break;
                case 21://ȡϢ
                    sql = "select a.Description,a.Comments,a.Privacy ,b.AlbumID,b.Title,b.ImagesCount from NT_Share a inner join dbo.NT_Album b on a.CaseID=b.AlbumID where a.CaseID=@ID and a.ShareType=3";
                    break;
                case 22://ȡƬϢ
                    sql = "select a.CaseID,a.Description,a.Comments,a.Privacy ,PhotoDes=b.Description,b.FilePath,c.AlbumID,c.Title from NT_Share a inner join dbo.NT_Photo b on b.PhotoID=a.CaseID inner join dbo.NT_Album c on b.AlbumID=c.AlbumID where a.CaseID=@ID and a.ShareType=2";
                    break;
                case 23://ȡұȦƬ
                    sql = "select number=Count(*) from NT_PhotoLasso where FriendID=@ID and IsLock=0"; 
                    break;
                case 24://ȡͷ·
                    sql = "select b.FilePath,b.PhotoID from  NT_Photo b where b.PhotoID=@ID";
                    break;
                case 25://ȡ
                    sql = "select ID=Count(ID) from dbo.NT_MiniBlogComment where MiniBlogID=@ID";
                    break;
                case 26://ȡƼĻԱ
                    sql = "select top 30 UserID from NT_User where Recommended=0 order by RegTime desc";
                    break;
                case 27://۱ŶȡϢ
                    sql = "select a.ID,a.Title from dbo.NT_Blog a inner join NT_BlogComment b on a.ID=b.BlogID where b.ID=@ID and a.IsLock=0 order by a.PostTime desc";
                    break;
                case 28://
                    sql = "select AlbumID,Title from dbo.NT_Album where AlbumID=@ID";
                    break;
           }
            return DbHelper.ExecuteTable(CommandType.Text, sql, param);
        }
        #endregion
        
        /// <summary>
        /// ȡݣDataTable
        /// </summary>
        /// <param name="flag"></param>
        /// <returns></returns>
        public DataTable getConstellation(int flag)
        {
            string sql = "";
            switch (flag)
            {
                case 0://ȡ
                    sql = "select ID,Name=Constellation from NT_Constellation";
                    break;
                case 1://ȡһ
                    sql = "select ID,ParentID,Name from NT_Dict_Area where IsLock=0 and ParentID=0";
                    break;
                case 2://ȡҵ
                    sql = "select ID,Name=VocName from NT_Dict_Vocation where IsLock=0";
                    break;
                case 3://ȡе
                    sql = "select ID,ParentID,Name from NT_Dict_Area where IsLock=0";
                    break;
            }
            return DbHelper.ExecuteTable(CommandType.Text, sql, null);
        }

        /// <summary>
        /// ̶ܽȺѧУϢ
        /// </summary>
        /// <param name="AreaId"></param>
        /// <param name="DegreeID">̶ܽ</param>
        /// <returns></returns>
        public DataTable getShool(int AreaId, int DegreeID)
        {
            SqlParameter[] param = new SqlParameter[2];
            param[0] = new SqlParameter("@AreaId", SqlDbType.Int, 4);
            param[0].Value = AreaId;
            param[1] = new SqlParameter("@DegreeID", SqlDbType.Int, 4);
            param[1].Value = DegreeID;
            string sql = "select SchoolID,DegreeID,AreaID,SchoolName from NT_Dict_School where DegreeID=@DegreeID and AreaID=@AreaID and IsLock=0";
            return DbHelper.ExecuteTable(CommandType.Text, sql, param);
        }

        /// <summary>
        /// ʡ,ź̶ܽѧУ
        /// </summary>
        /// <param name="shoolName">ʡ</param>
        /// <param name="AreaId"></param>
        /// <param name="DegreeID">̶ܽ</param>
        /// <returns></returns>
        public DataTable searchShool(string shoolName, int AreaId, int DegreeID)
        {
            SqlParameter[] param = new SqlParameter[3];
            param[0] = new SqlParameter("@AreaId", SqlDbType.Int, 4);
            param[0].Value = AreaId;
            param[1] = new SqlParameter("@DegreeID", SqlDbType.Int, 4);
            param[1].Value = DegreeID;
            param[2] = new SqlParameter("@shoolName", SqlDbType.NVarChar, 100);
            param[2].Value = shoolName;
            string sql = "select SchoolID,DegreeID,AreaID,SchoolName from NT_Dict_School where DegreeID=@DegreeID and AreaID=@AreaID and SchoolName like '%@shoolName%' and IsLock=0";
            return DbHelper.ExecuteTable(CommandType.Text, sql, param);
        }

        /// <summary>
        /// »Ա
        /// </summary>
        /// <param name="Info"></param>
        /// <param name="flag"></param>
        /// <returns></returns>
        public int UpdateUserInfo(NetSNS.Model.UserBasicInfo Info,int ID,int flag)
        {
            SqlConnection sqlConn = new SqlConnection(DBConfig.CnString);
            sqlConn.Open();
            SqlTransaction trans = sqlConn.BeginTransaction();
            try
            {
                SqlParameter[] param = null;
                EnumUserAction action = EnumUserAction.ChangeBasic;
                string description="";
                int n = 0;
                SqlParameter paramID = new SqlParameter("@ID", ID);
                string sql = "select UserID from NT_UserInfo where UserID=@ID";
                DataTable dt = DbHelper.ExecuteTable(CommandType.Text, sql, paramID);//ǷڸûԱ¼

                if (dt != null && dt.Rows.Count > 0)
                {
                    switch (flag)
                    {
                        case 0://Ϣ
                            param = getParameters(Info);
                            sql = "update NT_UserInfo set Sex=@Sex,Birthday=@Birthday,BirthidayDisplay=@BirthidayDisplay,Constellation=@Constellation,Vocation=@Vocation,HomeProv=@HomeProv,HomeCity=@HomeCity where UserID=@UserID";
                            action = EnumUserAction.ChangeBasic;
                            description = "˻Ϣ";
                            break;
                        case 1://»ԱϵϢ
                            param = getLXParameters(Info);
                            sql = "update NT_UserInfo set MSN=@MSN,GTalk=@GTalk,QQ=@QQ,Skype=@Skype,Mobile=@Mobile,Tel=@Tel,Addr=@Addr,WebSite=@WebSite where UserID=@UserID";
                            action = EnumUserAction.ChangeContact;
                            description = "ϵϢ";
                            break;
                        case 3://°Ϣ
                            param = getFavouriteParameters(Info);
                            sql = "update NT_UserInfo set Favourite=@Favourite,FavMusics=@FavMusics,FavMovies=@FavMovies,FavCartoons=@FavCartoons,FavGames=@FavGames,FavSports=@FavSports,FavBooks=@FavBooks,FavAdages=@FavAdages,AppreciateMen=@AppreciateMen,Presentation=@Presetation where UserID=@UserID";
                            action = EnumUserAction.ChangeFavor;
                            description = "˸˰Ϣ";
                            break;
                    }
                    n = DbHelper.ExecuteNonQuery(trans,CommandType.Text, sql, param);
                    n = UserLog(trans, action, Info.UserID, description, Info.UserID);
                    trans.Commit();
                }
                else
                {
                    switch (flag)
                    {
                        case 0://Ϣ
                            param = getParameters(Info);
                            sql = "insert into NT_UserInfo(UserID,Favourite,FavMusics,FavMovies,FavCartoons,FavGames,FavSports,FavBooks,FavAdages,AppreciateMen,Presentation,Sex,Birthday,Constellation,MSN,GTalk,QQ,Skype,Mobile,Tel,Addr,WebSite,BirthidayDisplay,Vocation,HomeProv,HomeCity,EmailPrivacy,MobilePrivacy,MSNPrivacy,GTalkPrivacy,QQPrivacy,TelPrivacy,SkypePrivacy,WebSitePrivacy,AddrPrivacy) values (@UserID,'','','','','','','','','','',@Sex,@Birthday,@Constellation,'','','','','','','','',@BirthidayDisplay,@Vocation,@HomeProv,@HomeCity,0,0,0,0,0,0,0,0,0)";
                            break;
                        case 1://ӻԱϵϢ
                            param = getLXParameters(Info);
                            sql = "insert into NT_UserInfo(UserID,Favourite,FavMusics,FavMovies,FavCartoons,FavGames,FavSports,FavBooks,FavAdages,AppreciateMen,Presentation,Sex,Birthday,Constellation,MSN,GTalk,QQ,Skype,Mobile,Tel,Addr,WebSite,BirthidayDisplay,Vocation,HomeProv,HomeCity,EmailPrivacy,MobilePrivacy,MSNPrivacy,GTalkPrivacy,QQPrivacy,TelPrivacy,SkypePrivacy,WebSitePrivacy,AddrPrivacy) values (@UserID,'','','','','','','','','','',0,'1900-1-1',0,@MSN,@GTalk,@QQ,@Skype,@Mobile,@Tel,@Addr,@WebSite,1,0,0,0,0,0,0,0,0,0,0,0,0)";
                            break;
                        case 3://ӰϢ
                            param = getFavouriteParameters(Info);
                            sql = "insert into NT_UserInfo(UserID,Favourite,FavMusics,FavMovies,FavCartoons,FavGames,FavSports,FavBooks,FavAdages,AppreciateMen,Presentation,Sex,Birthday,Constellation,MSN,GTalk,QQ,Skype,Mobile,Tel,Addr,WebSite,BirthidayDisplay,Vocation,HomeProv,HomeCity,EmailPrivacy,MobilePrivacy,MSNPrivacy,GTalkPrivacy,QQPrivacy,TelPrivacy,SkypePrivacy,WebSitePrivacy,AddrPrivacy) values (@UserID,@Favourite,@FavMusics,@FavMovies,@FavCartoons,@FavGames,@FavSports,@FavBooks,@FavAdages,@AppreciateMen,@Presetation,0,'1900-1-1',0,'','','','','','','','',1,0,0,0,0,0,0,0,0,0,0,0,0)";
                            break;
                    }
                    n = DbHelper.ExecuteNonQuery(trans,CommandType.Text, sql, param);
                    trans.Commit();
                }
               return n;
           }
           catch (SqlException sqlEx)
           {
               trans.Rollback();
               throw sqlEx;
           }
           finally
           {
               if (sqlConn.State == ConnectionState.Open)
                   sqlConn.Close();
           }
        }
       
        /// <summary>
        /// »ԱϢɼ
        /// </summary>
        /// <param name="StrName">ֶ</param>
        /// <param name="k">ֵ</param>
        /// <param name="UserID">Ա</param>
        /// <returns></returns>
        public int UpdatePrivacy(string StrName,int k,int UserID)
        {
            SqlParameter[] param = new SqlParameter[2];
            param[0] = new SqlParameter("@k", SqlDbType.Int, 4);
            param[0].Value = k;
            param[1] = new SqlParameter("@UserID", SqlDbType.Int, 4);
            param[1].Value = UserID;
            string sql = "update NT_UserInfo set " + StrName + "=@k where UserID=@UserID";
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, param);
        }

        /// <summary>
        /// رɾԱϢ
        /// </summary>
        /// <param name="ID"></param>
        /// <param name="flag"></param>
        /// <returns></returns>
        public int DelInfo(int ID, int flag)
        {
            string sql = "";
            SqlParameter param = new SqlParameter("@ID", ID);
            switch (flag)
            {
                case 0://ɾԱϢ
                    sql = "delete from NT_UserEducation where ID=@ID";
                    break;
                case 1://ɾԱϢ
                    sql = "delete from NT_UserCareer where ID=@ID";
                    break;
                case 2://ɾ
                    sql = "delete from NT_LeaveWord where ID=@ID";
                    break;
            }
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, param);
        }


        /// <summary>
        /// ɾӵƬ־
        /// </summary>
        /// <param name="ID"></param>
        /// <param name="flag"></param>
        /// <returns></returns>
        public int DelUserInfo(int ID,string time,int type,int userid)
        {
            if (time == "") { time = "1900-1-1"; }
            SqlParameter[] param = new SqlParameter[4];
            param[0] = new SqlParameter("@type", SqlDbType.Int, 4);
            param[0].Value = type;
            param[1] = new SqlParameter("@userID", SqlDbType.Int, 4);
            param[1].Value = userid;
            param[2] = new SqlParameter("@time", SqlDbType.DateTime, 8);
            param[2].Value = Convert.ToDateTime(time);
            param[3] = new SqlParameter("@ID", SqlDbType.Int, 4);
            param[3].Value = ID;

            string sql = "";
            if (type != 0)
            {
                sql = "delete from dbo.NT_UserLog where UserID=@userID and CONVERT(varchar(10), LogTime,120)=@time and ActionType=@type";
            }
            else
            {
                sql = "delete from dbo.NT_UserLog where ID=@ID";
            }
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, param);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="myid">߱</param>
        /// <param name="userId">߱</param>
        /// <param name="content"></param>
        /// <param name="IP">IP</param>
        /// <returns></returns>
        public int LeaveWords(int myid, int userId,string content,string IP)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();
            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                int n = 0;
                SqlParameter[] param = new SqlParameter[4];
                param[0] = new SqlParameter("@myid", SqlDbType.Int, 4);
                param[0].Value = myid;
                param[1] = new SqlParameter("@userId", SqlDbType.Int, 4);
                param[1].Value = userId;
                param[2] = new SqlParameter("@content", SqlDbType.NVarChar, 200);
                param[2].Value = content;
                param[3] = new SqlParameter("@IP", SqlDbType.Char, 15);
                param[3].Value = IP;

                string sql = "insert into NT_LeaveWord(Sender,Receiver,Content,PostTime,PostIP,IsLock) values(@myid,@userId,@content,getdate(),@IP,0)";
                n=DbHelper.ExecuteNonQuery(trans,CommandType.Text, sql, param);
                n = Notify(trans, EnumNotifyType.Leaveword, myid, userId, "", myid);
                trans.Commit();
                return n;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// ӻԱϢ
        /// </summary>
        /// <param name="Info"></param>
        /// <param name="ID"></param>
        /// <returns></returns>
        public int AddEducationInfo(NetSNS.Model.UserEducationInfo Info,int ID)
        {
            SqlParameter[] param = getEducationParameters(Info);
            SqlParameter paramID = new SqlParameter("@ID", ID);
            string sql = "select SchoolID from NT_UserEducation where ID=@ID";
            DataTable dt = DbHelper.ExecuteTable(CommandType.Text, sql, paramID);

            if (dt == null || dt.Rows.Count == 0)
            {
                sql = "insert into NT_UserEducation(UserID,DegreeID,SchoolID,AcademyID,MatriculationYear,PostTime,PostIP,IsLock) values(@UserID,@DegreeID,@SchoolID,@AcademyID,@MatriculationYear,getdate(),@PostIP,0)";
            }
            else
            {
                sql = "update NT_UserEducation set UserID=@UserID,DegreeID=@DegreeID,SchoolID=@SchoolID,AcademyID=@AcademyID,MatriculationYear=@MatriculationYear,PostTime=getdate(),PostIP=@PostIP where ID=" + ID;
            }
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, param);
        }  

        /// <summary>
        /// Ӹ»ԱϢ
        /// </summary>
        /// <param name="Info"></param>
        /// <param name="ID"></param>
        /// <returns></returns>
        public int AddCareerInfo(NetSNS.Model.UserCareerInfo Info, int ID)
        {
            SqlParameter[] param = getCareerParameters(Info);
            SqlParameter paramID = new SqlParameter("@ID", ID);
            string sql = "select Company from NT_UserCareer where ID=@ID";
            DataTable dt = DbHelper.ExecuteTable(CommandType.Text, sql, paramID);

            if (dt == null || dt.Rows.Count == 0)
            {
                sql = "insert into NT_UserCareer(UserID,Company,Description,IsStill,JoinYear,JoinMonth,PostTime,PostIP,LeaveYear,LeaveMonth)values(@UserID,@Company,@Description,@IsStill,@JoinYear,@JoinMonth,getdate(),@PostIP,@LeaveYear,@LeaveMonth)";
            }
            else
            {
                sql = "update NT_UserCareer set Company=@Company,Description=@Description,IsStill=@IsStill,JoinYear=@JoinYear,JoinMonth=@JoinMonth,PostTime=getdate(),PostIP=@PostIP,LeaveYear=@LeaveYear,LeaveMonth=@LeaveMonth where ID=" + ID;
            }
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, param);
        }


        /// <summary>
        /// 캯 
        /// </summary>
        /// <param name="Info">Ϣ</param>
        /// <returns>SQL</returns>
        private SqlParameter[] getParameters(NetSNS.Model.UserBasicInfo Info)
        {
            SqlParameter[] param = new SqlParameter[8];

            param[0] = new SqlParameter("@Sex", SqlDbType.Bit, 1);
            param[0].Value = Info.Sex;
            param[1] = new SqlParameter("@Birthday", SqlDbType.DateTime, 8);
            param[1].Value = Info.Birthday;
            param[2] = new SqlParameter("@BirthidayDisplay", SqlDbType.Int,4);
            param[2].Value = Info.BirthidayDisplay;
            param[3] = new SqlParameter("@Constellation", SqlDbType.Int, 4);
            param[3].Value = Info.Constellation;
            param[4] = new SqlParameter("@Vocation", SqlDbType.Int, 4);
            param[4].Value = Info.Vocation;
            param[5] = new SqlParameter("@HomeProv", SqlDbType.Int, 4);
            param[5].Value = Info.HomeProv;
            param[6] = new SqlParameter("@HomeCity", SqlDbType.Int, 4);
            param[6].Value = Info.HomeCity;
            param[7] = new SqlParameter("@UserID", SqlDbType.Int, 4);
            param[7].Value = Info.UserID;
            return param;
        }

        /// <summary>
        /// 캯
        /// </summary>
        /// <param name="Info">ϵϢ</param>
        /// <returns>SQL</returns>
        private SqlParameter[] getLXParameters(NetSNS.Model.UserBasicInfo Info)
        {
            SqlParameter[] param = new SqlParameter[9];
            param[0] = new SqlParameter("@UserID", SqlDbType.Int, 4);
            param[0].Value = Info.UserID;
            param[1] = new SqlParameter("@MSN", SqlDbType.NVarChar, 50);
            param[1].Value = Info.MSN;
            param[2] = new SqlParameter("@GTalk", SqlDbType.NVarChar, 50);
            param[2].Value = Info.GTalk;
            param[3] = new SqlParameter("@QQ", SqlDbType.NVarChar, 20);
            param[3].Value = Info.QQ;
            param[4] = new SqlParameter("@Skype", SqlDbType.NVarChar, 50);
            param[4].Value = Info.Skype;
            param[5] = new SqlParameter("@Mobile", SqlDbType.Char, 15);
            param[5].Value = Info.Mobile;
            param[6] = new SqlParameter("@Tel", SqlDbType.Char, 20);
            param[6].Value = Info.Tel;
            param[7] = new SqlParameter("@Addr", SqlDbType.NVarChar, 100);
            param[7].Value = Info.Addr;
            param[8] = new SqlParameter("@WebSite", SqlDbType.NVarChar, 50);
            param[8].Value = Info.WebSite;
            return param;
        }
        /// <summary>
        /// 캯
        /// </summary>
        /// <param name="Info">Ϣ</param>
        /// <returns>SQL</returns>
        private SqlParameter[] getFavouriteParameters(NetSNS.Model.UserBasicInfo Info)
        {
            SqlParameter[] param = new SqlParameter[11];
            param[0] = new SqlParameter("@UserID", SqlDbType.Int, 4);
            param[0].Value = Info.UserID;
            param[1] = new SqlParameter("@Favourite", SqlDbType.NVarChar, 200);
            param[1].Value = Info.Favourite;
            param[2] = new SqlParameter("@FavMusics", SqlDbType.NVarChar, 200);
            param[2].Value = Info.FavMusics;
            param[3] = new SqlParameter("@FavMovies", SqlDbType.NVarChar, 200);
            param[3].Value = Info.FavMovies;
            param[4] = new SqlParameter("@FavCartoons", SqlDbType.NVarChar, 200);
            param[4].Value = Info.FavCartoons;
            param[5] = new SqlParameter("@FavGames", SqlDbType.NVarChar, 200);
            param[5].Value = Info.FavGames;
            param[6] = new SqlParameter("@FavSports", SqlDbType.NVarChar, 200);
            param[6].Value = Info.FavSports;

            param[7] = new SqlParameter("@FavBooks", SqlDbType.NVarChar, 200);
            param[7].Value = Info.FavBooks;
            param[8] = new SqlParameter("@FavAdages", SqlDbType.NVarChar, 200);
            param[8].Value = Info.FavAdages;
            param[9] = new SqlParameter("@AppreciateMen", SqlDbType.NVarChar, 200);
            param[9].Value = Info.AppreciateMen;
            param[10] = new SqlParameter("@Presetation", SqlDbType.NVarChar, 200);
            param[10].Value = Info.Presetation;
            return param;
        }

        /// <summary>
        /// 캯
        /// </summary>
        /// <param name="Info">ӻԱϢ</param>
        /// <returns></returns>
        private SqlParameter[] getEducationParameters(NetSNS.Model.UserEducationInfo Info)
        {
            SqlParameter[] param = new SqlParameter[6];
            param[0] = new SqlParameter("@UserID", SqlDbType.Int, 4);
            param[0].Value = Info.UserID;
            param[1] = new SqlParameter("@DegreeID", SqlDbType.Int, 4);
            param[1].Value = Info.DegreeID;
            param[2] = new SqlParameter("@SchoolID", SqlDbType.Int, 4);
            param[2].Value = Info.SchoolID;
            param[3] = new SqlParameter("@AcademyID", SqlDbType.Int, 4);
            param[3].Value = Info.AcademyID;
            param[4] = new SqlParameter("@MatriculationYear", SqlDbType.Int, 4);
            param[4].Value = Info.MatriculationYear;
            param[5] = new SqlParameter("@PostIP", SqlDbType.Char, 15);
            param[5].Value = Info.PostIP;
            return param;
        }

        /// <summary>
        /// 캯
        /// </summary>
        /// <param name="Info">ӻԱϢ</param>
        /// <returns></returns>
        private SqlParameter[] getCareerParameters(NetSNS.Model.UserCareerInfo Info)
        {
            SqlParameter[] param = new SqlParameter[9];
            param[0] = new SqlParameter("@UserID", SqlDbType.Int, 4);
            param[0].Value = Info.UserID;
            param[1] = new SqlParameter("@Company", SqlDbType.NVarChar, 100);
            param[1].Value = Info.Company;
            param[2] = new SqlParameter("@Description", SqlDbType.NVarChar, 1000);
            param[2].Value = Info.Description;
            param[3] = new SqlParameter("@IsStill", SqlDbType.Bit, 1);
            param[3].Value = Info.IsStill;
            param[4] = new SqlParameter("@JoinYear", SqlDbType.Int, 4);
            if (Info.JoinYear == 0)
                param[4].Value = DBNull.Value;
            else
                param[4].Value = Info.JoinYear;

            param[5] = new SqlParameter("@JoinMonth", SqlDbType.Int, 4);
            if (Info.JoinMonth == 0)
                param[5].Value = DBNull.Value;
            else
                param[5].Value = Info.JoinMonth;
            param[6] = new SqlParameter("@PostIP", SqlDbType.Char, 15);
            param[6].Value = Info.PostIP;
            param[7] = new SqlParameter("@LeaveYear", SqlDbType.Int, 4);
            if (Info.LeaveYear == 0)
                param[7].Value = DBNull.Value;
            else
                param[7].Value = Info.LeaveYear;

            param[8] = new SqlParameter("@LeaveMonth", SqlDbType.Int, 4);
            if (Info.LeaveMonth == 0)
                param[8].Value = DBNull.Value;
            else
                param[8].Value = Info.LeaveMonth;
           
            return param;
        }

        /// <summary>
        /// ûǷĳȨ
        /// </summary>
        /// <param name="privacy">Ȩ</param>
        /// <param name="guest">ȴ֤ǷȨ޵ûID</param>
        /// <param name="host">ߵID</param>
        /// <returns></returns>
        public bool CheckPar(int privacy, int guest, int host)
        {
            SqlConnection cn = new SqlConnection(DBConfig.CnString);
            cn.Open();
            try
            {
                switch (privacy)
                {
                    case 0:
                        return true;
                    case 1:
                        if (Friend.IsFriends(cn, host, guest))
                            return true;
                        else
                            return false;
                    case 2:
                        if (Friend.IsInSameNetwork(cn, host, guest))
                            return true;
                        else
                        {
                            if (Friend.IsFriends(cn, host, guest))
                                return true;
                            else
                                return false;
                        }
                    case 3:
                        if (guest == host)
                            return true;
                        else
                            return false;
                    default:
                        return false;
                }
            }
            finally
            {
                if (cn.State == ConnectionState.Open)
                    cn.Close();
            }
        }

        /// <summary>
        /// ӡ·Ϣ
        /// </summary>
        /// <param name="MasterID">߱</param>
        /// <param name="VisitorID">߱</param>
        /// <param name="LastVisitTime">ʱ</param>
        /// <returns></returns>
        public int InserVisit(int MasterID, int VisitorID)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();

            try
            {
                SqlParameter[] param = new SqlParameter[2];
                param[0] = new SqlParameter("@MasterID", SqlDbType.Int, 4);
                param[0].Value = MasterID;
                param[1] = new SqlParameter("@VisitorID", SqlDbType.Int, 4);
                param[1].Value = VisitorID;
                string sql = "select ID,VisitTimes from dbo.NT_Visit where MasterID=@MasterID and VisitorID=@VisitorID";
                DataTable dt=DbHelper.ExecuteTable(Conn,CommandType.Text, sql, param);

                if (dt != null && dt.Rows.Count>0)
                {
                    int VisitTimes=int.Parse(dt.Rows[0]["VisitTimes"].ToString())+1;
                    sql = "update dbo.NT_Visit set LastVisitTime='" + DateTime.Now + "',LastVisitIP='" + NetSNS.Common.Public.GetClientIP() + "',VisitTimes=" + VisitTimes + " where MasterID=@MasterID and VisitorID=@VisitorID";
                }
                else
                {
                    sql = "insert into dbo.NT_Visit(MasterID,VisitorID,LastVisitTime,LastVisitIP,VisitTimes) values(@MasterID,@VisitorID,'" + DateTime.Now + "','" + NetSNS.Common.Public.GetClientIP() + "',1)";
                }
                return DbHelper.ExecuteNonQuery(Conn, CommandType.Text, sql, param);
            }
            catch (SqlException e)
            {
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// жǷͬһ
        /// </summary>
        /// <param name="myId"></param>
        /// <param name="Friend"></param>
        /// <returns>true :ǵ  false</returns>
        public bool CheckSameNet(int myId,int Friend)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();

            try
            {
                SqlParameter[] param = new SqlParameter[2];
                param[0] = new SqlParameter("@myId", SqlDbType.Int, 4);
                param[0].Value = myId;
                param[1] = new SqlParameter("@Friend", SqlDbType.Int, 4);
                param[1].Value = Friend;

                string sql = "select Province from NT_User where UserID=@myId";
                string sqlstr = "select Province from NT_User where UserID=@Friend";
                DataTable dtmy = DbHelper.ExecuteTable(Conn,CommandType.Text, sql, param);
                DataTable dtFriend = DbHelper.ExecuteTable(Conn, CommandType.Text, sqlstr, param);

                if (dtmy != null && dtFriend != null && dtmy.Rows.Count > 0 && dtFriend.Rows.Count > 0)
                {
                    if (dtmy.Rows[0]["Province"].ToString() == dtFriend.Rows[0]["Province"].ToString())
                    {
                        return true;
                    }
                    else
                    {
                        return false;
                    }
                }
                else
                {
                    return false;
                }
            }
            catch (SqlException e)
            {
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// ޸ҵ
        /// </summary>
        /// <param name="VocationName">ҵ</param>
        /// <param name="flag">ʶ 0ӣ1޸</param>
        /// <returns></returns>
        public int UpdateAddVocation(int ID,string VocationName,int flag)
        {
            SqlConnection cn = new SqlConnection(DBConfig.CnString);
            cn.Open();
            try
            {
                string sql = "";
                SqlParameter[] param = new SqlParameter[2];
                param[0] = new SqlParameter("@ID", SqlDbType.Int, 4);
                param[0].Value = ID;
                param[1] = new SqlParameter("@VocationName", SqlDbType.NVarChar,20);
                param[1].Value = VocationName;

                if (flag == 0)
                {
                    sql = "select ID from NT_Dict_Vocation where VocName=@VocationName";
                    object obj = DbHelper.ExecuteScalar(cn,CommandType.Text, sql, param);
                    if (!Convert.IsDBNull(obj) && obj != null)//Ѿù
                    {
                        return 2;
                    }
                    else
                    {
                        sql = "insert into NT_Dict_Vocation(VocName,IsLock) values(@VocationName,0)";
                    }
                }
                else
                {
                    sql = "select ID from NT_Dict_Vocation where VocName=@VocationName and ID<>@ID";
                    object obj = DbHelper.ExecuteScalar(cn,CommandType.Text, sql, param);
                    if (!Convert.IsDBNull(obj) && obj != null)//Ѿù
                    {
                        return 2;
                    }
                    else
                    {
                        sql = "update NT_Dict_Vocation set VocName=@VocationName where ID=@ID";
                    }
                }
                return DbHelper.ExecuteNonQuery(cn, CommandType.Text, sql, param);
            }
            finally
            {
                if (cn.State == ConnectionState.Open)
                    cn.Close();
            }
        }

        /// <summary>
        /// ɾҵϢ
        /// </summary>
        /// <param name="ID">ҵ</param>
        /// <param name="value"></param>
        /// <param name="flag"></param>
        /// <returns></returns>
        public int LockDelVocation(int ID, int value, int flag)
        {
            SqlConnection cn = new SqlConnection(DBConfig.CnString);
            cn.Open();
            try
            {
                SqlParameter[] param = new SqlParameter[2];
                param[0] = new SqlParameter("@ID", SqlDbType.Int, 4);
                param[0].Value = ID;
                param[1] = new SqlParameter("@value", SqlDbType.Int, 4);
                param[1].Value = value;

                //жҵǷʹù
                string sql = "";
                if (flag == 0)//ɾ
                {
                    //жҵǷʹù
                    sql = "select Vocation from NT_UserInfo where Vocation=@ID";
                    object obj = DbHelper.ExecuteScalar(cn, CommandType.Text, sql, param);

                    if (!Convert.IsDBNull(obj) && obj != null)//Ѿù
                    {
                        return 2;
                    }
                    sql = "delete  from NT_Dict_Vocation where ID=@ID";
                }
                else if (flag == 1)//
                {
                    sql = "update NT_Dict_Vocation set IsLock=@value where ID=@ID";
                }
                return DbHelper.ExecuteNonQuery(cn,CommandType.Text, sql, param);
            }
            finally
            {
                if (cn.State == ConnectionState.Open)
                    cn.Close();
            }
        }

        /// <summary>
        /// ȡûͬһʱͬһ͵־
        /// </summary>
        /// <param name="type"></param>
        /// <param name="userID"></param>
        /// <param name="time"></param>
        /// <returns></returns>
        public DataTable getPhoto(int type,int userID,DateTime time)
        {
            SqlParameter[] param = new SqlParameter[3];
            param[0] = new SqlParameter("@type", SqlDbType.Int, 4);
            param[0].Value = type;
            param[1] = new SqlParameter("@userID", SqlDbType.Int, 4);
            param[1].Value = userID;
            param[2] = new SqlParameter("@time", SqlDbType.DateTime, 8);
            param[2].Value = time;

            string sql = "select ID,UserID,ActionType,CorrespondInfo,LogTime from dbo.NT_UserLog where UserID=@userID and CONVERT(varchar(10), LogTime,120)=CONVERT(varchar(10), @time,120) and ActionType=@type order by Id desc";
            return DbHelper.ExecuteTable(CommandType.Text, sql, param);
        }


        public DataTable GetSpaceTemplateList(int PageIndex, int PageSize, out int RecordCount, out int PageCount, params SqlConditionInfo[] SqlCondition)
        {
            string sFilter = " where isLock=0";
            string AllFields = "id,TName,TPath,CreatTime,TPicture,IPoint,GPoint,isBG,UserID,UserNumber";
            string Condition = "NT_SpaceTemplate" + sFilter;
            string IndexField = "id";
            string OrderFields = "order by id desc";
            return DbHelper.ExecutePage(AllFields, Condition, IndexField, OrderFields, PageIndex, PageSize, out RecordCount, out PageCount, null);
        }

        public DataTable GetSpaceTemplateList1(int PageIndex, int PageSize, out int RecordCount, out int PageCount, params SqlConditionInfo[] SqlCondition)
        {
            string sFilter = " where 1=1";
            string AllFields = "id,TName,TPath,CreatTime,TPicture,IPoint,GPoint,isBG,UserID,UserNumber";
            string Condition = "NT_SpaceTemplate" + sFilter;
            string IndexField = "id";
            string OrderFields = "order by id desc";
            return DbHelper.ExecutePage(AllFields, Condition, IndexField, OrderFields, PageIndex, PageSize, out RecordCount, out PageCount, null);
        }


        public IDataReader GetSpaceTemplate(int TID)
        {
            string sql = "select ID,IPoint,GPoint,isBG,TPath,isLock,UserNumber from NT_SpaceTemplate where ID=" + TID;
            return DbHelper.ExecuteReader(CommandType.Text, sql, null);
        }


        public void UpdateSpaceTemplateLockStatc(int ID, int num)
        {
            string sql = string.Empty;
            if (num == 2)
            {
                sql = "delete from NT_SpaceTemplate where ID=" + ID;
            }
            else
            {
                sql = "update NT_SpaceTemplate set islock=" + num + " where ID=" + ID;
            }
            DbHelper.ExecuteNonQuery(CommandType.Text, sql, null);
        }

        /// <summary>
        /// »Ա鿴
        /// </summary>
        /// <param name="UserID"></param>
        /// <param name="times"></param>
        /// <returns></returns>
        public int InsertClick(int UserID, int times)
        {
            SqlParameter[] param = new SqlParameter[2];
            param[0] = new SqlParameter("@UserID", SqlDbType.Int, 4);
            param[0].Value = UserID;
            param[1] = new SqlParameter("@times", SqlDbType.Int, 4);
            param[1].Value = times;
            string sql = "update NT_User set Click=@times where UserID=@UserID";
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, param);
        }


        public IDataReader getSpaceTemplateInfo(int ID)
        {
            string sql = "select * from NT_SpaceTemplate where ID=" + ID;
            return DbHelper.ExecuteReader(CommandType.Text, sql, null);
        }

        public void USpaceTemplate(int ID, string TName, string TPath, string TPicture, DateTime CreatTime, int IsLock, int IPoint, int GPoint, int isBG, int UserID, int UserNumber)
        {
            string sql = string.Empty;
            if (ID != 0)
            {
                sql = "update NT_SpaceTemplate set TName='" + TName + "',TPath='" + TPath + "',TPicture='" + TPicture + "',Ipoint=" + IPoint + ",GPoint=" + GPoint + ",UserID=" + UserID + ",UserNumber=" + UserNumber + " where ID=" + ID;
            }
            else
            {
                sql = "insert into NT_SpaceTemplate(TName,TPath,TPicture,CreatTime,IsLock,IPoint,GPoint,isBG,UserID,UserNumber)VALUES('" + TName + "','" + TPath + "','" + TPicture + "','" + CreatTime + "'," + IsLock + "," + IPoint + "," + GPoint + "," + isBG + "," + UserID + "," + UserNumber + ")";
            }
            DbHelper.ExecuteNonQuery(CommandType.Text, sql, null);
        }
    }
}