using System;
using System.Collections.Generic;
using System.Text;
using NetSNS.DALFactory;
using System.Data;
using System.Data.SqlClient;
using NetSNS.DALProfile;
using NetSNS.Config;
using NetSNS.Model;
using NetSNS.Common;

namespace NetSNS.DALSQLServer
{
    public class User : DbBase, IUser
    {
        /// <summary>
        /// жǷѾע
        /// </summary>
        /// <param name="UserEmail">ûEmail</param>
        /// <returns></returns>
        public bool IsExist(string UserEmail)
        {
            SqlParameter param = new SqlParameter("@UserEmail", SqlDbType.NVarChar, 100);
            param.Value = UserEmail;
            string sql = "select Email from NT_User where Email=@UserEmail";
            string result = Convert.ToString(DbHelper.ExecuteScalar(CommandType.Text, sql, param));
            if (result == UserEmail)
            {
                return true;
            }
            else
            {
                return false;
            }
        }
        /// <summary>
        /// ûע
        /// </summary>
        /// <param name="ui">û</param>
        /// <returns>Ӱ</returns>
        public EnumRegister Register(UserInfo ui)
        {
            string verifyCode = Rand.Str(11);
            SqlConnection cn = new SqlConnection(DBConfig.CnString);
            cn.Open();
            try
            {
                SqlParameter[] param = new SqlParameter[13];
                param[0] = new SqlParameter("@ReturnValue", SqlDbType.Int);
                param[0].Direction = ParameterDirection.ReturnValue;
                param[1] = new SqlParameter("@Email", SqlDbType.NVarChar, 100);
                param[1].Value = ui.Email;
                param[2] = new SqlParameter("@IP", SqlDbType.Char, 15);
                param[2].Value = Public.GetClientIP();
                param[3] = new SqlParameter("@Password", SqlDbType.NVarChar, 32);
                param[3].Value = NetSNS.Common.Input.MD5(ui.Password, false);
                param[4] = new SqlParameter("@Username", SqlDbType.NVarChar, 50);
                param[4].Value = ui.Username;
                param[5] = new SqlParameter("@State", SqlDbType.Int, 4);
                param[5].Value = (int)EnumUserState.Register;
                param[6] = new SqlParameter("@Province", SqlDbType.Int, 4);
                param[6].Value = ui.Province;
                param[7] = new SqlParameter("@City", SqlDbType.Int, 4);
                if (ui.City == 0)
                    param[7].Value = DBNull.Value;
                else
                    param[7].Value = ui.City;
                param[8] = new SqlParameter("@NowTime", SqlDbType.DateTime);
                param[8].Value = DateTime.Now;
                param[9] = new SqlParameter("@VerifyCode", SqlDbType.Char, 11);
                param[9].Value = verifyCode;
                param[10] = new SqlParameter("@EmailItem", SqlDbType.VarChar, 1000);
                param[10].Value = EnumClass.GetEmailNotifyStr();
                param[11] = new SqlParameter("@PrivDef", SqlDbType.Int);
                param[11].Value = (int)EnumPrivacy.ForWholeSite;
                param[12] = new SqlParameter("@Kid", SqlDbType.Int);
                param[12].Value = ui.Kid;
                DbHelper.ExecuteNonQuery(cn, CommandType.StoredProcedure, "NTP_Register", param);
                int retvalue = (int)param[0].Value;
                switch (retvalue)
                {
                    case 1:
                        #region עɹʼ
                        try
                        {
                            //ĬϺ
                            string dfriend = UiConfig.defaultfriend;
                            string[] dfriendARR = null;
                            if (dfriend.IndexOf(",") > -1 || dfriend!=string.Empty)
                            {
                                DateTime now = DateTime.Now;
                                string qsql = "select UserID from NT_User where Email='" + ui.Email + "'";
                                int UserID = Convert.ToInt32(DbHelper.ExecuteScalar(cn, CommandType.Text, qsql, param));
                                if (dfriend.IndexOf(",") > -1)
                                {
                                    dfriendARR = dfriend.Split(',');
                                    string iSQL = string.Empty;
                                    string riSQL = string.Empty;
                                    for (int j = 0; j < dfriendARR.Length; j++)
                                    {
                                        iSQL = "insert into NT_Friend (UserID,FriendID,State,AddTime) values (" + UserID + "," + dfriendARR[j].ToString() + ",0,'" + now.ToString() + "')";
                                        int iCount = DbHelper.ExecuteNonQuery(cn, CommandType.Text, iSQL, null);

                                        riSQL = "insert into NT_Friend (UserID,FriendID,State,AddTime) values (" + dfriendARR[j].ToString() + "," + UserID + ",0,'" + now.ToString() + "')";
                                        int riCount = DbHelper.ExecuteNonQuery(cn, CommandType.Text, riSQL, null);
                                    }
                                }
                                else
                                {
                                    string reiSQL = "insert into NT_Friend (UserID,FriendID,State,AddTime) values (" + dfriend + "," + UserID + ",0,'" + now.ToString() + "')";
                                    int reiCount = DbHelper.ExecuteNonQuery(cn, CommandType.Text, reiSQL, null);
                                }
                            }

                            NetSNS.Common.EMail em = NetSNS.Common.EMail.CreateInstance();
                            string body = EmailConfig.register;
                            body = body.Replace("{SiteName}", UiConfig.SiteName);
                            body = body.Replace("{UserName}", ui.Username);
                            body = body.Replace("{Domain}", UiConfig.Domain);
                            body = body.Replace("{Date}", DateTime.Now.ToString("yyyyMMdd"));
                            body = body.Replace("{Url}", UiConfig.RootUrl + "/RegVerify.aspx?r=" + verifyCode);
                            em.Body = body;
                            em.Subject = "װ" + ui.Username + "ȷ" + UiConfig.SiteName + "ע";
                            em.To = ui.Email;
                            em.From = UiConfig.SiteName + "<" + EmailConfig.from + ">";
                            em.Send();
                            return EnumRegister.Succeed;

                        }
                        catch
                        {
                            return EnumRegister.EmailMayNotSend;
                        }
                        #endregion
                    case 2:
                        return EnumRegister.EmailRepeat;
                    default:
                        return EnumRegister.UnexpectedError;
                }
            }
            finally
            {
                if (cn.State == ConnectionState.Open)
                    cn.Close();
            }
        }
        /// <summary>
        /// עȷ,֤ͬʱ¼
        /// </summary>
        /// <param name="code"></param>
        /// <param name="userId"></param>
        /// <param name="userName"></param>
        /// <param name="md5Password"></param>
        /// <returns>0ɹ,-1֤벻ȷ,-2û֤ͨ,-3޸ʧ</returns>
        public int RegisterConfirm(string code, out int userId, out string userName, out string md5Password)
        {
            userId = 0;
            userName = string.Empty;
            md5Password = string.Empty;
            SqlConnection cn = new SqlConnection(DBConfig.CnString);
            cn.Open();
            try
            {
                EnumUserState state = EnumUserState.Normal;
                bool f = false;
                int inviter = 0;
                SqlParameter Param = new SqlParameter("@VerifyCode", code);
                string Sql = "select UserID,UserName,Password,State,InviterID from NT_User where VerifyCode=@VerifyCode";
                IDataReader rd = DbHelper.ExecuteReader(cn, CommandType.Text, Sql, Param);
                if (rd.Read())
                {
                    userId = rd.GetInt32(0);
                    userName = rd.GetString(1);
                    md5Password = rd.GetString(2);
                    state = (EnumUserState)rd.GetInt32(3);
                    if (!rd.IsDBNull(4)) inviter = rd.GetInt32(4);
                    f = true;
                }
                rd.Close();
                if (!f)
                    return -1;
                if (state != EnumUserState.Register)
                {
                    return -2;
                }
                Sql = "select count(ID) from NT_Friend where (UserID=" + userId + " and FriendID=" + inviter + ") or (UserID=" + inviter + " and FriendID=" + userId + ")";
                int m = (int)DbHelper.ExecuteScalar(cn, CommandType.Text, Sql, null);
                DateTime now = DateTime.Now;
                SqlTransaction trans = cn.BeginTransaction();
                try
                {
                    Sql = "update NT_User set State=" + (int)EnumUserState.Normal + ",LastLoginTime='" + now + "',LastLoginIP='" + Public.GetClientIP() + "',LoginTimes=1,ConfirmTime='" + now + "' where VerifyCode=@VerifyCode";
                    int n = DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, Param);
                    if (inviter > 0 && m == 0)
                    {
                        Sql = "insert into NT_Friend (UserID,FriendID,State,AddTime) values (" + userId + "," + inviter + ",0,'" + now + "')";
                        n += DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                        Sql = "insert into NT_Friend (UserID,FriendID,State,AddTime) values (" + inviter + "," + userId + ",0,'" + now + "')";
                        n += DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                    }
                    trans.Commit();
                    if (n > 0)
                        return 0;
                    else
                        return -3;
                }
                catch
                {
                    trans.Rollback();
                    throw;
                }
            }
            finally
            {
                if (cn.State == ConnectionState.Open)
                    cn.Close();
            }
        }
        /// <summary>
        /// ûע
        /// </summary>
        /// <param name="ui"></param>
        /// <param name="code"></param>
        /// <returns></returns>
        public EnumRegister InviterRegister(UserInfo ui, EnumFriendInviteMode mode, string code, out int userId)
        {
            userId = 0;           
            if (mode == EnumFriendInviteMode.Email)
            {
                return EmailRegister(ui, code, out userId);
            }
            else
            {
                return UrlRegister(ui, int.Parse(code), out userId);
            }
        }
        private void sellFriendInviteMoney(string code)
        {
            int r = 0;
            SellFriend sf = new SellFriend();
            if (int.TryParse(code, out r))
            {
                sf.GetInviteMoney(r);
            }
            else
            {
                sf.GetInviteMoney(code);
            }
        }
        /// <summary>
        /// Urlע
        /// </summary>
        /// <param name="ui"></param>
        /// <param name="code"></param>
        /// <param name="userId"></param>
        /// <returns></returns>
        EnumRegister UrlRegister(UserInfo ui, int Inviter, out int userId)
        {
            string verifyCode = Rand.Str(11);
            userId = 0;
            SqlConnection cn = new SqlConnection(DBConfig.CnString);
            cn.Open();
            try
            {
                SqlParameter[] param = new SqlParameter[14];
                param[0] = new SqlParameter("@ReturnValue", SqlDbType.Int);
                param[0].Direction = ParameterDirection.ReturnValue;
                param[1] = new SqlParameter("@InviterID", SqlDbType.Int);
                param[1].Value = Inviter;
                param[2] = new SqlParameter("@Email", SqlDbType.NVarChar, 100);
                param[2].Value = ui.Email;
                param[3] = new SqlParameter("@IP", SqlDbType.Char, 15);
                param[3].Value = Public.GetClientIP();
                param[4] = new SqlParameter("@Password", SqlDbType.NVarChar, 32);
                param[4].Value = NetSNS.Common.Input.MD5(ui.Password, false);
                param[5] = new SqlParameter("@Username", SqlDbType.NVarChar, 50);
                param[5].Value = ui.Username;
                param[6] = new SqlParameter("@State", SqlDbType.Int, 4);
                param[6].Value = (int)EnumUserState.Register;
                param[7] = new SqlParameter("@Province", SqlDbType.Int, 4);
                param[7].Value = ui.Province;
                param[8] = new SqlParameter("@City", SqlDbType.Int, 4);
                if (ui.City == 0)
                    param[8].Value = DBNull.Value;
                else
                    param[8].Value = ui.City;
                param[9] = new SqlParameter("@NowTime", SqlDbType.DateTime);
                param[9].Value = DateTime.Now;
                param[10] = new SqlParameter("@VerifyCode", SqlDbType.Char, 11);
                param[10].Value = verifyCode;
                param[11] = new SqlParameter("@EmailItem", SqlDbType.VarChar, 1000);
                param[11].Value = EnumClass.GetEmailNotifyStr();
                param[12] = new SqlParameter("@PrivDef", SqlDbType.Int);
                param[12].Value = (int)EnumPrivacy.ForWholeSite;
                param[13] = new SqlParameter("@NewUid", SqlDbType.Int);
                param[13].Direction = ParameterDirection.Output;
                DbHelper.ExecuteNonQuery(cn, CommandType.StoredProcedure, "NTP_UrlRegister", param);
                int retvalue = (int)param[0].Value;
                switch (retvalue)
                {
                    case 1:
                        #region עɹʼ
                        userId = (int)param[13].Value;
                        try
                        {

                            NetSNS.Common.EMail em = NetSNS.Common.EMail.CreateInstance();
                            string body = EmailConfig.register;
                            body = body.Replace("{SiteName}", UiConfig.SiteName);
                            body = body.Replace("{UserName}", ui.Username);
                            body = body.Replace("{Domain}", UiConfig.Domain);
                            body = body.Replace("{Date}", DateTime.Now.ToString("yyyyMMdd"));
                            body = body.Replace("{Url}", UiConfig.RootUrl + "/RegVerify.aspx?r=" + verifyCode);
                            em.Body = body;
                            em.Subject = "װ" + ui.Username + "ȷ" + UiConfig.SiteName + "ע";
                            em.To = ui.Email;
                            em.From = UiConfig.SiteName + "<" + EmailConfig.from + ">";
                            em.Send();
                            return EnumRegister.Succeed;

                        }
                        catch
                        {
                            return EnumRegister.EmailMayNotSend;
                        }
                        #endregion
                    case 2:
                        return EnumRegister.EmailRepeat;
                    default:
                        return EnumRegister.UnexpectedError;
                }
            }
            finally
            {
                if (cn.State == ConnectionState.Open)
                    cn.Close();
            }
        }
        /// <summary>
        /// Emailע
        /// </summary>
        /// <param name="ui"></param>
        /// <param name="code"></param>
        /// <param name="userId"></param>
        /// <returns></returns>
        EnumRegister EmailRegister(UserInfo ui, string code, out int userId)
        {
            userId = 0;
            SqlConnection cn = new SqlConnection(DBConfig.CnString);
            cn.Open();
            try
            {
                SqlParameter[] param = new SqlParameter[13];
                param[0] = new SqlParameter("@ReturnValue", SqlDbType.Int);
                param[0].Direction = ParameterDirection.ReturnValue;
                param[1] = new SqlParameter("@Email", SqlDbType.NVarChar, 100);
                param[1].Value = ui.Email;
                param[2] = new SqlParameter("@IP", SqlDbType.Char, 15);
                param[2].Value = Public.GetClientIP();
                param[3] = new SqlParameter("@Password", SqlDbType.NVarChar, 32);
                param[3].Value = NetSNS.Common.Input.MD5(ui.Password, false);
                param[4] = new SqlParameter("@Username", SqlDbType.NVarChar, 50);
                param[4].Value = ui.Username;
                param[5] = new SqlParameter("@State", SqlDbType.Int, 4);
                param[5].Value = (int)EnumUserState.Normal;
                param[6] = new SqlParameter("@Province", SqlDbType.Int, 4);
                param[6].Value = ui.Province;
                param[7] = new SqlParameter("@City", SqlDbType.Int, 4);
                if (ui.City == 0)
                    param[7].Value = DBNull.Value;
                else
                    param[7].Value = ui.City;
                param[8] = new SqlParameter("@NowTime", SqlDbType.DateTime);
                param[8].Value = DateTime.Now;
                param[9] = new SqlParameter("@EmailItem", SqlDbType.VarChar, 1000);
                param[9].Value = EnumClass.GetEmailNotifyStr();
                param[10] = new SqlParameter("@Code", SqlDbType.Char, 11);
                param[10].Value = code;
                param[11] = new SqlParameter("@PrivDef", SqlDbType.Int);
                param[11].Value = (int)EnumPrivacy.ForWholeSite;
                param[12] = new SqlParameter("@NewUid", SqlDbType.Int);
                param[12].Direction = ParameterDirection.Output;
                DbHelper.ExecuteNonQuery(cn, CommandType.StoredProcedure, "NTP_InviterRegister", param);
                int retvalue = (int)param[0].Value;
                switch (retvalue)
                {
                    case 1:
                        userId = (int)param[12].Value;
                        return EnumRegister.Succeed;
                    case 2:
                        return EnumRegister.InvalidCode;
                    case 3:
                        return EnumRegister.RegInviteCode;
                    case 4:
                        return EnumRegister.EmailRepeat;
                    default:
                        return EnumRegister.UnexpectedError;
                }
            }
            finally
            {
                if (cn.State == ConnectionState.Open)
                    cn.Close();
            }
        }
        /// <summary>
        /// ȡûݿ
        /// </summary>
        /// <param name="ui">û</param>
        /// <returns>ûݿ</returns>
        private SqlParameter[] GetParam(UserInfo ui)
        {
            SqlParameter[] param = new SqlParameter[7];
            param[0] = new SqlParameter("@Email", SqlDbType.NVarChar, 100);
            param[0].Value = ui.Email;
            param[1] = new SqlParameter("@Password", SqlDbType.NVarChar, 32);
            param[1].Value = ui.Password;
            param[2] = new SqlParameter("@Username", SqlDbType.NVarChar, 50);
            param[2].Value = ui.Username;
            param[3] = new SqlParameter("@State", SqlDbType.Int, 4);
            param[3].Value = ui.State;
            param[4] = new SqlParameter("@Province", SqlDbType.Int, 4);
            param[4].Value = ui.Province;
            param[5] = new SqlParameter("@City", SqlDbType.Int, 4);
            if (ui.City == 0)
                param[5].Value = DBNull.Value;
            else
                param[5].Value = ui.City;
            param[6] = new SqlParameter("@Portrait", SqlDbType.Int, 4);
            param[6].Value = ui.Portrait;
            return param;
        }
        /// <summary>
        /// ˳
        /// </summary>
        /// <param name="Email">ûEmail</param>
        /// <returns></returns>
        public int Exit(int userID)
        {
            SqlConnection sqlConn = new SqlConnection(DBConfig.CnString);
            sqlConn.Open();
            SqlTransaction trans = sqlConn.BeginTransaction();
            try
            {
                int num = UserLog(trans, EnumUserAction.LogOut, userID, "û˳", 0);
                trans.Commit();
                return num;
            }
            catch (SqlException sqlEx)
            {
                trans.Rollback();
                throw sqlEx;
            }
            finally
            {
                if (sqlConn.State == ConnectionState.Open)
                    sqlConn.Close();
            }
        }

        /// <summary>
        /// ޸û
        /// </summary>
        /// <param name="UserID">ûID</param>
        /// <param name="NewName">û</param>
        /// <returns></returns>
        public int ChangeName(int UserID, string NewName)
        {
            SqlConnection sqlConn = new SqlConnection(DBConfig.CnString);
            sqlConn.Open();
            SqlTransaction trans = sqlConn.BeginTransaction();
            try
            {
                SqlParameter param = new SqlParameter("@NewName", SqlDbType.NVarChar, 50);
                param.Value = NewName;
                string sql = "update NT_User set UserName=@NewName where UserID=" + UserID.ToString();
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, sql, param);
                int num = UserLog(trans, EnumUserAction.ChangeName, UserID, "޸", null);
                trans.Commit();
                return num;
            }
            catch (SqlException sqlEx)
            {
                trans.Rollback();
                throw sqlEx;
            }
            finally
            {
                if (sqlConn.State == ConnectionState.Open)
                    sqlConn.Close();
            }
        }
        /// <summary>
        /// ޸Email
        /// </summary>
        /// <param name="UserID">ûID</param>
        /// <param name="Email">Email</param>
        /// <returns></returns>
        public int ChangeEmail(int UserID, string Email)
        {
            SqlConnection sqlConn = new SqlConnection(DBConfig.CnString);
            sqlConn.Open();
            SqlTransaction trans = sqlConn.BeginTransaction();
            try
            {
                SqlParameter param = new SqlParameter("@Email", SqlDbType.NVarChar, 100);
                param.Value = Email;
                string sql = "update NT_User set Email=@Email where UserID=" + UserID.ToString();
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, sql, param);
                int num = UserLog(trans, EnumUserAction.ChangeEmail, UserID, "޸Email", null);
                trans.Commit();
                return num;
            }
            catch (SqlException sqlEx)
            {
                trans.Rollback();
                throw sqlEx;
            }
            finally
            {
                if (sqlConn.State == ConnectionState.Open)
                    sqlConn.Close();
            }
        }
        /// <summary>
        /// ޸
        /// </summary>
        /// <param name="UserID">ûID</param>
        /// <param name="Password">Password</param>
        /// <returns></returns>
        public int ChangePassword(int UserID, string Password)
        {
            SqlParameter param = new SqlParameter("@Password", SqlDbType.NChar, 32);
            param.Value = NetSNS.Common.Input.MD5(Password, false);
            string sql = "update NT_User set Password=@Password where UserID=" + UserID.ToString();
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, param);
        }
        /// <summary>
        /// ޸ڵ
        /// </summary>
        /// <param name="UserID">ûID</param>
        /// <param name="Province">ʡ</param>
        /// <param name="City"></param>
        /// <returns></returns>
        public int ChangeAddr(int UserID, int Province, int City)
        {
            SqlConnection sqlConn = new SqlConnection(DBConfig.CnString);
            sqlConn.Open();
            SqlTransaction trans = sqlConn.BeginTransaction();
            try
            {
                string sql = "update NT_User set Province=" + Province.ToString() + ",City=" + City.ToString() + " where UserID=" + UserID.ToString();
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, sql, null);
                int num = UserLog(trans, EnumUserAction.ChangeAddr, UserID, "޸ڵ", null);
                trans.Commit();
                return num;
            }
            catch (SqlException sqlEx)
            {
                trans.Rollback();
                throw sqlEx;
            }
            finally
            {
                if (sqlConn.State == ConnectionState.Open)
                    sqlConn.Close();
            }
        }
        /// <summary>
        /// MSN
        /// </summary>
        /// <param name="UserID">ûID</param>
        /// <param name="MSN">MSNʺ</param>
        /// <returns></returns>
        public int ChangeMSN(int UserID, string MSN)
        {
            SqlConnection sqlConn = new SqlConnection(DBConfig.CnString);
            sqlConn.Open();
            SqlTransaction trans = sqlConn.BeginTransaction();
            try
            {
                SqlParameter param = new SqlParameter("@MSN", SqlDbType.NVarChar, 50);
                param.Value = MSN;
                string sql = "update NT_UserInfo set MSN=@MSN where UserID=" + UserID.ToString();
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, sql, param);
                int num = UserLog(trans, EnumUserAction.ChangeContact, UserID, "޸ϵʽ", null);
                trans.Commit();
                return num;
            }
            catch (SqlException sqlEx)
            {
                trans.Rollback();
                throw sqlEx;
            }
            finally
            {
                if (sqlConn.State == ConnectionState.Open)
                    sqlConn.Close();
            }
        }
        /// <summary>
        /// GTalk
        /// </summary>
        /// <param name="UserID">ûID</param>
        /// <param name="MSN">GTalkʺ</param>
        /// <returns></returns>
        public int ChangeGTalk(int UserID, string GTalk)
        {
            SqlConnection sqlConn = new SqlConnection(DBConfig.CnString);
            sqlConn.Open();
            SqlTransaction trans = sqlConn.BeginTransaction();
            try
            {
                SqlParameter param = new SqlParameter("@GTalk", SqlDbType.NVarChar, 50);
                param.Value = GTalk;
                string sql = "update NT_UserInfo set GTalk=@GTalk where UserID=" + UserID.ToString();
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, sql, param);
                int num = UserLog(trans, EnumUserAction.ChangeContact, UserID, "޸ϵʽ", null);
                trans.Commit();
                return num;
            }
            catch (SqlException sqlEx)
            {
                trans.Rollback();
                throw sqlEx;
            }
            finally
            {
                if (sqlConn.State == ConnectionState.Open)
                    sqlConn.Close();
            }
        }
        /// <summary>
        /// Mobile
        /// </summary>
        /// <param name="UserID">ûID</param>
        /// <param name="MSN">Mobileʺ</param>
        /// <returns></returns>
        public int ChangeMobile(int UserID, string Mobile)
        {
            SqlConnection sqlConn = new SqlConnection(DBConfig.CnString);
            sqlConn.Open();
            SqlTransaction trans = sqlConn.BeginTransaction();
            try
            {
                SqlParameter param = new SqlParameter("@Mobile", SqlDbType.NChar, 15);
                param.Value = Mobile;
                string sql = "update NT_UserInfo set Mobile=@Mobile where UserID=" + UserID.ToString();
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, sql, param);
                int num = UserLog(trans, EnumUserAction.ChangeContact, UserID, "޸ϵʽ", null);
                trans.Commit();
                return num;
            }
            catch (SqlException sqlEx)
            {
                trans.Rollback();
                throw sqlEx;
            }
            finally
            {
                if (sqlConn.State == ConnectionState.Open)
                    sqlConn.Close();
            }
        }
        #region ¼
        /// <summary>
        /// ¼
        /// </summary>
        /// <param name="Email">ûEmail</param>
        /// <param name="Password"></param>
        /// <returns></returns>
        public EnumLoginState Login(string email, string password, out int userId, out string userName, out string portrait)
        {
            userId = -1;
            userName = string.Empty;
            portrait = string.Empty;
            SqlConnection cn = new SqlConnection(DBConfig.CnString);

            cn.Open();
            try
            {
                string pwd = string.Empty;
                EnumUserState us = EnumUserState.Lock;
                SqlParameter param = new SqlParameter("@Email", email);
                bool exist = false;
                int headpic = 0;
                string Sql = "select UserID,UserName,Password,State,Portrait from NT_User where Email=@Email";
                IDataReader rd = DbHelper.ExecuteReader(cn, CommandType.Text, Sql, param);
                if (rd.Read())
                {
                    userId = rd.GetInt32(0);
                    userName = rd.GetString(1);
                    pwd = rd.GetString(2);
                    us = (EnumUserState)rd.GetInt32(3);
                    if (!rd.IsDBNull(4)) headpic = rd.GetInt32(4);
                    exist = true;
                }
                rd.Close();
                if (!exist || pwd == string.Empty ||!Input.MD5Valid(pwd,password))
                    return EnumLoginState.Err_NameOrPwdError;
                if (us == EnumUserState.Register)
                    return EnumLoginState.Err_UnActivation;
                else if (us == EnumUserState.Lock)
                    return EnumLoginState.Err_Locked;
                if (headpic > 0)
                {
                    Sql = "select FilePath from NT_Photo where PhotoID=" + headpic;
                    portrait = Convert.ToString(DbHelper.ExecuteScalar(cn, CommandType.Text, Sql, null));
                }
                Sql = "update NT_User set LastLoginTime='" + DateTime.Now + "',LastLoginIP='" + NetSNS.Common.Public.GetClientIP() + "',LoginTimes=LoginTimes+1 where UserID=" + userId;
                DbHelper.ExecuteNonQuery(cn, CommandType.Text, Sql, null);
                return EnumLoginState.Succeed;
            }
            finally
            {
                if (cn.State == ConnectionState.Open)
                    cn.Close();
            }
        }
        /// <summary>
        /// ¼
        /// </summary>
        /// <param name="UserID">ûID</param>
        /// <param name="Password"></param>
        /// <returns></returns>
        public EnumLoginState Login(int UserID, string password,out string userName, out string portrait)
        {            
            userName = string.Empty;
            portrait = string.Empty;
            SqlConnection cn = new SqlConnection(DBConfig.CnString);

            cn.Open();
            try
            {
                string pwd = string.Empty;
                EnumUserState us = EnumUserState.Lock;
                SqlParameter param = new SqlParameter("@UserID", UserID);
                bool exist = false;
                int headpic = 0;
                string Sql = "select UserID,UserName,Password,State,Portrait from NT_User where UserID=@UserID";
                IDataReader rd = DbHelper.ExecuteReader(cn, CommandType.Text, Sql, param);
                if (rd.Read())
                {
                    userName = rd.GetString(1);
                    pwd = rd.GetString(2);
                    us = (EnumUserState)rd.GetInt32(3);
                    if (!rd.IsDBNull(4)) headpic = rd.GetInt32(4);
                    exist = true;
                }
                rd.Close();
                if (!exist || pwd == string.Empty || !Input.MD5Valid(pwd, password))
                    return EnumLoginState.Err_NameOrPwdError;
                if (us == EnumUserState.Register)
                    return EnumLoginState.Err_UnActivation;
                else if (us == EnumUserState.Lock)
                    return EnumLoginState.Err_Locked;
                if (headpic > 0)
                {
                    Sql = "select FilePath from NT_Photo where PhotoID=" + headpic;
                    portrait = Convert.ToString(DbHelper.ExecuteScalar(cn, CommandType.Text, Sql, null));
                }
                Sql = "update NT_User set LastLoginTime='" + DateTime.Now + "',LastLoginIP='" + NetSNS.Common.Public.GetClientIP() + "',LoginTimes=LoginTimes+1 where UserID=" + UserID;
                DbHelper.ExecuteNonQuery(cn, CommandType.Text, Sql, null);
                return EnumLoginState.Succeed;
            }
            finally
            {
                if (cn.State == ConnectionState.Open)
                    cn.Close();
            }
        }
        /// <summary>
        /// ¼
        /// </summary>
        /// <param name="userId"></param>
        /// <param name="password"></param>
        /// <returns></returns>
        public EnumLoginState CheckLogin(int userId, string password)
        {
            SqlConnection cn = new SqlConnection(DBConfig.CnString);
            cn.Open();
            try
            {
                string pwd = string.Empty;
                EnumUserState us = EnumUserState.Lock;
                bool exist = false;
                string Sql = "select Password,State from NT_User where UserID=" + userId;
                IDataReader rd = DbHelper.ExecuteReader(cn, CommandType.Text, Sql, null);
                if (rd.Read())
                {
                    pwd = rd.GetString(0);
                    us = (EnumUserState)rd.GetInt32(1);
                    exist = true;
                }
                rd.Close();
                if (!exist || pwd == string.Empty || !Input.M2D5(pwd,password))
                    return EnumLoginState.Err_NameOrPwdError;
                if (us == EnumUserState.Register)
                    return EnumLoginState.Err_UnActivation;
                else if (us == EnumUserState.Lock)
                    return EnumLoginState.Err_Locked;
                return EnumLoginState.Succeed;
            }
            finally
            {
                if (cn.State == ConnectionState.Open)
                    cn.Close();
            }
        }
        #endregion
        /// <summary>
        /// ȡûʵ
        /// </summary>
        /// <param name="UserID">ûID</param>
        /// <returns></returns>
        public UserInfo GetUserInfo(int UserID)
        {
            UserInfo UInfo = new UserInfo();
            UInfo.UserID = UserID;
            string sql = "select a.*,b.FilePath from NT_User a left join NT_Photo b on a.Portrait=b.PhotoID and b.IsLock=0 where UserID=" + UserID;
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, sql, null);
            if (rd.Read())
            {
                UInfo.Email = rd["Email"].ToString();
                UInfo.Password = rd["Password"].ToString();
                UInfo.Username = rd["Username"].ToString();
                UInfo.State = (EnumUserState)(int)rd["State"];
                if (rd["LastLoginTime"] != DBNull.Value) UInfo.LastLoginTime = (DateTime)rd["LastLoginTime"];
                if (rd["LastLoginIp"] != DBNull.Value) UInfo.LastLoginIp = rd["LastLoginIp"].ToString();
                UInfo.LoginTimes = (int)rd["LoginTimes"];
                UInfo.Province = (int)rd["Province"];
                if (rd["City"] != DBNull.Value) UInfo.City = (int)rd["City"];
                UInfo.RegTime = (DateTime)rd["RegTime"];
                UInfo.RegIP = rd["RegIP"].ToString();
                if (rd["Portrait"] != DBNull.Value) UInfo.Portrait = (int)rd["Portrait"];
                if (rd["FilePath"] != DBNull.Value) UInfo.PortraitDir = (string)rd["FilePath"];
                if (rd["Integral"] != DBNull.Value) UInfo.Integral = (int)rd["Integral"];
                if (rd["Click"] != DBNull.Value) UInfo.Click = (int)rd["Click"];
            }
            rd.Close();
            return UInfo;
        }

        /// <summary>
        /// ȡûϢʵ
        /// </summary>
        /// <param name="UserID">ûID</param>
        /// <returns></returns>
        public UserBasicInfo GetUserBasic(int UserID)
        {
            UserBasicInfo UBasicInfo = new UserBasicInfo();
            UBasicInfo.UserID = UserID;
            string sql = "select * from NT_UserInfo where UserID=" + UserID.ToString();
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, sql, null);
            if (rd.Read())
            {
                UBasicInfo.Sex = Convert.ToInt32(rd["Sex"]);
                if (rd["Birthday"] != DBNull.Value) UBasicInfo.Birthday = Convert.ToDateTime(rd["Birthday"]);
                if (rd["BirthidayDisplay"] != DBNull.Value) UBasicInfo.BirthidayDisplay = Convert.ToInt32(rd["BirthidayDisplay"]);
                if (rd["Constellation"] != DBNull.Value) UBasicInfo.Constellation = Convert.ToInt32(rd["Constellation"]);
                if (rd["MSN"] != DBNull.Value) UBasicInfo.MSN = Convert.ToString(rd["MSN"]);
                if (rd["GTalk"] != DBNull.Value) UBasicInfo.GTalk = Convert.ToString(rd["GTalk"]);
                if (rd["QQ"] != DBNull.Value) UBasicInfo.QQ = Convert.ToString(rd["QQ"]);
                if (rd["Skype"] != DBNull.Value) UBasicInfo.Skype = Convert.ToString(rd["Skype"]);
                if (rd["Mobile"] != DBNull.Value) UBasicInfo.Mobile = Convert.ToString(rd["Mobile"]);
                if (rd["MobilePrivacy"] != DBNull.Value) UBasicInfo.MobilePrivacy = Convert.ToInt32(rd["MobilePrivacy"]);
                if (rd["EmailPrivacy"] != DBNull.Value) UBasicInfo.EmailPrivacy = Convert.ToInt32(rd["EmailPrivacy"]);
                if (rd["Tel"] != DBNull.Value) UBasicInfo.Tel = Convert.ToString(rd["Tel"]);
                if (rd["Addr"] != DBNull.Value) UBasicInfo.Addr = Convert.ToString(rd["Addr"]);
                if (rd["WebSite"] != DBNull.Value) UBasicInfo.WebSite = Convert.ToString(rd["WebSite"]);
                if (rd["Favourite"] != DBNull.Value) UBasicInfo.Favourite = Convert.ToString(rd["Favourite"]);
                if (rd["FavMusics"] != DBNull.Value) UBasicInfo.FavMusics = Convert.ToString(rd["FavMusics"]);
                if (rd["FavMovies"] != DBNull.Value) UBasicInfo.FavMovies = Convert.ToString(rd["FavMovies"]);
                if (rd["FavCartoons"] != DBNull.Value) UBasicInfo.FavCartoons = Convert.ToString(rd["FavCartoons"]);
                if (rd["FavGames"] != DBNull.Value) UBasicInfo.FavGames = Convert.ToString(rd["FavGames"]);
                if (rd["FavSports"] != DBNull.Value) UBasicInfo.FavSports = Convert.ToString(rd["FavSports"]);
                if (rd["FavBooks"] != DBNull.Value) UBasicInfo.FavBooks = Convert.ToString(rd["FavBooks"]);
                if (rd["FavAdages"] != DBNull.Value) UBasicInfo.FavAdages = Convert.ToString(rd["FavAdages"]);
                if (rd["AppreciateMen"] != DBNull.Value) UBasicInfo.AppreciateMen = Convert.ToString(rd["AppreciateMen"]);
                if (rd["Presentation"] != DBNull.Value) UBasicInfo.Presetation = Convert.ToString(rd["Presentation"]);
                if (rd["Vocation"] != DBNull.Value) UBasicInfo.Vocation = Convert.ToInt32(rd["Vocation"]);
                if (rd["MSNPrivacy"] != DBNull.Value) UBasicInfo.MSNPrivacy = Convert.ToInt32(rd["MSNPrivacy"]);
                if (rd["GTalkPrivacy"] != DBNull.Value) UBasicInfo.GTalkPrivacy = Convert.ToInt32(rd["GTalkPrivacy"]);
                if (rd["QQPrivacy"] != DBNull.Value) UBasicInfo.QQPrivacy = Convert.ToInt32(rd["QQPrivacy"]);
                if (rd["SkypePrivacy"] != DBNull.Value) UBasicInfo.SkypePrivacy = Convert.ToInt32(rd["SkypePrivacy"]);
                if (rd["TelPrivacy"] != DBNull.Value) UBasicInfo.TelPrivacy = Convert.ToInt32(rd["TelPrivacy"]);
                if (rd["AddrPrivacy"] != DBNull.Value) UBasicInfo.AddrPrivacy = Convert.ToInt32(rd["AddrPrivacy"]);
                if (rd["WebSitePrivacy"] != DBNull.Value) UBasicInfo.WebSitePrivacy = Convert.ToInt32(rd["WebSitePrivacy"]);
                if (rd["HomeProv"] != DBNull.Value) UBasicInfo.HomeProv = Convert.ToInt32(rd["HomeProv"]);
                if (rd["HomeCity"] != DBNull.Value) UBasicInfo.HomeCity = Convert.ToInt32(rd["HomeCity"]);
            }
            rd.Close();
            return UBasicInfo;
        }
        #region
        //༭Ϣ
        /// <summary>
        /// Ϣ
        /// </summary>
        /// <param name="ubi">ûϢ</param>
        /// <param name="Province">ʡ</param>
        /// <param name="City"></param>
        /// <returns></returns>
        public int SaveBasic(NetSNS.Model.UserBasicInfo ubi, int Province, int City)
        {
            SqlConnection sqlConn = new SqlConnection(DBConfig.CnString);
            sqlConn.Open();
            SqlTransaction trans = sqlConn.BeginTransaction();
            try
            {
                SqlParameter[] param = GetUserBasic(ubi, Province, City);
                string sql = "update NT_UserInfo set Sex=@Sex,Birthday=@Birthday,BirthidayDisplay=@BirthidayDisplay,Constellation=@Constellation,Province=@Province,City=@City where UserID=@UserID";
                DbHelper.ExecuteNonQuery(CommandType.Text, sql, param);
                int num = UserLog(trans, EnumUserAction.ChangeBasic, ubi.UserID, "޸˻Ϣ", null);
                trans.Commit();
                return num;
            }
            catch (SqlException sqlEx)
            {
                trans.Rollback();
                throw sqlEx;
            }
            finally
            {
                if (sqlConn.State == ConnectionState.Open)
                    sqlConn.Close();
            }
        }
        /// <summary>
        /// ȡûϢݿ
        /// </summary>
        /// <param name="ubi">ûϢ</param>
        /// <param name="Province">ʡ</param>
        /// <param name="City"></param>
        /// <returns></returns>
        private SqlParameter[] GetUserBasic(NetSNS.Model.UserBasicInfo ubi, int Province, int City)
        {
            SqlParameter[] param = new SqlParameter[7];
            param[0] = new SqlParameter("@UserID", SqlDbType.Int, 4);
            param[0].Value = ubi.UserID;
            param[1] = new SqlParameter("@Sex", SqlDbType.Bit, 1);
            param[1].Value = ubi.Sex;
            param[2] = new SqlParameter("@Birthday", SqlDbType.DateTime, 8);
            param[2].Value = ubi.Birthday;
            param[3] = new SqlParameter("@BirthidayDisplay", SqlDbType.Int, 4);
            param[3].Value = ubi.BirthidayDisplay;
            param[4] = new SqlParameter("@Constellation", SqlDbType.Int, 4);
            param[4].Value = ubi.Constellation;
            param[5] = new SqlParameter("@Province", SqlDbType.Int, 4);
            param[5].Value = Province;
            param[6] = new SqlParameter("@City", SqlDbType.Int, 4);
            param[6].Value = City;
            return param;
        }

        /// <summary>
        /// ȡ˰ݿ
        /// </summary>
        /// <param name="ubi">ûϢ</param>
        /// <returns></returns>
        private SqlParameter[] GetFavorite(NetSNS.Model.UserBasicInfo ubi)
        {
            SqlParameter[] param = new SqlParameter[11];
            param[0] = new SqlParameter("@UserID", SqlDbType.Int, 4);
            param[0].Value = ubi.UserID;
            param[1] = new SqlParameter("@Favourite", SqlDbType.NVarChar, 200);
            param[1].Value = ubi.Favourite;
            param[2] = new SqlParameter("@FavMusics", SqlDbType.NVarChar, 200);
            param[2].Value = ubi.FavMusics;
            param[3] = new SqlParameter("@FavMovies", SqlDbType.NVarChar, 200);
            param[3].Value = ubi.FavMovies;
            param[4] = new SqlParameter("@FavCartoons", SqlDbType.NVarChar, 200);
            param[4].Value = ubi.FavCartoons;
            param[5] = new SqlParameter("@FavGames", SqlDbType.NVarChar, 200);
            param[5].Value = ubi.FavGames;
            param[6] = new SqlParameter("@FavSports", SqlDbType.NVarChar, 200);
            param[6].Value = ubi.FavSports;
            param[7] = new SqlParameter("@FavBooks", SqlDbType.NVarChar, 200);
            param[7].Value = ubi.FavBooks;
            param[8] = new SqlParameter("@FavAdages", SqlDbType.NVarChar, 200);
            param[8].Value = ubi.FavAdages;
            param[9] = new SqlParameter("@AppreciateMen", SqlDbType.NVarChar, 200);
            param[9].Value = ubi.AppreciateMen;
            param[10] = new SqlParameter("@Presentation", SqlDbType.NVarChar, 200);
            param[10].Value = ubi.Presetation;
            return param;
        }

        /// <summary>
        /// ȡϵϢݿ
        /// </summary>
        /// <param name="ubi">ûϢ</param>
        /// <returns></returns>
        private SqlParameter[] GetContact(NetSNS.Model.UserBasicInfo ubi)
        {
            SqlParameter[] param = new SqlParameter[7];
            param[0] = new SqlParameter("@UserID", SqlDbType.Int, 4);
            param[0].Value = ubi.UserID;
            param[0] = new SqlParameter("@QQ", SqlDbType.NVarChar, 20);
            param[0].Value = ubi.QQ;
            param[0] = new SqlParameter("@Skype", SqlDbType.NVarChar, 50);
            param[0].Value = ubi.Skype;
            param[0] = new SqlParameter("@Mobile", SqlDbType.Char, 15);
            param[0].Value = ubi.Mobile;
            param[0] = new SqlParameter("@Tel", SqlDbType.Char, 20);
            param[0].Value = ubi.Tel;
            param[0] = new SqlParameter("@Addr", SqlDbType.NVarChar, 100);
            param[0].Value = ubi.Addr;
            param[0] = new SqlParameter("@WebSite", SqlDbType.NVarChar, 50);
            param[0].Value = ubi.WebSite;
            return param;
        }
        /// <summary>
        /// Ϣ
        /// </summary>
        /// <param name="listEdu">Ϣ</param>
        /// <returns></returns>
        public int SaveEducation(List<NetSNS.Model.UserEducationInfo> listEdu)
        {
            SqlParameter[] param = null;
            int num = 0;
            for (int i = 0; i < listEdu.Count; i++)
            {
                //жǷѾID
                param = GetEducation(listEdu[i]);
                string sqlIsExist = "select ID from NT_UserEducation where ID=" + listEdu[i].ID.ToString();
                string result = Convert.ToString(DbHelper.ExecuteScalar(CommandType.Text, sqlIsExist, null));
                if (result == listEdu[i].ID.ToString())
                {
                    string sqlUpdate = "update NT_UserEducation set DegreeID=@DegreeID,SchoolID=@SchoolID,AcademyID=@AcademyID,MatriculationYear=@MatriculationYear,PostTime='" + DateTime.Now.ToString() + "',PostIP='" + NetSNS.Common.Public.GetClientIP() + "' where ID=@ID and  UserID=@UserID";
                    num = DbHelper.ExecuteNonQuery(CommandType.Text, sqlUpdate, param);
                }
                else
                {
                    string sqlInsert = "insert into NT_UserEducation (UserID,DegreeID,SchoolID,AcademyID,MatriculationYear,PostTime,PostIP,IsLock) values (@UserID,@DegreeID,@SchoolID,@AcademyID,@MatriculationYear,'" + DateTime.Now.ToString() + "','" + NetSNS.Common.Public.GetClientIP() + "',0)";
                    DbHelper.ExecuteNonQuery(CommandType.Text, sqlInsert, param);
                }
            }
            return num;
        }
        /// <summary>
        /// ɾѧУ
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public int DelEducation(int ID)
        {
            SqlParameter param = new SqlParameter("@ID", ID);
            string sql = "DELETE FROM NT_UserEducation WHERE ID =@ID";
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, param);
        }
        /// <summary>
        /// ȡϢݿ
        /// </summary>
        /// <param name="uEdu">Ϣ</param>
        /// <returns></returns>
        private SqlParameter[] GetEducation(NetSNS.Model.UserEducationInfo uEdu)
        {
            SqlParameter[] param = new SqlParameter[6];
            param[0] = new SqlParameter("@ID", SqlDbType.Int, 4);
            param[0].Value = uEdu.ID;
            param[1] = new SqlParameter("@UserID", SqlDbType.Int, 4);
            param[1].Value = uEdu.UserID;
            param[2] = new SqlParameter("@DegreeID", SqlDbType.Int, 4);
            param[2].Value = uEdu.DegreeID;
            param[3] = new SqlParameter("@SchoolID", SqlDbType.Int, 4);
            param[3].Value = uEdu.SchoolID;
            param[4] = new SqlParameter("@AcademyID", SqlDbType.Int, 4);
            param[4].Value = uEdu.AcademyID;
            param[5] = new SqlParameter("@MatriculationYear", SqlDbType.Int, 4);
            param[5].Value = uEdu.MatriculationYear;
            return param;
        }
        /// <summary>
        /// 湤Ϣ
        /// </summary>
        /// <param name="listCareer">Ϣ</param>
        /// <returns></returns>
        public int SaveCareer(List<NetSNS.Model.UserCareerInfo> listCareer)
        {
            SqlParameter[] param = null;
            int num = 0;
            for (int i = 0; i < listCareer.Count; i++)
            {
                //жǷѾID
                param = GetCareer(listCareer[i]);
                string sqlIsExist = "select ID from NT_UserCareer where ID=" + listCareer[i].ID.ToString();
                string result = Convert.ToString(DbHelper.ExecuteScalar(CommandType.Text, sqlIsExist, null));
                if (result == listCareer[i].ID.ToString())
                {
                    string sqlUpdate = "update NT_UserCareer set Company=@Company,Description=@Description,IsStill=@IsStill,JoinYear=@JoinYear,JoinMonth=@JoinMonth,PostTime='" + DateTime.Now + "',PostIP='" + NetSNS.Common.Public.GetClientIP() + "' where ID=@ID and  UserID=@UserID";
                    num = DbHelper.ExecuteNonQuery(CommandType.Text, sqlUpdate, param);
                }
                else
                {
                    string sqlInsert = "insert into NT_UserCareer (UserID,Company,Description,IsStill,JoinYear,JoinMonth,PostTime,PostIP) values (@UserID,@Company,@Description,@IsStill,@JoinYear,@JoinMonth,'" + DateTime.Now + "','" + NetSNS.Common.Public.GetClientIP() + "')";
                    DbHelper.ExecuteNonQuery(CommandType.Text, sqlInsert, param);
                }
            }
            return num;
        }
        /// <summary>
        /// ɾϢ
        /// </summary>
        /// <param name="ID">ϢID</param>
        /// <returns></returns>
        public int DelCareer(int ID)
        {
            SqlParameter param = new SqlParameter("@ID", ID);
            string sql = "DELETE FROM NT_UserCareer WHERE ID =@ID";
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, param);
        }
        /// <summary>
        /// ȡϢݿ
        /// </summary>
        /// <param name="uEdu">Ϣ</param>
        /// <returns></returns>
        private SqlParameter[] GetCareer(NetSNS.Model.UserCareerInfo uCar)
        {
            SqlParameter[] param = new SqlParameter[7];
            param[0] = new SqlParameter("@ID", SqlDbType.Int, 4);
            param[0].Value = uCar.ID;
            param[1] = new SqlParameter("@UserID", SqlDbType.Int, 4);
            param[1].Value = uCar.UserID;
            param[2] = new SqlParameter("@Company", SqlDbType.NVarChar, 100);
            param[2].Value = uCar.Company;
            param[3] = new SqlParameter("@Description", SqlDbType.NVarChar, 1000);
            param[3].Value = uCar.Description;
            param[4] = new SqlParameter("@IsStill", SqlDbType.Bit, 1);
            param[4].Value = uCar.IsStill;
            param[5] = new SqlParameter("@JoinYear", SqlDbType.Int, 4);
            param[5].Value = uCar.JoinYear;
            param[6] = new SqlParameter("@JoinMonth", SqlDbType.Int, 4);
            param[6].Value = uCar.JoinMonth;
            return param;
        }
        /// <summary>
        /// ȡ˽˶̬ʵ
        /// </summary>
        /// <param name="UserID">ûID</param>
        /// <returns></returns>
        public UserSettingInfo GetUSetInfo(int UserID)
        {
            SqlParameter param = new SqlParameter("@UserID", UserID);
            UserSettingInfo USetInfo = new UserSettingInfo();
            USetInfo.UserID = UserID;
            string sql = "select * from NT_UserSetting where UserID=@UserID";
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, sql, param);
            if (rd.Read())
            {
                USetInfo.PrivSpace = Convert.ToInt32(rd["PrivSpace"]);
                USetInfo.PrivFavourite = Convert.ToInt32(rd["PrivFavourite"]);
                USetInfo.PrivEducate = Convert.ToInt32(rd["PrivEducate"]);
                USetInfo.PrivLasso = Convert.ToInt32(rd["PrivLasso"]);
                USetInfo.PrivFriends = Convert.ToInt32(rd["PrivFriends"]);
                USetInfo.PrivLeaveWord = Convert.ToInt32(rd["PrivLeaveWord"]);
                USetInfo.PrivMiniBlog = Convert.ToInt32(rd["PrivMiniBlog"]);
                USetInfo.PrivShare = Convert.ToInt32(rd["PrivShare"]);
                USetInfo.PrivGroup = Convert.ToInt32(rd["PrivGroup"]);
                USetInfo.PrivMovies = Convert.ToInt32(rd["PrivMovies"]);
                USetInfo.ActUpdateData = Convert.ToBoolean(rd["ActUpdateData"]);
                USetInfo.ActAddFriend = Convert.ToBoolean(rd["ActAddFriend"]);
                USetInfo.ActLeaveWord = Convert.ToBoolean(rd["ActLeaveWord"]);
                USetInfo.ActPicComment = Convert.ToBoolean(rd["ActPicComment"]);
                USetInfo.ActSecede = Convert.ToBoolean(rd["ActSecede"]);
                USetInfo.ActDeliver = Convert.ToBoolean(rd["ActDeliver"]);
                USetInfo.ActLogComment = Convert.ToBoolean(rd["ActLogComment"]);
                USetInfo.ActMovieComment = Convert.ToBoolean(rd["ActMovieComment"]);
                USetInfo.ActPhotoLasso = Convert.ToBoolean(rd["ActPhotoLasso"]);
                USetInfo.ActShareComment = Convert.ToBoolean(rd["ActShareComment"]);
                USetInfo.LastPostTime = Convert.ToDateTime(rd["LastPostTime"]);
                USetInfo.LastPostIP = Convert.ToString(rd["LastPostIP"]);
            }
            rd.Close();
            return USetInfo;
        }
        #endregion
        #region ȡûһЩصϢ
        /// <summary>
        /// ȡûĽϢ
        /// </summary>
        /// <param name="userid">鿴ID</param>
        /// <param name="friendid">鿴ID</param>
        /// <returns></returns>
        public DataTable GetEducation(int userid, int friendid)
        {
            SqlConnection cn = new SqlConnection(DBConfig.CnString);
            cn.Open();
            try
            {
                SqlParameter[] param = new SqlParameter[2];
                param[0] = new SqlParameter("@userid", SqlDbType.Int, 4);
                param[0].Value = userid;
                param[1] = new SqlParameter("@friendid", SqlDbType.Int, 4);
                param[1].Value = friendid;

                EnumPrivacy pri = GetWorkAndEduPrivacy(cn, friendid);
                if (!CheckPrivacy(cn, pri, userid, friendid))
                    return null;
                string Sql = "select a.DegreeID,a.MatriculationYear,b.SchoolName,c.Name from NT_UserEducation a inner join NT_Dict_School b on a.SchoolID=b.SchoolID inner join NT_Dict_Academy c on a.AcademyID=c.ID where a.UserID=@friendid order by a.DegreeID Desc,a.MatriculationYear desc";
                return DbHelper.ExecuteTable(cn, CommandType.Text, Sql, param);
            }
            finally
            {
                if (cn.State == ConnectionState.Open)
                    cn.Close();
            }
        }
        /// <summary>
        /// ȡùصϢ
        /// </summary>
        /// <param name="userid">鿴ID</param>
        /// <param name="friendid">鿴ID</param>
        /// <returns></returns>
        public DataTable GetCareer(int userid, int friendid)
        {
            SqlConnection cn = new SqlConnection(DBConfig.CnString);
            cn.Open();
            try
            {
                EnumPrivacy pri = GetWorkAndEduPrivacy(cn, friendid);
                if (!CheckPrivacy(cn, pri, userid, friendid))
                    return null;
                string Sql = "select * from NT_UserCareer where UserID=" + friendid;
                return DbHelper.ExecuteTable(cn, CommandType.Text, Sql, null);
            }
            finally
            {
                if (cn.State == ConnectionState.Open)
                    cn.Close();
            }
        }
        /// <summary>
        /// ȡý͹˽
        /// </summary>
        /// <param name="cn"></param>
        /// <param name="userid"></param>
        /// <returns></returns>
        private EnumPrivacy GetWorkAndEduPrivacy(SqlConnection cn, int userid)
        {
            SqlParameter param = new SqlParameter("@userid", userid);
            string Sql = "select PrivEducate from NT_UserSetting where UserID=@userid";
            return (EnumPrivacy)Convert.ToInt32(DbHelper.ExecuteScalar(cn, CommandType.Text, Sql, param));
        }
        #endregion
        #region ȡûϢ
        /// <summary>
        /// ȡû߽Ϣ
        /// </summary>
        /// <param name="UserID">Ա</param>
        /// <returns></returns>
        public UserEducationInfo LastEducInfo(int UserID)
        {
            SqlParameter param = new SqlParameter("@UserID", UserID);
            UserEducationInfo info = new UserEducationInfo();
            string Sql = "Select ID,UserID,DegreeID,SchoolID,AcademyID,MatriculationYear,PostTime,PostIP,IsLock From NT_UserEducation " +
                         "Where UserID=@UserID Order By DegreeID Desc";
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, Sql, param);
            if (rd.Read())
            {
                info.ID = Convert.ToInt32(rd["ID"].ToString());
                info.UserID = Convert.ToInt32(rd["UserID"].ToString());
                info.DegreeID = Convert.ToInt32(rd["DegreeID"].ToString());
                info.SchoolID = Convert.ToInt32(rd["SchoolID"].ToString());
                info.AcademyID = Convert.ToInt32(rd["AcademyID"].ToString());
                info.MatriculationYear = Convert.ToInt32(rd["MatriculationYear"].ToString());
                info.PostTime = Convert.ToDateTime(rd["PostTime"].ToString());
                if (rd["PostIP"] != DBNull.Value) info.PostIP = rd["PostIP"].ToString();
                info.IsLock = Convert.ToBoolean(rd["IsLock"].ToString());
            }
            rd.Close();
            return info;
        }

        /// <summary>
        /// ȡѧУϢ
        /// </summary>
        /// <param name="SchoolID">ѧУ</param>
        /// <returns></returns>
        public DictSchoolInfo GetSchoolInfo(int SchoolID)
        {
            SqlParameter param = new SqlParameter("@SchoolID", SchoolID);
            DictSchoolInfo info = new DictSchoolInfo();
            string Sql = "Select SchoolID,DegreeID,AreaID,SchoolName,IsLock From NT_Dict_School Where SchoolID=@SchoolID";
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, Sql, param);
            if (rd.Read())
            {
                info.SchoolID = Convert.ToInt32(rd["SchoolID"].ToString());
                info.DegreeID = Convert.ToInt32(rd["DegreeID"].ToString());
                info.AreaID = Convert.ToInt32(rd["AreaID"].ToString());
                if (rd["SchoolName"] != DBNull.Value) info.SchoolName = rd["SchoolName"].ToString();
                info.IsLock = Convert.ToBoolean(rd["IsLock"].ToString());
            }
            rd.Close();
            return info;
        }

        /// <summary>
        /// ȡԺϵϢ
        /// </summary>
        /// <param name="AcademyID">Ժϵ</param>
        /// <returns></returns>
        public DictAcademyInfo GetAcademyInfo(int AcademyID)
        {
            SqlParameter param = new SqlParameter("@AcademyID", AcademyID);
            DictAcademyInfo info = new DictAcademyInfo();
            string Sql = "Select ID,Name,SchoolID,IsLock From NT_Dict_Academy Where ID=@AcademyID";
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, Sql, param);
            if (rd.Read())
            {
                info.ID = Convert.ToInt32(rd["ID"].ToString());
                if (rd["Name"] != DBNull.Value) info.Name = rd["Name"].ToString();
                info.SchoolID = Convert.ToInt32(rd["SchoolID"].ToString());
                info.IsLock = Convert.ToBoolean(Convert.ToInt32(rd["IsLock"]));
            }
            rd.Close();
            return info;
        }
        #endregion
        /// <summary>
        /// ȡĳһû
        /// </summary>
        /// <param name="topNum"></param>
        /// <param name="networkId"></param>
        /// <returns></returns>
        DataTable IUser.GetUserByNetwork(int topNum, int networkId, int userId)
        {
            using (SqlConnection cn = new SqlConnection(DBConfig.CnString))
            {
                string Sql = "select top " + topNum + " a.UserID,a.UserName,a.Province,b.Name,c.FilePath,MiniContent='',MiniTime=GETDATE(),";
                Sql += "WorkCompany='',WorkJoinYear=0,WorkJoinMonth=0,WorkLeaveYear=0,WorkLeaveMonth=0,SchlDegreeID=0,SchlMatriculationYear=0,SchoolName='',SchlAcdName=''";
                Sql += " from NT_User a inner join NT_Dict_Area b on a.Province=b.ID left join NT_Photo c on a.Portrait=c.PhotoID and c.IsLock=0 Where a.UserID<>" + userId + " and a.Province=" + networkId + " and a.State<>" + (int)EnumUserState.Register + " order by newid()";
                DataTable dt = DbHelper.ExecuteTable(cn, CommandType.Text, Sql, null);
                for (int i = 0; i < dt.Rows.Count; i++)
                {
                    DataRow r = dt.Rows[i];
                    int fid = (int)r[0];
                    Sql = "select PrivMiniBlog from NT_UserSetting where UserID=" + fid;
                    EnumPrivacy prv = (EnumPrivacy)Convert.ToInt32(DbHelper.ExecuteScalar(cn, CommandType.Text, Sql, null));
                    if (CheckPrivacy(cn, prv, userId, fid))
                    {
                        Sql = "select Content,PostTime from NT_MiniBlog where UserID=" + fid + " and IsLock=0 order by PostTime Desc";
                        IDataReader rd = DbHelper.ExecuteReader(cn, CommandType.Text, Sql, null);
                        if (rd.Read())
                        {
                            r["MiniContent"] = rd.GetString(0);
                            r["MiniTime"] = rd.GetDateTime(1);
                        }
                        rd.Close();
                    }
                    EnumPrivacy pri = GetWorkAndEduPrivacy(cn, fid);
                    if (CheckPrivacy(cn, pri, userId, fid))
                    {
                        Sql = "select Company,JoinYear,JoinMonth,LeaveYear,LeaveMonth from NT_UserCareer where UserID=" + fid;
                        IDataReader rd = DbHelper.ExecuteReader(cn, CommandType.Text, Sql, null);
                        if (rd.Read())
                        {
                            r["WorkCompany"] = rd[0];
                            r["WorkJoinYear"] = rd[1];
                            r["WorkJoinMonth"] = rd[2];
                            r["WorkLeaveYear"] = rd[3];
                            r["WorkLeaveMonth"] = rd[4];
                        }
                        rd.Close();
                    }
                    EnumPrivacy prie = GetWorkAndEduPrivacy(cn, fid);
                    if (CheckPrivacy(cn, prie, userId, fid))
                    {
                        Sql = "select a.DegreeID,a.MatriculationYear,b.SchoolName,c.Name from NT_UserEducation a inner join NT_Dict_School b on a.SchoolID=b.SchoolID inner join NT_Dict_Academy c on a.AcademyID=c.ID where a.UserID=" + fid + " order by a.DegreeID Desc,a.MatriculationYear desc";
                        IDataReader rd = DbHelper.ExecuteReader(cn, CommandType.Text, Sql, null);
                        if (rd.Read())
                        {
                            r["SchlDegreeID"] = rd[0];
                            r["SchlMatriculationYear"] = rd[1];
                            r["SchoolName"] = rd[2];
                            r["SchlAcdName"] = rd[3];
                        }
                        rd.Close();
                    }
                }
                return dt;
            }
        }
        /// <summary>
        /// ȡ
        /// </summary>
        /// <param name="Email">Email</param>
        /// <returns>0,ɹ,-2,Ч,-3ʼʧ</returns>
        int IUser.Retrieve(string email)
        {
            string userName = string.Empty;
            SqlConnection cn = new SqlConnection(DBConfig.CnString);
            cn.Open();
            try
            {
                string Sql = "select UserName from NT_User where Email=@Email";
                object obj = DbHelper.ExecuteScalar(cn, CommandType.Text, Sql, new SqlParameter("@Email", email));
                if (obj == null || obj == DBNull.Value)
                {
                    return -2;
                }

                userName = (string)obj;
                string code = Rand.Str(32);
                while ((int)DbHelper.ExecuteScalar(cn, CommandType.Text, "select count(ID) from NT_RetrievePwd where ValidCode='" + code + "'", null) > 0)
                {
                    code = Rand.Str(32, true);
                }
                Sql = "insert into NT_RetrievePwd (Email,PostTime,PostIP,State,ValidCode) values (@Email,'" + DateTime.Now + "','" + NetSNS.Common.Public.GetClientIP() + "',0,@ValidCode)";
                SqlParameter[] Param = new SqlParameter[2];
                Param[0] = new SqlParameter("@Email", SqlDbType.NVarChar, 100);
                Param[0].Value = email;
                Param[1] = new SqlParameter("@ValidCode", SqlDbType.Char, 32);
                Param[1].Value = code;
                try
                {
                    #region ʼ
                    NetSNS.Common.EMail eml = NetSNS.Common.EMail.CreateInstance();
                    eml.To = email;
                    eml.Subject = "װ" + userName + "" + UiConfig.SiteName + "";
                    string body = EmailConfig.retrieve;
                    body = body.Replace("{SiteName}", UiConfig.SiteName);
                    body = body.Replace("{UserName}", userName);
                    body = body.Replace("{Domain}", UiConfig.Domain);
                    body = body.Replace("{Date}", DateTime.Now.ToString("yyyyMMdd"));
                    body = body.Replace("{Url}", UiConfig.RootUrl + "/user/resetpwd.aspx?r=" + code);
                    eml.Body = body;
                    eml.Send();
                    #endregion
                    DbHelper.ExecuteNonQuery(cn, CommandType.Text, Sql, Param);
                    return 0;
                }
                catch
                {
                    return -3;
                }
            }
            finally
            {
                if (cn.State == ConnectionState.Open)
                    cn.Close();
            }
        }
        /// <summary>
        /// ,Ϊ¼¼״̬
        /// </summary>
        /// <param name="newPwd"></param>
        /// <param name="code"></param>
        /// <returns>0ɹ-1ûҵص¼,-2Ч,-3Ч</returns>
        int IUser.ResetPwd(string newPwd, string code, out int userId, out string userName, out string userPortrait)
        {
            userId = 0;
            userName = string.Empty;
            userPortrait = string.Empty;
            SqlConnection cn = new SqlConnection(DBConfig.CnString);
            cn.Open();
            try
            {
                bool f = false;
                int state = -1;
                int id = 0;
                string email = string.Empty;
                string Sql = "select ID,Email,State from NT_RetrievePwd where CAST(ValidCode AS binary(32))=CAST('" + code.Replace("'", "") + "' AS binary(32))";
                IDataReader rd = DbHelper.ExecuteReader(cn, CommandType.Text, Sql, null);
                if (rd.Read())
                {
                    id = rd.GetInt32(0);
                    email = rd.GetString(1);
                    state = rd.GetInt32(2);
                    f = true;
                }
                rd.Close();
                if (!f)
                {
                    return -1;
                }
                if (state != 0)
                    return -2;
                f = false;
                SqlParameter Param = new SqlParameter("@Email", email);
                Sql = "select a.UserID,a.UserName,b.FilePath from NT_User a left join NT_Photo b on a.Portrait=b.PhotoID where a.Email=@Email";
                rd = DbHelper.ExecuteReader(cn, CommandType.Text, Sql, Param);
                if (rd.Read())
                {
                    userId = rd.GetInt32(0);
                    userName = rd.GetString(1);
                    if (!rd.IsDBNull(2)) userPortrait = rd.GetString(2);
                    f = true;
                }
                rd.Close();
                if (!f)
                    return -3;
                SqlTransaction trans = cn.BeginTransaction();
                try
                {
                    string pwd = NetSNS.Common.Input.MD5(newPwd, false);
                    Sql = "update NT_User set Password='" + pwd + "',LastLoginTime='" + DateTime.Now + "',LastLoginIP='" + Public.GetClientIP() + "',LoginTimes=LoginTimes+1 where Email=@Email";
                    DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, Param);
                    Sql = "update NT_RetrievePwd set State=1,ConfirmTime='" + DateTime.Now + "',ConfirmIP='" + NetSNS.Common.Public.GetClientIP() + "' where ID=" + id;
                    DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                    trans.Commit();
                    return 0;
                }
                catch
                {
                    trans.Rollback();
                    return -3;
                }
            }
            finally
            {
                if (cn.State == ConnectionState.Open)
                    cn.Close();
            }
        }

        /// <summary>
        /// ȡ˽Ϣ
        /// </summary>
        /// <param name="UserID">ûIDϢ</param>
        /// <returns></returns>
        public PrivacyInfo GetPrivacy(int UserID)
        {
            string sql = "select UserID,PrivSpace,PrivFavourite,PrivEducate,PrivLasso,PrivFriends,PrivLeaveWord,PrivMiniBlog,PrivShare,PrivGroup,PrivMovies,ActUpdateData,ActAddFriend,ActLeaveWord,ActPicComment,ActSecede,ActDeliver,ActLogComment,ActMovieComment,ActPhotoLasso,ActShareComment,LastPostTime,LastPostIP from NT_UserSetting where UserID=" + UserID;
            PrivacyInfo pri = new PrivacyInfo();
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, sql, null);
            if (rd.Read())
            {
                pri.UserID = Convert.ToInt32(rd["UserID"]);
                if (rd["PrivSpace"] != DBNull.Value) pri.PrivacySpace = (EnumPrivacy)Convert.ToInt32(rd["PrivSpace"]);
                if (rd["PrivFavourite"] != DBNull.Value) pri.PrivacyFavourite = (EnumPrivacy)Convert.ToInt32(rd["PrivFavourite"]);
                if (rd["PrivEducate"] != DBNull.Value) pri.PrivacyEducate = (EnumPrivacy)Convert.ToInt32(rd["PrivEducate"]);
                if (rd["PrivLasso"] != DBNull.Value) pri.PrivacyLasso = (EnumPrivacy)Convert.ToInt32(rd["PrivLasso"]);
                if (rd["PrivFriends"] != DBNull.Value) pri.PrivacyFriends = (EnumPrivacy)Convert.ToInt32(rd["PrivFriends"]);
                if (rd["PrivLeaveWord"] != DBNull.Value) pri.PrivacyLeaveWord = (EnumPrivacy)Convert.ToInt32(rd["PrivLeaveWord"]);
                if (rd["PrivMiniBlog"] != DBNull.Value) pri.PrivacyMiniBlog = (EnumPrivacy)Convert.ToInt32(rd["PrivMiniBlog"]);
                if (rd["PrivShare"] != DBNull.Value) pri.PrivacyShare = (EnumPrivacy)Convert.ToInt32(rd["PrivShare"]);
                if (rd["PrivGroup"] != DBNull.Value) pri.PrivacyGroup = (EnumPrivacy)Convert.ToInt32(rd["PrivGroup"]);
                if (rd["PrivMovies"] != DBNull.Value) pri.PrivacyMovies = (EnumPrivacy)Convert.ToInt32(rd["PrivMovies"]);
                if (rd["ActUpdateData"] != DBNull.Value) pri.ActUpdateData = Convert.ToBoolean(rd["ActUpdateData"]);
                if (rd["ActAddFriend"] != DBNull.Value) pri.ActAddFriend = Convert.ToBoolean(rd["ActAddFriend"]);
                if (rd["ActLeaveWord"] != DBNull.Value) pri.ActLeaveWord = Convert.ToBoolean(rd["ActLeaveWord"]);
                if (rd["ActPicComment"] != DBNull.Value) pri.ActPicComment = Convert.ToBoolean(rd["ActPicComment"]);
                if (rd["ActSecede"] != DBNull.Value) pri.ActSecede = Convert.ToBoolean(rd["ActSecede"]);
                if (rd["ActDeliver"] != DBNull.Value) pri.ActDeliver = Convert.ToBoolean(rd["ActDeliver"]);
                if (rd["ActLogComment"] != DBNull.Value) pri.ActLogComment = Convert.ToBoolean(rd["ActLogComment"]);
                if (rd["ActMovieComment"] != DBNull.Value) pri.ActMovieComment = Convert.ToBoolean(rd["ActMovieComment"]);
                if (rd["ActPhotoLasso"] != DBNull.Value) pri.ActPhotoLasso = Convert.ToBoolean(rd["ActPhotoLasso"]);
                if (rd["ActShareComment"] != DBNull.Value) pri.ActShareComment = Convert.ToBoolean(rd["ActShareComment"]);
                if (rd["LastPostTime"] != DBNull.Value) pri.LastPostTime = Convert.ToDateTime(rd["LastPostTime"]);
                if (rd["LastPostIP"] != DBNull.Value) pri.LastPostIP = Convert.ToString(rd["LastPostIP"]);
            }
            else
            {
                pri.UserID = UserID;
            }
            rd.Close();
            return pri;
        }

        /// <summary>
        /// ˽Ϣ
        /// 0ʾʧ
        /// </summary>
        /// <param name="UserID">ûID</param>
        /// <param name="privacyinfo">˽Ϣ</param>
        /// <returns></returns>
        public int SetPrivacy(int UserID, PrivacyInfo privacyinfo)
        {
            if (UserID != privacyinfo.UserID)
            {
                return 0;
            }
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();

            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                SqlParameter[] param = GetPrivacyParm(privacyinfo);
                string sql = "select Count(*) from NT_UserSetting where UserID=" + UserID;
                if (Convert.ToInt32(DbHelper.ExecuteScalar(trans, CommandType.Text, sql, null)) > 0)
                {
                    sql = "update NT_UserSetting set PrivSpace=@PrivSpace,PrivFavourite=@PrivFavourite,PrivEducate=@PrivEducate,PrivLasso=@PrivLasso,PrivFriends=@PrivFriends,PrivLeaveWord=@PrivLeaveWord,PrivMiniBlog=@PrivMiniBlog,"
                    + "PrivShare=@PrivShare,PrivGroup=@PrivGroup,PrivMovies=@PrivMovies,ActUpdateData=@ActUpdateData,ActAddFriend=@ActAddFriend,ActLeaveWord=@ActLeaveWord,ActPicComment=@ActPicComment,ActSecede=@ActSecede,ActDeliver=@ActDeliver,ActLogComment=@ActLogComment,"
                    + "ActMovieComment=@ActMovieComment,ActPhotoLasso=@ActPhotoLasso,ActShareComment=@ActShareComment,LastPostTime=@LastPostTime,LastPostIP=@LastPostIP where UserID=@UserID";
                }
                else
                {
                    sql = "insert into NT_UserSetting (PrivSpace,PrivFavourite,PrivEducate,PrivLasso,PrivFriends,PrivLeaveWord,PrivMiniBlog,PrivShare,PrivGroup,PrivMovies,ActUpdateData,ActAddFriend,ActLeaveWord,ActPicComment,ActSecede,ActDeliver,ActLogComment,ActMovieComment,ActPhotoLasso,ActShareComment,LastPostTime,LastPostIP,UserID) values(@PrivSpace,@PrivFavourite,@PrivEducate,@PrivLasso,@PrivFriends,@PrivLeaveWord,@PrivMiniBlog,@PrivShare,@PrivGroup,@PrivMovies,@ActUpdateData,@ActAddFriend,@ActLeaveWord,@ActPicComment,@ActSecede,@ActDeliver,@ActLogComment,@ActMovieComment,@ActPhotoLasso,@ActShareComment,@LastPostTime,@LastPostIP,@UserID)";
                }

                int rint = DbHelper.ExecuteNonQuery(trans, CommandType.Text, sql, param);
                trans.Commit();
                return rint;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }
        /// <summary>
        /// ˽Ϣ
        /// </summary>
        /// <param name="pri">˽Ϣ</param>
        /// <returns>sql</returns>
        private SqlParameter[] GetPrivacyParm(PrivacyInfo pri)
        {
            SqlParameter[] param = new SqlParameter[23];
            param[0] = new SqlParameter("@UserID", SqlDbType.Int, 4);
            param[0].Value = pri.UserID;
            param[1] = new SqlParameter("@PrivSpace", SqlDbType.Int, 4);
            param[1].Value = pri.PrivacySpace;
            param[2] = new SqlParameter("@PrivFavourite", SqlDbType.Int, 4);
            param[2].Value = pri.PrivacyFavourite;
            param[3] = new SqlParameter("@PrivEducate", SqlDbType.Int, 4);
            param[3].Value = pri.PrivacyEducate;
            param[4] = new SqlParameter("@PrivLasso", SqlDbType.Int, 4);
            param[4].Value = pri.PrivacyLasso;
            param[5] = new SqlParameter("@PrivFriends", SqlDbType.Int, 4);
            param[5].Value = pri.PrivacyFriends;
            param[6] = new SqlParameter("@PrivLeaveWord", SqlDbType.Int, 4);
            param[6].Value = pri.PrivacyLeaveWord;
            param[7] = new SqlParameter("@PrivMiniBlog", SqlDbType.Int, 4);
            param[7].Value = pri.PrivacyMiniBlog;
            param[8] = new SqlParameter("@PrivShare", SqlDbType.Int, 4);
            param[8].Value = pri.PrivacyShare;
            param[9] = new SqlParameter("@PrivGroup", SqlDbType.Int, 4);
            param[9].Value = pri.PrivacyGroup;
            param[10] = new SqlParameter("@PrivMovies", SqlDbType.Int, 4);
            param[10].Value = pri.PrivacyMovies;
            param[11] = new SqlParameter("@ActUpdateData", SqlDbType.Bit, 1);
            param[11].Value = pri.ActUpdateData;
            param[12] = new SqlParameter("@ActAddFriend", SqlDbType.Bit, 1);
            param[12].Value = pri.ActAddFriend;
            param[13] = new SqlParameter("@ActLeaveWord", SqlDbType.Bit, 1);
            param[13].Value = pri.ActLeaveWord;
            param[14] = new SqlParameter("@ActPicComment", SqlDbType.Bit, 1);
            param[14].Value = pri.ActPicComment;
            param[15] = new SqlParameter("@ActSecede", SqlDbType.Bit, 1);
            param[15].Value = pri.ActSecede;
            param[16] = new SqlParameter("@ActDeliver", SqlDbType.Bit, 1);
            param[16].Value = pri.ActDeliver;
            param[17] = new SqlParameter("@ActLogComment", SqlDbType.Bit, 1);
            param[17].Value = pri.ActLogComment;
            param[18] = new SqlParameter("@ActMovieComment", SqlDbType.Bit, 1);
            param[18].Value = pri.ActMovieComment;
            param[19] = new SqlParameter("@ActPhotoLasso", SqlDbType.Bit, 1);
            param[19].Value = pri.ActPhotoLasso;
            param[20] = new SqlParameter("@ActShareComment", SqlDbType.Bit, 1);
            param[20].Value = pri.ActShareComment;
            param[21] = new SqlParameter("@LastPostTime", SqlDbType.DateTime, 8);
            param[21].Value = pri.LastPostTime;
            param[22] = new SqlParameter("@LastPostIP", SqlDbType.NChar, 15);
            param[22].Value = pri.LastPostIP;
            return param;
        }

        /// <summary>
        /// û
        /// </summary>
        /// <param name="us">ʵ</param>
        /// <param name="UserID">Ա</param>
        /// <returns></returns>
        public int UpdateUser(NetSNS.Model.UserInfo us, int UserID)
        {
            SqlParameter[] param = GetParam(us);
            string sql = "update NT_User set Email=@Email,Password=@Password,UserName=@UserName,Province=@Province,City=@City,State=@State,Portrait=@Portrait where UserID=" + UserID;
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, param);
        }

        /// <summary>
        /// ɾԱ
        /// </summary>
        /// <param name="UserID"></param>
        /// <returns></returns>
        public int DelUser(int UserID, int flag)
        {
            string sql = "";
            SqlParameter param = new SqlParameter("@UserID", UserID);
            if (flag == 0)
            {
                sql = "delete from NT_User where UserID=@UserID";
            }
            else if (flag == 1)//Ƽ
            {
                sql = "update NT_User set Recommended=1 where UserID=@UserID";
            }
            else if (flag == 2)//ȡƼ
            {
                sql = "update NT_User set Recommended=0 where UserID=@UserID";
            }
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, param);
        }

        /// <summary>
        /// »ԱϢ
        /// </summary>
        /// <param name="info"></param>
        /// <returns></returns>
        public int UpdateUserBase(UserBasicInfo info)
        {
            SqlParameter[] param = GetBaseParm(info);

            string sql = "select UserID from NT_UserInfo where UserID=@UserID";
            object dresult = DbHelper.ExecuteScalar(CommandType.Text, sql, param);//ǷڸûԱ¼

            if (!Convert.IsDBNull(dresult) && dresult != null)
            {
                sql = "update NT_UserInfo set Sex=@Sex,Birthday=@Brithday,Constellation=@Constellation,MSN=@MSN,GTalk=@GTalk,QQ=@QQ,Skype=@Skype,Mobile=@Mobile,Tel=@Tel,Addr=@Addr,WebSite=@WebSite,BirthidayDisplay=@birthPrivacy,Vocation=@Vocation,HomeProv=@HomeProv,HomeCity=@HomeCity where UserID=@UserID";
            }
            else
            {
                sql = "insert into NT_UserInfo(UserID,Favourite,FavMusics,FavMovies,FavCartoons,FavGames,FavSports,FavBooks,FavAdages,AppreciateMen,Presentation,Sex,Birthday,Constellation,MSN,GTalk,QQ,Skype,Mobile,Tel,Addr,WebSite,BirthidayDisplay,Vocation,HomeProv,HomeCity,EmailPrivacy,MobilePrivacy,MSNPrivacy,GTalkPrivacy,QQPrivacy,TelPrivacy,SkypePrivacy,WebSitePrivacy,AddrPrivacy) values (@UserID,'','','','','','','','','','',@Sex,@Brithday,@Constellation,@MSN,@GTalk,@QQ,@Skype,@Mobile,@Tel,@Addr,@WebSite,@birthPrivacy,@Vocation,@HomeProv,@HomeCity,0,0,0,0,0,0,0,0,0)";
            }
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, param);
        }

        /// <summary>
        /// ԱϵϢ
        /// </summary>
        /// <returns>sql</returns>
        private SqlParameter[] GetBaseParm(UserBasicInfo Basic)
        {
            SqlParameter[] param = new SqlParameter[16];
            param[0] = new SqlParameter("@UserID", SqlDbType.Int, 4);
            param[0].Value = Basic.UserID;
            param[1] = new SqlParameter("@Sex", SqlDbType.Int, 4);
            param[1].Value = Basic.Sex;
            param[2] = new SqlParameter("@Brithday", SqlDbType.DateTime, 4);
            param[2].Value = Basic.Birthday;
            param[3] = new SqlParameter("@Constellation", SqlDbType.Int, 4);
            param[3].Value = Basic.Constellation;
            param[4] = new SqlParameter("@MSN", SqlDbType.NVarChar, 50);
            param[4].Value = Basic.MSN;
            param[5] = new SqlParameter("@GTalk", SqlDbType.NVarChar, 50);
            param[5].Value = Basic.GTalk;
            param[6] = new SqlParameter("@QQ", SqlDbType.NVarChar, 20);
            param[6].Value = Basic.QQ;
            param[7] = new SqlParameter("@Skype", SqlDbType.NVarChar, 50);
            param[7].Value = Basic.Skype;
            param[8] = new SqlParameter("@Mobile", SqlDbType.Char, 15);
            param[8].Value = Basic.Mobile;
            param[9] = new SqlParameter("@Tel", SqlDbType.Char, 20);
            param[9].Value = Basic.Tel;
            param[10] = new SqlParameter("@Addr", SqlDbType.NVarChar, 100);
            param[10].Value = Basic.Addr;
            param[11] = new SqlParameter("@WebSite", SqlDbType.NVarChar, 50);
            param[11].Value = Basic.WebSite;
            param[12] = new SqlParameter("@birthPrivacy", SqlDbType.Int, 4);
            param[12].Value = Basic.BirthidayDisplay;
            param[13] = new SqlParameter("@Vocation", SqlDbType.Int, 4);
            param[13].Value = Basic.Vocation;
            param[14] = new SqlParameter("@HomeProv", SqlDbType.Int, 4);
            param[14].Value = Basic.HomeProv;
            param[15] = new SqlParameter("@HomeCity", SqlDbType.Int, 4);
            param[15].Value = Basic.HomeCity;
            return param;
        }

        /// <summary>
        /// ޸ĻԱϵϢɼ
        /// </summary>
        /// <param name="ub"></param>
        /// <returns></returns>
        public int UpdateUserPrivacy(UserBasicInfo ub)
        {
            SqlParameter[] param = GetBasePrivacyParm(ub);

            string sql = "select UserID from NT_UserInfo where UserID=@UserID";
            object dresult = DbHelper.ExecuteScalar(CommandType.Text, sql, param);//ǷڸûԱ¼

            if (!Convert.IsDBNull(dresult) && dresult != null)
            {
                sql = "update NT_UserInfo set EmailPrivacy=@EmailPrivacy,MobilePrivacy=@MobilePrivacy,MSNPrivacy=@MSNPrivacy,GTalkPrivacy=@GTalkPrivacy,QQPrivacy=@QQPrivacy,TelPrivacy=@TelPrivacy,SkypePrivacy=@SkypePrivacy,WebSitePrivacy=@WebSitePrivacy,AddrPrivacy=@AddrPrivacy where UserID=@UserID";
            }
            else
            {
                sql = "insert into NT_UserInfo(UserID,Favourite,FavMusics,FavMovies,FavCartoons,FavGames,FavSports,FavBooks,FavAdages,AppreciateMen,Presentation,Sex,Birthday,Constellation,MSN,GTalk,QQ,Skype,Mobile,Tel,Addr,WebSite,BirthidayDisplay,Vocation,HomeProv,HomeCity,EmailPrivacy,MobilePrivacy,MSNPrivacy,GTalkPrivacy,QQPrivacy,TelPrivacy,SkypePrivacy,WebSitePrivacy,AddrPrivacy) values (@UserID,'','','','','','','','','','',0,'1900-1-1',0,'','','','','','','','',1,0,0,0,@EmailPrivacy,@MobilePrivacy,@MSNPrivacy,@GTalkPrivacy,@QQPrivacy,@TelPrivacy,@SkypePrivacy,@WebSitePrivacy,@AddrPrivacy)";
            }
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, param);
        }

        /// <summary>
        /// ԱϵϢɼȲ
        /// </summary>
        /// <returns>sql</returns>
        private SqlParameter[] GetBasePrivacyParm(UserBasicInfo Basic)
        {
            SqlParameter[] param = new SqlParameter[13];
            param[0] = new SqlParameter("@UserID", SqlDbType.Int, 4);
            param[0].Value = Basic.UserID;
            param[1] = new SqlParameter("@EmailPrivacy", SqlDbType.Int, 4);
            param[1].Value = Basic.EmailPrivacy;
            param[2] = new SqlParameter("@MobilePrivacy", SqlDbType.Int, 4);
            param[2].Value = Basic.MobilePrivacy;
            param[3] = new SqlParameter("@MSNPrivacy", SqlDbType.Int, 4);
            param[3].Value = Basic.MSNPrivacy;
            param[4] = new SqlParameter("@GTalkPrivacy", SqlDbType.Int, 4);
            param[4].Value = Basic.GTalkPrivacy;
            param[5] = new SqlParameter("@QQPrivacy", SqlDbType.Int, 4);
            param[5].Value = Basic.QQPrivacy;
            param[6] = new SqlParameter("@TelPrivacy", SqlDbType.Int, 4);
            param[6].Value = Basic.TelPrivacy;
            param[7] = new SqlParameter("@WebSitePrivacy", SqlDbType.Int, 4);
            param[7].Value = Basic.WebSitePrivacy;
            param[8] = new SqlParameter("@SkypePrivacy", SqlDbType.Int, 4);
            param[8].Value = Basic.SkypePrivacy;
            param[9] = new SqlParameter("@AddrPrivacy", SqlDbType.Int, 4);
            param[9].Value = Basic.AddrPrivacy;
            return param;
        }

        /// <summary>
        /// IDȡϢ
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public DataTable getEducationByID(int id)
        {
            SqlParameter param = new SqlParameter("@id", id);
            string sql = "select a.ID,a.UserID,a.DegreeID,a.SchoolID,a.AcademyID,a.MatriculationYear,a.PostTime,SchoolName=(select SchoolName from NT_Dict_School where SchoolID=a.SchoolID) from  NT_UserEducation a where a.ID=@id";
            return DbHelper.ExecuteTable(CommandType.Text, sql, param);
        }

        /// <summary>
        /// IDȡϢ
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public DataTable getCareerByID(int id)
        {
            SqlParameter param = new SqlParameter("@id", id);
            string sql = "select UserID,ID,Company,Description,IsStill,JoinYear,JoinMonth,LeaveYear,LeaveMonth from NT_UserCareer where ID=@id";
            return DbHelper.ExecuteTable(CommandType.Text, sql, param);
        }

        /// <summary>
        /// Ϣ
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public int LockEducation(int ID, int value)
        {
            string sql = "update NT_UserEducation set IsLock=" + value + " where ID=" + ID;
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, null);
        }

        /// <summary>
        /// ɾϢ
        /// </summary>
        /// <param name="ID"></param>
        /// <param name="value"></param>
        /// <param name="flag"></param>
        /// <returns></returns>
        public int LockDelArea(int ID, int value, int flag)
        {
            SqlConnection cn = new SqlConnection(DBConfig.CnString);
            cn.Open();
            try
            {
                SqlParameter param = new SqlParameter("@ID", ID);
                string sql = "";
                if (flag == 0)//ɾ
                {
                    //жϵǷʹù
                    sql = "select Province,City from NT_User where Province=@ID or City=@ID";
                    string strsql = "select HomeProv,HomeCity from NT_UserInfo where HomeProv=@ID or HomeCity=@ID";
                    object obj = DbHelper.ExecuteScalar(cn, CommandType.Text, sql, param);
                    object objstr = DbHelper.ExecuteScalar(cn, CommandType.Text, strsql, param);

                    if (!Convert.IsDBNull(obj) && obj != null && !Convert.IsDBNull(objstr) && objstr != null)
                    {
                        //Ѿù
                        return 2;
                    }
                    sql = "delete  from NT_Dict_Area where ID=@ID or ParentID=@ID";
                }
                else if (flag == 1)//
                {
                    sql = "update NT_Dict_Area set IsLock=" + value + " where ID=@ID or ParentID=@ID";
                }
                return DbHelper.ExecuteNonQuery(cn, CommandType.Text, sql, param);
            }
            finally
            {
                if (cn.State == ConnectionState.Open)
                    cn.Close();
            }
        }

        /// <summary>
        /// ӡ޸ĵϢ
        /// </summary>
        /// <param name="ID"></param>
        /// <param name="name"></param>
        /// <param name="flag"></param>
        /// <returns></returns>
        public int UpdateAddArea(int ID, int ParentID, string name, int flag)
        {
            SqlConnection cn = new SqlConnection(DBConfig.CnString);
            cn.Open();
            try
            {
                //жǷظ
                string sql = null;
                SqlParameter[] param = new SqlParameter[3];
                param[0] = new SqlParameter("@ID", SqlDbType.Int, 4);
                param[0].Value = ID;
                param[1] = new SqlParameter("@ParentID", SqlDbType.Int, 4);
                param[1].Value = ParentID;
                param[2] = new SqlParameter("@name", SqlDbType.NVarChar, 50);
                param[2].Value = name;

                if (flag == 0)//
                {
                    sql = "select Name from NT_Dict_Area where Name=@name";
                    object obj = DbHelper.ExecuteScalar(cn, CommandType.Text, sql, param);//ǷڸûԱ¼
                    if (!Convert.IsDBNull(obj) && obj != null)
                    {
                        return 2;
                    }
                    else
                    {
                        sql = "insert into NT_Dict_Area(ParentID,Name,IsLock) values(@ParentID,@name,0)";
                    }
                }
                else if (flag == 1)//޸
                {
                    sql = "select Name from NT_Dict_Area where Name=@name and ID<>@ID";
                    object obj = DbHelper.ExecuteScalar(cn, CommandType.Text, sql, param);//ǷڸûԱ¼
                    if (!Convert.IsDBNull(obj) && obj != null)
                    {
                        return 2;
                    }
                    else
                    {
                        sql = "update NT_Dict_Area set Name=@name where ID=@ID";
                    }
                }
                return DbHelper.ExecuteNonQuery(cn, CommandType.Text, sql, param);
            }
            finally
            {
                if (cn.State == ConnectionState.Open)
                    cn.Close();
            }
        }
        /// <summary>
        /// жϵм
        /// </summary>
        /// <param name="ParentID"></param>
        /// <returns></returns>
        public int getArea(int ParentID)
        {
            SqlConnection cn = new SqlConnection(DBConfig.CnString);
            cn.Open();
            try
            {
                SqlParameter param = new SqlParameter("@ParentID", ParentID);
                string sql = "select ParentID from NT_Dict_Area where ID=@ParentID";
                string n = Convert.ToString(DbHelper.ExecuteScalar(cn, CommandType.Text, sql, param));
                int k = 0;

                if (n == "0")//2
                {
                    k = 1;
                }
                else
                {
                    sql = "select ParentID from NT_Dict_Area where ID=" + int.Parse(n);
                    n = Convert.ToString(DbHelper.ExecuteScalar(cn, CommandType.Text, sql, null));

                    if (n == "0")//3
                    {
                        k = 2;
                    }
                    else
                    {
                        k = 1;
                    }
                }
                return k;
            }
            finally
            {
                if (cn.State == ConnectionState.Open)
                    cn.Close();
            }
        }

        #region ûע
        /// <summary>
        /// ȡϢ
        /// </summary>
        /// <param name="code"></param>
        /// <returns></returns>
        InviteInfo IUser.GetInviteInfo(string code, EnumFriendInviteMode mode, out Dictionary<string, string> friends)
        {
            InviteInfo info = new InviteInfo();
            friends = new Dictionary<string, string>();
            SqlConnection cn = new SqlConnection(DBConfig.CnString);
            cn.Open();
            try
            {
                int reply = 1;
                bool f = false;
                SqlParameter Param = new SqlParameter("@ValidCode", code);
                string Sql = "select a.ID,a.UserID,a.Invitee,a.Postscript,b.UserName,c.Name,d.FilePath,a.Reply from NT_FriendInvite a inner join NT_User b on a.UserID=b.UserID inner join NT_Dict_Area c on b.Province=c.ID left join NT_Photo d on b.Portrait=d.PhotoID and d.IsLock=0 where a.Method=1 and a.ValidCode=@ValidCode";
                if (mode == EnumFriendInviteMode.URL)
                    Sql = "select 0,a.UserID,null,null,a.UserName,b.Name,c.FilePath,0 from NT_User a inner join NT_Dict_Area b on a.Province=b.ID left join NT_Photo c on a.Portrait=c.PhotoID and c.IsLock=0 where a.UserID=@ValidCode";
                IDataReader rd = DbHelper.ExecuteReader(cn, CommandType.Text, Sql, Param);
                if (rd.Read())
                {
                    info.ID = rd.GetInt32(0);
                    info.UserID = rd.GetInt32(1);
                    if (!rd.IsDBNull(2)) info.Invitee = rd.GetString(2);
                    if (!rd.IsDBNull(3)) info.Postscript = rd.GetString(3);
                    info.UserName = rd.GetString(4);
                    info.Network = rd.GetString(5);
                    if (!rd.IsDBNull(6)) info.HeaPic = rd.GetString(6);
                    reply = rd.GetInt32(7);
                    f = true;
                }
                rd.Close();
                if (!f)
                {
                    throw new Exception("ûҵϢ,ЧϢ");
                }
                if (reply != 0)
                {
                    throw new Exception("ûѾע");
                }
                #region ʼͳ
                //
                Sql = "select count(ID) from NT_Friend where UserID=" + info.UserID;
                info.FriendCount = (int)DbHelper.ExecuteScalar(cn, CommandType.Text, Sql, null);
                //Ƭ
                Sql = "select count(PhotoID) from NT_Photo where UploadUser=" + info.UserID;
                info.PhotoCount = (int)DbHelper.ExecuteScalar(cn, CommandType.Text, Sql, null);
                //־
                Sql = "select count(ID) from NT_Blog where UserID=" + info.UserID;
                info.BlogCount = (int)DbHelper.ExecuteScalar(cn, CommandType.Text, Sql, null);
                //
                Sql = "select count(ID) from NT_LeaveWord where Receiver=" + info.UserID;
                info.NoteCount = (int)DbHelper.ExecuteScalar(cn, CommandType.Text, Sql, null);
                //
                Sql = "select count(ID) from NT_Share where UserID=" + info.UserID;
                info.ShareCount = (int)DbHelper.ExecuteScalar(cn, CommandType.Text, Sql, null);
                //Ӱ
                Sql = "select count(ID) from NT_MovieComment where UserID=" + info.UserID;
                info.MovieCount = (int)DbHelper.ExecuteScalar(cn, CommandType.Text, Sql, null);
                //Ⱥ
                Sql = "select count(ID) from NT_GroupMember where UserID=" + info.UserID;
                info.GroupCount = (int)DbHelper.ExecuteScalar(cn, CommandType.Text, Sql, null);
                #endregion
                #region õб
                Sql = "select top 6 a.FriendID,b.UserName,c.FilePath from NT_Friend a inner join NT_User b on a.FriendID=b.UserID left join NT_Photo c on b.Portrait=c.PhotoID and c.IsLock=0 where a.UserID=" + info.UserID + " order by b.LastLoginTime DESC";
                rd = DbHelper.ExecuteReader(cn, CommandType.Text, Sql, null);
                while (rd.Read())
                {
                    string unm = rd.GetString(0);
                    string uhp = string.Empty;
                    if (!rd.IsDBNull(2)) uhp = rd.GetString(1);
                    friends.Add(unm, uhp);
                }
                rd.Close();
                #endregion
                return info;
            }
            finally
            {
                if (cn.State == ConnectionState.Open)
                    cn.Close();
            }
        }
        #endregion

        /// <summary>
        /// жûǷ
        /// </summary>
        /// <param name="UserId"></param>
        public bool CheckUser(int UserId)
        {
            SqlParameter param = new SqlParameter("@UserId", UserId);
            string sql = "select userID from NT_User where userID=@UserId";
            object obj = DbHelper.ExecuteScalar(CommandType.Text, sql, param);//ǷڸûԱ¼

            if (!Convert.IsDBNull(obj) && obj != null)
            {
                return true;//
            }
            else
            {
                return false;//
            }
        }

        public int GetUserCity(int UserID)
        {
            string sql = "select City From NT_User where UserID=" + UserID;
            object obj = DbHelper.ExecuteScalar(CommandType.Text, sql, null);
            if (obj != null && obj != DBNull.Value)
            {
                return (int)obj;
            }
            else
            {
                return 0;
            }
        }

        public IDataReader GetRecUser(int flg)
        {
            string sql = "select top 15 UserID,UserName,(select Name from NT_Dict_Area where NT_Dict_Area.ID=NT_User.Province) AS Province1,(select Name from NT_Dict_Area where NT_Dict_Area.ID=NT_User.City) AS City1 from NT_User where Recommended=1 and State!=0 and ((select count(*) from NT_Photo where UploadUser=NT_User.UserID and PhotoType=0)>0)  order by newid()";
            //if (flg == 0)
            //{
            //    sql = "select top 9 UserID,UserName from NT_User where Recommended=1 and State!=0 and and ((select count(*) from NT_Photo where UploadUser=NT_User.UserID and PhotoType=0)>0)  order by newid()";
            //}
            return DbHelper.ExecuteReader(CommandType.Text, sql, null);
        }

        public IDataReader GetMiniBlog(int Num)
        {
            string sql = "SELECT TOP "+Num+" a.ID, a.UserID, b.Content, b.PostTime, b.MType FROM (SELECT UserID, MAX(ID) AS ID FROM NT_MiniBlog WHERE isrec = 1 GROUP BY UserID) a INNER JOIN NT_MiniBlog b ON b.ID = a.ID ORDER BY a.ID DESC";
            return DbHelper.ExecuteReader(CommandType.Text, sql, null);
        }


        /// <summary>
        /// ȡUSerID
        /// </summary>
        /// <returns></returns>
        public int GetMaxUserID()
        {
            string sql = "select top 1 userid from nt_user order by userid desc";
            return Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, sql, null));
        }

        /// <summary>
        /// Ϊעӻ
        /// </summary>
        /// <param name="UserID"></param>
        public void GetInvReg(int UserID)
        {
            string sql = "select InviterID from NT_User where UserID=" + UserID;
            IDataReader dr = DbHelper.ExecuteReader(CommandType.Text, sql, null);
            if (dr.Read())
            {
                string InvID = dr["InviterID"].ToString();
                if (NetSNS.Common.Input.IsInteger(InvID) && InvID!="0")
                {
                    updateinte(Convert.ToInt32(InvID), 200, 0, 0,"û");
                    sellFriendInviteMoney(InvID.ToString());
                }
            }            
            dr.Close();
        }

        /// <summary>
        /// ӻֻ߽
        /// </summary>
        /// <param name="UserID">ûID</param>
        /// <param name="Point">λ</param>
        /// <param name="Flag">0ӻ֣1ӽ</param>
        /// <param name="ifoat">0ӣ1</param>
        /// <param name="Content"></param>
        public void updateinte(int UserID, int Point, int Flag, int ifoat, string Content)
        {
            SqlConnection cn = new SqlConnection(DBConfig.CnString);
            cn.Open();
            try
            {
                string sql = string.Empty;
                int iPoint = 0;
                int gPoint = 0;
                int bNum = Convert.ToInt32(NetSNS.Config.UiConfig.intel) * Point;
                switch (Flag)
                {
                    case 0:
                        if (ifoat == 0)
                        {
                            sql = "update NT_User set integral=integral+" + bNum + " where UserID=" + UserID;
                        }
                        else
                        {
                            sql = "update NT_User set integral=integral-" + bNum + " where UserID=" + UserID;
                        }
                        iPoint = bNum;
                        break;
                    case 1:
                        if (ifoat == 0)
                        {
                            sql = "update NT_User set inteyb=inteyb+" + bNum + " where UserID=" + UserID;
                        }
                        else
                        {
                            sql = "update NT_User set inteyb=inteyb-" + bNum + " where UserID=" + UserID;
                        }
                        gPoint = bNum;
                        break;
                }
                DbHelper.ExecuteNonQuery(cn,CommandType.Text, sql, null);
                //ݿ
                string iSQL = "insert into NT_UserPointHistory(UserID,Point,GPoint,UTF,CreatTime,Content) values(" + UserID + "," + iPoint + "," + gPoint + "," + ifoat + ",'" + DateTime.Now + "','" + Content + "')";
                DbHelper.ExecuteNonQuery(cn, CommandType.Text, iSQL, null);
                //־ļ
                NetSNS.Common.Public.SaveInLogs(UserID, bNum, ifoat, Content);
            }
            finally
            {
                if (cn.State == ConnectionState.Open)
                {
                    cn.Close();
                }
            }
        }

        public IDataReader GetUserPoint(int UserID)
        {
            string sql = "select integral,inteyb from NT_User where UserID=" + UserID;
            return DbHelper.ExecuteReader(CommandType.Text, sql, null);
        }

        /// <summary>
        /// ѯҳ
        /// </summary>
        /// <param name="sTime">ʼʱ</param>
        /// <param name="eTime">ʱ</param>
        /// <param name="PageIndex">ǰҳ</param>
        /// <param name="PageSize">ÿҳʾ</param>
        /// <param name="RecordCount">¼</param>
        /// <param name="PageCount">ҳ</param>
        /// <returns>ݱ</returns>
        public DataTable SearchPointHistoryPage(int UserID,string sTime, string eTime, int PageIndex, int PageSize, out int RecordCount, out int PageCount)
        {
            string allFields = "*";
            string tablesAndWhere = " NT_UserPointHistory Where UserID=" + UserID + "";
            if (NetSNS.Common.Input.IsDate(sTime) && NetSNS.Common.Input.IsDate(eTime))
            {
                tablesAndWhere += " and CreatTime BETWEEN '" + sTime + "' AND '" + eTime + "'";
            }           
            string indexField = "ID";
            string orderField = "Order By ID Desc";
            return DbHelper.ExecutePage(allFields, tablesAndWhere, indexField, orderField, PageIndex, PageSize, out RecordCount, out PageCount, null);
        }

        /// <summary>
        /// ֤
        /// </summary>
        /// <param name="kid">ûID</param>
        /// <param name="md5email">MD5EMAIL</param>
        /// <param name="ui">ûϢ</param>
        /// <returns></returns>
        public bool checkForKanshu(int kid, string md5email, out UserInfo ui)
        {            
            SqlParameter parm = new SqlParameter("Kid", DbType.Int32);
            parm.Value = kid;
            UserInfo UInfo = new UserInfo();
            string semail = string.Empty;
            string sql = "select a.*,b.FilePath from NT_User a left join NT_Photo b on a.Portrait=b.PhotoID and b.IsLock=0 where kid=@kid";
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, sql, parm);
            if (rd.Read())
            {
                UInfo.Email = rd["Email"].ToString();
                semail = rd["Email"].ToString();
                UInfo.UserID = Convert.ToInt32(rd["UserID"]);
                UInfo.Password = rd["Password"].ToString();
                UInfo.Username = rd["Username"].ToString();
                UInfo.State = (EnumUserState)(int)rd["State"];
                if (rd["LastLoginTime"] != DBNull.Value) UInfo.LastLoginTime = (DateTime)rd["LastLoginTime"];
                if (rd["LastLoginIp"] != DBNull.Value) UInfo.LastLoginIp = rd["LastLoginIp"].ToString();
                UInfo.LoginTimes = (int)rd["LoginTimes"];
                UInfo.Province = (int)rd["Province"];
                if (rd["City"] != DBNull.Value) UInfo.City = (int)rd["City"];
                UInfo.RegTime = (DateTime)rd["RegTime"];
                UInfo.RegIP = rd["RegIP"].ToString();
                if (rd["Portrait"] != DBNull.Value) UInfo.Portrait = (int)rd["Portrait"];
                if (rd["FilePath"] != DBNull.Value) UInfo.PortraitDir = (string)rd["FilePath"];
            }
            rd.Close();
            ui = UInfo;
            if (!string.IsNullOrEmpty(semail))
            {
                if (Common.Input.MD5(semail, false) == md5email)
                    return true;
            }
            return false;
        }

        /// <summary>
        /// IDȡûϢ
        /// </summary>
        /// <param name="kid">ûID</param>
        /// <returns></returns>
        public UserInfo GetUserInfoByKid(int kid)
        {
            SqlParameter parm = new SqlParameter("Kid", DbType.Int32);
            parm.Value = kid;
            UserInfo UInfo = new UserInfo();
            string sql = "select a.*,b.FilePath from NT_User a left join NT_Photo b on a.Portrait=b.PhotoID and b.IsLock=0 where kid=@kid";
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, sql, parm);
            if (rd.Read())
            {
                UInfo.Email = rd["Email"].ToString();
                UInfo.UserID = Convert.ToInt32(rd["UserID"]);
                UInfo.Password = rd["Password"].ToString();
                UInfo.Username = rd["Username"].ToString();
                UInfo.State = (EnumUserState)(int)rd["State"];
                if (rd["LastLoginTime"] != DBNull.Value) UInfo.LastLoginTime = (DateTime)rd["LastLoginTime"];
                if (rd["LastLoginIp"] != DBNull.Value) UInfo.LastLoginIp = rd["LastLoginIp"].ToString();
                UInfo.LoginTimes = (int)rd["LoginTimes"];
                UInfo.Province = (int)rd["Province"];
                if (rd["City"] != DBNull.Value) UInfo.City = (int)rd["City"];
                UInfo.RegTime = (DateTime)rd["RegTime"];
                UInfo.RegIP = rd["RegIP"].ToString();
                if (rd["Portrait"] != DBNull.Value) UInfo.Portrait = (int)rd["Portrait"];
                if (rd["FilePath"] != DBNull.Value) UInfo.PortraitDir = (string)rd["FilePath"];
            }
            rd.Close();
            return UInfo;
        }

        public IDataReader GetGameInfo(int ID)
        {
            string sql = "select * from NT_Game where ID="+ID;
            return DbHelper.ExecuteReader(CommandType.Text, sql, null);
        }

        public IDataReader GetGameClass(int ID)
        {
            string sql = "select Name,ID from NT_GameClass where classid=" + ID;
            return DbHelper.ExecuteReader(CommandType.Text, sql, null);
        }

        /// <summary>
        /// ȡԱϢ
        /// </summary>
        /// <param name="ID">Ա</param>
        /// <returns></returns>
        public IDataReader getAdmin(int ID)
        {
            SqlParameter param = new SqlParameter("@ID", ID);
            string sql = "select AdminID,LoginName,TrueName,Password,LastLoginTime,LastLoginIP,LoginTimes,State from dbo.NT_Admin where AdminID=@ID";
            return DbHelper.ExecuteReader(CommandType.Text, sql, param);
        }

        /// <summary>
        /// Ӹ¹Ա
        /// </summary>
        /// <param name="loginname">½</param>
        /// <param name="TrueName">ʵ</param>
        /// <param name="Pwd">Ա</param>
        /// <param name="AdminID"></param>
        /// <param name="flag">0ӣ1޸</param>
        /// <returns></returns>
        public int addUpdateAdmin(string loginname, string TrueName, string Pwd, int AdminID, int flag)
        {
            string sql = "";
            SqlParameter[] param = new SqlParameter[4];
            param[0] = new SqlParameter("@loginname", SqlDbType.NVarChar, 20);
            param[0].Value = loginname;
            param[1] = new SqlParameter("@TrueName", SqlDbType.NVarChar, 20);
            param[1].Value = TrueName;
            param[2] = new SqlParameter("@Pwd", SqlDbType.Char,32);
            param[2].Value = Pwd;
            param[3] = new SqlParameter("@AdminID", SqlDbType.Int, 4);
            param[3].Value = AdminID;

            if (flag == 0)
            {
                sql = "insert into dbo.NT_Admin(LoginName,TrueName,Password,LastLoginTime,LastLoginIP,LoginTimes,State) values(@loginname,@TrueName,@Pwd,getdate(),'"+NetSNS.Common.Public.GetClientIP()+"',0,5)"; 
            }
            else if(flag==1)
            {
                sql = "update dbo.NT_Admin set LoginName=@loginname,TrueName=@TrueName,Password=@Pwd where AdminID=@AdminID";
            }
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, param);
        }

        /// <summary>
        /// ɾԱ
        /// </summary>
        /// <param name="AdminID">Ա</param>
        /// <param name="value">05ɾ</param>
        /// <returns></returns>
        public int deleteLock(int AdminID, int value)
        {
            SqlParameter[] param = new SqlParameter[2];
            param[0] = new SqlParameter("@AdminID", SqlDbType.Int, 4);
            param[0].Value = AdminID;
            param[1] = new SqlParameter("@value", SqlDbType.Int, 4);
            param[1].Value = value;
            string sql = "delete from dbo.NT_Admin where AdminID=@AdminID";

            if (value == 0 || value==5)
            {
                sql = "update dbo.NT_Admin  set State=@value where AdminID=@AdminID";
            }
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, param);
        }
        /// <summary>
        /// ȡûID by email
        /// </summary>
        /// <param name="email">ʼ</param>
        /// <returns></returns>
        public int GetIdByEmail(string email)
        {
            int UserID = 0;
            SqlParameter param = new SqlParameter("@Email", SqlDbType.NVarChar, 100);
            param.Value = email;
            string sql = "select UserID from [NT_User] where Email=@Email";
            try
            {
                UserID = Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, sql, param));
            }
            catch { };
            return UserID;
        }
        /// <summary>
        /// ȡÿûID
        /// </summary>
        /// <param name="UserID">ûID</param>
        /// <returns></returns>
        public int GetKid(int UserID)
        {
            int kid = 0;
            SqlParameter param = new SqlParameter("@UserID", UserID);
            string sql = "select kid from Nt_User where UserID=@UserID";
            try
            {
                kid = Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, sql, param));
            }
            catch { }
            return kid;
        }
    }
}
