//===========================================================
//==               (c)2008  NETSNS 1.0                     ==
//==            website:www.aspxcms.com                    ==
//==         qq:6458450,Email:qwsf01115@163.com            ==
//==               Code By Xi.Deng                         ==
//===========================================================
using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Common;
using System.Data.SqlClient;
using NetSNS.DALProfile;
using NetSNS.DALFactory;
using NetSNS.Model;
using NetSNS.Config;

namespace NetSNS.DALSQLServer
{
    /// <summary>
    /// Ⱥ
    /// </summary>
    public class UserGroup : DbBase, IUserGroup
    {
        /// <summary>
        /// Ⱥ
        /// </summary>
        /// <param name="Info">Ⱥʵ</param>
        /// <returns>ӳɹȺ</returns>
        public int Add(UserGroupInfo Info)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();

            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                SqlParameter[] param = getParameters(Info);
                string Sql = "Insert Into [NT_UserGroup]([GroupName]," +
                             "[UserID],[Members],[Bulletin],[NetWork],[Portrait],[Publicity],[State],[PostTime],[PostIP]) " +
                             "Values" +
                             "(@GroupName,@UserID,@Members,@Bulletin,@NetWork,@Portrait,@Publicity,@State,@PostTime,@PostIP);" +
                             "Select @@IDENTITY";
                int GroupID = Convert.ToInt32(DbHelper.ExecuteScalar(trans, CommandType.Text, Sql, param));

                Sql = "Insert Into [NT_GroupMember]([GroupID],[UserID],[JoinTime],[Grade]) " +
                      "Values" +
                      "(" + GroupID + ",@UserID,@PostTime," + (int)EnumGroupGrade.Master + ")";
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, param);

                int n = UserLog(trans, EnumUserAction.AddGroup, Info.UserID, "һȺ", GroupID);
                trans.Commit();
                User us = new User();
                us.updateinte(Info.UserID, 5, 0, 0, "Ⱥ");
                return GroupID;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// ɾȺ(̨)
        /// </summary>
        /// <param name="GroupID">Ⱥ</param>
        /// <returns>ɾɹ1</returns>
        public int Del(int GroupID)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();
            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                //Ⱥ־״̬Ϊ
                string Sql = "Update [NT_UserLog] " +
                      "Set " +
                      "[IsLock]=" + (int)EnumIsLock.Lock + " " +
                      "Where " +
                      "([CorrespondInfo]=" + GroupID + " And " +
                            "([ActionType]=" + (int)EnumUserAction.JoinGroup + " Or [ActionType]=" + (int)EnumUserAction.ExitGroup + " Or " +
                            "[ActionType]=" + (int)EnumUserAction.AddGroup + ")) Or " +
                            "(([CorrespondInfo] In(Select [ID] From [NT_GroupDiscuss] Where [GroupID]=" + GroupID + "))) And " +
                                "([ActionType]=" + (int)EnumUserAction.AddTopic + " Or [ActionType]=" + (int)EnumUserAction.ReTopic + " Or " +
                                   "[ActionType]=" + (int)EnumUserAction.DelTopic + " Or [ActionType]=" + (int)EnumUserAction.DelReply + ")";
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);

                //ɾ֪ͨ
                Sql = "Delete From [NT_Notice] Where " +
                      "[MsgType]=" + (int)EnumNotifyType.GroupAdmin + " And [Correspond]=" + GroupID;
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                //ɾȺ
                Sql = "Delete From [NT_GroupInvite] Where [GroupID]=" + GroupID;
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                //ɾȺ۱
                Sql = "Delete From [NT_GroupDiscuss] Where [GroupID]=" + GroupID;
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                //ɾȺԱ
                Sql = "Delete From [NT_GroupMember] Where [GroupID]=" + GroupID;
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                //ɾȺ
                Sql = "Delete From [NT_UserGroup] Where [GroupID]=" + GroupID;
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                //ɾ
                Sql = "Delete From [NT_Request] " +
                      "Where " +
                      "[CorrespondInfo]=" + GroupID + " And " +
                      "([RequestType]=" + (int)EnumRequestType.InviteGroup + " Or [RequestType]=" + (int)EnumRequestType.ApplyGroup + ")";
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);

                trans.Commit();
                return 1;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }


        /// <summary>
        ///  ɾȺ(ǰ̨)
        /// </summary>
        /// <param name="GroupID">Ⱥ</param>
        /// <param name="UserID">Ⱥ</param>
        /// <returns>ɾɹ1,򷵻-1</returns>
        public int Del(int GroupID, int UserID)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();
            if (!Check(Conn, UserID, GroupID))
                return -1;

            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                int n = UserLog(trans, EnumUserAction.ExitGroup, UserID, "ɾȺ", GroupID);
                //Ⱥ־״̬Ϊ
                string Sql = "Update [NT_UserLog] " +
                      "Set " +
                      "[IsLock]=" + (int)EnumIsLock.Lock + " " +
                      "Where " +
                      "([UserID]=" + UserID + " And [CorrespondInfo]=" + GroupID + " And " +
                            "([ActionType]=" + (int)EnumUserAction.JoinGroup + " Or [ActionType]=" + (int)EnumUserAction.ExitGroup + " Or " +
                            "[ActionType]=" + (int)EnumUserAction.AddGroup + ")) Or " +
                            "(([CorrespondInfo] In(Select [ID] From [NT_GroupDiscuss] Where [GroupID]=" + GroupID + "))) And " +
                                "([ActionType]=" + (int)EnumUserAction.AddTopic + " Or [ActionType]=" + (int)EnumUserAction.ReTopic + " Or " +
                                   "[ActionType]=" + (int)EnumUserAction.DelTopic + " Or [ActionType]=" + (int)EnumUserAction.DelReply + ")";
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);

                //ɾȺ
                Sql = "Delete From [NT_GroupInvite] Where [GroupID]=" + GroupID;
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                //ɾȺ۱
                Sql = "Delete From [NT_GroupDiscuss] Where [GroupID]=" + GroupID;
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                //ɾȺԱ
                Sql = "Delete From [NT_GroupMember] Where [GroupID]=" + GroupID;
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                //ɾȺ
                Sql = "Delete From [NT_UserGroup] Where [GroupID]=" + GroupID + " And [UserID]=" + UserID;
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                //ɾ
                Sql = "Delete From [NT_Request] " +
                      "Where " +
                      "[CorrespondInfo]=" + GroupID + " And " +
                      "([RequestType]=" + (int)EnumRequestType.InviteGroup + " Or [RequestType]=" + (int)EnumRequestType.ApplyGroup + ")";
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);

                trans.Commit();
                User us = new User();
                us.updateinte(UserID, 5, 0, 1, "ɾȺ");

                return n;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// ޸ȺϢ
        /// </summary>
        /// <param name="Info">Ⱥʵ</param>
        /// <returns>޸ĳɹ1</returns>
        public int EditInfo(UserGroupInfo Info)
        {
            SqlParameter[] param = getParameters(Info);
            string Sql = "Update [NT_UserGroup] " +
                         "Set [GroupName]=@GroupName,[Bulletin]=@Bulletin,[NetWork]=@NetWork,[Publicity]=@Publicity " +
                         "Where [GroupID]=@GroupID And [UserID]=@UserID";
            return DbHelper.ExecuteNonQuery(CommandType.Text, Sql, param);
        }

        /// <summary>
        /// ޸Ⱥͷ
        /// </summary>
        /// <param name="Info">Ⱥʵ</param>
        /// <returns>޸ĳɹ1</returns>
        public int EditHead(UserGroupInfo Info)
        {
            SqlParameter[] param = getParameters(Info);
            string Sql = "Update [NT_UserGroup] " +
                         "Set [Portrait]=@Portrait " +
                         "Where [GroupID]=@GroupID And [UserID]=@UserID";
            return DbHelper.ExecuteNonQuery(CommandType.Text, Sql, param);
        }

        /// <summary>
        /// ȡûԱܹȺ
        /// </summary>
        /// <param name="UserID">Ա</param>
        /// <returns></returns>
        public int Count(int UserID)
        {
            string Sql = "Select Count([ID]) From [NT_GroupMember] Where [UserID]=" + UserID;
            return Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, Sql, null));
        }

        /// <summary>
        /// ǷѵȺ
        /// </summary>
        /// <param name="GroupID">Ⱥ</param>
        /// <param name="UserID">Ա</param>
        /// <returns></returns>
        public bool IsMyGroup(int GroupID, int UserID)
        {
            bool tf = false;
            string Sql = "Select Count([GroupID]) From [NT_UserGroup] Where [GroupID]=" + GroupID + " And [UserID]=" + UserID;
            int n = Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, Sql, null));
            if (n > 0)
                tf = true;
            return tf;
        }

        /// <summary>
        /// ȺϢ
        /// </summary>
        /// <param name="GroupID">Ⱥ</param>
        /// <returns>Ⱥʵ</returns>
        public UserGroupInfo Info(int GroupID)
        {
            UserGroupInfo info = new UserGroupInfo();

            string Sql = "Select A.[GroupID],B.[Type],Hot,Ding,[GroupName],[UserID]," +
                         "[Members],[Bulletin],[NetWork],[Portrait],[Publicity],[State],[PostTime],[PostIP] " +
                         "From " +
                         "[NT_UserGroup] A inner join NT_GroupType B on B.GroupID=A.GroupID " +
                         "Where A.[GroupID]=" + GroupID;
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, Sql, null);
            if (rd.Read())
            {
                info.GroupID = Convert.ToInt32(rd["GroupID"].ToString());
                if (rd["GroupName"] != DBNull.Value) info.GroupName = rd["GroupName"].ToString();
                info.UserID = Convert.ToInt32(rd["UserID"].ToString());
                info.Members = Convert.ToInt32(rd["Members"].ToString());
                if (rd["Bulletin"] != DBNull.Value) info.Bulletin = rd["Bulletin"].ToString();
                info.NetWork = Convert.ToInt32(rd["NetWork"].ToString());
                if (rd["Portrait"] != DBNull.Value) info.Portrait = rd["Portrait"].ToString();
                info.Publicity = (EnumGroupPrivacy)Convert.ToInt32(rd["Publicity"].ToString());
                info.State = Convert.ToInt32(rd["State"].ToString());
                info.PostTime = Convert.ToDateTime(rd["PostTime"].ToString());
                if (rd["PostIP"] != DBNull.Value) info.PostIP = rd["PostIP"].ToString();
                if (rd["Type"] != DBNull.Value) info.Type = Convert.ToInt32(rd["Type"]);
                info.TypeStr = NetSNS.Config.GroupConfig.GetGroupType(info.Type);
                if (rd["Hot"] != DBNull.Value) info.Hot = Convert.ToInt32(rd["Hot"]);
                if (rd["Ding"] != DBNull.Value) info.Ding = Convert.ToInt32(rd["Ding"]);
            }
            rd.Close();
            return info;
        }

        /// <summary>
        /// ݿǷڴ˼¼
        /// </summary>
        /// <param name="Conn">SQLӶ</param>
        /// <param name="UserID">Ա</param>
        /// <param name="GroupID">Ⱥ</param>
        /// <returns>ڷtrue,򷵻false</returns>
        private bool Check(SqlConnection Conn, int UserID, int GroupID)
        {
            bool tf = false;
            string Sql = "Select Count([GroupID]) From [NT_UserGroup] Where [UserID]=" + UserID + " And GroupID=" + GroupID;
            int i_Cnt = Convert.ToInt32(DbHelper.ExecuteScalar(Conn, CommandType.Text, Sql, null));
            if (i_Cnt > 0)
                tf = true;
            return tf;
        }
        /// <summary>
        /// ȡָûȺ
        /// </summary>
        /// <param name="UserID">ûID</param>
        /// <returns></returns>
        public List<UserGroupInfo> GetUserGroup(int UserID)
        {
            List<UserGroupInfo> grouplist = new List<UserGroupInfo>();
            SqlParameter param = new SqlParameter("@UserID", SqlDbType.Int, 4);
            param.Value = UserID;
            string sql = "Select A.[GroupID],B.[Type],Hot,Ding,[GroupName],[UserID],[Members],[Bulletin],[NetWork],[Portrait],[Publicity],[State],[PostTime],[PostIP] From [NT_UserGroup] A inner join NT_GroupType B on B.GroupID=A.GroupID Where A.[GroupID] in (select GroupID from NT_GroupMember where UserID=@UserID)";
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, sql, param);
            while (rd.Read())
            {
                UserGroupInfo info = new UserGroupInfo();
                info.GroupID = Convert.ToInt32(rd["GroupID"].ToString());
                if (rd["GroupName"] != DBNull.Value) info.GroupName = rd["GroupName"].ToString();
                info.UserID = Convert.ToInt32(rd["UserID"].ToString());
                info.Members = Convert.ToInt32(rd["Members"].ToString());
                if (rd["Bulletin"] != DBNull.Value) info.Bulletin = rd["Bulletin"].ToString();
                info.NetWork = Convert.ToInt32(rd["NetWork"].ToString());
                if (rd["Portrait"] != DBNull.Value) info.Portrait = rd["Portrait"].ToString();
                info.Publicity = (EnumGroupPrivacy)Convert.ToInt32(rd["Publicity"].ToString());
                info.State = Convert.ToInt32(rd["State"].ToString());
                info.PostTime = Convert.ToDateTime(rd["PostTime"].ToString());
                if (rd["PostIP"] != DBNull.Value) info.PostIP = rd["PostIP"].ToString();
                if (rd["Type"] != DBNull.Value) info.Type = Convert.ToInt32(rd["Type"]);
                info.TypeStr = NetSNS.Config.GroupConfig.GetGroupType(info.Type);
                if (rd["Hot"] != DBNull.Value) info.Hot = Convert.ToInt32(rd["Hot"]);
                if (rd["Ding"] != DBNull.Value) info.Ding = Convert.ToInt32(rd["Ding"]);
                grouplist.Add(info);
            }
            rd.Close();
            return grouplist;
        }
        /// <summary>
        /// ȡָûȺ
        /// </summary>
        /// <param name="UserID">ûID</param>
        /// <param name="num"></param>
        /// <returns></returns>
        public List<UserGroupInfo> GetUserGroup(int UserID,int num)
        {
            List<UserGroupInfo> grouplist = new List<UserGroupInfo>();
            SqlParameter param = new SqlParameter("@UserID", SqlDbType.Int, 4);
            param.Value = UserID;
            string topstr = string.Empty;
            if (num != 0)
            {
                topstr = " top " + num + " ";
            }
            string sql = "Select " + topstr + " A.[GroupID],B.[Type],Hot,Ding,[GroupName],[UserID],[Members],[Bulletin],[NetWork],[Portrait],[Publicity],[State],[PostTime],[PostIP] From [NT_UserGroup] A inner join NT_GroupType B on B.GroupID=A.GroupID Where A.[GroupID] in (select GroupID from NT_GroupMember where UserID=@UserID)";
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, sql, param);
            while (rd.Read())
            {
                UserGroupInfo info = new UserGroupInfo();
                info.GroupID = Convert.ToInt32(rd["GroupID"].ToString());
                if (rd["GroupName"] != DBNull.Value) info.GroupName = rd["GroupName"].ToString();
                info.UserID = Convert.ToInt32(rd["UserID"].ToString());
                info.Members = Convert.ToInt32(rd["Members"].ToString());
                if (rd["Bulletin"] != DBNull.Value) info.Bulletin = rd["Bulletin"].ToString();
                info.NetWork = Convert.ToInt32(rd["NetWork"].ToString());
                if (rd["Portrait"] != DBNull.Value) info.Portrait = rd["Portrait"].ToString();
                info.Publicity = (EnumGroupPrivacy)Convert.ToInt32(rd["Publicity"].ToString());
                info.State = Convert.ToInt32(rd["State"].ToString());
                info.PostTime = Convert.ToDateTime(rd["PostTime"].ToString());
                if (rd["PostIP"] != DBNull.Value) info.PostIP = rd["PostIP"].ToString();
                if (rd["Type"] != DBNull.Value) info.Type = Convert.ToInt32(rd["Type"]);
                info.TypeStr = NetSNS.Config.GroupConfig.GetGroupType(info.Type);
                if (rd["Hot"] != DBNull.Value) info.Hot = Convert.ToInt32(rd["Hot"]);
                if (rd["Ding"] != DBNull.Value) info.Ding = Convert.ToInt32(rd["Ding"]);
                grouplist.Add(info);
            }
            rd.Close();
            return grouplist;
        }

        /// <summary>
        /// ȡûȺ
        /// </summary>
        /// <param name="Num"></param>
        /// <returns></returns>
        public List<UserGroupInfo> NewGroupList(int Num)
        {
            List<UserGroupInfo> list = new List<UserGroupInfo>();
            string sql = "Select Top " + Num + " A.[GroupID],B.[Type],Hot,Ding,[GroupName],[UserID],[Members],[Bulletin],[NetWork],[Portrait],[Publicity],[State],[PostTime],[PostIP] From [NT_UserGroup] A inner Join Nt_GroupType B on B.GroupID=A.GroupID Order By A.[GroupID] Desc";
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, sql, null);
            while (rd.Read())
            {
                UserGroupInfo info = new UserGroupInfo();
                info.GroupID = Convert.ToInt32(rd["GroupID"].ToString());
                if (rd["GroupName"] != DBNull.Value) info.GroupName = rd["GroupName"].ToString();
                info.UserID = Convert.ToInt32(rd["UserID"].ToString());
                info.Members = Convert.ToInt32(rd["Members"].ToString());
                if (rd["Bulletin"] != DBNull.Value) info.Bulletin = rd["Bulletin"].ToString();
                info.NetWork = Convert.ToInt32(rd["NetWork"].ToString());
                if (rd["Portrait"] != DBNull.Value) info.Portrait = rd["Portrait"].ToString();
                info.Publicity = (EnumGroupPrivacy)Convert.ToInt32(rd["Publicity"].ToString());
                info.State = Convert.ToInt32(rd["State"].ToString());
                info.PostTime = Convert.ToDateTime(rd["PostTime"].ToString());
                if (rd["PostIP"] != DBNull.Value) info.PostIP = rd["PostIP"].ToString();
                if (rd["Type"] != DBNull.Value) info.Type = Convert.ToInt32(rd["Type"]);
                info.TypeStr = NetSNS.Config.GroupConfig.GetGroupType(info.Type);
                if (rd["Hot"] != DBNull.Value) info.Hot = Convert.ToInt32(rd["Hot"]);
                if (rd["Ding"] != DBNull.Value) info.Ding = Convert.ToInt32(rd["Ding"]);
                list.Add(info);
            }
            rd.Close();
            return list;
        }



        /// <summary>
        /// ȺIDȡѻϢ
        /// </summary>
        /// <param name="GroupID">ȺID</param>
        /// <returns></returns>
        public CarClubInfo GetCarClubInfo(int GroupID)
        {
            CarClubInfo info = new CarClubInfo();
            string Sql = "Select [id],[clubName],[clubDesc],[clubAnnounce]," +
                         "[ischeck],[GroupID],[privacyFlag],[Province],[City],[CreatTime],[isLock],[isRec],[UserID] " +
                         "From " +
                         "[NT_CarClub] " +
                         "Where [GroupID]=" + GroupID + " order by [ID]";
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, Sql, null);
            if (rd.Read())
            {
                info.id = Convert.ToInt32(rd["id"].ToString());
                if (rd["clubName"] != DBNull.Value) info.clubName = rd["clubName"].ToString();
                if (rd["clubDesc"] != DBNull.Value) info.clubDesc = rd["clubDesc"].ToString();
                if (rd["clubAnnounce"] != DBNull.Value) info.clubAnnounce = rd["clubAnnounce"].ToString();
                info.ischeck = (EnumIsLock)Convert.ToInt32(rd["ischeck"].ToString());
                info.GroupID = Convert.ToInt32(rd["GroupID"].ToString());
                info.privacyFlag = (EnumCarClubPrivacy)Convert.ToInt32(rd["privacyFlag"].ToString());
                info.Province = Convert.ToInt32(rd["Province"].ToString());
                info.City = Convert.ToInt32(rd["City"].ToString());
                info.CreatTime = Convert.ToDateTime(rd["CreatTime"].ToString());
                info.isLock = (EnumIsLock)Convert.ToInt32(rd["isLock"].ToString());
                info.isRec = Convert.ToInt32(rd["isRec"].ToString());
                info.UserID = Convert.ToInt32(rd["UserID"].ToString());
            }
            rd.Close();
            return info;
        }
        /// <summary>
        /// Ⱥ
        /// </summary>
        /// <param name="GroupName">Ⱥ</param>
        /// <returns></returns>
        public bool ExistGroup(string GroupName)
        {
            SqlParameter param = new SqlParameter("@GroupName", SqlDbType.NVarChar, 15);
            param.Value = GroupName;
            string sql = "select count(GroupID) from NT_UserGroup where GroupName=@GroupName";
            int n = Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, sql, param));
            if (n > 0)
                return true;
            return false;
        }
        /// <summary>
        /// ȡID
        /// </summary>
        /// <param name="GroupName">Ⱥ</param>
        /// <returns></returns>
        public int GetIdByName(string GroupName)
        {
            int id = 0;
            SqlParameter param = new SqlParameter("@GroupName", SqlDbType.NVarChar, 15);
            param.Value = GroupName;
            string sql = "select GroupID from NT_UserGroup where GroupName=@GroupName";
            try
            {
                id = Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, sql, param));
            }
            catch { }
            return id;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="GroupID">ȺID</param>
        /// <returns></returns>
        public int AddHot(int GroupID)
        {
            SqlParameter param = new SqlParameter("@GroupID", GroupID);
            string sql = "update NT_UserGroup set Hot=hot+1 where GroupID=@GroupID";
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, param);
        }
        /// <summary>
        /// Ӷ
        /// </summary>
        /// <param name="GroupID"></param>
        /// <returns></returns>
        public int AddDing(int GroupID)
        {
            SqlParameter param = new SqlParameter("@GroupID", GroupID);
            string sql = "update NT_UserGroup set ding=0 where  GroupID=@GroupID and ding is null ";
            DbHelper.ExecuteNonQuery(CommandType.Text, sql, param);

            sql = "update NT_UserGroup set ding=ding+1 where GroupID=@GroupID";
            DbHelper.ExecuteNonQuery(CommandType.Text, sql, param);

            sql = "Select Ding from NT_UserGroup where GroupID=@GroupID";
            int n = Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, sql, param));
            return n;
        }
        /// <summary>
        /// Ⱥ
        /// </summary>
        /// <param name="GroupID">ȺID</param>
        /// <param name="type">Ⱥ</param>
        /// <returns></returns>
        public int SetGroupType(int GroupID, int type)
        {
            SqlParameter[] param ={
                new SqlParameter("@GroupID",GroupID),
                new SqlParameter("@Type",type)
            };
            string sql = "Update Nt_GroupType set [Type]=@Type where GroupID=@GroupID ";
            int n = DbHelper.ExecuteNonQuery(CommandType.Text, sql, param);
            if (n < 1)
            {
                sql = "Insert into Nt_GroupType (GroupID,Type) values(@GroupID,@Type)";
                n = DbHelper.ExecuteNonQuery(CommandType.Text, sql, param);
            }
            return n;
        }
        /// <summary>
        /// ӷÿͼ¼
        /// </summary>
        /// <param name="GroupID">ȺID</param>
        /// <param name="UserID">ûID</param>
        /// <returns></returns>
        public int AddVisit(int GroupID, int UserID)
        {
            SqlParameter[] param ={
                new SqlParameter("@GroupID",GroupID),
                new SqlParameter("@UserID",UserID)
            };
            string sql = "select count(groupid) from Nt_GroupVisit where UserID=@UserID";
            int n = Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, sql, param));
            if (n > 0)
                sql = "update Nt_GroupVisit set VisitTime=GetDate() where GroupID=@GroupID";
            else
                sql = "Insert into Nt_GroupVisit (GroupID,UserID,VisitTime) values(@GroupID,@UserID,GetDate())";
            return DbHelper.ExecuteNonQuery(CommandType.Text, sql, param);
        }
        /// <summary>
        /// ȡ÷
        /// </summary>
        /// <param name="GroupID"></param>
        /// <returns></returns>
        public int GetVisit(int GroupID)
        {
            SqlParameter param = new SqlParameter("@GroupID", GroupID);
            string sql = "select Count(*) from Nt_GroupVisit where GroupID=@GroupID";
            return Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, sql, param));
        }
        /// <summary>
        /// ȡ
        /// </summary>
        /// <param name="GroupID"></param>
        /// <returns></returns>
        public int GetTopicsNum(int GroupID)
        {
            SqlParameter param = new SqlParameter("@GroupID", GroupID);
            string sql = "Select Count(ID) From NT_GroupDiscuss where GroupID=@GroupID";
            return Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, sql, param));
        }
        /// <summary>
        /// ȡȺ 
        /// </summary>
        /// <param name="GroupID">ȺID</param>
        /// <returns></returns>
        public object[] GetGroupType(int GroupID)
        {
            SqlParameter param = new SqlParameter("@GroupID", GroupID);
            string sql = "Select [Type] from NT_GroupType where GroupID=@GroupID";
            int type = Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, sql, param));
            return new object[] { type, NetSNS.Config.GroupConfig.GroupType[type] };
        }
        /// <summary>
        /// 캯
        /// </summary>
        /// <param name="Info">Ⱥʵ</param>
        /// <returns>SQL</returns>
        private SqlParameter[] getParameters(UserGroupInfo Info)
        {
            SqlParameter[] param = new SqlParameter[11];

            param[0] = new SqlParameter("@GroupID", SqlDbType.Int, 4);
            param[0].Value = Info.GroupID;
            param[1] = new SqlParameter("@GroupName", SqlDbType.NVarChar, 15);
            param[1].Value = Info.GroupName;
            param[2] = new SqlParameter("@UserID", SqlDbType.Int, 4);
            param[2].Value = Info.UserID;

            param[3] = new SqlParameter("@Members", SqlDbType.Int, 4);
            param[3].Value = Info.Members;
            param[4] = new SqlParameter("@Bulletin", SqlDbType.NVarChar, 255);
            param[4].Value = Info.Bulletin;
            param[5] = new SqlParameter("@NetWork", SqlDbType.Int, 4);
            param[5].Value = Info.NetWork;

            param[6] = new SqlParameter("@Portrait", SqlDbType.NVarChar, 255);
            param[6].Value = Info.Portrait;
            param[7] = new SqlParameter("@Publicity", SqlDbType.Int, 4);
            param[7].Value = Info.Publicity;
            param[8] = new SqlParameter("@State", SqlDbType.Int, 4);
            param[8].Value = Info.State;

            param[9] = new SqlParameter("@PostTime", SqlDbType.DateTime, 8);
            param[9].Value = Info.PostTime;
            param[10] = new SqlParameter("@PostIP", SqlDbType.VarChar, 15);
            param[10].Value = Info.PostIP;

            return param;
        }
    }
}
