using System;
using System.Collections.Generic;
using System.Text;
using NetSNS.DALFactory;
using System.Data;
using System.Data.SqlClient;
using NetSNS.DALProfile;
using NetSNS.Config;
using NetSNS.Model;
using NetSNS.Common;

namespace NetSNS.DALSQLServer
{
    public class UserIndex : DbBase, IUserIndex
    {
        /// <summary>
        /// ȡû־
        /// </summary>
        /// <param name="UserID">ûID</param>
        /// <param name="DateNum">0ʾ죬1ʾ죬2ʾǰ죬(δ)</param>
        /// <returns></returns>
        public List<UserLogInfo> GetUserLog(int userId, int dateNum)
        {
            SqlConnection cn = new SqlConnection(DBConfig.CnString);
            cn.Open();
            try
            {
                List<UserLogInfo> list = new List<UserLogInfo>();
                string sql = "select top 50 a.ID,a.UserID,b.UserName,a.ActionType,a.LogTime,a.Description,a.Remark,a.CorrespondInfo,";
                sql += "a.CorreUserID,c.UserName from NT_UserLog";
                sql += " a inner join NT_User b on a.UserID=b.UserID left join NT_User c on a.CorreUserID=c.UserID where a.UserID!=" + userId + " and a.IsLock=0 and a.IsDel=0 and a.UserId In (select FriendID from NT_Friend";
                sql += " where UserID=" + userId + ") order by a.ID desc";
                IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, sql, null);
                while (rd.Read())
                {
                    UserLogInfo newlog = new UserLogInfo(); //еϢ
                    newlog.ID = rd.GetInt32(0);
                    newlog.User = new UserCurtInfo(rd.GetInt32(1), rd.GetString(2));
                    newlog.ActionType = (EnumUserAction)rd.GetInt32(3);
                    newlog.LogTime = rd.GetDateTime(4);
                    if (!rd.IsDBNull(5)) newlog.Description = rd.GetString(5);
                    if (!rd.IsDBNull(6)) newlog.Remark = rd.GetString(6);
                    if (!rd.IsDBNull(8) && !rd.IsDBNull(9)) newlog.CorreUser = new UserCurtInfo(rd.GetInt32(8), rd.GetString(9));
                    #region Ϣ
                    if (!rd.IsDBNull(7))
                    {
                        int CorId = rd.GetInt32(7);
                        string[] CorInfo = null;
                        switch (newlog.ActionType)
                        {
                            case EnumUserAction.AddGroup:
                                CorInfo = GetIdName(cn, CorId, 1);
                                break;
                            case EnumUserAction.JoinGroup:
                                CorInfo = GetIdName(cn, CorId, 1);
                                break;
                            case EnumUserAction.ExitGroup:
                                CorInfo = GetIdName(cn, CorId, 1);
                                break;
                            case EnumUserAction.BeFriends:
                                CorInfo = GetIdName(cn, CorId, 2);
                                break;
                            case EnumUserAction.CreateAlbum:
                                CorInfo = GetIdName(cn, CorId, 3);
                                break;
                            case EnumUserAction.AddPhoto:
                                CorInfo = GetIdName(cn, CorId, 14);
                                break;
                            case EnumUserAction.UpdateHead:
                                CorInfo = GetIdName(cn, CorId, 14);
                                break;
                            case EnumUserAction.AddLasso:
                                CorInfo = GetIdName(cn, CorId, 14);
                                break;
                            case EnumUserAction.DeliverBlog:
                                CorInfo = GetIdName(cn, CorId, 5);
                                break;
                            case EnumUserAction.CommentBlog:
                                CorInfo = GetIdName(cn, CorId, 6);
                                break;
                            case EnumUserAction.AddTopic:
                                CorInfo = GetIdName(cn, CorId, 7);
                                break;
                            case EnumUserAction.ReTopic:
                                CorInfo = GetIdName(cn, CorId, 7);
                                break;
                            case EnumUserAction.AddShareComm:
                                CorInfo = GetIdName(cn, CorId, 8);
                                break;
                            case EnumUserAction.ModifyBlog:
                                CorInfo = GetIdName(cn, CorId, 7);
                                break;
                            case EnumUserAction.MovieComment:
                                CorInfo = GetIdName(cn, CorId, 10);
                                break;
                            case EnumUserAction.ShareBlog:
                                CorInfo = GetIdName(cn, CorId, 5);
                                break;
                            case EnumUserAction.ShareAlbum:
                                CorInfo = GetIdName(cn, CorId, 3);
                                break;
                            case EnumUserAction.MiniBlog:
                                CorInfo = GetIdName(cn, CorId, 12);
                                break;
                            case EnumUserAction.SharePhoto:
                                CorInfo = GetIdName(cn, CorId, 4);
                                break;
                            //------------------------------------
                            case EnumUserAction.ShareFriend:
                                CorInfo = GetIdName(cn, CorId, 15);
                                break;
                            case EnumUserAction.ShareWeb:
                                CorInfo = GetIdName(cn, CorId, 13);
                                break;
                            case EnumUserAction.BuyFriend:
                                CorInfo = GetBuyAction(cn, CorId, userId);
                                break;
                            case EnumUserAction.AddVote:
                                CorInfo = GetIdName(cn, CorId, 16);
                                break;
                            case EnumUserAction.ToVote:
                                CorInfo = GetIdName(cn, CorId, 16);
                                break;
                        }
                        newlog.CorrespondInfo = new UserLogCorrespondInfo[] { new UserLogCorrespondInfo(CorId, CorInfo) };
                    }
                    #endregion
                    #region ظ
                    int n = list.Count;
                    if (n > 0)
                    {
                        n--;
                        UserLogInfo prevs = list[n];
                        if (prevs.ActionType == newlog.ActionType && prevs.User.UserID == newlog.User.UserID &&
                        (newlog.ActionType == EnumUserAction.BeFriends
                        || newlog.ActionType == EnumUserAction.AddGroup
                        || newlog.ActionType == EnumUserAction.AddPhoto
                        || newlog.ActionType == EnumUserAction.JoinGroup
                        || newlog.ActionType == EnumUserAction.ExitGroup))
                        {
                            if (newlog.CorrespondInfo.Length > 0)
                            {
                                UserLogCorrespondInfo[] ar = prevs.CorrespondInfo;
                                int m = ar.Length;
                                Array.Resize<UserLogCorrespondInfo>(ref ar, m + 1);
                                ar[m] = newlog.CorrespondInfo[0];
                                prevs.CorrespondInfo = ar;
                            }
                            prevs.RepeatNum++;
                            continue;
                        }
                    }
                    #endregion
                    list.Add(newlog);
                }
                rd.Close();
                return list;
            }
            finally
            {
                if (cn.State == ConnectionState.Open)
                    cn.Close();
            }
        }
        /// <summary>
        /// ȡѶ̬Ϣ
        /// </summary>
        /// <param name="cn"></param>
        /// <param name="CorId">ID</param>
        /// <param name="userid">ûID</param>
        /// <returns></returns>
        private string[] GetBuyAction(SqlConnection cn, int CorId,int userid)
        {
            SellFriend sf = new SellFriend();
            SellActionInfo info = sf.GetAction(cn, CorId);
            if (string.IsNullOrEmpty(info.ActionType))
                return new string[] { "" };
            string str = sf.ParseActionStr(info, userid, false) + info.ActionTime.ToString("MM-dd");
            str = "<div class=\"feed " + info.ActionType + "\">" + str + "</div>";
            return new string[] { str };
        }

        /// <summary>
        /// õһݵ
        /// </summary>
        /// <param name="InfoID">ݵID</param>
        /// <param name="Flag">1Ⱥ,2Ϊû,3,4Ƭ,5־,6־,7Ⱥ⣬8,9־,10Ӱ,11ռ,12ûռ,13ҳ,14Ƭ</param>
        /// <returns></returns>
        string[] GetIdName(SqlConnection cn, int infoId, int Flag)
        {
            string sql = string.Empty;
            switch (Flag)
            {
                case 1:
                    sql = "select GroupName from NT_UserGroup where GroupID=" + infoId;
                    break;
                case 2:
                    sql = "select UserName from NT_User where UserID=" + infoId;
                    break;
                case 3:
                    sql = "select a.Title,a.ImagesCount,b.FilePath from NT_Album a left join NT_Photo b on a.AlbumID=b.AlbumID and b.IsCover=1 where a.AlbumID=" + infoId;
                    break;
                case 4:
                    sql = "select a.FilePath,a.AlbumID,a.PhotoID,a.phototype from NT_Photo a inner join NT_share b on b.caseid=a.Photoid where b.id=" + infoId;
                    break;
                case 5:
                    sql = "select Title,Content from NT_Blog where ID=" + infoId;
                    break;
                case 6:
                    sql = "select a.BlogID,b.Title,a.Content from NT_BlogComment a inner join NT_Blog b on a.BlogID=b.ID where a.ID=" + infoId;
                    break;
                case 7:
                    sql = "select Topic from NT_GroupDiscuss where ID=" + infoId;
                    break;
                case 8:
                    sql = "select a.Content,b.title from NT_ShareComment a,NT_Share b where a.ID=" + infoId + " and a.ShareID=b.ID";
                    break;
                case 9:
                    sql = "select Title from NT_blog where ID=" + infoId;
                    break;
                case 10:
                    sql = "select a.Title,b.Comment,a.PosterFile,b.MovieID from NT_Movie a inner join NT_MovieComment b on a.MovieID=b.MovieID where b.ID=" + infoId;
                    break;
                case 11:
                    sql = "select Content from NT_MiniBlog where ID=" + infoId;
                    break;
                case 12:
                    sql = "select  ID,Content,Comments from NT_MiniBlog where ID=" + infoId + " and islock=0 order by id desc";
                    break;
                case 13:
                    sql = "select top 1 URL,Description from NT_Share where ID=" + infoId + " order by id desc";
                    break;
                case 14:
                    sql = "select a.FilePath,a.AlbumID,a.PhotoID,a.phototype,b.Title,b.ImagesCount from NT_Photo a left join NT_Album b on a.AlbumID=b.AlbumID where a.PhotoID=" + infoId;
                    break;
                case 15:
                    sql = "select a.UserName,b.FilePath from NT_User a left join NT_Photo b on a.Portrait=b.PhotoID and b.IsLock=0 where a.UserID=" + infoId;
                    break;
                case 16:
                    sql = "select Title from NT_Vote where ID=" + infoId;
                    break;
            }
            string[] ReusltStr = null;
            IDataReader dr = DbHelper.ExecuteReader(cn, CommandType.Text, sql, null);
            if (dr.Read())
            {
                if (Flag == 14)
                {
                    ReusltStr = new string[6];
                    ReusltStr[0] = Convert.ToString(dr.GetValue(0));
                    ReusltStr[1] = Convert.ToString(dr.GetValue(1));
                    ReusltStr[2] = Convert.ToString(dr.GetValue(2));
                    ReusltStr[3] = Convert.ToString(dr.GetValue(3));
                    ReusltStr[4] = Convert.ToString(dr.GetValue(4));
                    ReusltStr[5] = Convert.ToString(dr.GetValue(5));
                }
                else if (Flag == 4 || Flag == 10)
                {
                    ReusltStr = new string[4];
                    ReusltStr[0] = Convert.ToString(dr.GetValue(0));
                    ReusltStr[1] = Convert.ToString(dr.GetValue(1));
                    ReusltStr[2] = Convert.ToString(dr.GetValue(2));
                    ReusltStr[3] = Convert.ToString(dr.GetValue(3));
                }
                else if (Flag == 3 || Flag == 6 || Flag == 12)
                {
                    ReusltStr = new string[3];
                    ReusltStr[0] = Convert.ToString(dr.GetValue(0));
                    ReusltStr[1] = Convert.ToString(dr.GetValue(1));
                    ReusltStr[2] = Convert.ToString(dr.GetValue(2));
                }
                else if (Flag == 5 || Flag == 8 || Flag == 13 | Flag == 15)
                {
                    ReusltStr = new string[2];
                    ReusltStr[0] = Convert.ToString(dr.GetValue(0));
                    ReusltStr[1] = Convert.ToString(dr.GetValue(1));
                }
                else
                {
                    ReusltStr = new string[1];
                    ReusltStr[0] = Convert.ToString(dr.GetValue(0));
                }
            }
            dr.Close();
            return ReusltStr;
            //Convert.ToString(DbHelper.ExecuteScalar(CommandType.Text, sql, null));
        }

        /// <summary>
        /// õһݵ
        /// </summary>
        /// <param name="InfoID">ݵID</param>
        /// <param name="Flag">1Ⱥ,2Ϊû,3,4Ƭ,5־,6־,7Ⱥ⣬8,9־,10Ӱ,11ռ,12ûռ,13ҳ,14Ƭ</param>
        /// <returns></returns>
        public string GetIdName(int infoId, int Flag)
        {
            SqlConnection cn = new SqlConnection(DBConfig.CnString);
            cn.Open();
            try
            {
                string[] s = GetIdName(cn, infoId, Flag);
                string r = string.Empty;
                if (s != null && s.Length > 0)
                {
                    foreach (string _s in s)
                    {
                        if (r != string.Empty)
                            r += "|";
                        r += _s;
                    }
                }
                return r;
            }
            finally
            {
                if (cn.State == ConnectionState.Open)
                    cn.Close();
            }
        }


        /// <summary>
        /// к
        /// </summary>
        /// <param name="UserID">к</param>
        /// <returns></returns>
        public IDataReader PokeStr(int UserID)
        {
            string sql = "select DISTINCT a.UserID,b.UserName from NT_Greet a inner join NT_User b on a.UserID=b.UserID where a.IsRead=0 and a.FriendID=" + UserID;
            return DbHelper.ExecuteReader(CommandType.Text, sql, null);
        }

        /// <summary>
        /// ´к״̬
        /// </summary>
        /// <param name="fID">ID</param>
        /// <param name="uID">ûID</param>
        /// <param name="Flag">0ظ1</param>
        public void UpdatePoke(int fID, int uID, int Flag)
        {
            string sql = string.Empty;
            if (Flag == 0)
            {
                sql = "update NT_Greet set isRead=0,UserID=" + uID + ", FriendID=" + fID + " where UserID=" + fID + " and FriendID=" + uID + "";
            }
            else
            {
                sql = "delete from NT_Greet where UserID=" + fID + " and FriendID=" + uID + "";
            }
            DbHelper.ExecuteNonQuery(CommandType.Text, sql, null);
        }

        /// <summary>
        /// ظк״̬
        /// </summary>
        /// <param name="fID">ID</param>
        /// <param name="uID">ûID</param>
        public void updateRePoke(int fID, int uID)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();
            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                //ɾǰ
                string sql = "delete from NT_Greet where FriendID=" + fID + " and UserID=" + uID + "";
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, sql, null);
                //µ
                string insertSQL = "insert into NT_Greet (UserID,FriendID,PostTime,PostIP,IsRead) values(" + fID + "," + uID + ",'" + DateTime.Now + "','" + NetSNS.Common.Public.GetClientIP() + "',0)";
                DbHelper.ExecuteNonQuery(trans, CommandType.Text, insertSQL, null);

                trans.Commit();
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// ȡ
        /// </summary>
        /// <param name="UserID">ûID</param>
        /// <returns></returns>
        public int FriendRequest(int UserID, int Type)
        {
            string sql = string.Empty;
            switch (Type)
            {
                case 1:
                    sql = "select count(id) from NT_Request where Receiver=" + UserID + " and ReplyResult=" + (int)EnumReply.NoneReply + " and RequestType=" + (int)EnumRequestType.MakeFriends + "";
                    break;
                //
                case 3:
                    sql = "select count(id) from NT_GroupInvite where InviteFlag=1 and JoinUserID=" + UserID + " and Response=0";
                    break;
            }
            return Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, sql, null));
        }


        /// <summary>
        /// ȡ֪ͨδ
        /// </summary>
        /// <param name="UserID"></param>
        /// <returns></returns>
        public int NoticeInfo(int UserID)
        {
            string sql = "select count(id) from NT_Notice where Receiver=" + UserID + " and IsLock=0 and IsDel=0 and IsRead=0";
            return Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, sql, null));
        }

        /// <summary>
        /// ȡ10ڼյĺ
        /// </summary>
        /// <param name="UserID"></param>
        /// <returns></returns>
        public IDataReader FriendBirthday(int UserID)
        {
            string sql = "select NT_Friend.UserID,(select NT_User.UserName from NT_User where NT_Friend.UserID=NT_User.UserID) as UserName,(select NT_UserInfo.Birthday from NT_UserInfo where NT_UserInfo.UserID=NT_Friend.UserID and (convert(Datetime,SUBSTRING(convert(varchar,Birthday),1,6)+ convert(varchar,year(getdate()))) BETWEEN getdate() AND (getdate()+7))) as gBirthday from NT_Friend  where NT_Friend.FriendID=" + UserID + "";
            return DbHelper.ExecuteReader(CommandType.Text, sql, null);
        }

        /// <summary>
        /// õӰͼƬ
        /// </summary>
        /// <param name="MovieID"></param>
        /// <returns></returns>
        public string GetMoviePic(int MovieID)
        {
            string sql = "select PosterFile from NT_Movie where MovieID=" + MovieID;
            return Convert.ToString(DbHelper.ExecuteScalar(CommandType.Text, sql, null));
        }

        /// <summary>
        /// ݷ뱻ݷ
        /// </summary>
        /// <param name="userId"></param>
        /// <param name="boundNum">ŷӦ</param>
        /// <param name="topNum">ȡ</param>
        /// <returns></returns>
        public List<VisitInfo>[] Visit(int userId, int boundNum, int topNum)
        {
            SqlConnection cn = new SqlConnection(DBConfig.CnString);
            cn.Open();
            try
            {
                string sql = "select count(id) from NT_visit where VisitorID=" + userId;
                int n = (int)DbHelper.ExecuteScalar(cn, CommandType.Text, sql, null);
                if (n <= boundNum)
                    return null;
                List<VisitInfo>[] list = new List<VisitInfo>[2] { new List<VisitInfo>(), new List<VisitInfo>() };
                string sql0 = "select DISTINCT top " + topNum + " a.MasterID,a.VisitorID,b.UserName,a.LastVisitTime,c.FilePath from NT_visit a inner join NT_User b ";

                sql = sql0 + "on a.VisitorID=b.UserID left join NT_Photo c on b.Portrait=c.PhotoID and c.IsLock=0 where MasterID=" + userId + " order by LastVisitTime desc";
                IDataReader rd = DbHelper.ExecuteReader(cn, CommandType.Text, sql, null);
                while (rd.Read())
                {
                    VisitInfo f = new VisitInfo();
                    f.UserID = rd.GetInt32(1);
                    f.UserName = rd.GetString(2);
                    f.VisitTime = rd.GetDateTime(3);
                    if (!rd.IsDBNull(4))
                        f.Portrait = rd.GetString(4);
                    else
                        f.Portrait = string.Empty;
                    list[0].Add(f);
                }
                rd.Close();
                sql = sql0 + "on a.MasterID=b.UserID left join NT_Photo c on b.Portrait=c.PhotoID and c.IsLock=0 where VisitorID=" + userId + " order by LastVisitTime desc";
                rd = DbHelper.ExecuteReader(cn, CommandType.Text, sql, null);
                while (rd.Read())
                {
                    VisitInfo f = new VisitInfo();
                    f.UserID = rd.GetInt32(0);
                    f.UserName = rd.GetString(2);
                    f.VisitTime = rd.GetDateTime(3);
                    if (!rd.IsDBNull(4))
                        f.Portrait = rd.GetString(4);
                    else
                        f.Portrait = string.Empty;
                    list[1].Add(f);
                }
                rd.Close();
                return list;
            }
            finally
            {
                if (cn.State == ConnectionState.Open)
                    cn.Close();
            }
        }

        public List<UserInfo>[] FindFriend(int userId)
        {
            SqlConnection cn = new SqlConnection(DBConfig.CnString);
            cn.Open();
            try
            {
                List<UserInfo>[] list = new List<UserInfo>[3];
                #region ͬ
                string Sql = "select City from NT_User where UserID=" + userId;
                object obj = DbHelper.ExecuteScalar(cn, CommandType.Text, Sql, null);
                if (obj == null || obj == DBNull.Value)
                    list[0] = null;
                else
                {
                    list[0] = new List<UserInfo>();
                    Sql = "select top 6 a.UserID,a.UserName,a.City,b.FilePath from NT_User a inner join NT_Photo b on a.Portrait=b.PhotoID and b.IsLock=0 where a.City=" + obj + " and a.State!=0 and a.UserID not in (select FriendID from NT_Friend where UserID=" + userId + ") and a.UserID!=" + userId + " order by newid()";
                    IDataReader rd = DbHelper.ExecuteReader(cn, CommandType.Text, Sql, null);
                    while (rd.Read())
                    {
                        UserInfo us = new UserInfo();
                        us.UserID = rd.GetInt32(0);
                        us.Username = rd.GetString(1);
                        if (!rd.IsDBNull(2)) us.City = rd.GetInt32(2);
                        if (!rd.IsDBNull(3)) us.PortraitDir = rd.GetString(3);
                        list[0].Add(us);
                    }
                    rd.Close();
                }
                #endregion
                #region 
                list[1] = new List<UserInfo>();
                Sql = "select top 6 a.UserID,a.UserName,b.Name,c.FilePath from NT_User a inner join NT_Dict_Area b on a.Province=b.ID inner join NT_Photo c on a.Portrait=c.PhotoID and c.IsLock=0 where a.State!=0 and a.UserID not in (select FriendID from NT_Friend where UserID=" + userId + ") and a.UserID!=" + userId + "  order by newid()";
                IDataReader dr = DbHelper.ExecuteReader(cn, CommandType.Text, Sql, null);
                while (dr.Read())
                {
                    UserInfo us = new UserInfo();
                    us.UserID = dr.GetInt32(0);
                    us.Username = dr.GetString(1);
                    if (!dr.IsDBNull(2)) us.ProvinceName = dr.GetString(2);
                    if (!dr.IsDBNull(3)) us.PortraitDir = dr.GetString(3);
                    list[1].Add(us);
                }
                dr.Close();
                #endregion
                #region Ƽ
                list[2] = new List<UserInfo>();
                Sql = "select top 6 a.UserID,a.UserName,b.FilePath from NT_User a inner join NT_Photo b on a.Portrait=b.PhotoID and b.IsLock=0 where a.Recommended=1 and a.State!=0 and a.UserID!=" + userId + " order by newid()";
                dr = DbHelper.ExecuteReader(cn, CommandType.Text, Sql, null);
                while (dr.Read())
                {
                    UserInfo us = new UserInfo();
                    us.UserID = dr.GetInt32(0);
                    us.Username = dr.GetString(1);
                    if (!dr.IsDBNull(2)) us.PortraitDir = dr.GetString(2);
                    list[2].Add(us);
                }
                dr.Close();
                #endregion
                return list;
            }
            finally
            {
                if (cn.State == ConnectionState.Open)
                    cn.Close();
            }
        }
    }
}
