﻿//======================================================
//==     (c)2008 古羌科技 by NeTCMS v1.0              ==
//==          Forum:bbs.aspxcms.com                   ==
//==         Website:www.aspxcms.com                  ==
//======================================================
using System;
using System.Data;
using System.Data.SqlClient;
using System.Collections.Generic;
using System.Text;
using System.Reflection;
using System.Text.RegularExpressions;
using NetSNS.Model;
using NetSNS.DALFactory;
using NetSNS.DALProfile;
using NetSNS.Config;

namespace NetSNS.DALSQLServer
{
    /// <summary>
    /// 公用分页类
    /// </summary>
    public class UtilPage : DbBase, IUtilPage
    {
        #region 分页查询列表，第一个字段必须是不重复的索引字段，必须有order by 索引字段语句
        #region 会员前台
        /// <summary>
        /// 私信通知列表
        /// </summary>
        protected string[] Notice_aspx = { "a.ID", "a.ID,a.Content,a.PostTime,a.Sender,a.MsgType,a.Correspond,b.UserName,a.IsRead", "NT_NOTICE a inner join NT_User b on a.Sender=b.UserID where a.IsLock=0 and a.IsDel=0 and a.Receiver=@Receiver", "order by a.IsRead asc,a.Id desc" };

        /// <summary>
        /// 私信收件箱列表
        /// </summary>
        protected string[] Inbox_aspx = { "a.ID", "a.ID,a.Sender,a.Receiver,a.Title,a.Content,a.PostTime,a.IsReply,a.LtType,a.RelativeID,b.UserName,d.FilePath", "NT_Letter as a inner join NT_User as b on a.Sender=b.UserID left Join Nt_Photo as d On b.Portrait=d.PhotoID And d.IsLock=0 where (a.ID IN (SELECT letterid FROM nt_inbox WHERE userid=@Receiver) and a.TopicID=0)", "order by a.Id desc" };

        /// <summary>
        /// 私信发件箱列表
        /// </summary>
        protected string[] Outbox_aspx = { "a.ID", "a.ID,a.Sender,a.Receiver,a.Title,a.Content,a.PostTime,a.IsReply,a.LtType,a.RelativeID,b.UserName,d.FilePath", "NT_Letter as a inner join NT_User as b on a.Receiver=b.UserID left Join Nt_Photo as d On b.Portrait=d.PhotoID And d.IsLock=0 where (ID IN (SELECT letterid FROM nt_outbox WHERE userid=@Sender) and a.TopicID=0)", "order by a.Id desc" };

        /// <summary>
        /// 私信回复列表
        /// </summary>
        protected string[] LetterInfo_aspx = { "a.ID", "a.ID,a.Sender,a.Title,a.Content,a.PostTime,a.LtType,a.RelativeID,b.UserName,c.FilePath", "NT_Letter as a inner join NT_User as b on a.Sender=b.UserID Left Join Nt_Photo as c On b.Portrait=c.PhotoID And c.IsLock=0 where a.ID=@TopicID Or a.TopicID=@TopicID", "order by a.Id Asc" };

        /// <summary>
        /// 我的群组最新讨论主题列表
        /// </summary>
        protected string[] DyanGroup_aspx = { "a.ID", "a.ID,a.GroupID,a.UserID,a.Topic,a.LastPostTime,a.LastPoster,a.Replys,a.LastPoster,a.TopNum,b.UserName,c.GroupName", "NT_GroupDiscuss as a inner join NT_User as b on a.UserID=b.UserID Inner Join NT_UserGroup as c on a.GroupID=c.GroupID  where a.GroupID In(Select GroupID From NT_GroupMember Where UserID=@UserID) And a.DiscussType=0 And a.State=0", "order by a.LastPostTime Desc" };
        /// <summary>
        /// 群组最新讨论主题列表
        /// </summary>
        protected string[] GroupDiscuss_aspx = { "a.ID", "a.ID,a.GroupID,a.UserID,a.Topic,a.LastPostTime,a.LastPoster,a.Replys,a.LastPoster,a.TopNum,b.UserName,c.GroupName", "NT_GroupDiscuss as a inner join NT_User as b on a.UserID=b.UserID Inner Join NT_UserGroup as c on a.GroupID=c.GroupID  where a.GroupID=@GroupID And a.DiscussType=0 And a.State=0", "order by a.TopNum Desc,a.Id Desc" };

        /// <summary>
        /// 群组主题回复列表
        /// </summary>
        protected string[] GroupDiscussInfo_aspx = { "a.ID", "a.ID,a.GroupID,a.UserID,a.Content,a.PostTime,a.LastModifyTime,a.ReplyTack,a.SeriesNum,a.State,b.UserName,c.Name,d.FilePath", "NT_GroupDiscuss as a inner join NT_User as b on a.UserID=b.UserID Inner Join NT_Dict_Area as c on b.Province=c.ID Left Join Nt_Photo as d On b.Portrait=d.PhotoID And d.IsLock=0 where (a.BelongTopic=@ID Or a.ID=@ID)", "order by a.Id Asc" };

        /// <summary>
        /// 我的群组
        /// </summary>
        protected string[] MyGroup_aspx = { "a.GroupID", "a.GroupID,a.GroupName,a.UserID,a.Members,a.Portrait,a.Bulletin,(Select Count(b.ID) From NT_GroupDiscuss as b Where b.DiscussType=0 And b.State=0 And a.GroupID=b.GroupID) as Cnt", "NT_UserGroup a where a.GroupID In(Select c.GroupID From NT_GroupMember as c Where c.UserID=@UserID)", "order by a.GroupID desc" };

        /// <summary>
        /// 群组列表
        /// </summary>
        protected string[] GroupList_aspx ={ "a.GroupID", "a.GroupID,a.GroupName,a.UserID,a.Members,a.Portrait,a.Bulletin,(Select Count(b.ID) From NT_GroupDiscuss as b Where b.DiscussType=0 And b.State=0 And a.GroupID=b.GroupID ) as Cnt", "NT_UserGroup a Where 1=1", "order by a.GroupID desc" };

        /// <summary>
        /// 群组列表
        /// </summary>
        protected string[] GroupList_Key_aspx ={ "a.GroupID", "a.GroupID,a.GroupName,a.UserID,a.Members,a.Portrait,a.Bulletin,(Select Count(b.ID) From NT_GroupDiscuss as b Where b.DiscussType=0 And b.State=0 And a.GroupID=b.GroupID ) as Cnt", "NT_UserGroup a where a.GroupName Like @GroupName", "order by a.GroupID desc" };

        /// <summary>
        /// 留言板
        /// </summary>
        protected string[] leaveword_aspx = { "a.ID", "a.ID,a.Sender,a.Content,a.PostTime,b.UserName,c.Name,d.FilePath", "NT_LeaveWord a inner join NT_User b on a.Sender=b.UserID inner join NT_Dict_Area c on b.Province=c.ID left join NT_Photo d on b.Portrait=d.PhotoID and d.IsLock=0 where a.IsLock=0 and a.Receiver=@Receiver", "order by a.Id desc" };
        /// <summary>
        /// 留言板对话录
        /// </summary>
        protected string[] leaveword_dialog = { "a.ID", "a.ID,a.Sender,a.Content,a.PostTime,b.UserName,c.Name,d.FilePath", "NT_LeaveWord a inner join NT_User b on a.Sender=b.UserID inner join NT_Dict_Area c on b.Province=c.ID left join NT_Photo d on b.Portrait=d.PhotoID and d.IsLock=0 where a.IsLock=0 and (a.Receiver=@Receiver and a.Sender=@Sender or a.Receiver=@Sender and a.Sender=@Receiver)", "order by a.Id desc" };


        /// <summary>
        ///好友邀请记录列表
        /// </summary>
        protected string[] friend_invite = { "ID", "ID,Invitee,PostTime", "NT_FriendInvite where UserID=@UserID and Reply=@Reply and Method=1", "order by ID desc" };


        /*
        /// <summary>
        ///描述好友列表
        /// </summary>
        protected string[] friend_list_detail = { "a.ID", "a.ID,a.FriendID,b.UserName,c.Name", "NTV_FriendDetail a inner join NT_User b on a.FriendID=b.UserID inner join NT_Dict_Area c on b.Province=c.ID where (a.UserID=@UserID and a.DescType=@DescType)", "order by a.Id desc" };
        
        /// <summary>
        ///无描述好友列表
        /// </summary>
        protected string[] friend_list_detail_none = { "a.ID", "a.ID,a.FriendID,b.UserName,c.Name", "NTV_FriendDetail a inner join NT_User b on a.FriendID=b.UserID inner join NT_Dict_Area c on b.Province=c.ID where (a.UserID=@UserID and a.DescType is null)", "order by a.Id desc" };
        */

        /// <summary>
        /// 读取好友列表
        /// </summary>
        protected string[] friend_list = { "a.UserID", "a.UserID,a.UserName,a.Portrait ", "NT_User a where a.UserID in (select b.FriendID from NT_Friend b where b.UserID=@ID) ", "order by a.LastLoginTime desc" };

        /// <summary>
        ///根据姓名查找好友列表
        /// </summary>
        protected string[] friend_search = { "a.UserID", "a.UserID,a.UserName,a.Province,b.Name,c.FilePath", "NT_User a inner join NT_Dict_Area b on a.Province=b.ID left join NT_Photo c on a.Portrait=c.PhotoID and c.IsLock=0 where a.State=" + (int)EnumUserState.Normal + " and a.UserName like @UserName", "order by a.UserID desc" };
        /// <summary>
        ///日志列表
        /// </summary>
        protected string[] blog_list = { "ID", "ID,Title,PostTime,Comments,Reads,Content,PicPath,Privacy,UserID", "NT_Blog where (IsLock=0 and UserID=@UserID)", "order by ID desc" };
        /// <summary>
        ///好友日志列表
        /// </summary>
        protected string[] blog_friend_list = { "a.ID", "a.ID,a.UserID,a.Title,a.PostTime,a.Comments,a.Reads,a.Content,a.PicPath,a.Privacy,b.UserName,c.Name,d.FilePath", "NT_Blog a inner join NT_User b on a.UserID=b.UserID inner join NT_Dict_Area c on b.Province=c.ID left join NT_Photo d on b.Portrait=d.PhotoID  where (a.IsLock=0 and a.UserID in (select FriendID from NT_Friend where UserID=@UserID) and a.Privacy<>" + (int)EnumPrivacy.ForOwner + ")", "order by a.ID desc" };
        ///<summary>
        ///关于我的日志
        /// </summary>
        protected string[] blog_aboutme_list = { "a.ID", "a.ID,a.UserID,a.Title,a.PostTime,a.Comments,a.Reads,a.Content,a.PicPath,a.Privacy,b.UserName,c.Name,d.FilePath", "NT_Blog a inner join NT_User b on a.UserID=b.UserID inner join NT_Dict_Area c on b.Province=c.ID left join NT_Photo d on b.Portrait=d.PhotoID  where (a.IsLock=0 and (a.Title like @UserName or a.Content like @UserName) and a.Privacy<>" + (int)EnumPrivacy.ForOwner + ")", "order by a.ID desc" };
        /// <summary>
        ///某用户的日志列表
        /// </summary>
        protected string[] blog_user_list = { "ID", "ID,Title,PostTime,Comments,Reads,Content,PicPath,Privacy", "NT_Blog where (IsLock=0 and UserID=@UserID and Privacy<>" + (int)EnumPrivacy.ForOwner + ")", "order by ID desc" };
        /// <summary>
        ///好友的心情日记列表
        /// </summary>
        protected string[] miniblog_recent = { "a.ID", "a.ID,a.UserID,a.Content,a.PostTime,b.UserName,c.FilePath,a.MType", "NT_MiniBlog a inner join NT_User b on a.UserID=b.UserID left join NT_Photo c on b.Portrait=c.PhotoID and c.IsLock=0 where (a.IsLock=0 and (exists (select FriendID from NT_Friend where FriendID=a.UserID and UserID=@UserID)))", "order by a.ID desc" };
        /// <summary>
        ///好友的心情日记列表(评论的)
        /// </summary>
        /// exists (select FriendID from NT_Friend where FriendID=a.UserID and UserID=@UserID)
        protected string[] miniblog_recent_id = { "a.ID", "a.ID,a.UserID,a.Content,a.PostTime,b.UserName,c.FilePath,a.MType", "NT_MiniBlog a inner join NT_User b on a.UserID=b.UserID left join NT_Photo c on b.Portrait=c.PhotoID and c.IsLock=0 where a.IsLock=0 and a.ID=@MID", "order by a.ID desc" };

        /// <summary>
        ///我的心情日记列表
        /// </summary>
        protected string[] miniblog_mine = { "ID", "ID,UserID,Content,PostTime,mType", "NT_MiniBlog where (IsLock=0 and UserID=@UserID)", "order by ID desc" };
        /// <summary>
        ///草稿列表
        /// </summary>
        protected string[] blog_draft = { "ID", "ID,Title,PostTime,Content,PicPath,Privacy", "NT_BlogDraft where (IsLock=0 and UserID=@UserID)", "order by ID desc" };
        /// <summary>
        ///群组成员列表
        /// </summary>
        protected string[] GroupMember_aspx = { "a.ID", "a.UserID,b.UserName,c.[Name],d.FilePath", "NT_GroupMember AS a INNER JOIN NT_User AS b ON a.[userid]=b.[userid] INNER JOIN NT_Dict_Area AS c ON b.[Province]=c.[id] Left Join Nt_Photo as d On b.Portrait=d.PhotoID And d.IsLock=0 where a.[GroupID]=@GroupID", "order by a.[ID] desc" };
        /// <summary>
        /// 相册列表
        /// </summary>
        protected string[] photo_list ={ "a.AlbumID", "a.AlbumID,a.UserID,a.Title,a.Description,a.ImagesCount,a.CreateTime,a.Privacy,a.LastUploadTime,c.FilePath,(select count(b.PhotoID) from NT_Photo b where b.IsLock=0 and b.AlbumID=a.AlbumID) as Cnt", "NT_Album a inner join NT_Photo c on c.AlbumID=a.AlbumID where UserID=@UserID and c.IsCover=1", "order by a.AlbumID desc" };

        /// <summary>
        ///我的好友电影
        /// </summary>
        protected string[] FriendMovie_aspx = { "a.MovieID", "a.MovieID,a.Title,a.PosterFile,b.Score,b.Comment,c.UserID,c.UserName,d.FilePath", "NT_Movie AS a INNER JOIN NT_MovieComment AS b ON a.[MovieID]=b.[MovieID] INNER JOIN NT_User AS c ON b.[UserID]=c.[UserID] Left Join Nt_Photo as d On c.Portrait=d.PhotoID And d.IsLock=0 where b.[UserID] In (Select FriendID From NT_Friend Where UserID=@UserID)", "order by a.[MovieID] desc" };

        /// <summary>
        ///我的电影
        /// </summary>
        protected string[] MyMovie_aspx = { "a.MovieID", "a.MovieID,a.Title,a.PosterFile,b.Score,b.Comment", "NT_Movie AS a INNER JOIN NT_MovieComment AS b ON a.[MovieID]=b.[MovieID] where b.[UserID]=@UserID", "order by a.[MovieID] desc" };

        /// <summary>
        ///所有电影列表
        /// </summary>
        protected string[] MovieList_1_aspx = { "MovieID", "MovieID,Title,PosterFile,Director,Billing,YearOnShow", "NT_Movie Where 1=1", "order by AddTime Desc,isRec desc" };

        /// <summary>
        ///按导演查询
        /// </summary>
        protected string[] MovieList_Director_aspx = { "MovieID", "MovieID,Title,PosterFile,Director,Billing,YearOnShow", "NT_Movie Where Director Like @Key ", "order by MovieID desc" };

        /// <summary>
        ///按演员查询
        /// </summary>
        protected string[] MovieList_Billing_aspx = { "MovieID", "MovieID,Title,PosterFile,Director,Billing,YearOnShow", "NT_Movie Where Billing Like @Key ", "order by MovieID desc" };

        /// <summary>
        ///按年份查询
        /// </summary>
        protected string[] MovieList_Year_aspx = { "MovieID", "MovieID,Title,PosterFile,Director,Billing,YearOnShow", "NT_Movie Where YearOnShow Like @Key ", "order by MovieID desc" };
        /// <summary>
        ///按类型查询
        /// </summary>
        protected string[] MovieList_Gut_aspx = { "MovieID", "MovieID,Title,PosterFile,Director,Billing,YearOnShow", "NT_Movie Where MovieID In (Select MovieID From NT_MovieSort Where SortID In(Select ID From NT_Dict_MovieSort Where SortName Like @Key))", "order by MovieID desc" };

        /// <summary>
        ///按关键字查询
        /// </summary>
        protected string[] MovieList_Key_aspx = { "MovieID", "MovieID,Title,PosterFile,Director,YearOnShow,Score,Director,Billing,YearOnShow,IsRec", "NT_Movie Where (Title Like @Key) Or (MovieID In (Select MovieID From NT_MovieSort Where SortID In(Select ID From NT_Dict_MovieSort Where SortName Like @Key))) Or (Director Like @Key) Or (Billing Like @Key) Or (YearOnShow Like @Key)", "order by MovieID desc" };

        /// <summary>
        /// 分享列表(所有的好友)
        /// </summary>
        protected string[] User_share_index_all ={ "ID", "id,UserID,Title,Description,URL,ShareType, CaseID,IsLock,PostTime,PostIP,Comments,Privacy", "NT_Share where isLock=0 and UserID in (select FriendID from NT_Friend where UserID=@UserID) and Privacy!=3", "order by Id desc" };

        /// <summary>
        /// 分享列表(我的)
        /// </summary>
        protected string[] User_share_index_my ={ "ID", "id,UserID,Title,Description,URL,ShareType,CaseID,IsLock,PostTime,PostIP,Comments,Privacy", "NT_Share where (UserID=@UserID Or FriendIDGroup=@UserID)", "Order by Id desc" };

        /// <summary>
        /// 好友请求
        /// </summary>
        protected string[] Friend_Request ={ "a.ID", "a.ID,a.Demander,b.UserName,c.Name,d.FilePath", "NT_Request a inner join NT_User b on a.Demander=b.UserID inner join NT_Dict_Area c on b.Province=c.ID left join NT_Photo d on b.Portrait=d.PhotoID where (a.Receiver=@Receiver and a.ReplyResult=" + (int)EnumReply.NoneReply + " and a.RequestType=" + (int)EnumRequestType.MakeFriends + ")", "order by a.Id desc" };
        /// <summary>
        /// 照片评论列表
        /// </summary>
        protected string[] PhotoCommentList = { "ID", "ID,PhotoID,UserID,Content,PostTime,PostIP,IsLock,CommentID", "NT_PhotoComment where PhotoID=@PhotoID", "order by ID desc" };
        /// <summary>
        /// 朋友的相册列表
        /// </summary>
        protected string[] Friend_Album_List ={ "AlbumID", "[AlbumID],[UserID],[Title],[Description],[ImagesCount],[CreateTime],[Privacy],[GroupID]", "[NT_Album] Where [UserID] in (select FriendID from [NT_Friend] where UserID=@UserID) and ((GroupID IS NULL) OR (GroupID = 0))", "order by AlbumID desc" };
        /// <summary>
        /// 我的相册列表
        /// </summary>
        protected string[] My_Album_List ={ "AlbumID", "[AlbumID],[UserID],[Title],[Description],[ImagesCount],[CreateTime],[Privacy],[GroupID]", "[NT_Album] Where [UserID]=@UserID", "order by AlbumID desc" };
        /// <summary>
        /// 群组相册列表
        /// </summary>
        protected string[] Group_Album_List ={ "AlbumID", "[AlbumID],[UserID],[Title],[Description],[ImagesCount],[CreateTime],[Privacy],[GroupID]", "[NT_Album] Where [UserID] in (select FriendID from [NT_Friend] where GroupID=@GroupID)", "order by AlbumID desc" };
        /// <summary>
        /// 相册查看
        /// </summary>
        //protected string[] Album_View ={ "PhotoID", "[PhotoID],[AlbumID],[Description],[Views],[FileSize],[State],[IsCover],[Comments],[PostTime],[PostIP],[IsLock],[PhotoType],[Width],[Height],[UploadUser],[FilePath]", "[NT_Photo] where IsLock=0 and PhotoType=1 and AlbumID=@AlbumID and [UploadUser]=@UserID", "order by PhotoID desc" };
        protected string[] Album_View ={ "PhotoID", "[PhotoID],[AlbumID],[Description],[Views],[FileSize],[State],[IsCover],[Comments],[PostTime],[PostIP],[IsLock],[PhotoType],[Width],[Height],[UploadUser],[FilePath]", "[NT_Photo] where IsLock=0 and PhotoType=1 and AlbumID=@AlbumID", "order by PhotoID desc" };
        /// <summary>
        /// 头像相册查看
        /// </summary>
        protected string[] Album_Head_View ={ "PhotoID", "[PhotoID],[AlbumID],[Description],[Views],[FileSize],[State],[IsCover],[Comments],[PostTime],[PostIP],[IsLock],[PhotoType],[Width],[Height],[UploadUser],[FilePath]", "[NT_Photo] where IsLock=0 and PhotoType=0 and AlbumID=@AlbumID and [UploadUser]=@UserID", "order by PhotoID desc" };

        /// <summary>
        /// 被圈好友列表
        /// </summary>
        protected string[] FriendLasso_List ={ "ID", "[ID],[PhotoID],[FriendID],[UserID],[PosX],[PosY],[PostTime],[PostIP],[IsLock],[Description]", "[NT_PhotoLasso] Where  IsLock=(0) and [FriendID] in (select FriendID from [NT_Friend] where UserID=@UserID)", "order by ID desc" };
        /// <summary>
        /// 系统留言列表
        /// </summary>
        protected string[] guestbook_aspx ={ "a.ID", "a.UserID,a.Content,a.PostTime,a.ReplyContent,a.ReplyTime,b.UserName", "[NT_SysNotepad] as a Inner Join NT_User as b on a.UserID=b.UserID Where a.Replier!=0", "order by a.ID desc" };


        /// <summary>
        /// 车友会最新活动
        /// </summary>
        protected string[] atclist_aspx ={ "a.HID", "a.HID,a.HName,a.StartTime,a.EndTime,a.GoTime,a.CID,b.clubName", "[NT_CarATC] as a Inner Join NT_CarClub as b on a.CID=b.id And b.isLock=0 And a.isLock=0", "order by a.HID desc" };

        /// <summary>
        /// 车友会推荐活动
        /// </summary>
        protected string[] atclist_rec_aspx ={ "a.HID", "a.HID,a.HName,a.StartTime,a.EndTime,a.GoTime,a.CID,b.clubName", "[NT_CarATC] as a Inner Join NT_CarClub as b on a.CID=b.id And b.isLock=0 And a.isLock=0 and a.isRec=1", "order by a.HID desc" };
        /// <summary>
        /// 车友会推荐活动带参数
        /// </summary>
        protected string[] atclist_rec_param_aspx ={ "a.HID", "a.HID,a.HName,a.StartTime,a.EndTime,a.GoTime,a.CID,b.clubName", "[NT_CarATC] as a Inner Join NT_CarClub as b on a.CID=b.id And b.isLock=0 And a.isLock=0 and a.isRec=1 and b.ID=@ClubID", "order by a.HID desc" };

        /// <summary>
        /// 车友会clubid参数
        /// </summary>
        protected string[] atclist_param_aspx ={ "a.HID", "a.HID,a.HName,a.StartTime,a.EndTime,a.GoTime,a.CID,b.clubName", "[NT_CarATC] as a Inner Join NT_CarClub as b on a.CID=b.id And b.isLock=0 And a.isLock=0 where b.ID=@ClubID", "order by a.HID desc" };

        /// <summary>
        /// 我的车友会
        /// </summary>
        protected string[] myclub_aspx ={ "a.ID", "a.ClubID,a.isAdmin,b.clubName,b.Province,b.City,b.clubAnnounce", "[NT_CarClubUser] as a Inner Join NT_CarClub as b on a.ClubID=b.id Where a.UserID=@UserID And b.isLock=0 And a.State=0", "order by a.ID desc" };

        /// <summary>
        /// 车友会列表
        /// </summary>
        protected string[] clublist_aspx ={ "id", "id,clubName,clubAnnounce,Province,City", "[NT_CarClub] Where isLock=0", "order by id desc" };

        /// <summary>
        /// 车友会列表
        /// </summary>
        protected string[] clublist_rec_aspx ={ "id", "id,clubName,clubAnnounce,Province,City", "[NT_CarClub] Where isLock=0 And isRec=1", "order by id desc" };

        /// <summary>
        /// 车友会列表(搜索)
        /// </summary>
        protected string[] clublist_Key_aspx ={ "id", "id,clubName,clubAnnounce,Province,City", "[NT_CarClub] Where isLock=0 And clubName Like @Key", "order by id desc" };

        /// <summary>
        /// 活动日程
        /// </summary>
        protected string[] AtcCal_aspx ={ "id", "ID,CName,CDesc,CSleep,Cfood,CTr,CTrs,LogIDS,AlbumID,MapParam,HID,CID", "NT_CarATCCal where HID=@HID", "order by id asc" };

        /// <summary>
        /// 车友会成员列表(所有成员,普通以及管理员)
        /// </summary>
        protected string[] clubuserlist_aspx ={ "a.ID", "a.ID,a.UserID,a.isAdmin,a.State,b.UserName,c.Name", "[NT_CarClubUser] As a Inner Join NT_User As b On a.UserID=b.UserID Inner Join NT_Dict_Area as c On b.Province=c.[ID] Where a.ClubID=@ClubID And a.State=0", "order by a.ID desc" };

        /// <summary>
        /// 车友会成员列表(管理员)
        /// </summary>
        protected string[] clubuserlist_1_aspx ={ "a.ID", "a.ID,a.UserID,a.isAdmin,a.State,b.UserName,c.Name", "[NT_CarClubUser] As a Inner Join NT_User As b On a.UserID=b.UserID Inner Join NT_Dict_Area as c On b.Province=c.[ID] Where a.ClubID=@ClubID And a.State=0 And a.isAdmin=1", "order by a.ID desc" };

        /// <summary>
        /// 车友会成员列表(申请加入的会员)
        /// </summary>
        protected string[] clubuserlist_2_aspx ={ "a.ID", "a.ID,a.UserID,a.isAdmin,a.State,b.UserName,c.Name", "[NT_CarClubUser] As a Inner Join NT_User As b On a.UserID=b.UserID Inner Join NT_Dict_Area as c On b.Province=c.[ID] Where a.ClubID=@ClubID And a.State=1", "order by a.ID desc" };

        /// <summary>
        /// 车友会活动列表
        /// </summary>
        protected string[] atclist2_aspx ={ "a.HID", "a.HID,a.HName,a.StartTime,a.EndTime,a.GoTime,a.CID,b.clubName", "[NT_CarATC] as a Inner Join NT_CarClub as b on a.CID=b.id And b.isLock=0 And a.isLock=0 And CID=@ClubID", "order by a.HID desc" };

        /// <summary>
        ///车友会成员列表
        /// </summary>
        protected string[] clubmemberlist_aspx = { "a.ID", "a.UserID,b.UserName,c.[Name],d.FilePath", "NT_CarClubUser AS a INNER JOIN NT_User AS b ON a.[userid]=b.[userid] INNER JOIN NT_Dict_Area AS c ON b.[Province]=c.[id] Left Join Nt_Photo as d On b.Portrait=d.PhotoID And d.IsLock=0 where a.[ClubID]=@ClubID  And a.[State]=0", "order by a.[ID] desc" };

        /// <summary>
        /// 车友会活动评论
        /// </summary>
        protected string[] AtcCommentList ={ "a.ID", "a.ID,a.Content,a.ATCID,a.UserID,a.CreatTime,a.isLock,a.IP,b.username", "Nt_CarATCComment as a inner join nt_user as b on a.userid=b.userid where a.atcid=@atcid", "order by a.id desc " };
        /// <summary>
        /// 道具列表
        /// </summary>
        protected string[] PropsList_aspx ={ "ID", "ID,PropsName,Role,Integral,Currency,Total,Sales,Path,Islock=case Islock when '0' then '正常' when '1' then '锁定' end", "NT_Props where Islock=0", " order by ID desc" };

        #region 买卖好友分页
        /// <summary>
        /// 每日收益排行榜
        /// </summary>
        protected string[] PerRank_aspx ={ "a.ID", "a.UserID,a.Assets,a.Cash,a.Worth,a.NickName,a.Whos,b.Profit", "Nt_Sell_Property a inner join NT_Sell_Profit b on b.UserID=a.UserID where a.UserID in (Select FriendID From NT_Friend Where UserID=@UserID)", " Order by b.Profit desc" };
        /// <summary>
        /// 资产排行榜
        /// </summary>
        protected string[] AssetsRank_aspx ={ "[Date]", "UserID,Assets,Cash,Worth,NickName,Whos", "Nt_Sell_Property where UserID in (Select FriendID From NT_Friend Where UserID=@UserID)", "order by Assets desc" };
        /// <summary>
        /// 身价排行榜
        /// </summary>
        protected string[] worthRank_aspx ={ "[Date]", "UserID,Assets,Cash,Worth,NickName,Whos", "Nt_Sell_Property where UserID in (Select FriendID From NT_Friend Where UserID=@UserID)", "order by Worth desc" };
        /// <summary>
        /// 现金排行榜
        /// </summary>
        protected string[] cashRank_aspx ={ "[Date]", "UserID,Assets,Cash,Worth,NickName,Whos", "Nt_Sell_Property where UserID in (Select FriendID From NT_Friend Where UserID=@UserID)", "order by Cash desc" };
        /// <summary>
        /// 最近活跃
        /// </summary>
        protected string[] activeRank_aspx ={ "a.[Date]", "a.UserID,a.Assets,a.Cash,a.Worth,a.NickName,a.Whos,b.Profit", "Nt_Sell_Property a inner join NT_Sell_Profit b on b.UserID=a.UserID where a.UserID in (Select FriendID From NT_Friend Where UserID=@UserID)", " Order by b.ActionTime desc" };
        /// <summary>
        /// 我买得起的
        /// </summary>
        protected string[] allow_aspx ={ "[Date]", "UserID,Assets,Cash,Worth,NickName,Whos", "Nt_Sell_Property where Worth+Worth*" + SellFriendConfig.TaxRate + "< (select Cash from Worth where UserID=@UserID) and UserID in (Select FriendID From NT_Friend Where UserID=@UserID)", "order by newid() desc" };
        /// <summary>
        /// 我的好友
        /// </summary>
        protected string[] gamefriend_aspx ={ "[Date]", "UserID,Assets,Cash,Worth,NickName,Whos", "Nt_Sell_Property where UserID in (Select FriendID From NT_Friend Where UserID=@UserID)", "order by newid() desc" };
        /// <summary>
        /// 所有游戏用户
        /// </summary>
        protected string[] alluser_aspx ={ "[Date]", "UserID,Assets,Cash,Worth,NickName,Whos", "Nt_Sell_Property", "order by newid() desc" };


        #endregion

        /// <summary>
        /// 我添加的投票列表
        /// </summary>
        protected string[] myaddvote_aspx ={ "ID", "ID,Title,Intro,Mode,JCnt", "NT_Vote Where UserID=@UserID", "order by ID desc" };

        /// <summary>
        /// 我参与的投票列表
        /// </summary>
        protected string[] myjoinvote_aspx ={ "a.ID", "a.ID,a.Title,a.Intro,a.Mode,a.JCnt", "NT_Vote As a Inner Join Nt_ToVote As b On a.ID=b.VoteID Where b.UserID=@UserID", "order by b.ID desc" };

        /// <summary>
        /// 最新投票
        /// </summary>
        protected string[] newvote_aspx ={ "a.ID", "a.ID,a.Title,a.Intro,a.UserID,a.AddTime,a.Mode,a.EndTime,a.JCnt,b.UserName,c.FilePath", "NT_Vote AS a INNER JOIN NT_User AS b ON a.[userid]=b.[userid] Left Join Nt_Photo as c On b.Portrait=c.PhotoID And c.IsLock=0 Where a.ID Not In(Select VoteID From Nt_ToVote Where UserID=@UserID)", "order by a.ID desc" };

        /// <summary>
        /// 最新投票
        /// </summary>
        protected string[] hotvote_aspx ={ "a.ID", "a.ID,a.Title,a.Intro,a.UserID,a.AddTime,a.Mode,a.EndTime,a.JCnt,b.UserName,c.FilePath", "NT_Vote AS a INNER JOIN NT_User AS b ON a.[userid]=b.[userid] Left Join Nt_Photo as c On b.Portrait=c.PhotoID And c.IsLock=0 Where 1=1", "order by a.AddTime Desc,a.Jcnt desc" };

        /// <summary>
        /// 理财列表前台
        /// </summary>
        protected string[] AccountList_aspx ={ "a.ID", "a.ID,a.UseTime,a.Note,a.Amount,a.Type,Name=case a.Type when '0' then '支出' when '1' then '收入' end,FamilyName=(select b.Name from NT_Family b where b.ID=a.Family),ExpenditureTwo=(select c.Name from NT_FinancialType c where c.ID=a.ExpenditureTwo)", "NT_Financial a  where a.UserID=@UserID", "order by a.ID desc" };

        /// <summary>
        /// 好友理财列表前台
        /// </summary>
        protected string[] FriendFinancial_aspx ={ "a.ID", "a.ID,a.UseTime,a.Note,a.Amount,a.Type,Name=case a.Type when '0' then '支出' when '1' then '收入' end,FamilyName=(select b.Name from NT_Family b where b.ID=a.Family),ExpenditureTwo=(select c.Name from NT_FinancialType c where c.ID=a.ExpenditureTwo),e.UserName", "NT_Financial a inner join NT_User e on e.UserId=a.UserID where a.UserID in (select d.FriendID from NT_Friend d where d.UserID=@UserID)", "order by a.ID desc" };


        #region 开公司游戏公页
        /// <summary>
        /// 任务列表
        /// </summary>
        protected string[] TaskSelect_aspx ={ "TaskID", "[TaskID],[ComID],[TastName],[CreateTime],[Finished],[NeedTime],[ProsType],OrderID,UserID,Published,AreaID", "NT_Co_Task A where  published=1 and UserID=0 and AreaID=(Select AreaID from NT_Co_UserInfo where UserID=@UserID) and not Exists(Select ComID from Nt_Co_Company where ComID=A.ComID and Closed=1)", "Order by TaskID desc" };
        /// <summary>
        /// 某公司库存产品，包括上架和没上架的
        /// </summary>
        protected string[] ListProducts ={ "ProductID", "B.Path,[ProductID],B.[Integral],B.[type],B.Pvalue,[Number],[ObjectID],[Price],[ComID],[OilStationID],IsOnline", "NT_Co_Products A inner join Nt_Props B on B.ID=A.ObjectID  where ComID=@ComID and B.[Type]<>" + (int)NetSNS.Model.EnumPropsType.OilSystem + "", "Order by ProductID desc" };
        /// <summary>
        /// 某公司库存产品，上架的, 参数@ComID
        /// </summary>
        protected string[] ListOnProducts ={ "ProductID", "B.Path,[ProductID],B.[Integral],B.[type],B.Pvalue,[Number],[ObjectID],[Price],[ComID],[OilStationID],IsOnline", "NT_Co_Products A inner join Nt_Props B on B.ID=A.ObjectID  where ComID=@ComID and IsOnline=1 and B.[Type]<>" + (int)NetSNS.Model.EnumPropsType.OilSystem + "", "Order by ProductID desc" };
        /// <summary>
        /// 某公司库存产品，没上架的 参数@ComID
        /// </summary>
        protected string[] ListOffProducts ={ "ProductID", "B.Path,[ProductID],B.[Integral],B.[type],B.Pvalue,[Number],[ObjectID],[Price],[ComID],[OilStationID],IsOnline", "NT_Co_Products A inner join Nt_Props B on B.ID=A.ObjectID  where ComID=@ComID and IsOnline=1 and B.[Type]<>" + (int)NetSNS.Model.EnumPropsType.OilSystem + "", "Order by ProductID desc" };
        /// <summary>
        /// 某公司库存产品，库存少于某数值的 参数@ComID,@Number
        /// </summary>
        protected string[] ListLessProducts ={ "ProductID", "B.Path,[ProductID],B.[Integral],B.[type],B.Pvalue,[Number],[ObjectID],[Price],[ComID],[OilStationID],IsOnline", "NT_Co_Products A inner join Nt_Props B on B.ID=A.ObjectID  where ComID=@ComID and IsOnline=1 and B.[Type]<>" + (int)NetSNS.Model.EnumPropsType.OilSystem + " and Number<@Number", "Order by ProductID desc" };
        /// <summary>
        /// 公司可以发布的任务，参数@ComID
        /// </summary>
        protected string[] AllowPubTask_aspx ={ "[TaskID]", "[TaskID],[ComID],[TastName],[CreateTime],[Finished],[NeedTime],[ProsType],OrderID,UserID,Published,AreaID,Pay", "[NT_Co_Task] Where Published=0 and ComID=@ComID", "Order by TaskID desc" };
        /// <summary>
        /// 公司已发布任务，参数@ComID
        /// </summary>
        protected string[] PublishedTask_aspx ={ "[TaskID]", "[TaskID],[ComID],[TastName],[CreateTime],[Finished],[NeedTime],[ProsType],OrderID,UserID,Published,AreaID,Pay", "[NT_Co_Task] Where Published=1 and ComID=@ComID", "Order by TaskID desc" };
        /// <summary>
        /// 所有产品，按分类 @PropsType
        /// </summary>
        protected string[] ListAllProductsByType = { "ProductID", "Distinct [ProductID],[Number],[ObjectID],[Price],[ComID],[OilStationID],IsOnline", "NT_Co_Products A,NT_PropsType B where A.ObjectID=B.ObjectID and B.Type=@PropsType and A.IsOnline=1 and B.[Type]<>" + (int)NetSNS.Model.EnumPropsType.OilSystem + "", "Order by ProductID desc" };
        /// <summary>
        /// 我的任务 参数@UserID
        /// </summary>
        protected string[] MyTaskList ={ "TaskID", "TaskID,ComID,TastName,CreateTime,Finished,NeedTime,StartTime,ProsType,OrderID,UserID,Published,AreaID,Pay", "Nt_Co_Task where UserID=@UserID", "Order by StartTime desc" };
        /// <summary>
        /// 现金排行榜
        /// </summary>
        protected string[] CashRank ={ "ID", "ID,UserID,HungerPRE,Money,AreaID,OilNum", "NT_Co_UserInfo", "Order by Money desc" };
        /// <summary>
        /// 某公司的任务列表 参数@ComID
        /// </summary>
        protected string[] ComTaskList_aspx ={ "TaskID", "[TaskID],[ComID],[TastName],[CreateTime],[Finished],[NeedTime],[ProsType],OrderID,UserID,Published,AreaID,Pay", "NT_Co_Task where  published=1 and ComID=@ComID", "Order by TaskID desc" };
        /// <summary>
        /// 我的物品 参数@UserID
        /// </summary>
        protected string[] MyObject_aspx ={ "a.ID", "a.ID,b.pvalue,ObjectID,[Name],UseType,Used,Money,UserID", "NT_Co_Object a inner join Nt_Props b on b.ID=a.ObjectID where UserID=@UserID and ((UseType<>" + (int)NetSNS.Model.EnumPropsType.Run + " and Used=0) or UseType=" + (int)NetSNS.Model.EnumPropsType.Run + ") ", "Order by a.ID desc" };

        /// <summary>
        /// 公司商品列表
        /// </summary>
        protected string[] ComProductList_1_aspx ={ "b.[ProductID]", "a.[Path],a.[Integral],a.[Pvalue],a.[type],a.[PropsName],b.[ProductID],b.[Number],b.[Price]", "[NT_Props] As a Inner Join [NT_Co_Products] As b On a.[ID]=b.[ObjectID] Where [ComID]=@ComID And [IsOnline]=1 and a.[Type]<>" + (int)NetSNS.Model.EnumPropsType.OilSystem + " and not Exists(Select ComID from Nt_Co_Company where ComID=b.ComID and Closed=1)", "Order by b.[Price] asc" };

        /// <summary>
        /// 区域商品列表
        /// </summary>
        protected string[] SelectProduct_aspx ={ "b.[ProductID]", "a.[Path],a.[PropsName],a.[Type],a.[Pvalue],b.[ProductID],b.[Number],b.[Price],c.[ComID],c.[Name]", "[NT_Props] As a Inner Join [NT_Co_Products] As b On a.[ID]=b.[ObjectID] Inner Join [NT_Co_Company] As c On b.[ComID]=c.[ComID]  Where c.[AreaID]=@areaid And a.[Type]=@type And [IsOnline]=1 and a.[Type]<>" + (int)NetSNS.Model.EnumPropsType.OilSystem + " and b.[Number]<>0", "Order by b.[Price] asc" };
        /// <summary>
        /// 区域公司列表 参数@AreaID
        /// </summary>
        protected string[] AreaComList ={ "ComID", "[ComID],[Name],[Desc],[UserID],[Capital],[Cash],[Closed],[CreatTime],[Type],[IsSys],[Locked],[CloseTime],[AreaID]", "[NT_Co_Company] Where [AreaID]=@AreaID and Closed=0", "Order by CreatTime desc" };

        /// <summary>
        /// 区域公司列表 参数@AreaID
        /// </summary>
        protected string[] AreaComList_1 ={ "ComID", "[ComID],[Name],[Desc],[UserID],[Capital],[Cash],[Closed],[CreatTime],[Type],[IsSys],[Locked],[CloseTime],[AreaID]", "[NT_Co_Company] Where [AreaID]=@AreaID And [Type]=@Type and Closed=0", "Order by CreatTime desc" };

        /// <summary>
        /// 开公司游戏好友用户列表
        /// </summary>
        protected string[] catchwind_aspx ={ "D.ID", "a.[FriendID],b.[UserName],c.[FilePath]", "NT_Co_UserInfo as d inner join NT_Friend  as a on d.UserID=a.FriendID Inner Join NT_User as b On a.[FriendID]=b.[Userid] left Join Nt_Photo as c On b.Portrait=c.PhotoID And c.IsLock=0 Where a.[UserID]=@UserID", "Order by newid()" };

        #endregion


        #region 看书网方面的东西

        /// <summary>
        /// 圈子列表
        /// </summary>
        protected string[] grouptype_aspx ={ "a.GroupID", "a.GroupID,a.GroupName,a.UserID,a.Members,a.Portrait,a.Bulletin,(Select Count(b.ID) From NT_GroupDiscuss as b Where b.DiscussType=0 And b.State=0 And a.GroupID=b.GroupID) as Cnt,c.Type", "NT_UserGroup as a inner join Nt_GroupType as c on a.GroupID=c.GroupID Where c.Type=@Type", "order by a.GroupID desc" };

        /// <summary>
        /// 圈子排行
        /// </summary>
        protected string[] groupranking_aspx ={ "a.GroupID", "a.GroupID,a.GroupName,a.UserID,a.Members,a.Portrait,a.Bulletin,a.Ding,(Select Count(b.ID) From NT_GroupDiscuss as b Where b.DiscussType=0 And b.State=0 And a.GroupID=b.GroupID) as Cnt,(Select Count(d.ID) From Nt_GroupVisit as d Where a.GroupID=d.GroupID) as vcnt,e.Type", "NT_UserGroup a inner join Nt_GroupType as c On a.GroupID=c.GroupID inner join Nt_GroupType as e on a.GroupID=e.GroupID Where 1=1", "order by a.Ding desc" };

        /// <summary>
        /// 首页圈子列表
        /// </summary>
        protected string[] quanziindex_aspx ={ "a.GroupID", "a.GroupID,a.GroupName,a.UserID,a.Members,a.Portrait,a.Bulletin,a.Ding,a.Hot,(Select Count(b.ID) From NT_GroupDiscuss as b Where b.DiscussType=0 And b.State=0 And a.GroupID=b.GroupID) as Cnt,(Select Count(d.ID) From Nt_GroupVisit as d Where a.GroupID=d.GroupID) as vcnt,e.Type", "NT_UserGroup a inner join Nt_GroupType as c On a.GroupID=c.GroupID inner join Nt_GroupType as e on a.GroupID=e.GroupID Where 1=1", "order by a.GroupID desc" };


        /// <summary>
        /// 圈子收藏
        /// </summary>
        protected string[] groupfav_aspx ={ "ID", "ID,GroupID,UserID,ShelfPic,ShelfUrl,ShelfName,ShelfIntro,ShelfType", "Nt_BookShelf Where GroupID=@GroupID", "order by ID desc" };

        /// <summary>
        /// 圈子访问记录
        /// </summary>
        protected string[] groupvisit_aspx ={ "a.ID", "a.ID,a.GroupID,a.UserID,a.VisitTime,b.UserName,c.FilePath", "Nt_GroupVisit As a inner join NT_User as b on a.UserID=b.UserID left Join Nt_Photo as c On b.Portrait=c.PhotoID And c.IsLock=0 Where a.GroupID=@GroupID", "order by ID desc" };
        
        
        /// <summary>
        /// 我的圈子
        /// </summary>
        protected string[] myquanzitype_aspx ={ "a.GroupID", "a.GroupID,a.GroupName,a.UserID,a.Members,a.Portrait,a.Bulletin,(Select Count(b.ID) From NT_GroupDiscuss as b Where b.DiscussType=0 And b.State=0 And a.GroupID=b.GroupID) as Cnt,c.Type", "NT_UserGroup as a inner join Nt_GroupType as c on a.GroupID=c.GroupID Where a.UserID=@UserID", "order by a.GroupID desc" };

        /// <summary>
        /// 圈子讨论
        /// </summary>
        protected string[] quanzidiscuss_aspx ={ "a.ID", "a.ID,a.GroupID,a.UserID,a.Topic,a.PostTime,a.LastPostTime,a.LastPoster,a.Replys,a.TopNum,b.UserName,c.GroupName", "NT_GroupDiscuss as a inner join NT_User as b on a.UserID=b.UserID Inner Join NT_UserGroup as c on a.GroupID=c.GroupID  where a.GroupID=@GroupID And a.DiscussType=0 And a.State=0", "order by a.TopNum Desc,a.Id Desc" };


        #endregion
        #endregion


        #region 管理员后台列表
        /// <summary>
        ///电影类型列表
        /// </summary>
        protected string[] sortlist_aspx = { "ID", "ID,SortName", "NT_Dict_MovieSort Where 1=1", "order by ID desc" };

        /// <summary>
        ///电影列表
        /// </summary>
        protected string[] movieList_aspx = { "MovieID", "MovieID,Title,Director,YearOnShow,Score,IsRec", "NT_Movie  Where 1=1", "order by MovieID desc" };

        /// <summary>
        ///电影海报列表
        /// </summary>
        protected string[] moviepiclist_aspx = { "ID", "ID,FileName", "NT_MoviePoster Where MovieID=@MovieID", "order by ID desc" };

        /// <summary>
        ///获取会员列表
        /// </summary>
        protected string[] UserList_aspx = { "UserID", "UserID,Email,UserName,State=(case State when 0 then '刚刚注册等待验证' when 1 then '锁定' when 5 then '正常' end),RegTime,LoginTimes,Recommended=(case Recommended when 1 then '是' else '不是' end)", "NT_User where 1=1", "order by UserID desc" };

        /// <summary>
        ///按姓名查询会员
        /// </summary>
        protected string[] UserList_Name_aspx = { "UserID", "UserID,Email,UserName ,State=(case State when 0 then '刚刚注册等待验证' when 1 then '锁定' when 5 then '正常' end),RegTime,LoginTimes,Recommended=(case Recommended when 1 then '是' else '不是' end)", "NT_User where Email like @Key or UserName like @Key", "order by UserID desc" };

        /// <summary>
        ///获取会员教育信息列表
        /// </summary>
        protected string[] EducationList_aspx = { "a.ID", "ID,a.UserID,Degree=(case a.DegreeID when 1 then '初中' when 2 then '高中' when 3 then '大学' when 4 then '研究生' else '博士' end),SchoolName=(select SchoolName from NT_Dict_School where SchoolID=a.SchoolID),Name=(select Name from NT_Dict_Academy where ID=a.AcademyID),a.MatriculationYear,IsLock=(case IsLock when 0 then '正常' when 1 then '锁定' end)", "NT_UserEducation a where a.UserID=@UserID", "order by a.PostTime desc" };

        /// <summary>
        ///获取会员工作信息列表
        /// </summary>
        protected string[] CareerList_aspx = { "ID", "UserID,ID,Company,Description,IsStill=(case IsStill when 0 then '已离职' when 1 then '在职' end),JoinYear,JoinMonth,LeaveYear,LeaveMonth", "NT_UserCareer where UserID=@UserID", "order by PostTime desc" };

        /// <summary>
        /// 群组列表
        /// </summary>
        protected string[] managegrouplist_aspx ={ "a.GroupID", "a.GroupID,a.GroupName,a.UserID,a.Members,a.Bulletin,a.Publicity,a.Portrait,a.State,a.PostTime,b.UserName,c.[Name],(Select Count(d.ID) From NT_GroupDiscuss as d Where d.DiscussType=0 And d.State=0 And a.GroupID=d.GroupID ) as Cnt", "NT_UserGroup as a inner Join NT_User as b On a.UserID=b.UserID Left Join NT_Dict_Area as c on a.NetWork=c.id", "order by a.GroupID desc" };

        /// <summary>
        /// 群组列表(搜索)
        /// </summary>
        protected string[] managegrouplist_Key_aspx ={ "a.GroupID", "a.GroupID,a.GroupName,a.UserID,a.Members,a.Bulletin,a.Publicity,a.Portrait,a.State,a.PostTime,b.UserName,c.[Name],(Select Count(d.ID) From NT_GroupDiscuss as d Where d.DiscussType=0 And d.State=0 And a.GroupID=d.GroupID ) as Cnt", "NT_UserGroup as a inner Join NT_User as b On a.UserID=b.UserID Left Join NT_Dict_Area as c on a.NetWork=c.id Where (a.GroupName Like @Key) Or (b.UserName Like @Key) Or (c.[Name] Like @Key)", "order by a.GroupID desc" };

        /// <summary>
        /// 相册列表
        /// </summary>
        protected string[] manageAlbumList_aspx ={ "a.AlbumID", "a.AlbumID,a.UserID,a.Title,a.Description,a.ImagesCount,a.CreateTime,a.Privacy,a.LastUploadTime,b.UserName", "NT_Album a inner join nt_user b on b.UserID=a.UserID", "order by @order desc" };

        /// <summary>
        /// 相册搜索
        /// </summary>
        protected string[] manageAlbumlist_key_aspx ={ "a.AlbumID", "a.AlbumID,a.UserID,a.Title,a.Description,a.ImagesCount,a.CreateTime,a.Privacy,a.LastUploadTime,b.UserName", "NT_Album a inner join nt_user b on b.UserID=a.UserID where Title like @key or description like @key or b.UserName like @key", "order by @order desc" };

        /// <summary>
        /// 照片列表
        /// </summary>
        protected string[] managePhotoList_aspx ={ "a.PhotoID", "a.PhotoID,a.AlbumID,a.UploadUser,a.Description,a.Views,a.FileSize,a.State,a.IsCover,a.Comments,a.PostTime,a.PostIP,a.isLock,a.PhotoType,a.Width,a.Height,a.FilePath,b.Title as AlbumTitle,c.UserName", "NT_Photo a inner join nt_Album b on b.AlbumID=a.AlbumID inner join Nt_User c on c.UserID=a.UploadUser", "order by @order desc" };
        /// <summary>
        /// 照片搜索
        /// </summary>
        protected string[] managePhotoList_key_aspx ={ "a.PhotoID", "a.PhotoID,a.AlbumID,a.UploadUser,a.Description,a.Views,a.FileSize,a.State,a.IsCover,a.Comments,a.PostTime,a.PostIP,a.isLock,a.PhotoType,a.Width,a.Height,a.FilePath,b.Title as AlbumTitle,c.UserName", "NT_Photo a inner join nt_Album b on b.AlbumID=a.AlbumID inner join Nt_User c on c.UserID=a.UploadUser where a.Description like @key or b.Title like @key or c.UserName like @key", "order by @order desc" };
        /// <summary>
        /// 地区列表
        /// </summary>
        protected string[] AreaList_aspx ={ "ID", "ID,ParentID,Name,IsLock=case IsLock when '0' then '正常' when '1' then '锁定' end", "NT_Dict_Area where 1=1", "order by ID desc" };

        /// <summary>
        /// 系统留言列表
        /// </summary>
        protected string[] guestbook_1_aspx ={ "a.ID", "a.ID,a.UserID,a.Content,a.PostTime,a.ReplyContent,a.ReplyTime,a.Replier,b.UserName", "[NT_SysNotepad] as a Inner Join NT_User as b on a.UserID=b.UserID", "order by a.ID desc" };

        ///搜索个人爱好信息
        protected string[] Search_Favourite_aspx ={ "a.UserID", "a.UserID,a.UserName,Province=(select Name from NT_Dict_Area where id=a.Province),b.MSN,b.GTalk,b.Mobile,Photo=(select FilePath from NT_Photo where PhotoID=a.Portrait and PhotoType=0) ", "dbo.NT_User a inner join  dbo.NT_UserInfo b on a.UserID=b.UserID where Favourite like @where", "order by a.RegTime desc" };
        ///搜索个人喜欢的音乐
        protected string[] Search_FavMusics_aspx ={ "a.UserID", "a.UserID,a.UserName,Province=(select Name from NT_Dict_Area where id=a.Province),b.MSN,b.GTalk,b.Mobile,Photo=(select FilePath from NT_Photo where PhotoID=a.Portrait and PhotoType=0) ", "dbo.NT_User a inner join  dbo.NT_UserInfo b on a.UserID=b.UserID where FavMusics like @where", "order by a.RegTime desc" };
        ///搜索个人喜欢的电影
        protected string[] Search_FavMovies_aspx ={ "a.UserID", "a.UserID,a.UserName,Province=(select Name from NT_Dict_Area where id=a.Province),b.MSN,b.GTalk,b.Mobile,Photo=(select FilePath from NT_Photo where PhotoID=a.Portrait and PhotoType=0) ", "dbo.NT_User a inner join  dbo.NT_UserInfo b on a.UserID=b.UserID where FavMovies like @where", "order by a.RegTime desc" };
        ///搜索个人喜欢的动漫
        protected string[] Search_FavCartoons_aspx ={ "a.UserID", "a.UserID,a.UserName,Province=(select Name from NT_Dict_Area where id=a.Province),b.MSN,b.GTalk,b.Mobile,Photo=(select FilePath from NT_Photo where PhotoID=a.Portrait and PhotoType=0) ", "dbo.NT_User a inner join  dbo.NT_UserInfo b on a.UserID=b.UserID where FavCartoons like @where", "order by a.RegTime desc" };
        ///搜索个人喜欢的游戏
        protected string[] Search_FavGames_aspx ={ "a.UserID", "a.UserID,a.UserName,Province=(select Name from NT_Dict_Area where id=a.Province),b.MSN,b.GTalk,b.Mobile,Photo=(select FilePath from NT_Photo where PhotoID=a.Portrait and PhotoType=0) ", "dbo.NT_User a inner join  dbo.NT_UserInfo b on a.UserID=b.UserID where FavGames like @where", "order by a.RegTime desc" };
        ///搜索个人喜欢的运动
        protected string[] Search_FavSports_aspx ={ "a.UserID", "a.UserID,a.UserName,Province=(select Name from NT_Dict_Area where id=a.Province),b.MSN,b.GTalk,b.Mobile,Photo=(select FilePath from NT_Photo where PhotoID=a.Portrait and PhotoType=0) ", "dbo.NT_User a inner join  dbo.NT_UserInfo b on a.UserID=b.UserID where FavSports like @where", "order by a.RegTime desc" };
        ///搜索个人喜欢的书
        protected string[] Search_FavBooks_aspx ={ "a.UserID", "a.UserID,a.UserName,Province=(select Name from NT_Dict_Area where id=a.Province),b.MSN,b.GTalk,b.Mobile,Photo=(select FilePath from NT_Photo where PhotoID=a.Portrait and PhotoType=0) ", "dbo.NT_User a inner join  dbo.NT_UserInfo b on a.UserID=b.UserID where FavBooks like @where", "order by a.RegTime desc" };
        ///搜索个人欣赏的人
        protected string[] Search_AppreciateMen_aspx ={ "a.UserID", "a.UserID,a.UserName,Province=(select Name from NT_Dict_Area where id=a.Province),b.MSN,b.GTalk,b.Mobile,Photo=(select FilePath from NT_Photo where PhotoID=a.Portrait and PhotoType=0) ", "dbo.NT_User a inner join  dbo.NT_UserInfo b on a.UserID=b.UserID where AppreciateMen like @where", "order by a.RegTime desc" };
        ///搜索同一公司的人
        protected string[] Search_Company_aspx ={ "a.UserID", "a.UserID,a.ID,b.UserName,Province=(select Name from NT_Dict_Area where id=b.Province),a.Company,a.JoinYear,a.IsStill,a.JoinMonth,a.LeaveYear,a.LeaveMonth,Photo=(select FilePath from NT_Photo where PhotoID=b.Portrait and PhotoType=0) ", "dbo.NT_UserCareer a inner join dbo.NT_User b on a.userID=b.UserID  where a.Company like @where", "order by b.RegTime desc" };
        ///搜索同一学校的人
        protected string[] Search_SchoolID_aspx ={ "c.UserID", "c.UserID,c.UserName,Province=(select Name from NT_Dict_Area where id=c.Province),Photo=(select FilePath from NT_Photo where PhotoID=c.Portrait and PhotoType=0),c.RegTime", "NT_Dict_School a join NT_UserEducation b on a.SchoolID=b.SchoolID join NT_User c  on b.UserID=c.UserID where b.SchoolID=@where", "order by c.RegTime desc" };
        ///搜索同一学校同一院校的人
        protected string[] Search_AcademyID_aspx ={ "c.UserID", "c.UserID,c.UserName,Province=(select Name from NT_Dict_Area where id=c.Province),Photo=(select FilePath from NT_Photo where PhotoID=c.Portrait and PhotoType=0),c.RegTime ", "NT_Dict_School a join NT_UserEducation b on a.SchoolID=b.SchoolID join NT_User c  on b.UserID=c.UserID where b.SchoolID=@SchoolID and b.AcademyID=@AcademyID", "order by c.RegTime desc" };
        ///读取所有帮助
        protected string[] HelpList_aspx ={ "ID", "ID,SN,Title,Content", "dbo.NT_Help where 1=1", "order by ID" };
        ///读取所有行业
        protected string[] VocationList_aspx ={ "ID", "ID,VocName,Lock=IsLock,IsLock=case IsLock when '0' then '正常' when '1' then '锁定' end", "NT_Dict_Vocation where 1=1", "order by ID" };
        ///搜索行业
        protected string[] Search_VocationList_aspx ={ "ID", "ID,VocName,Lock=IsLock,IsLock=case IsLock when '0' then '正常' when '1' then '锁定' end", "NT_Dict_Vocation where VocName like @Name", "order by ID" };
        ///搜索帮助
        protected string[] Search_HelpList_aspx ={ "ID", "ID,SN,Title,Content", "dbo.NT_Help where SN like @SN", "order by ID desc" };

        /// <summary>
        /// 搜索地区列表
        /// </summary>
        protected string[] Search_AreaList_aspx ={ "ID", "ID,ParentID,Name,IsLock=case IsLock when '0' then '正常' when '1' then '锁定' end", "NT_Dict_Area where Name like @Name", "order by ID desc" };

        /// <summary>
        /// 车友会列表
        /// </summary>
        protected string[] carclublist_aspx ={ "a.id", "a.id,a.clubName,a.ischeck,a.Province,a.City,a.CreatTime,a.isLock,a.isRec,b.UserName", "[NT_CarClub] As a Inner Join [NT_User] as b On a.userid=b.userid  Where 1=1", "order by a.id desc" };

        /// <summary>
        /// 车友会列表(搜索)
        /// </summary>
        protected string[] carclublist_key_aspx ={ "a.id", "a.id,a.clubName,a.ischeck,a.Province,a.City,a.CreatTime,a.isLock,a.isRec,b.UserName", "[NT_CarClub] As a Inner Join [NT_User] as b On a.userid=b.userid Where a.clubName Like @key", "order by a.id desc" };


        /// <summary>
        /// 景点名称列麦
        /// </summary>
        protected string[] IntroList_aspx ={ "ID", "ID,AreaName", "NT_CarClubAreaIntro where 1=1", "order by ID desc" };


        /// <summary>
        /// 景点名称列麦(搜索)
        /// </summary>
        protected string[] IntroList_key_aspx ={ "ID", "ID,AreaName", "NT_CarClubAreaIntro where AreaName Like @key", "order by ID desc" };

        /// <summary>
        /// 商家列麦(搜索)
        /// </summary>
        protected string[] companylist_key_aspx ={ "ID", "ID,ComPanyName,Tel,Contact,Address", "NT_Company where ComPanyName Like @key", "order by ID desc" };

        /// <summary>
        /// 商家列麦
        /// </summary>
        protected string[] companylist_aspx ={ "ID", "ID,ComPanyName,Tel,Contact,Address", "NT_Company where 1=1", "order by ID desc" };

        /// <summary>
        /// 广告列麦
        /// </summary>
        protected string[] adslist_aspx ={ "a.ID", "a.ID,a.keyword,a.ViewTime,a.CompanyID,b.ComPanyName", "NT_Ads as a Inner join NT_Company As b On a.CompanyID=b.ID Where 1=1", "order by a.ID desc" };

        /// <summary>
        /// 广告列麦(搜索)
        /// </summary>
        protected string[] adslist_key_aspx ={ "a.ID", "a.ID,a.keyword,a.ViewTime,a.CompanyID,b.ComPanyName", "NT_Ads as a Inner join NT_Company As b On a.CompanyID=b.ID Where a.keyword Like @key Or b.ComPanyName Like @key", "order by a.ID desc" };

        /// <summary>
        /// 管理员列麦
        /// </summary>
        protected string[] adminList_aspx ={ "AdminID", "AdminID,LoginName,TrueName,TrueName,Password,LastLoginTime,LastLoginIP,LoginTimes,State=case state when 5 then '正常' when 0 then '锁定' end", "NT_Admin where 1=1", "order by AdminID desc" };

        /// <summary>
        /// 道具列表
        /// </summary>
        protected string[] PropsList1_aspx ={ "ID", "ID,PropsName,Pvalue,Role,Integral,Currency,Total,Sales,Path,Type,Islock=case Islock when '0' then '正常' when '1' then '锁定' end", "NT_Props where 1=1", " order by ID desc" };
        /// <summary>
        /// 道具搜索列表
        /// </summary>
        protected string[] PropsList_Name_aspx ={ "ID", "ID,Pvalue,PropsName,Role,Integral,Currency,Total,Sales,Path,Type,Islock=case Islock when '0' then '正常' when '1' then '锁定' end", "NT_Props where PropsName like @PropsName", " order by ID desc" };
        /// <summary>
        /// 我的道具
        /// </summary>
        protected string[] MyProps_aspx ={ "a.ID", "a.ID,a.PropsName,a.Role,a.Integral,a.Currency,a.Path,a.Islock,a.Sales,b.UserID,b.Total,a.Type", "NT_Props a inner join NT_UserProps b on a.ID=b.PropsID where b.UserID=@ID and a.IsLock=0", " order by a.ID desc" };
        /// <summary>
        /// 所有订单
        /// </summary>
        protected string[] OrderList_aspx ={ "ID", "ID,UserID,OrderID,Name,Description,Price,CreateTime,State=case State when '0' then '已付款' when '1' then '未付款' end", "NT_Order where 1=1", " order by ID desc" };
        /// <summary>
        /// 搜索订单
        /// </summary>
        protected string[] OrderList_OrderID_aspx ={ "ID", "ID,UserID,OrderID,Name,Description,Price,CreateTime,State=case State when '0' then '已付款' when '1' then '未付款' end", "NT_Order where OrderID like @OrderID", " order by ID desc" };

        /// <summary>
        /// 家庭成员列表
        /// </summary>
        protected string[] FamilyList_aspx ={ "ID", "ID,UserID,Name,Birthday,Sex=case Sex when '0' then '女' when '1' then '男' end", "NT_Family where UserID=@UserID", "order by ID desc" };
        /// <summary>
        /// 理财分类信息列表  
        /// </summary>
        protected string[] FinancialList_aspx ={ "ID", "ID,ParentID,UserID,Name,Type=case Type when '0' then '支出' when '1' then '收入' end,System=case UserID when '0' then '系统' else '用户' end,IsLock=case IsLock when '0' then '正常' when '1' then '解锁' end", "NT_FinancialType where ParentID=@ParentID", "order by ID desc" };

        /// <summary>
        /// 理财分类信息列表  
        /// </summary>
        protected string[] Search_FinancialList_aspx ={ "ID", "ID,ParentID,UserID,Name,Type=case Type when '0' then '支出' when '1' then '收入' end,System=case UserID when '0' then '系统' else '用户' end,IsLock=case IsLock when '0' then '正常' when '1' then '解锁' end", "NT_FinancialType where Name like @Name", "order by ID desc" };


        #endregion
        #endregion

        /// <summary>
        /// 获取SQL语句
        /// </summary>
        /// <param name="PageName"></param>
        /// <returns></returns>
        protected string[] GetSqlSentence(string PageName)
        {
            FieldInfo fi = this.GetType().GetField(PageName, BindingFlags.NonPublic | BindingFlags.Instance | BindingFlags.IgnoreCase);
            if (fi == null)
                throw new Exception("没有找到SQL");
            return (string[])fi.GetValue(this);
        }
        /// <summary>
        /// 取得分页
        /// </summary>
        /// <param name="pageCode">分页代码,通常为类名</param>
        /// <param name="pageIndex">当前页码(从１开始，大于总页数，则为最后一页)</param>
        /// <param name="pageSize">每页记录条数</param>
        /// <param name="recordCount">返回记录总数</param>
        /// <param name="pageCount">返回总页数</param>
        /// <param name="conditions">查询条件</param>
        /// <returns></returns>
        DataTable IUtilPage.GetPage(string pageCode, int pageIndex, int pageSize, out int recordCount, out int pageCount, params SqlConditionInfo[] conditions)
        {
            try
            {
                string[] Sql = GetSqlSentence(pageCode);
                string IndexField = Sql[0];
                string AllFields = Sql[1];
                string TablesAndWhere = Sql[2];
                string OrderFields = Sql[3];
                if (conditions != null)
                {
                    foreach (SqlConditionInfo con in conditions)
                    {
                        TablesAndWhere = TablesAndWhere.Replace(con.ParamName, Util.GetStr(con));
                        OrderFields = OrderFields.Replace(con.ParamName, con.ParamValue.ToString());
                    }
                }
                return Pagination.ProcPage(AllFields, TablesAndWhere, IndexField, OrderFields, pageIndex, pageSize, out recordCount, out pageCount);
            }
            catch (SqlException e)
            {
                throw e;
            }
            catch (Exception e)
            {
                throw new Exception("用于分页的SQL语句无效," + e.Message);
            }
        }


        /// <summary>
        /// 找好朋友分页
        /// </summary>
        /// <param name="keywords">标识</param>
        /// <param name="pr">省</param>
        /// <param name="city">市</param>
        /// <param name="beginYear">最小年龄</param>
        /// <param name="endyear">最大年龄</param>
        /// <param name="sex">性别</param>
        /// <param name="tx">是否显示头像</param>
        /// <param name="PageSize"></param>
        /// <param name="RecordCount"></param>
        /// <param name="PageCount"></param>
        /// <param name="SqlCondition"></param>
        /// <returns></returns>
        DataTable IUtilPage.GetUserPage(int pr, int city, int beginYear, int endyear, int sex, int tx, int PageIndex, int PageSize, out int RecordCount, out int PageCount, params SqlConditionInfo[] SqlCondition)
        {
            SqlParameter[] param = new SqlParameter[5];
            param[0] = new SqlParameter("@pr", SqlDbType.Int, 4);
            param[0].Value = pr;
            param[1] = new SqlParameter("@city", SqlDbType.Int, 4);
            param[1].Value = city;
            param[2] = new SqlParameter("@beginYear", SqlDbType.Int, 4);
            param[2].Value = beginYear;
            param[3] = new SqlParameter("@endyear", SqlDbType.Int, 4);
            param[3].Value = endyear;
            param[4] = new SqlParameter("@sex", SqlDbType.Bit, 1);
            param[4].Value = sex;

            string sFilter = " where a.UserID<>'' ";
            string IndexField = "a.UserID";
            string OrderFields = "order by newid()";
            string AllFields = " a.UserID,a.UserName,b.Favourite,b.BirthidayDisplay,b.Birthday,Province=(select Name from NT_Dict_Area where id=a.Province),Photo=(select FilePath from NT_Photo where PhotoID=a.Portrait and PhotoType=0),Sex=(select Sex=case Sex when 0 then '女' when 1 then '男' end),City=(select Name from NT_Dict_Area where id=a.City) ";
            string Condition = " dbo.NT_User a inner join  dbo.NT_UserInfo b on a.UserID=b.UserID ";

            if (pr != 0)
            {
                sFilter += " and Province=@pr ";
            }
            if (city != 0)
            {
                sFilter += " and City=@city ";
            }
            if (beginYear != 0)
            {
                sFilter += " and (datepart(year, getdate()) -datepart(year,b.Birthday))>=@beginYear ";
            }
            if (endyear != 0)
            {
                sFilter += " and (datepart(year, getdate()) -datepart(year,b.Birthday))<=@endyear ";
            }
            if (sex != 2)
            {
                sFilter += " and b.Sex=@sex ";
            }
            if (tx == 1)
            {
                sFilter += " and c.FilePath<>'' ";
                Condition = " dbo.NT_User a inner join  dbo.NT_UserInfo b on a.UserID=b.UserID inner join NT_Photo c on c.PhotoID=a.Portrait and PhotoType=0 ";
                AllFields = " a.UserID,a.UserName,b.Favourite,b.BirthidayDisplay,b.Birthday,Province=(select Name from NT_Dict_Area where id=a.Province),Photo=c.FilePath,Sex=(select Sex=case Sex when 0 then '女' when 1 then '男' end),City=(select Name from NT_Dict_Area where id=a.City) ";
            }
            Condition = Condition + sFilter;
            return DbHelper.ExecutePage(AllFields, Condition, IndexField, OrderFields, PageIndex, PageSize, out RecordCount, out PageCount, param);
        }

        DataTable IUtilPage.GetMinPage(int PageIndex, int PageSize, out int RecordCount, out int PageCount, params SqlConditionInfo[] SqlCondition)
        {
            //            string sql = "SELECT TOP "+Num+" a.ID, a.UserID, b.Content, b.PostTime, b.MType FROM (SELECT UserID, MAX(ID) AS ID FROM NT_MiniBlog WHERE isrec = 1 GROUP BY UserID) a INNER JOIN NT_MiniBlog b ON b.ID = a.ID ORDER BY a.ID DESC";
            string sFilter = " ";
            string IndexField = "a.ID";
            string OrderFields = "ORDER BY a.ID DESC";
            string AllFields = " a.ID, a.UserID, b.Content, b.PostTime, b.MType ";
            string Condition = " (SELECT UserID, MAX(ID) AS ID FROM NT_MiniBlog WHERE isrec = 1 GROUP BY UserID) a INNER JOIN NT_MiniBlog b ON b.ID = a.ID";
            Condition = Condition + sFilter;
            return DbHelper.ExecutePage(AllFields, Condition, IndexField, OrderFields, PageIndex, PageSize, out RecordCount, out PageCount, null);
        }

        DataTable IUtilPage.GetGamePage(string Sort, string Key, int PageIndex, int PageSize, out int RecordCount, out int PageCount, params SqlConditionInfo[] SqlCondition)
        {
            string sFilter = " where 1=1";
            if (Key != "#0")
            {
                sFilter += " and (flashname like '%" + Key + "%' or body like '%" + Key + "%')";
            }

            if (Sort != "#0")
            {
                sFilter += " and classname='" + Sort + "'";
            }
            string IndexField = "ID";
            string OrderFields = "ORDER BY ID DESC";
            string AllFields = " ID,flashname,flashurl,classname,pic,sj,body,tj,hits,hot ";
            string Condition = " NT_Game";
            Condition = Condition + sFilter;
            return DbHelper.ExecutePage(AllFields, Condition, IndexField, OrderFields, PageIndex, PageSize, out RecordCount, out PageCount, null);
        }
        /// <summary>
        /// 地区车友会
        /// </summary>
        /// <param name="province">省份代码</param>
        /// <param name="city">城市代码</param>
        /// <param name="PageIndex"></param>
        /// <param name="PageSize"></param>
        /// <param name="RecordCount"></param>
        /// <param name="PageCount"></param>
        /// <returns></returns>
        DataTable IUtilPage.GetAreaClubPage(int province, int city, int PageIndex, int PageSize, out int RecordCount, out int PageCount)
        {
            string sFilter = " where 1=1";
            if (province != 0)
            {
                sFilter += " and province=" + province + " ";

            }
            if (city != 0)
            {
                sFilter += " and city=" + city + " ";

            }
            string IndexField = "ID";
            string OrderFields = "ORDER BY ID DESC";
            string AllFields = " [id],[clubName],[clubDesc],[clubAnnounce],[ischeck],[GroupID],[privacyFlag],[Province],[City],[CreatTime],[isLock],[isRec],[UserID] ";
            string Condition = " NT_CarClub";
            Condition = Condition + sFilter;
            return DbHelper.ExecutePage(AllFields, Condition, IndexField, OrderFields, PageIndex, PageSize, out RecordCount, out PageCount, null);
        }
        /// <summary>
        /// 取得买卖好友排行
        /// </summary>
        /// <param name="param">参数</param>
        /// <param name="PageSize"></param>
        /// <param name="RecordCount"></param>
        /// <param name="PageCount"></param>
        /// <returns></returns>
        public DataTable GetSellPage(int[] param, int PageIndex, int PageSize, out int RecordCount, out int PageCount)
        {
            string sOrder = " order by newid() desc";
            string sqlfiled = "a.UserID,a.Assets,a.Cash,a.Worth,a.NickName,Whos";
            string condition = " Nt_Sell_Property a";
            string sFilter = " where 1=1";


            switch (param[0])
            {
                case 0: //收益排行榜
                    sOrder = " Order by b.Profit desc ";
                    sqlfiled = "a.UserID,a.Assets,a.Cash,a.Worth,a.NickName,a.Whos,b.Profit";
                    condition = " Nt_Sell_Property a inner join NT_Sell_Profit b on b.UserID=a.UserID ";
                    sFilter += " and datediff(d,b.date,getdate())=1 ";
                    break;
                case 1: //身价排行榜
                    sOrder = " order by a.Worth desc ";
                    break;
                case 2: //资产排行榜
                    sOrder = " order by a.Assets desc ";
                    break;
                case 3: //现金排行榜
                    sOrder = " order by a.Cash desc ";
                    break;
                case 4: //最近活跃
                    sqlfiled = "a.UserID,a.Assets,a.Cash,a.Worth,a.NickName,a.Whos ";
                    condition = " Nt_Sell_Property a inner join (select * from NT_Sell_Action where ActionID IN(SELECT MAX(ActionID) AS Expr1 FROM NT_Sell_Action AS NT_Sell_Action_1 GROUP BY UserID)) as b on b.UserID=a.UserID ";
                    sOrder = " Order by b.ActionTime desc";
                    break;
            }


            switch (param[1])
            {
                case 0: //全部
                    sFilter += " ";
                    break;
                case 1: //男
                    sFilter += " and (select sex from nt_userinfo where userid=a.userid)=1 ";
                    break;
                case 2: //女
                    sFilter += " and (select sex from nt_userinfo where userid=a.userid)=0 ";
                    break;
            }



            switch (param[2])
            {
                case 0: //我和好友
                    sFilter += " and (a.UserID=" + param[3] + " or exists (Select FriendID From NT_Friend Where UserID=" + param[3] + " and FriendID=a.UserID )) ";
                    break;
                case 1: //我买得起的
                    sFilter += " and  a.Worth+a.Worth*" + SellFriendConfig.TaxRate + "< (select Cash from Nt_Sell_Property where UserID=" + param[3] + ") ";
                    break;
                case 2: //所有人
                    sFilter += "  ";
                    break;
            }

            condition += sFilter;
            return DbHelper.ExecutePage(sqlfiled, condition, "a.UserID", sOrder, PageIndex, PageSize, out RecordCount, out PageCount, null);
        }
    }
}
