//===========================================================
//==               (c)2008  NETSNS 1.0                     ==
//==            website:www.aspxcms.com                    ==
//==         qq:6458450,Email:qwsf01115@163.com            ==
//==               Code By Xi.Deng                         ==
//===========================================================
using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Common;
using System.Data.SqlClient;
using NetSNS.DALProfile;
using NetSNS.DALFactory;
using NetSNS.Model;
using NetSNS.Config;

namespace NetSNS.DALSQLServer
{
    /// <summary>
    /// ͶƱ
    /// </summary>
    public class Vote : DbBase, IVote
    {
        /// <summary>
        /// ͶƱ
        /// </summary>
        /// <param name="Info">ͶƱʵ</param>
        /// <returns>ӳɹͶƱ</returns>
        public int Add(VoteInfo Info)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();
            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                SqlParameter[] param = getParameters(Info);
                string Sql = "Insert Into [NT_Vote]([Title],[Intro],[UserID],[AddTime],[Mode],[EndTime],[JCnt],[VCnt],[IsFriend]) " +
                             "Values(@Title,@Intro,@UserID,@AddTime,@Mode,@EndTime,@JCnt,@VCnt,@IsFriend);" +
                             "Select @@IDENTITY;";
                int id = Convert.ToInt32(DbHelper.ExecuteScalar(trans, CommandType.Text, Sql, param));

                UserLog(trans, EnumUserAction.AddVote, Info.UserID, "һͶƱ", id);
                trans.Commit();

                return id;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// ɾͶƱ
        /// </summary>
        /// <param name="VoteID">ͶƱ</param>
        /// <param name="UserID">û</param>
        /// <returns>ɾɹ1</returns>
        public int Del(int VoteID, int UserID)
        {
            SqlConnection Conn = new SqlConnection(DBConfig.CnString);
            Conn.Open();
            SqlTransaction trans = Conn.BeginTransaction();
            try
            {
                string Sql = "Delete From [NT_Vote] Where [UserID]=" + UserID + " And [ID]=" + VoteID;
                int n = Convert.ToInt32(DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null));

                if (n == 1)
                {
                    Sql = "Delete From [NT_VoteOption] Where [VoteID]=" + VoteID;
                    DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);

                    Sql = "Delete From [NT_ToVote] Where [VoteID]=" + VoteID;
                    DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);

                    Sql = "Delete From [NT_VoteComm] Where [VoteID]=" + VoteID;
                    DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);

                    Sql = "Delete From [NT_DisVote] Where [VoteID]=" + VoteID;
                    DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);

                    //ɾ̬
                    Sql = "Update [NT_UserLog] " +
                          "Set " +
                          "[IsLock]=" + (int)EnumIsLock.Lock + " " +
                          "Where " +
                          "([CorrespondInfo]=" + VoteID + " And " +
                          "([ActionType]=" + (int)EnumUserAction.AddVote + " Or [ActionType]=" + (int)EnumUserAction.ToVote + ")) ";
                    DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);

                    //ɾ֪ͨ
                    Sql = "Delete From [NT_Notice] Where " +
                          "[MsgType]=" + (int)EnumNotifyType.ToVote + "And [Correspond]=" + VoteID;
                    DbHelper.ExecuteNonQuery(trans, CommandType.Text, Sql, null);
                }
                trans.Commit();
                return n;
            }
            catch (SqlException e)
            {
                trans.Rollback();
                throw e;
            }
            finally
            {
                if (Conn.State == ConnectionState.Open)
                    Conn.Close();
            }
        }

        /// <summary>
        /// Ӳμ
        /// </summary>
        /// <param name="ID">ͶƱ</param>
        /// <returns>ӳɹ1</returns>
        public int AddJCnt(int ID)
        {
            string Sql = "Update [NT_Vote] Set [JCnt]=[JCnt]+1 Where [ID]=" + ID;
            return Convert.ToInt32(DbHelper.ExecuteNonQuery(CommandType.Text, Sql, null));
        }

        /// <summary>
        /// ûӵͶƱ
        /// </summary>
        /// <param name="UserID">ͶƱ</param>
        /// <returns>ؼ¼</returns>
        public int MyAddCnt(int UserID)
        {
            string Sql = "Select Count([ID]) From [NT_Vote] Where [UserID]=" + UserID;
            return Convert.ToInt32(DbHelper.ExecuteScalar(CommandType.Text, Sql, null));
        }

        /// <summary>
        /// ͶƱϢ
        /// </summary>
        /// <param name="ID">ͶƱ</param>
        /// <returns>ͶƱʵ</returns>
        public VoteInfo Info(int ID)
        {
            VoteInfo info = new VoteInfo();
            string Sql = "Select [ID],[Title],[Intro]," +
                         "[UserID],[AddTime],[Mode],[EndTime],[JCnt],[VCnt],[IsFriend] " +
                         "From " +
                         "[NT_Vote] " +
                         "Where [ID]=" + ID;
            IDataReader rd = DbHelper.ExecuteReader(CommandType.Text, Sql, null);
            if (rd.Read())
            {
                info.ID = Convert.ToInt32(rd["ID"].ToString());
                if (rd["Title"] != DBNull.Value) info.Title = rd["Title"].ToString();
                if (rd["Intro"] != DBNull.Value) info.Intro = rd["Intro"].ToString();
                info.UserID = Convert.ToInt32(rd["UserID"].ToString());
                info.AddTime = Convert.ToDateTime(rd["AddTime"].ToString());
                info.Mode = Convert.ToInt32(rd["Mode"].ToString());
                info.EndTime = Convert.ToDateTime(rd["EndTime"].ToString());
                info.JCnt = Convert.ToInt32(rd["JCnt"].ToString());
                info.VCnt = Convert.ToInt32(rd["VCnt"].ToString());
                info.IsFriend = Convert.ToInt32(rd["IsFriend"].ToString());
            }
            rd.Close();
            return info;
        }

        /// <summary>
        /// ͶƱб
        /// </summary>
        /// <param name="Num"></param>
        /// <param name="UserID">Ա</param>
        /// <returns>б</returns>
        public DataTable FriendNewVoteList(int Num, int UserID)
        {
            string Sql = "Select Top " + Num + " " +
                         "a.ID,a.Title,a.Intro,a.UserID,a.AddTime,a.Mode,a.EndTime,a.JCnt,b.UserName,c.FilePath " +
                         "From NT_Vote AS a " +
                         "INNER JOIN NT_User AS b ON a.[userid]=b.[userid] " +
                         "Left Join Nt_Photo as c On b.Portrait=c.PhotoID And c.IsLock=0 " +
                         "Where " +
                         "a.UserID In(Select FriendID From NT_Friend Where UserID=" + UserID + ") " +
                         "And a.ID Not In(Select VoteID From Nt_DisVote Where UserID=" + UserID + ") " +
                         "And a.ID Not In(Select VoteID From NT_ToVote Where UserID=" + UserID + ") " +
                         "Order By a.AddTime Desc";
            return DbHelper.ExecuteTable(CommandType.Text, Sql, null);
        }

        /// <summary>
        /// μӵͶƱб
        /// </summary>
        /// <param name="Num"></param>
        /// <param name="UserID">Ա</param>
        /// <returns>б</returns>
        public DataTable FriendNewJoinVoteList(int Num, int UserID)
        {
            string Sql = "Select Top " + Num + " " +
                         "a.ID,a.Title,c.UserID,c.UserName " +
                         "From NT_Vote AS a INNER JOIN Nt_ToVote AS b ON a.[ID]=b.[VoteID]  " +
                         "Inner Join NT_User  As c On b.userid=c.userid " +
                         "Where exists(Select FriendID From NT_Friend Where UserID=" + UserID + " and FriendID=c.UserID) " +
                         "Order By b.ID Desc";
            return DbHelper.ExecuteTable(CommandType.Text, Sql, null);
        }

        /// <summary>
        /// ͶƱб
        /// </summary>
        /// <param name="Num"></param>
        /// <returns>б</returns>
        public DataTable HotVote(int Num)
        {
            string Sql = "Select Top " + Num + " " +
                         "a.ID,a.Title,a.UserID,b.UserName " +
                         "From NT_Vote AS a INNER JOIN NT_User AS b ON a.[userid]=b.[userid] " +
                         "Order By a.AddTime Desc,a.JCnt Desc";
            return DbHelper.ExecuteTable(CommandType.Text, Sql, null);
        }

        /// <summary>
        /// ҷͶƱб
        /// </summary>
        /// <param name="Num"></param>
        /// <param name="UserID">Ա</param>
        /// <returns>б</returns>
        public DataTable MyAddVote(int Num, int UserID)
        {
            string Sql = "Select Top " + Num + " " +
                         "ID,Title,Intro,Mode,JCnt,AddTime " +
                         "From NT_Vote " +
                         "Where UserID=" + UserID + " " +
                         "Order By AddTime Desc";
            return DbHelper.ExecuteTable(CommandType.Text, Sql, null);
        }

        /// <summary>
        /// ҷͶƱб(ųǰͶƱ)
        /// </summary>
        /// <param name="Num"></param>
        /// <param name="UserID">Ա</param>
        /// <param name="VoteID">Ա</param>
        /// <returns>б</returns>
        public DataTable MyAddVote(int Num, int UserID, int VoteID)
        {
            string Sql = "Select Top " + Num + " " +
                         "ID,Title,Intro,Mode,JCnt,AddTime " +
                         "From NT_Vote " +
                         "Where UserID=" + UserID + " And ID!=" + VoteID + " " +
                         "Order By AddTime Desc";
            return DbHelper.ExecuteTable(CommandType.Text, Sql, null);
        }


        /// <summary>
        /// ҲͶƱб
        /// </summary>
        /// <param name="Num"></param>
        /// <param name="UserID">Ա</param>
        /// <returns>б</returns>
        public DataTable MyJoinVote(int Num, int UserID)
        {
            string Sql = "Select Top " + Num + " " +
                         "a.ID,a.Title,a.Intro,a.Mode,a.JCnt " +
                         "From NT_Vote As a Inner Join Nt_ToVote As b On a.ID=b.VoteID " +
                         "Where b.UserID=" + UserID + " " +
                         "Order By b.ID Desc";
            return DbHelper.ExecuteTable(CommandType.Text, Sql, null);
        }

        /// <summary>
        /// ȡͶƱѡ
        /// </summary>
        /// <param name="UserID">Ա</param>
        /// <param name="VoteID">ͶƱ</param>
        /// <returns>ݱ</returns>
        public DataTable FriendVote(int UserID, int VoteID)
        {
            string Sql = "Select a.ID,a.UserID,a.VoteID,a.OptionID,b.UserName,c.FilePath From Nt_ToVote As a " +
                         "Inner Join NT_User as b on a.UserID=b.UserID " +
                         "Left Join Nt_Photo as c On b.Portrait=c.PhotoID And c.IsLock=0 " +
                         "Where a.UserID In(Select FriendID From NT_Friend Where UserID=" + UserID + ") And a.VoteID=" + VoteID + " " +
                         "Order By a.ID Desc";
            return DbHelper.ExecuteTable(CommandType.Text, Sql, null);
        }

        /// <summary>
        /// ͶƱѡ
        /// </summary>
        /// <param name="UserID">Ա</param>
        /// <param name="VoteID">ͶƱ</param>
        /// <returns>ݱ</returns>
        public DataTable OtherVote(int UserID, int VoteID)
        {
            string Sql = "Select a.ID,a.UserID,a.VoteID,a.OptionID,b.UserName,c.FilePath From Nt_ToVote As a " +
                         "Inner Join NT_User as b on a.UserID=b.UserID " +
                         "Left Join Nt_Photo as c On b.Portrait=c.PhotoID And c.IsLock=0 " +
                         "Where a.UserID Not In(Select FriendID From NT_Friend Where UserID=" + UserID + ") " +
                         "And a.UserID!=" + UserID + " And VoteID=" + VoteID + " " +
                         "Order By a.ID Desc";
            return DbHelper.ExecuteTable(CommandType.Text, Sql, null);
        }

        /// <summary>
        /// 캯
        /// </summary>
        /// <param name="Info">ͶƱʵ</param>
        /// <returns>SQL</returns>
        private SqlParameter[] getParameters(VoteInfo Info)
        {
            SqlParameter[] param = new SqlParameter[10];

            param[0] = new SqlParameter("@ID", SqlDbType.Int, 4);
            param[0].Value = Info.ID;
            param[1] = new SqlParameter("@Title", SqlDbType.NVarChar, 100);
            param[1].Value = Info.Title;
            param[2] = new SqlParameter("@Intro", SqlDbType.NVarChar, 200);
            param[2].Value = Info.Intro;

            param[3] = new SqlParameter("@UserID", SqlDbType.Int, 4);
            param[3].Value = Info.UserID;
            param[4] = new SqlParameter("@AddTime", SqlDbType.DateTime, 8);
            param[4].Value = Info.AddTime;
            param[5] = new SqlParameter("@Mode", SqlDbType.Int, 4);
            param[5].Value = Info.Mode;

            param[6] = new SqlParameter("@EndTime", SqlDbType.DateTime, 8);
            param[6].Value = Info.EndTime;
            param[7] = new SqlParameter("@JCnt", SqlDbType.Int, 4);
            param[7].Value = Info.JCnt;
            param[8] = new SqlParameter("@VCnt", SqlDbType.Int, 4);
            param[8].Value = Info.VCnt;

            param[9] = new SqlParameter("@IsFriend", SqlDbType.Int, 4);
            param[9].Value = Info.IsFriend;
            return param;
        }
    }
}
