using System;
using System.Collections;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.ComponentModel;
using NetSNS.Common;

namespace NetSNS.Web.UI.Control
{
    [DefaultProperty("Text"), ToolboxData("<{0}:NTTextBox runat=server></{0}:NTTextBox>"), Designer("System.Web.UI.Design.WebControls.PreviewControlDesigner, System.Design, Version=2.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
    public class NTTextBox : System.Web.UI.WebControls.TextBox 
    {
        /// <summary>
        /// 캯
        /// </summary>
        public NTTextBox(): base()
        {
            base.Attributes.Add("onfocus", "this.className='" + _onFocusCss + "';");
            base.Attributes.Add("onblur", "this.className='" + _onBlurCss + "';");
            base.CssClass = _Class;
        }

        private string _onFocusCss = "colorfocus";
        [Bindable(true), Category("Appearance"), Description("ıȡʱ¼")]
        /// <summary>
        /// ȡʱʽ
        /// </summary>
        public string onFocus
        {
            get { return _onFocusCss; }
            set { _onFocusCss = value; }
        }

        private string _onBlurCss = "colorblur";
        [Bindable(true), Category("Appearance"), Description("ıʧȥʱ¼")]
        /// <summary>
        /// ʧȥʱʽ
        /// </summary>
        public string onBlurCss
        {
            get { return _onBlurCss; }
            set { _onBlurCss = value; }
        }

        private string _Class = "colorblur";
        [Bindable(true), Category("Appearance"), DefaultValue("")]
        /// <summary>
        /// ʽ
        /// </summary>
        public string Class
        {
            get { return _Class; }
            set { _Class = value; }
        }

        /// <summary>
        /// ȡĿؼID(ύť)
        /// </summary>
        [Bindable(true), Category("Appearance"), DefaultValue("")]
        public string SetFocusButtonID
        {
            get
            {
                object o = ViewState[this.ClientID + "_SetFocusButtonID"];
                return (o == null) ? "" : o.ToString();
            }
            set
            {
                ViewState[this.ClientID + "_SetFocusButtonID"] = value;
                if (value != "")
                {
                    this.Attributes.Add("onkeydown", "if(event.keyCode==13){document.getElementById('" + value + "').focus();}");
                }
            }
        }



    }
}
