//======================================================
//==     (c)2008 ǼƼ by NeTCMS v1.0              ==
//==          Forum:bbs.aspxcms.com                   ==
//==         Website:www.aspxcms.com                  ==
//======================================================
using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;
using System.Web;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using NetSNS.Config;
using NetSNS.Model;
using System.IO;
using NetSNS.Common;
namespace NetSNS.Web.UI.Page
{
    public class BasePage : System.Web.UI.Page
    {
        private long dur;

        protected const int PAGESZ = 20;
        /// <summary>
        /// ¼û
        /// </summary>
        protected HttpCookie cookieToken;

        /// <summary>
        /// ƤCookies
        /// </summary>
        protected HttpCookie skinStyle;

        /// <summary>
        /// ǰ¼ûID
        /// </summary>
        protected int UserID;

        /// <summary>
        /// ǰ¼û
        /// </summary>
        protected string UserName;

        /// <summary>
        /// ǰ¼ûͷַ
        /// </summary>
        protected string UserPortrait;

        /// 캯
        /// </summary>
        public BasePage()
        {
            this.Load += new EventHandler(BasePage_Load);
            this.LoadComplete += new EventHandler(BasePage_LoadComplete);
            //this.LoadComplete += new EventHandler(UserPage_LoadComplete);
        }

        private void BasePage_LoadComplete(object sender, EventArgs e)
        {
            try
            {
                this.Page.Title = this.Page.Title + "|" + UiConfig.PageTitle;
            }
            catch
            {
                System.Web.UI.HtmlControls.HtmlGenericControl control = (System.Web.UI.HtmlControls.HtmlGenericControl)this.FindControl("pagetitle");
                if (control != null)
                {
                    try
                    {
                        control.InnerText = control.InnerText + "|" + UiConfig.PageTitle;
                    }
                    catch { }
                }
            }
        }

        /// <summary>
        /// LOAD¼
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void BasePage_Load(object sender, EventArgs e)
        {
            dur = DateTime.Now.Ticks;
        }



        protected void PageRight(string RightMsg, string Url)
        {
            PageRight(RightMsg, Url, false);
        }

        protected void PageRight(string ErrMsg, string Url, bool RetrunUrl)
        {
            WebHint.ShowRight(ErrMsg, Url, RetrunUrl);
        }

        protected void PageError(string ErrMsg, string Url)
        {
            PageError(ErrMsg, Url, false);
        }

        protected void PageError(string ErrMsg, string Url, bool RetrunUrl)
        {
            WebHint.ShowError(ErrMsg, Url, RetrunUrl);
        }
        /// <summary>
        /// Ѻôʾ
        /// </summary>
        /// <param name="ErrMsg">Ϣ</param>
        /// <param name="ReturnText">ı</param>
        /// <param name="ReturnURL">URL</param>
        protected void PageFriendlyError(string ErrMsg,string ReturnText,string ReturnURL)
        {
            WebHint.PageFriendlyRender(ErrMsg, ReturnText, ReturnURL);
        }

        /// <summary>
        /// ˳
        /// </summary>
        protected virtual void Logout()
        {
            Context.Session.Remove("SITEINFO");
        }

        /// <summary>
        /// ִһJS
        /// </summary>
        /// <param name="sentence">Ҫִе</param>
        protected void ExecuteJs(string sentence)
        {
            Context.Response.Write("<script language=\"javascript\" type=\"text/javascript\">");
            Context.Response.Write(sentence);
            Context.Response.Write("</script>");
        }

        /// <summary>
        /// Ƿ¼
        /// </summary>
        protected virtual void CheckLogin()
        { }

        /// <summary>
        /// ¼״̬
        /// </summary>
        /// <param name="state"></param>
        protected void CheckResultShow(EnumLoginState loginState, string backUrl)
        {
            string ErrorMsg = string.Empty;
            int isAdminReturn = 0;
            switch (loginState)
            {
                case EnumLoginState.Err_IPLimited:
                    ErrorMsg = "IP[" + NetSNS.Common.Public.GetClientIP() + "]ƣܵ½";
                    isAdminReturn = 2;
                    break;
                case EnumLoginState.Err_Locked:
                    ErrorMsg = "Ѿ";
                    isAdminReturn = 2;
                    break;
                case EnumLoginState.Err_UnActivation:
                    ErrorMsg = "ûͨʼܵ½ϵͳ";
                    isAdminReturn = 0;
                    break;
                case EnumLoginState.Err_TimeOut:
                    Context.Response.Redirect(backUrl);
                    break;
                case EnumLoginState.Err_NoAuthority:
                    ErrorMsg = "ûдĲȨޣ";
                    isAdminReturn = 1;
                    break;
                case EnumLoginState.Err_DbException:
                    ErrorMsg = "ϵͳ󡣳ԭǣ1.ݿͨʧܣ2.ݿַȷ3.ݿⷢ쳣";
                    isAdminReturn = 2;
                    break;
                case EnumLoginState.Err_DurativeLogError:
                    ErrorMsg = "½Ѿ";
                    isAdminReturn = 0;
                    break;
                case EnumLoginState.Err_NameOrPwdError:
                    ErrorMsg = "ûڻ";
                    isAdminReturn = 2;
                    break;
                case EnumLoginState.Err_GroupExpire:
                    ErrorMsg = "ʺѹ";
                    isAdminReturn = 0;
                    break;
                case EnumLoginState.Err_NotAdmin:
                    ErrorMsg = "ǸǹԱĲѾ¼<li>IP[" + NetSNS.Common.Public.GetClientIP() + "]ѱ¼</li>";
                    isAdminReturn = 1;
                    break;
                case EnumLoginState.Succeed:
                    return;
                default:
                    ErrorMsg = "쳣" + loginState.ToString();
                    isAdminReturn = 2;
                    break;
            }

            PageError(ErrorMsg, backUrl, true);
        }

        /// <summary>
        /// ʾϢ,ִֹ
        /// </summary>
        /// <param name="ErrInfo">ʾϢ</param>
        /// <param name="DivID"></param>
        protected void ShowErr(string ErrInfo, HtmlContainerControl DivID)
        {
            DivID.Style.Value = "display:";
            DivID.InnerHtml = ErrInfo;
        }

        /// <summary>
        /// ʾɹϢ
        /// </summary>
        /// <param name="SccInfo">ɹʾϢ</param>
        /// <param name="DivID"></param>
        protected void ShowSuc(string SucInfo, HtmlContainerControl DivID)
        {
            DivID.Style.Value = "display:";
            DivID.InnerHtml = SucInfo;
        }

        /// <summary>
        /// ȡԭʼƬ·
        /// </summary>
        /// <param name="filename">ļ</param>
        /// <returns></returns>
        protected string GetOrgPic(string filename)
        {
            if (string.IsNullOrEmpty(filename))
                return GetOrgPic("default.jpg");
            string dir = "";
            dir += PicConfig.PhotoServer + "/";
            dir += PicConfig.PhotoRoot;
            string rvalue = filename;
            if (dir.StartsWith("~/"))
            {
                dir = dir.Substring(2);
            }
            rvalue = dir + "/" + filename;
            if (rvalue.StartsWith("http") || rvalue.StartsWith("/"))
            {
                return rvalue;
            }
            if (PicConfig.PhotoServer != "~"&&PicConfig.PhotoServer != "")
            {
                return PicConfig.PhotoServer + "/" + rvalue;
            }
            return "/" + rvalue;
        }
        /// <summary>
        /// ȡԭʼͷ·
        /// </summary>
        /// <param name="filename">ļ</param>
        /// <returns></returns>
        protected string GetOrgHeadPic(string filename)
        {
            if (string.IsNullOrEmpty(filename) || filename.Trim() == "")
                return GetOrgHeadPic("default.jpg");
            string dir = "";
            dir += PicConfig.ProtraitServer + "/";
            dir += PicConfig.ProtraitRoot;
            if (dir.StartsWith("~/"))
            {
                dir = dir.Substring(2);
            }
            string rvalue = filename;
            rvalue = dir + "/" + filename;
            if (rvalue.StartsWith("http") || rvalue.StartsWith("/"))
            {
                return rvalue;
            }
            if (PicConfig.ProtraitServer != "~"&&PicConfig.ProtraitServer != "")
            {
                return PicConfig.ProtraitServer + "/" + rvalue;
            }
            return "/" + rvalue;
        }
        /// <summary>
        /// תƬ·Ϊͼ·
        /// </summary>
        /// <param name="orgPicPath">ԭʼ·</param>
        /// <param name="name">С</param>
        /// <returns></returns>
        protected string GetSmallPic(string orgPicPath, int size)
        {
            if (string.IsNullOrEmpty(orgPicPath) || orgPicPath.Trim() == "")
                return GetSmallPic("default.jpg", size);
            string name = size.ToString();
            Dictionary<string, PicConfigInfo> _photo = PicConfig.Photo;
            if (string.IsNullOrEmpty(orgPicPath))
            {
                return "";
            }
            if (orgPicPath.StartsWith("/images"))
            {
                return orgPicPath.Substring(0);
            }
            string rvalue = orgPicPath;
            if (_photo[name].Directory.EndsWith("/"))
            {
                rvalue = _photo[name].Directory + rvalue;
            }
            else
            {
                rvalue = _photo[name].Directory + "/" + rvalue;
            }
            if (rvalue.StartsWith("http") || rvalue.StartsWith("/"))
            {
                return rvalue;
            }
            if (PicConfig.PhotoServer != "~"&&PicConfig.PhotoServer != "")
            {
                return PicConfig.PhotoServer + "/" + rvalue;
            }
            return "/" + rvalue;
        }
        /// <summary>
        /// תͷ·Ϊ·
        /// </summary>
        /// <param name="orgPicPath">ԭʼ·</param>
        /// <param name="size">С</param>
        /// <returns></returns>
        public string GetSmallHeadPic(object orgHeadPicPath, int size, int userid)
        {
            if (orgHeadPicPath == null || orgHeadPicPath == DBNull.Value)
                return GetSmallHeadPic((object)"default.jpg", size, userid);
            if (orgHeadPicPath.ToString().Trim() == "")
                return GetSmallHeadPic((object)"default.jpg", size, userid);
            string name = size.ToString();
            Dictionary<string, PicConfigInfo> _portrait = PicConfig.Portrait;
            string rvalue = string.Empty;
            try
            {
               rvalue = (string)orgHeadPicPath;
            }
            catch { }
            if (rvalue.Trim() == string.Empty)
                return string.Empty;
            if (_portrait[name].Directory.EndsWith("/"))
            {
                rvalue = _portrait[name].Directory + rvalue;
            }
            else
            {
                rvalue = _portrait[name].Directory + "/" + rvalue;
            }
            if (rvalue.StartsWith("http") || rvalue.StartsWith("/"))
            {
                return rvalue;
            }
            if (PicConfig.ProtraitServer != "~"&&PicConfig.ProtraitServer != "")
            {
                return PicConfig.ProtraitServer + "/" + rvalue;
            }
            if (rvalue.IndexOf("default.jpg") != -1)
            {
                NetSNS.BLL.User.User u = new NetSNS.BLL.User.User();
                UserBasicInfo ubi = u.GetUserBasic(userid);
                if (ubi.Sex == 0)
                {
                    rvalue = rvalue.Replace("default.jpg", "default_1.jpg");
                }
            }
            return "/" + rvalue;
        }
        /// <summary>
        /// ȡͷ
        /// </summary>
        /// <param name="userid">ûid</param>
        /// <param name="size">ͼ</param>
        /// <returns>ͷ·</returns>
        protected string GetHeadImage(int userid, int size)
        {
            string dstr="default.jpg";
            NetSNS.BLL.User.User u = new NetSNS.BLL.User.User();
            UserInfo ui = u.GetUserInfo(userid);            
            NetSNS.BLL.User.Photo p = new NetSNS.BLL.User.Photo();
            PhotoInfo pi = p.Info(ui.Portrait);
            string s = GetSmallHeadPic(pi.FilePath, size, userid);
            if (s.IndexOf(dstr) != -1)
            {
                UserBasicInfo ubi = u.GetUserBasic(userid);
                if (ubi.Sex == 0)
                {
                    s = s.Replace(dstr, "default_1.jpg");
                }
            }
            return s;
        }
        /// <summary>
        /// ȡͷ
        /// </summary>
        /// <param name="userid">ûid</param>
        /// <returns>ͷ·</returns>
        protected string GetHeadImage(int userid)
        {
            return GetHeadImage(userid, 1);
        }
        /// <summary>
        /// ȡͷ
        /// </summary>
        /// <param name="userid">ûid</param>
        /// <returns>ͷ·</returns>
        protected string GetHeadImage(object userid)
        {
            if (userid == null || userid == DBNull.Value)
                return GetSmallHeadPic(null, 1, 0);
            return GetHeadImage(Convert.ToInt32(userid));
        }
        /// <summary>
        /// ȡԼСȷͷ
        /// </summary>
        /// <returns>ͷ·</returns>
        protected string GetHeadImage()
        {
            return GetSmallHeadPic(UserPortrait, 1, this.UserID);
        }

        /// <summary>
        /// ȡͷ·
        /// </summary>
        /// <param name="userid">ûid</param>
        /// <returns>ͷ·</returns>
        protected string GetHeadPath(int userid)
        {
            NetSNS.BLL.User.User u = new NetSNS.BLL.User.User();
            UserInfo ui = u.GetUserInfo(userid);
            NetSNS.BLL.User.Photo p = new NetSNS.BLL.User.Photo();
            PhotoInfo pi = p.Info(ui.Portrait);
            return pi.FilePath;
        }
        /// <summary>
        /// ȡͷ·
        /// </summary>
        /// <param name="filepath">ͷ·</param>
        /// <returns></returns>
        protected string GetGroupHead(string filepath)
        {
            if (string.IsNullOrEmpty(filepath))
            {
                return "/images/grouppic.jpg";
            }
            if (PicConfig.GroupHeadServer != "~" && PicConfig.GroupHeadServer != "")
            {
                return PicConfig.GroupHeadServer + filepath;
            }
            return filepath;
        }
        /// <summary>
        /// ȡͷ·
        /// </summary>
        /// <param name="filepath">ͷ·</param>
        /// <returns></returns>
        protected string GetGroupHead(object filepath)
        {
            string fstr = string.Empty;
            try
            {
                fstr = Convert.ToString(filepath);
            }
            catch { }
            return GetGroupHead(Convert.ToString(filepath));
        }
        /// <summary>
        /// ֤COOKIEǷ
        /// </summary>
        /// <returns></returns>
        protected bool Expired()
        {
            HttpCookie cookieToken = Context.Request.Cookies["SnsUserToken"];
            int UserID = 0;
            if (cookieToken == null || cookieToken["token"] == null)
                return true;
            cookieToken.Domain = UiConfig.CookieDomain;
            string userCookie = cookieToken["token"];
            string desstr = NetSNS.Common.DES.Decrypt(userCookie, SecretConfig.UserKey, SecretConfig.UserIV);
            string[] userInfo = desstr.Split(SecretConfig.UserSeparator);
            EnumLoginState state = EnumLoginState.Err_TimeOut;
            if (userInfo.Length == 3)
            {
                UserID = int.Parse(userInfo[0]);
                string pass = userInfo[1];
                string cookip = userInfo[2];
                if (cookip != Public.GetClientIP())
                {
                    state = EnumLoginState.Err_TimeOut;
                }
                else
                {
                    NetSNS.BLL.User.User us = new NetSNS.BLL.User.User();
                    state = us.CheckLogin(UserID, pass);
                }
            }
            if (state == EnumLoginState.Succeed)
            {
                return false;
            }
            else
            {
                return true;
            }
        }
        /// <summary>
        /// ȡõǰ½ûID
        /// </summary>
        /// <returns></returns>
        static public int GetCurrentUserID()
        {
            int UserID = 0;
            HttpCookie cookieToken = HttpContext.Current.Request.Cookies["SnsUserToken"];
            if (cookieToken == null || cookieToken["token"] == null || cookieToken["token"] == "")
                return UserID;          
            string userCookie = cookieToken["token"];
            string desstr = NetSNS.Common.DES.Decrypt(userCookie, SecretConfig.UserKey, SecretConfig.UserIV);
            string[] userInfo = desstr.Split(SecretConfig.UserSeparator);
            EnumLoginState state = EnumLoginState.Err_TimeOut;
            if (userInfo.Length == 3)
            {
                UserID = int.Parse(userInfo[0]);
                string pass = userInfo[1];                
                NetSNS.BLL.User.User us = new NetSNS.BLL.User.User();
                state = us.CheckLogin(UserID, pass);                
            }
            if (state == EnumLoginState.Succeed)
            {
                return UserID;
            }
            else
            {
                return 0;
            }
        }
        /// <summary>
        /// ȡõǰ½ûID
        /// </summary>
        /// <returns></returns>
        protected int GetUserID()
        {
            return GetCurrentUserID();
        }
        /// <summary>
        /// ˽Ƿ鿴
        /// </summary>
        /// <param name="ept">˽</param>
        /// <param name="userid">ûID</param>
        /// <param name="visitUserid">ʵûID</param>
        /// <returns>true|false</returns>
        protected bool PrivacyAvailable(EnumPrivacyType ept, int userid, int visitUserid)
        {
            if (IsAdmin())
                return true;
            if (userid == visitUserid)
                return true;
            BLL.User.User u = new BLL.User.User();
            BLL.User.Friend fr = new NetSNS.BLL.User.Friend();
            PrivacyInfo pri = u.GetPrivacy(visitUserid);
            switch (ept)
            {
                case EnumPrivacyType.Educate:
                    switch (pri.PrivacyEducate)
                    {
                        case EnumPrivacy.ForFriends:
                            if (fr.IsFriends(userid, visitUserid))
                                return true;
                            break;
                        case EnumPrivacy.ForNetWorkAndFriends:
                            if (fr.IsInSameNetwork(userid, visitUserid))
                                return true;
                            break;
                        case EnumPrivacy.ForOwner:
                            if (userid == visitUserid)
                                return true;
                            break;
                        case EnumPrivacy.ForWholeSite:
                            return true;
                    }
                    break;
                case EnumPrivacyType.Favourite:
                    switch (pri.PrivacyFavourite)
                    {
                        case EnumPrivacy.ForFriends:
                            if (fr.IsFriends(userid, visitUserid))
                                return true;
                            break;
                        case EnumPrivacy.ForNetWorkAndFriends:
                            if (fr.IsInSameNetwork(userid, visitUserid))
                                return true;
                            break;
                        case EnumPrivacy.ForOwner:
                            if (userid == visitUserid)
                                return true;
                            break;
                        case EnumPrivacy.ForWholeSite:
                            return true;
                    }
                    break;
                case EnumPrivacyType.Friends:
                    switch (pri.PrivacyFriends)
                    {
                        case EnumPrivacy.ForFriends:
                            if (fr.IsFriends(userid, visitUserid))
                                return true;
                            break;
                        case EnumPrivacy.ForNetWorkAndFriends:
                            if (fr.IsInSameNetwork(userid, visitUserid))
                                return true;
                            break;
                        case EnumPrivacy.ForOwner:
                            if (userid == visitUserid)
                                return true;
                            break;
                        case EnumPrivacy.ForWholeSite:
                            return true;
                    }
                    break;
                case EnumPrivacyType.Group:
                    switch (pri.PrivacyGroup)
                    {
                        case EnumPrivacy.ForFriends:
                            if (fr.IsFriends(userid, visitUserid))
                                return true;
                            break;
                        case EnumPrivacy.ForNetWorkAndFriends:
                            if (fr.IsInSameNetwork(userid, visitUserid))
                                return true;
                            break;
                        case EnumPrivacy.ForOwner:
                            if (userid == visitUserid)
                                return true;
                            break;
                        case EnumPrivacy.ForWholeSite:
                            return true;
                    }
                    break;
                case EnumPrivacyType.Lasso:
                    switch (pri.PrivacyLasso)
                    {
                        case EnumPrivacy.ForFriends:
                            if (fr.IsFriends(userid, visitUserid))
                                return true;
                            break;
                        case EnumPrivacy.ForNetWorkAndFriends:
                            if (fr.IsInSameNetwork(userid, visitUserid))
                                return true;
                            break;
                        case EnumPrivacy.ForOwner:
                            if (userid == visitUserid)
                                return true;
                            break;
                        case EnumPrivacy.ForWholeSite:
                            return true;
                    }
                    break;
                case EnumPrivacyType.LeaveWord:
                    switch (pri.PrivacyLeaveWord)
                    {
                        case EnumPrivacy.ForFriends:
                            if (fr.IsFriends(userid, visitUserid))
                                return true;
                            break;
                        case EnumPrivacy.ForNetWorkAndFriends:
                            if (fr.IsInSameNetwork(userid, visitUserid))
                                return true;
                            break;
                        case EnumPrivacy.ForOwner:
                            if (userid == visitUserid)
                                return true;
                            break;
                        case EnumPrivacy.ForWholeSite:
                            return true;
                    }
                    break;
                case EnumPrivacyType.MiniBlog:
                    switch (pri.PrivacyMiniBlog)
                    {
                        case EnumPrivacy.ForFriends:
                            if (fr.IsFriends(userid, visitUserid))
                                return true;
                            break;
                        case EnumPrivacy.ForNetWorkAndFriends:
                            if (fr.IsInSameNetwork(userid, visitUserid))
                                return true;
                            break;
                        case EnumPrivacy.ForOwner:
                            if (userid == visitUserid)
                                return true;
                            break;
                        case EnumPrivacy.ForWholeSite:
                            return true;
                    }
                    break;
                case EnumPrivacyType.Movies:
                    switch (pri.PrivacyMovies)
                    {
                        case EnumPrivacy.ForFriends:
                            if (fr.IsFriends(userid, visitUserid))
                                return true;
                            break;
                        case EnumPrivacy.ForNetWorkAndFriends:
                            if (fr.IsInSameNetwork(userid, visitUserid))
                                return true;
                            break;
                        case EnumPrivacy.ForOwner:
                            if (userid == visitUserid)
                                return true;
                            break;
                        case EnumPrivacy.ForWholeSite:
                            return true;
                    }
                    break;
                case EnumPrivacyType.Share:
                    switch (pri.PrivacyShare)
                    {
                        case EnumPrivacy.ForFriends:
                            if (fr.IsFriends(userid, visitUserid))
                                return true;
                            break;
                        case EnumPrivacy.ForNetWorkAndFriends:
                            if (fr.IsInSameNetwork(userid, visitUserid))
                                return true;
                            break;
                        case EnumPrivacy.ForOwner:
                            if (userid == visitUserid)
                                return true;
                            break;
                        case EnumPrivacy.ForWholeSite:
                            return true;
                    }
                    break;
                case EnumPrivacyType.Space:
                    switch (pri.PrivacySpace)
                    {
                        case EnumPrivacy.ForFriends:
                            if (fr.IsFriends(userid, visitUserid))
                                return true;
                            break;
                        case EnumPrivacy.ForNetWorkAndFriends:
                            if (fr.IsInSameNetwork(userid, visitUserid))
                                return true;
                            break;
                        case EnumPrivacy.ForOwner:
                            if (userid == visitUserid)
                                return true;
                            break;
                        case EnumPrivacy.ForWholeSite:
                            return true;
                    }
                    break;
            }
            return false;
        }
        /// <summary>
        /// ˽Ƿ
        /// </summary>
        /// <param name="ept">˽</param>
        /// <param name="userid">ûID</param>
        /// <param name="visitUserid">ûID</param>
        /// <returns></returns>
        protected bool PrivacyAvailable(EnumPrivacy ep, int userid, int visitUserid)
        {
            if (IsAdmin())
                return true;
            if (userid == visitUserid)
                return true;
            BLL.User.User u = new BLL.User.User();
            BLL.User.Friend fr = new NetSNS.BLL.User.Friend();
            switch (ep)
            {
                case EnumPrivacy.ForFriends:
                    if (fr.IsFriends(userid, visitUserid))
                        return true;
                    break;
                case EnumPrivacy.ForNetWorkAndFriends:
                    if (fr.IsInSameNetwork(userid, visitUserid))
                        return true;
                    break;
                case EnumPrivacy.ForOwner:
                    if (userid == visitUserid)
                        return true;
                    break;
                case EnumPrivacy.ForWholeSite:
                    return true;
            }
            return false;
        }
        /// <summary>
        /// ˽Ƿ
        /// </summary>
        /// <param name="ep">˽</param>
        /// <param name="visitUserid">û</param>
        /// <returns></returns>
        protected bool PrivacyAvailable(EnumPrivacy ep, int visitUserid)
        {
            if (IsAdmin())
                return true;
            return PrivacyAvailable(ep, this.UserID, visitUserid);
        }
        /// <summary>
        /// ǷǹԱ
        /// </summary>
        /// <returns></returns>
        protected bool IsAdmin()
        {
            return false;
        }
        /// <summary>
        /// ȡû
        /// </summary>
        /// <param name="UserID">ûID</param>
        /// <returns></returns>
        protected string GetUserName(object UserID)
        {
            if (this.UserID == (int)UserID)
                return "";
            UserInfo info = new NetSNS.BLL.User.User().GetUserInfo((int)UserID);
            return info.Username;
        }
    }
}
