using System;
using System.Web;
using System.Web.UI;
using System.Collections.Generic;
using System.Text;
using NetSNS.Model;
using NetSNS.Common;
using NetSNS.Config;

namespace NetSNS.Web.UI.Page
{
    public class UserPage : BasePage
    {
        /// <summary>
        /// Ĭϵ¼ַ
        /// </summary>
        private static string loginUrl = "/user/index.aspx?g=timeout";
        private bool _UserCertificate = true;
        protected int VisitedUserID = 0;
        protected EnumPrivacyType Enum_Privacy_Type;
        protected override void Logout()
        {
            base.Logout();
            Context.Response.End();
        }
        public UserPage()
        {
            this.Load += new EventHandler(UserPage_Load);
        }

        /// <summary>
        /// load¼
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void UserPage_Load(object sender, EventArgs e)
        {
            CheckLogin();
            //˽
            if (this.VisitedUserID != 0)
            {
                if (!PrivacyAvailable(this.Enum_Privacy_Type, this.UserID, this.VisitedUserID))
                {
                    this.PageError("ǰû˽ò鿴", Request.RawUrl);
                }
            }
        }
        /// <summary>
        /// ¼״̬
        /// </summary>
        protected override void CheckLogin()
        {
            cookieToken = Context.Request.Cookies["SnsUserToken"];
            if (cookieToken == null || cookieToken["token"] == null || cookieToken["token"] == "")
                base.CheckResultShow(NetSNS.Model.EnumLoginState.Err_TimeOut, loginUrl);
            //cookieToken.Domain = UiConfig.CookieDomain;            
            string userCookie = cookieToken["token"];
            this.UserPortrait = cookieToken["headpic"];
            this.UserName = Input.URLDecode(cookieToken["username"]);
            string desstr = NetSNS.Common.DES.Decrypt(userCookie, SecretConfig.UserKey, SecretConfig.UserIV);
            string[] userInfo = desstr.Split(SecretConfig.UserSeparator);
            EnumLoginState state = EnumLoginState.Err_TimeOut;
            if (userInfo.Length == 3)
            {
                UserID = int.Parse(userInfo[0]);
                string pass = userInfo[1];
                string cookip = userInfo[2];
                if (cookip != Public.GetClientIP())
                {
                    state = EnumLoginState.Err_TimeOut;
                }
                else
                {
                    NetSNS.BLL.User.User us = new NetSNS.BLL.User.User();
                    state = us.CheckLogin(UserID, pass);
                }
            }
            if (!(state == EnumLoginState.Succeed))
            {
                CheckResultShow(state, "/user/index.aspx");
            }
        }
        /// <summary>
        /// ǷҪ֤ҪĹ캯
        /// </summary>
        protected bool UserCertificate
        {
            set { _UserCertificate = value; }
        }
        /// <summary>
        /// õ¼Cookie
        /// </summary>
        /// <param name="userId">ûID</param>
        /// <param name="userName">û</param>
        /// <param name="Password">Md5ܺ</param>
        /// <param name="userPortrait">ûͷ</param>
        /// <param name="isAlways">Ƿ񱣳ֵ¼״̬(´ͬһ¼)</param>
        static public void SetCookie(int userId, string userName, string Password, string userPortrait, bool isAlways)
        {
            HttpCookie cookieToken = new HttpCookie("SnsUserToken");

            string s = userId.ToString() + SecretConfig.UserSeparator.ToString() + Password + SecretConfig.UserSeparator.ToString() + Public.GetClientIP();
            cookieToken["token"] = DES.Encrypt(s, SecretConfig.UserKey, SecretConfig.UserIV);
            cookieToken["headpic"] = userPortrait;            
            cookieToken["username"] = Input.URLEncode(userName);
            cookieToken.Domain = UiConfig.CookieDomain;
            cookieToken.Secure = false;
            if (isAlways)
                cookieToken.Expires = DateTime.Now.AddYears(20);
            HttpContext.Current.Response.AppendCookie(cookieToken);
        }        
    }
}
