using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.SessionState;
using NetSNS.Model;
using NetSNS.BLL.User;
using NetSNS.Config;
using NetSNS.Common;

namespace NetSNS.Web
{
    public class Global : System.Web.HttpApplication
    {

        protected void Application_Start(object sender, EventArgs e)
        {

        }

        protected void Application_End(object sender, EventArgs e)
        {

        }
        protected void Application_Error(object sender, EventArgs e)
        {
            //Exception x = Server.GetLastError().GetBaseException();
            //NetSNS.Web.UI.WebHint.ShowError(x.ToString(), "", false);
            //NetSNS.Web.UI.WebHint.ShowError(x.Message, "", false);
        }
        protected void Application_BeginRequest(Object sender, EventArgs e)
        {
            OnlineUserInfo info = new OnlineUserInfo();
            OnlineUser user = new OnlineUser();
            HttpCookie cookieToken = Context.Request.Cookies["SnsUserToken"];

            bool islogin = true;
            if (cookieToken == null || cookieToken["token"] == null || cookieToken["token"] == "")
                islogin = false;
            if (islogin)
            {
                string userCookie = cookieToken["token"];
                string UserPortrait = cookieToken["headpic"];
                string UserName = Input.URLDecode(cookieToken["username"]);
                string desstr = NetSNS.Common.DES.Decrypt(userCookie, SecretConfig.UserKey, SecretConfig.UserIV);
                string[] userInfo = desstr.Split(SecretConfig.UserSeparator);
                info.LastIP = Request.UserHostAddress;
                info.LastTime = DateTime.Now;
                int userid=0;
                int.TryParse(userInfo[0], out userid);
                info.UserID = userid;
                info.UserName = userid == 0 ? "ο" : UserName;
                info.LastURL = Request.Url.ToString();
                //if (!(userid == 0))
                //{
                //    DateTime dt = cookieToken.Expires;
                //    TimeSpan span = dt.Subtract(DateTime.Now);
                //    if (span.TotalMinutes < 30)
                //        cookieToken.Expires = DateTime.Now.AddMinutes(30);
                //    cookieToken.Domain = UiConfig.CookieDomain;
                //    Context.Response.SetCookie(cookieToken);
                //}
            }
            else
            {
                info.LastIP = Request.UserHostAddress;
                info.LastTime = DateTime.Now;
                info.UserID = 0;
                info.UserName = "ο";
                info.LastURL = Request.Url.ToString();
            }

            if (user.CheckOnline(info.UserID, info.LastIP))
            {
                user.Update(info);
            }
            else
            {
                user.Add(info);
            }
            user.DeleteExpires();
        }
    }
}