using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using NetSNS.BLL.User;
using NetSNS.Model;
using System.Collections.Generic;
using System.Text;

namespace NetSNS.Web.Inc.Ajax
{
    public partial class FootPrintOperator : NetSNS.Web.UI.Page.UserPage
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            string action = Request.Form["action"];
            switch (action)
            {
                case "add":
                    Add();
                    break;
                case "get":
                    Get();
                    break;
                case "delete":
                    Delete();
                    break;
                default:
                    break;
            }
        }

        
        /// <summary>
        /// 㼣
        /// </summary>
        protected void Add()
        {
            string x = Request.Form["x"];
            string y = Request.Form["y"];
            string desc = Request.Form["desc"];
            string name = Request.Form["name"];
            string aritime = Request.Form["ArrivedTime"];
            string year = Request.Form["year"];
            string month = Request.Form["month"];
            string day = Request.Form["day"];
            string zoom = Request.Form["zoom"];
            DateTime arriveTime = DateTime.MinValue;
            if (string.IsNullOrEmpty(x) || string.IsNullOrEmpty(y))
            {
                Response.Write("1");
                Response.End();
                return;
            }
            try
            {
                arriveTime = Convert.ToDateTime(arriveTime);
            }
            catch { }
            if (arriveTime == DateTime.MinValue)
            {
                try
                {
                    arriveTime = arriveTime.AddYears(int.Parse(year) - 1);
                    arriveTime = arriveTime.AddMonths(int.Parse(month) - 1);
                    arriveTime = arriveTime.AddDays(int.Parse(day) - 1);
                }
                catch { }
            }
            FootPrint fp = new FootPrint();
            PrintFootInfo info = new PrintFootInfo();
            info.X = x;
            info.Y = y;
            info.Content = desc;
            info.Name = name;
            info.UserID = this.UserID;
            info.AddTime = DateTime.Now;
            info.ArrivedTime = arriveTime;
            info.Zoom = 3;
            try
            {
                info.Zoom = int.Parse(zoom);
            }
            catch { }
            int tn = fp.Add(info);
            if (tn > 0)
            {
                Response.Write("0");
                Response.End();
            }
            else
            {
                Response.Write("1");
                Response.End();
            }
        }
        /// <summary>
        /// ȡҵ㼣
        /// </summary>
        protected void Get()
        {
            string userid = Request.QueryString["userid"];
            int UserID = this.UserID;
            try
            {
                UserID = int.Parse(userid);
            }
            catch { }
            FootPrint fp = new FootPrint();
            List<PrintFootInfo> list = fp.List(UserID);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < list.Count; i++)
            {
                PrintFootInfo info = list[i];
                if (info.Zoom == 0)
                    info.Zoom = 3;
                if (i > 0)
                {
                    sb.Append(",");
                }
                if (this.UserID != UserID)
                {
                    sb.Append("new Array('" + info.X + "','" + info.Y + "','" + info.Zoom + "','" + info.Name + "','" + info.Content + "','" + info.ArrivedTime + "')");
                }
                else
                {
                    sb.Append("new Array('" + info.X + "','" + info.Y + "','" + info.Zoom + "','" + info.Name + "','" + info.Content + "','" + info.ArrivedTime + "','" + info.ID + "')");
                }
            }
            string str = sb.ToString();
            if (!string.IsNullOrEmpty(str))
            {
                Response.Write("new Array(" + str + ")");
            }
            else
            {
                Response.Write("null");
            }
        }
        //ɾ
        private void Delete()
        {
            string userid = Request.QueryString["userid"];
            int UserID = this.UserID;
            try
            {
                UserID = int.Parse(userid);
            }
            catch { }
            if (this.UserID != UserID)
            {
                Response.Write("1");
                Response.End();
            }
            string id = Request.Form["id"];
            int ID=0;
            try
            {
                ID = int.Parse(id);
            }
            catch { Response.Write("1"); Response.End(); return; }
            FootPrint fp = new FootPrint();
            int tn=fp.Delete(ID);
            if (tn > 0)
            {
                Response.Write("0");
            }
            else
            {
                Response.Write("1");
            }
            Response.End();
        }
    }
}
