using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using NetSNS.Model;
using NetSNS.Common;

namespace NetSNS.Web.Inc.Ajax
{
    public partial class ShareOperator : NetSNS.Web.UI.Page.UserPage
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            string action = Request.QueryString["action"];
            if (action != string.Empty && action != null)
            { 
                string sFriendIDGroup = Request.QueryString["sFriendIDGroup"];
                string ShareType = Request.QueryString["ShareType"];
                string ShareUrl = Request.QueryString["ShareUrl"];
                string stitle = Request.QueryString["stitle"];
                string scontent = Request.QueryString["scontent"];
                string shareID = Request.QueryString["shareID"];
                ShareInfo info = new ShareInfo();
                NetSNS.BLL.User.Share shareBill = new NetSNS.BLL.User.Share();
                info.UserID = UserID;
                info.Title = stitle;
                info.Description = scontent;
                info.Url = string.Empty;
                info.CaseID = Convert.ToInt16(shareID);
                switch (ShareType)
                {
                    case "1":
                        info.ShareType = EnumShareType.ShareWeb;
                        if (ShareUrl.Substring(6) != "http://")
                        {
                            ShareUrl = "http://" + ShareUrl;
                        }
                        info.Url = ShareUrl;
                        info.CaseID = 0;
                        break;
                    case "2":
                        info.ShareType = EnumShareType.SharePhoto;
                        break;
                    case "3":
                        info.ShareType = EnumShareType.ShareAlbum;
                        break;
                    case "4":
                        info.ShareType = EnumShareType.ShareBlog;
                        break;
                    case "5":
                        info.ShareType = EnumShareType.ShareViode;
                        break;
                    case "6":
                        info.ShareType = EnumShareType.ShareFriend;
                        break;
                    case "7":
                        info.ShareType = EnumShareType.ShareOther;
                        break;
                }
                info.IsLock = 0;
                info.PostTime = DateTime.Now;
                info.PostIP = NetSNS.Common.Public.GetClientIP();
                info.Comments = 0;
                info.Privacy = EnumPrivacy.ForFriends;
                if (shareBill.Add(info) > 0)
                {
                    Response.Write("SaveSharesuccess");
                    Response.End();
                }
                else
                {
                    Response.Write("SaveSharefail");
                    Response.End();
                }
            }
        }
    }
}
