using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

namespace NetSNS.Web.Inc.Ajax
{
    public partial class showPoint : NetSNS.Web.UI.Page.UserPage
    {
        protected new int UserID;
        protected void Page_Load(object sender, EventArgs e)
        {
            UserID = this.GetUserID();
            NetSNS.BLL.User.User us = new NetSNS.BLL.User.User();
            IDataReader dr = us.GetUserPoint(UserID);
            string listStr = string.Empty;
            string sTime = Request.QueryString["sTime"];
            string eTime = Request.QueryString["eTime"];
            if (Request.QueryString["type"] != string.Empty && Request.QueryString["type"] != null)
            {
                string curPage = Request.QueryString["page"];
                int page = 0;

                if (curPage == "" || curPage == null || curPage == string.Empty) { page = 1; }
                else
                {
                    try { page = int.Parse(curPage); }
                    catch
                    {
                        page = 1;
                    }
                }
                int i, j;
                DataTable dt = us.SearchPointHistoryPage(UserID, sTime, eTime, page, 16, out i, out j);
                if (dt != null && dt.Rows.Count > 0)
                {
                    listStr += "<ul>";
                    for (int k = 0; k < dt.Rows.Count; k++)
                    {
                        string utf = string.Empty;
                        if (dt.Rows[k]["UTF"].ToString() == "0")
                        {
                            utf = "<span style=\"color:Green;font-size:12px;\"></span>";
                        }
                        else
                        {
                            utf = "<span style=\"color:Red;font-size:12px;\"></span>";
                        }
                        string ContentStr = string.Empty;
                        if (dt.Rows[k]["content"] != null && dt.Rows[k]["content"].ToString() != string.Empty)
                        {
                            ContentStr = "" + dt.Rows[k]["Content"].ToString() + "";
                        }
                        listStr += "<li>&bull; " + utf +" "+ ContentStr+":" + dt.Rows[k]["Point"].ToString() + " | " + NetSNS.Config.UiConfig.gName + ":" + dt.Rows[k]["GPoint"].ToString() + " <span>(" + dt.Rows[k]["CreatTime"].ToString() + ")</span></li>";
                    }
                    dt.Clear();
                    dt.Dispose();
                }
                else
                {
                    listStr += "ûм¼";
                }
                listStr += "</ul>";
                listStr += "<div>" + ShowPage(page, i, j, sTime,eTime) + "</div>";
            }
            else
            {
                listStr = "<div class=\"pointd\">";
                if (dr.Read())
                {
                    listStr += "<div class=\"pointtitle\">ҵ" + NetSNS.Config.UiConfig.SiteName + "˻:</div>";
                    listStr += "<div class=\"pointitem\">&bull; ֣<span>" + dr["integral"].ToString() + "</span>  &nbsp;  &nbsp; &bull; " + NetSNS.Config.UiConfig.gName + "<span>" + dr["inteyb"].ToString() + "</span></div>";
                    listStr += "<div class=\"pointitem\"><a href=\"javascript://\" onclick=\"javascript:showPointHistory('1','" + sTime + "','" + eTime + "');\">鿴¼</a> &nbsp;&nbsp;  <a href=\"/help/?a=point\" target=\"_blank\"><span style=\"color:Red;\">λûֺ" + NetSNS.Config.UiConfig.gName + "</span></a> &nbsp;  &nbsp; <a href=\"/user/Props/Send.aspx\"><span style=\"color:Red;\">ֵ" + NetSNS.Config.UiConfig.gName + "</span></a></div>";
                }
                dr.Close();
                listStr += "</div>";
                listStr += "<div></div>";
                listStr += "<div class=\"pointhisty\" id=\"div_pointhisty\" style=\"display:none\">loading...</div>";
                listStr += "<div style=\"width:96%;text-align:right;\"><a href=\"javascript:closediv($('point_idwindow'));\">رմ</a></div>";
            }
            Response.Write(listStr);
            Response.End();
        }

        /// <summary>
        /// ҳ
        /// </summary>
        /// <param name="page">ǰҳ</param>
        /// <param name="Cnt">ܼ¼</param>
        /// <param name="pageCount">ҳ</param>
        /// <returns></returns>
        protected string ShowPage(int page, int Cnt, int pageCount,string sTime,string eTime)
        {
            string urlstr = "<div style=\"height:10px;clear:both;border-bottom:1px dotted #333333;margin-bottom:5px;\"></div>" + Cnt.ToString() + "¼," + pageCount.ToString() + "ҳ,ǰ" + page.ToString() + "ҳ <br />";
            urlstr += "<a href=\"javascript:showPointHistory('1','" + sTime + "','" + eTime + "');\" title=\"ҳ\" >ҳ</a> ";
            if ((page - 1) < 1)
            {
                urlstr += " һҳ ";
            }
            else
            {
                urlstr += " <a href=\"javascript:showPointHistory('" + (page - 1) + "','" + sTime + "','" + eTime + "');\" title=\"һҳ\" >һҳ</a> ";
            }
            for (int i = page; i < (page + 10); i++)
            {
                if (i > pageCount)
                {
                    break;
                }
                else
                {
                    urlstr += "&nbsp;&nbsp;<a href=\"javascript:showPointHistory('" + i + "','" + sTime + "','" + eTime + "');\" title=\"һҳ\" >" + i + "</a>&nbsp;";
                }
            }
            if (page == pageCount)
            {
                urlstr += " һҳ ";
            }
            else
            {
                urlstr += " <a href=\"javascript:showPointHistory('" + (page + 1) + "','" + sTime + "','" + eTime + "');\" title=\"һҳ\" >һҳ</a> ";
            }
            urlstr += " <a href=\"javascript:showPointHistory('" + pageCount + "','" + sTime + "','" + eTime + "');\" title=\"βҳ\">βҳ</a> ";
            return urlstr;
        }
    }
}
