using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Collections.Generic;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using NetSNS.BLL.User;
using NetSNS.Model;
using NetSNS.Common;
using NetSNS.Config;

namespace NetSNS.Web
{
    public partial class InviteReg : NetSNS.Web.UI.Page.BasePage
    {
        protected string province = string.Empty;
        protected string cityarray = string.Empty;
        protected bool succeed = false;
        protected string error = string.Empty;
        protected string email = string.Empty;
        protected InviteInfo info;
        protected Dictionary<string, string> frnd;
        protected string code;
        protected int invitemode = (int)EnumFriendInviteMode.Email;
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {

                if (Request.Form["Register"] == "Submit")
                {
                    DoRegister();
                }
                if (Request["r"] != null && Request["r"].Trim() != string.Empty)
                {
                    try
                    {
                        code = Request["r"].Trim();
                        EnumFriendInviteMode mode = EnumFriendInviteMode.Email;
                        NetSNS.BLL.User.User us = new User();
                        if (Request["a"] != null && Request["a"].ToLower() == "urlreg")
                        {
                            #region url
                            string _code = DES.Decrypt(Input.URLDecode(code), SecretConfig.InviteKey, SecretConfig.InviteIV);
                            string[] arrcode = _code.Split(SecretConfig.InviteSeparator);
                            if (arrcode.Length == 2)
                            {
                                code = arrcode[0];
                                mode = EnumFriendInviteMode.URL;
                                invitemode = (int)mode;
                            }
                            else
                            {
                                PageError("Ч", "InviteReg.aspx");
                            }
                            #endregion
                        }
                        info = us.GetInviteInfo(code, mode, out frnd);
                        if (mode == EnumFriendInviteMode.URL)
                            info.Postscript = UiConfig.SiteName + "һѱϵĵطоҲɡ";
                    }
                    catch (System.Threading.ThreadAbortException ex)
                    { }
                    catch (Exception ex)
                    {
                        PageError(ex.Message, "");
                    }
                }
                else
                {
                    PageError("", "InviteReg.aspx");
                }
                if (!succeed)
                {
                    Dict dict = new Dict();
                    IList<DictAreaInfo> list = dict.GetArea();
                    foreach (DictAreaInfo info in list)
                    {
                        if (info.ParentID.Equals(0))
                        {
                            province += "<option value=\"" + info.ID + "\">" + info.Name + "</option>";
                        }
                        else
                        {
                            if (!cityarray.Equals(string.Empty))
                                cityarray += ",";
                            cityarray += "new Array('" + info.ParentID + "','" + info.ID + "','" + info.Name + "')";
                        }
                    }
                }
                DataBind();
            }
        }
        /// <summary>
        /// ע
        /// </summary>
        protected void DoRegister()
        {
            UserInfo ui = new UserInfo();
            ui.Email = email = Request["TxtEmail"];
            ui.Username = Request["TxtName"];
            ui.Password = Request["TxtPassword"];
            ui.Province = Convert.ToInt32(Request["SlctProvince"]);
            ui.City = Convert.ToInt32(Request["SlctCity"]);
            EnumFriendInviteMode mode = EnumFriendInviteMode.Email;
            if (Convert.ToInt32(Request["mode"]) == (int)EnumFriendInviteMode.URL)
                mode = EnumFriendInviteMode.URL;
            NetSNS.BLL.User.User user = new User();
            int userId;
            EnumRegister ret = user.InviterRegister(ui, mode, Request["r"], out userId);
            if (ret == EnumRegister.Succeed || ret == EnumRegister.EmailMayNotSend)
            {
                if (mode == EnumFriendInviteMode.Email)
                {
                    NetSNS.Web.UI.Page.UserPage.SetCookie(userId, ui.Username, Input.MD5(ui.Password, false), "", false);
                    Response.Redirect("/user/default.aspx");
                }
                else
                {
                    DisSucc(ui.Email);
                }
            }
            else if (ret == EnumRegister.EmailRepeat)
            {
                error = "Emailַעʻ";
            }
            else if (ret == EnumRegister.InvalidCode)
            {
                error = "֤Ч";
            }
            else if (ret == EnumRegister.RegInviteCode)
            {
                error = "Ѿע";
            }
            else
            {
                error = "ϵͳ,Ժ";
            }
        }
        /// <summary>
        /// ʾɹ
        /// </summary>
        private void DisSucc(string email)
        {
            Response.Write("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\r\n");
            Response.Write("<html xmlns=\"http://www.w3.org/1999/xhtml\">\r\n");
            Response.Write("<head>\r\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />\r\n");
            Response.Write("<title>-ע</title>\r\n<link href=\"/css/base.css\" type=\"text/css\" rel=\"stylesheet\" /><link href=\"/css/skin/" + NetSNS.Config.UiConfig.SkinStyle + "/style.css\" type=\"text/css\" rel=\"stylesheet\" />\r\n");
            Response.Write("</head>\r\n<body>\r\n<div id=\"doc\">\r\n");
            Response.Write(Public.GetTextFileContent(Server.MapPath("~/head0.htm")));
            Response.Write(Public.GetTextFileContent(Server.MapPath("~/left0.htm")));
            //Response.Write("<!--#include file=\"head0.htm\"-->\r\n<!--#include file=\"left0.htm\"-->\r\n");
            Response.Write("<div id=\"container\">\r\n<div id=\"content\">\r\n<div class=\"block\">");
            Response.Write("<h3>\r\n֤ Email ַ</h3>\r\n<p>\r\n");
            Response.Write("ллעᣡǸ㷢һ֤ʼ <strong>");
            Response.Write(email);
            Response.Write("</strong>ոʼעᡣ</p>\r\n");
            Response.Write("<p style=\"font-size: 14px;\">");
            Response.Write("<button class=\"f-button\" onclick=\"window.open('" + NetSNS.Config.EmailConfig.GetEmailLoginUrl(email) + "')\">");
            Response.Write("¼</button></p>\r\n");
            Response.Write("<p style=\"color: #800;\">㳤ʱûյ֤ʼ뿴Ƿ</p><p style=\"margin-top:8px;\">ȷʵûյ֤ʼע service@fengla.com һΪ֤ʼԱЭ㼤ʺš</p>\r\n");
            Response.Write("</div>\r\n</div>\r\n</div>\r\n");
            Response.Write(Public.GetTextFileContent(Server.MapPath("~/user/footer.htm")));
            //<!--#include file=\"/user/footer.htm\"-->");
            Response.Write("</div>\r\n</body>\r\n</html>");
            Response.End();
        }
    }
}

