using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Collections.Generic;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using NetSNS.BLL.User;
using NetSNS.Model;
using NetSNS.Common;
using NetSNS.Config;

namespace NetSNS.Web
{
    public partial class Register : NetSNS.Web.UI.Page.BasePage
    {
        protected string province = string.Empty;
        protected string cityarray = string.Empty;
        protected bool succeed = false;
        protected string error = string.Empty;
        protected string email = string.Empty;

        protected void Page_Load(object sender, EventArgs e)
        {
            if (UiConfig.RegSwitch == "0")
            {
                PageError("δûעṦ", "/user/index.aspx");
            }
            if (!IsPostBack)
            {
                if (Request.Form["Register"] == "Submit")
                {

                    DoRegister();
                }
                if (!succeed)
                {
                    Dict dict = new Dict();
                    IList<DictAreaInfo> list = dict.GetArea();
                    foreach (DictAreaInfo info in list)
                    {
                        if (info.ParentID.Equals(0))
                        {
                            province += "<option value=\"" + info.ID + "\">" + info.Name + "</option>";
                        }
                        else
                        {
                            if (!cityarray.Equals(string.Empty))
                                cityarray += ",";
                            cityarray += "new Array('" + info.ParentID + "','" + info.ID + "','" + info.Name + "')";
                        }
                    }
                }
                DataBind();
            }
        }
        /// <summary>
        /// ע
        /// </summary>
        protected void DoRegister()
        {
            UserInfo ui = new UserInfo();
            ui.Email = email = Request["TxtEmail"];
            ui.Username = Request["TxtName"];
            ui.Password = Request["TxtPassword"];
            ui.Province = Convert.ToInt32(Request["SlctProvince"]);
            ui.City = Convert.ToInt32(Request["SlctCity"]);
            NetSNS.BLL.User.User User = new User();
            EnumRegister ret = User.Register(ui);
            if (ret == EnumRegister.Succeed)
            {
                succeed = true;
            }
            else if (ret == EnumRegister.EmailRepeat)
            {
                error = "Emailַעʻ";
            }
            else if (ret == EnumRegister.EmailMayNotSend)
            {
                #region CMS 
                string uname = ui.Email.Split('@')[0];
                NetSNS.API.Interface.PDOAction pdo = new NetSNS.API.Interface.PDOAction();
                if (pdo.Enabled())
                {
                    pdo.RegUser(uname, ui.Password, 100, 100, "0", ui.Email, "", "111111", "111111", ui.Username, "", "", "", Public.GetClientIP(), 1, true, "");
                    pdo.Login(ui.Email, ui.Password, 1);
                }
                #endregion
                error = "Ѿɹע,Ժ,ûյʺȷʼ,ͷϵ";
            }
            else
            {
                error = "ϵͳ,Ժ";
            }
        }
    }
}

