using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Collections.Generic;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using NetSNS.Model;
using NetSNS.Web.UI.Control;
using NetSNS.BLL.User;
using NetSNS.Common;

namespace NetSNS.Web.manage.Ads
{
    public partial class companyedit : NetSNS.Web.UI.Page.ManagePage
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            Response.CacheControl = "no-cache";
            if (!Page.IsPostBack)
                getInfo();
        }

        /// <summary>
        /// ҳʼϢ
        /// </summary>
        protected void getInfo()
        {
            string id = Request.QueryString["id"];
            if (id == null || id == "")
                PageError("ݴ", Request.RawUrl);
            Hid_ID.Value = id;

            Company company = new Company();
            CompanyInfo companyinfo = new CompanyInfo();
            companyinfo = company.Info(Convert.ToInt32(id));

            Dict dict = new Dict();
            IList<DictAreaInfo> list = dict.GetArea();
            foreach (DictAreaInfo info in list)
            {
                if (info.ParentID == 0)
                {
                    ListItem itm = new ListItem();
                    itm.Value = info.ID.ToString(); itm.Text = info.Name;
                    Province.Items.Add(itm);
                }
            }
            ComPanyName.Text = companyinfo.ComPanyName;
            Intro.Text = Input.ToTxt(companyinfo.Intro);
            Tel.Text = companyinfo.Tel;
            Contact.Text = companyinfo.Contact;
            Address.Text = companyinfo.Address;
            Province.Text = companyinfo.Province.ToString();
        }

        /// <summary>
        /// ִб̼Ϣ
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void Button1_Click(object sender, EventArgs e)
        {
            if (Page.IsValid)
            {
                Company company = new Company();
                CompanyInfo companyinfo = new CompanyInfo();

                companyinfo.ID = Convert.ToInt32(Hid_ID.Value);
                companyinfo.ComPanyName = ComPanyName.Text;
                companyinfo.Intro = Input.ToHtml(Intro.Text);
                companyinfo.Tel = Tel.Text;
                companyinfo.Contact = Contact.Text;
                companyinfo.Address = Address.Text;
                companyinfo.Province = Convert.ToInt32(Request.Form["Province"]);

                int n = company.Edit(companyinfo);
                if (n == -1)
                    PageError("̼ظ޸!", Request.RawUrl);
                else if (n == 1)
                    PageRight("޸̼Ϣɹ!", Request.RawUrl);
                else
                    PageError("޸̼ʧ!", Request.RawUrl);
            }

        }
    }
}
