//===========================================================
//==               (c)2008  NETSNS 1.0                     ==
//==            website:www.aspxcms.com                    ==
//==         qq:93333147,Email:zhangyuanjun@126.com        ==
//==               Code By Arjun                           ==
//===========================================================
using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using NetSNS.Web.UI.Control;
using NetSNS.BLL.User;
using NetSNS.Model;

namespace NetSNS.Web.manage.Album
{
    public partial class AlbumList : NetSNS.Web.UI.Page.ManagePage
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            bindData();
        }


        protected void bindData()
        {
            int ReCount, PgCount;
            int PageIndex = 1;
            string order=Request.QueryString["order"];
            string key = Request.QueryString["key"];
            if (string.IsNullOrEmpty(order))
            {
                order = "AlbumID";
            }
            
            string listpage = "manageAlbumList_aspx";
            SqlConditionInfo[] sqlcondition=new SqlConditionInfo[1];
            sqlcondition[0] = new SqlConditionInfo("@order", order, TypeCode.Int32);
            
            if (Request.QueryString["Page"] != null)
                PageIndex = Convert.ToInt32(Request.QueryString["Page"]);

            if (!string.IsNullOrEmpty(key))
            {
                key = NetSNS.Common.Input.Filter(key.Trim());
                Array.Resize<SqlConditionInfo>(ref sqlcondition, sqlcondition.Length+1);
                sqlcondition[1] = new SqlConditionInfo("@key", key, TypeCode.String);
                sqlcondition[1].Blur = 3;
                listpage = "manageAlbumlist_key_aspx";   
            }
            DataTable dt = UtilPage.GetPage(listpage, PageIndex, PAGESZ, out ReCount, out PgCount, sqlcondition);
            string PageUrl = "AlbumList.aspx";
            this.RptData.DataSource = dt;
            this.RptData.DataBind();
            PageUrl += "?";
            if (!string.IsNullOrEmpty(order))
            {
                PageUrl += "&order="+order;
            }
            if (!string.IsNullOrEmpty(key))
            {
                PageUrl += "&key=" + Server.UrlEncode(key);
            }
            PageUrl.Replace("??", "?");
            PageUrl.Replace("?&", "?");
            if (ReCount > PAGESZ)
            {
                this.DivPage.InnerHtml = PageNavigator.Pagination(PageIndex, PgCount, PageUrl);
            }
            else
            {
                this.DivPage.Visible = false;
            }
        }

        /// <summary>
        /// ɾ
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void delAlbum_Click(object sender, EventArgs e)
        {
            string ids = Request.Form["albumchkedid"];
            string[] id = ids.Split(',');
            for (int i = 0; i < id.Length; i++)
            {
                delAlbumfuc(Convert.ToInt32(id[i]));
            }
            Response.Redirect(Request.RawUrl);
        }


        private int delAlbumfuc(int AlbumID)
        {
            BLL.User.Album ab = new BLL.User.Album();
            return ab.Del(AlbumID);
        }
    }
}
