//===========================================================
//==               (c)2008  NETSNS 1.0                     ==
//==            website:www.aspxcms.com                    ==
//==         qq:93333147,Email:zhangyuanjun@126.com        ==
//==               Code By Arjun                           ==
//===========================================================
using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using NetSNS.BLL.User;
using NetSNS.Model;
using NetSNS.Web.UI.Control;

namespace NetSNS.Web.manage.Album
{
    public partial class PhotoList : NetSNS.Web.UI.Page.ManagePage
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            bindData();
        }


        protected void bindData()
        {
            int ReCount, PgCount;
            int PageIndex = 1;
            string order = Request.QueryString["order"];
            string key = Request.QueryString["key"];
            this.Key.Text = key;
            if (string.IsNullOrEmpty(order))
            {
                order = "PhotoID";
            }
            string listpage = "managePhotoList_aspx";
            SqlConditionInfo[] sqlcondition = new SqlConditionInfo[1];
            sqlcondition[0] = new SqlConditionInfo("@order", order, TypeCode.Int32);

            if (Request.QueryString["Page"] != null)
                PageIndex = Convert.ToInt32(Request.QueryString["Page"]);

            if (!string.IsNullOrEmpty(key))
            {
                key = NetSNS.Common.Input.Filter(key.Trim());
                Array.Resize<SqlConditionInfo>(ref sqlcondition, sqlcondition.Length + 1);
                sqlcondition[1] = new SqlConditionInfo("@key", key, TypeCode.String);
                sqlcondition[1].Blur = 3;
                listpage = "managePhotoList_key_aspx";
            }
            DataTable dt = UtilPage.GetPage(listpage, PageIndex, PAGESZ, out ReCount, out PgCount, sqlcondition);
            string PageUrl = "PhotoList.aspx";
            this.RptData.DataSource = dt;
            this.RptData.DataBind();
            PageUrl += "?";
            if (!string.IsNullOrEmpty(order))
            {
                PageUrl += "&order=" + order;
            }
            if (!string.IsNullOrEmpty(key))
            {
                PageUrl += "&key=" + Server.UrlEncode(key);
            }
            PageUrl = PageUrl.Replace("??", "?");
            PageUrl = PageUrl.Replace("?&", "?");
            if (ReCount > PAGESZ)
            {
                this.DivPage.InnerHtml = PageNavigator.Pagination(PageIndex, PgCount, PageUrl);
            }
            else
            {
                this.DivPage.Visible = false;
            }
        }

        /// <summary>
        /// ɾƬ
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void delPhoto_Click(object sender, EventArgs e)
        {
            string ids = Request.Form["albumchkedid"];
            string[] id = ids.Split(',');
            for (int i = 0; i < id.Length; i++)
            {
                delPhotofuc(Convert.ToInt32(id[i]));
            }
            Response.Redirect("photolist.aspx");
        }

        /// <summary>
        /// ִɾƬ
        /// </summary>
        /// <param name="photoID"></param>
        /// <returns></returns>
        protected int delPhotofuc(int photoID)
        {
            Photo p = new Photo();
            return p.Del(photoID);
        }

        /// <summary>
        /// ûʱʾ
        /// </summary>
        /// <param name="content"></param>
        /// <param name="msg"></param>
        /// <returns></returns>
        protected string noContent(object content, string msg)
        {
            string Con = content.ToString();
            if (string.IsNullOrEmpty(Con))
            {
                return msg;
            }
            return Con;
        }
        /// <summary>
        /// Ƿ
        /// </summary>
        /// <returns></returns>
        protected string isno(object isbool)
        {
            bool ISbool = (bool)isbool;
            if (ISbool)
                return "";
            else
                return "";
        }
        /// <summary>
        /// Ƭ
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void lockPhoto_Click(object sender, EventArgs e)
        {
            string ids = Request.Form["albumchkedid"];
            string[] id = ids.Split(',');
            Photo p = new Photo();
            for (int i = 0; i < id.Length; i++)
            {
                p.Lock(Convert.ToInt32(id[i]));
            }
            Response.Redirect(Request.RawUrl);
        }
        /// <summary>
        /// ÷
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void setCover_Click(object sender, EventArgs e)
        {
            string ids = Request.Form["albumchkedid"];
            string[] id = ids.Split(',');
            Photo p = new Photo();
            for (int i = 0; i < id.Length; i++)
            {
                p.SetCover(Convert.ToInt32(id[i]), UserID, false);
            }
            Response.Redirect(Request.RawUrl);
        }

        /// <summary>
        /// ʾļС
        /// </summary>
        /// <param name="kb"></param>
        /// <returns></returns>
        protected string viewFileSize(object b)
        {
            int bt = Convert.ToInt32(b);
            if (bt == 0)
                return "";
            string s = bt.ToString() + "ֽ";
            if (bt > 1024)
            {
                s = bt / 1024 + "KB";
            }

            if (bt > 1024 * 1024)
            {
                s = bt / 1024 * 1024 + "MB";
            }
            return s;
        }
    }
}
