using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

namespace NetSNS.Web.manage.Help
{
    public partial class HelpEdit : NetSNS.Web.UI.Page.ManagePage
    {
        NetSNS.BLL.User.Help help = new NetSNS.BLL.User.Help();
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                getInfo();
            }
        }

        /// <summary>
        /// ҳʼϢ
        /// </summary>
        protected void getInfo()
        {
            this.txtID.Value= Request.QueryString["ID"];
            this.txtSN.Text = Request.QueryString["SN"];
            if (this.txtSN.Text == null || this.txtSN.Text == "")
                PageError("ݴ!", "HelpList.aspx");
            DataTable dt = help.getHelp(this.txtSN.Text);

            if (dt != null)
            {
                if (dt.Rows.Count > 0)
                {
                    this.txtSN.Text = dt.Rows[0]["SN"].ToString();
                    this.txtTitle.Text = dt.Rows[0]["Title"].ToString();
                    this.txtContent.Value = dt.Rows[0]["Content"].ToString();
                }
            }
        }

        protected void Button1_Click(object sender, EventArgs e)
        {
            NetSNS.Model.helpInfo hp = new NetSNS.Model.helpInfo();
            hp.ID = int.Parse(this.txtID.Value);
            hp.SN = this.txtSN.Text;
            hp.Title = this.txtTitle.Text;
            hp.Content = this.txtContent.Value;

            int n = help.UpdateAdd(hp, 1);
            if (n == 1)
            {
                PageRight("޸İϢɹ!", "HelpList.aspx");
            }
            else if (n == 0)
            {
                PageError("޸İϢʧ!", "HelpList.aspx");
            }
            else if (n == 2)
            {
                PageError("޸ʧ,ظ!", "HelpList.aspx");
            }
        }
    }
}
