﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using NetSNS.Model;

public partial class manage_Login : NetSNS.Web.UI.Page.BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Request.QueryString["a"]!=string.Empty && Request.QueryString["a"]!=null)
            {
                HttpCookie cookieToken = new HttpCookie("SnsAdminToken");
                if (cookieToken != null)
                {
                    cookieToken.Expires.AddMilliseconds(0.1);
                    Response.Cookies.Add(cookieToken);
                }
                Response.Write("<script>top.location.href='index.aspx';</script>");
            }
        }
    }

    protected void IBtnLogin_Click(object sender, ImageClickEventArgs e)
    {
        string name = this.TxtName.Text;
        string pwd = this.TxtPass.Text;
        string vrf = this.TxtVerify.Text;
        if (name.Trim() == string.Empty || pwd.Trim() == string.Empty)
        {
            this.LblError.Text = "请输入用户名和密码";
            return;
        }
        if (vrf.Trim() == string.Empty)
        {
            this.LblError.Text = "请输入验证码";
            return;
        }
        if (Session["CheckCode"] == null)
        {
            this.LblError.Text = "验证码超时,请重新刷新本页面";
            return;
        }
        if (Session["CheckCode"].ToString().ToLower() != vrf.ToLower())
        {
            this.LblError.Text = "验证码输入错误";
            return;
        }
        NetSNS.Manage.Manager mg = new NetSNS.Manage.Manager();
        string md5pwd = NetSNS.Common.Input.MD5(pwd, false);
        int adminId = 0;
        string trueName = string.Empty;
        EnumLoginState state = mg.Login(name, md5pwd, out adminId, out trueName);
        switch (state)
        {
            case EnumLoginState.Succeed:
                NetSNS.Web.UI.Page.ManagePage.SetCookie(adminId, trueName, md5pwd);
                Response.Redirect("index.aspx");
                break;
            case EnumLoginState.Err_NameOrPwdError:
                this.LblError.Text = "用户名不存在或者密码错误";
                break;
            case EnumLoginState.Err_Locked:
                this.LblError.Text = "对不起，您的帐号已经被系统锁定";
                break;
        }
    }
}
