﻿<%@ Page Language="C#" AutoEventWireup="true" Codebehind="List.aspx.cs" Inherits="NetSNS.Web.manage.Movie.List" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title id="pagetitle" runat="server">电影管理</title>
    <link href="../Images/css/style.css" rel="stylesheet" type="text/css" />
</head>
<body>
    <form id="form1" runat="server">
        <div id="maintop">
            <div class="maintopleft">
                文字描述：欢迎访问NETSNS社交管理系统v1.0 当前用户：<span class="reshow"><%=this.UserName %></span></div>
            <div class="maintopright">
                您的位置：<a href="../main.aspx">首页</a> > 电影</div>
        </div>
        <div id="mainbody">
            <b>电影管理</b>
            <asp:Repeater runat="server" ID="Rpt_MovieList">
                <HeaderTemplate>
                    <table width="100%" border="0" cellpadding="3" cellspacing="1" class="maintable">
                        <tr class="maintablehead">
                            <td align="center" style="width: 10%;">
                                编号</td>
                            <td align="center" style="width: 20%;">
                                电影名称</td>
                            <td align="center" style="width: 20%;">
                                导演</td>
                            <td align="center" style="width: 10%;">
                                年份</td>
                            <td align="center" style="width: 10%;">
                                得分</td>
                            <td align="center" style="width: 10%;">
                                是否推荐</td>
                            <td align="center" style="width: 20%;">
                                操作</td>
                        </tr>
                </HeaderTemplate>
                <ItemTemplate>
                    <tr class="maintablelist">
                        <td align="center">
                            <%# DataBinder.Eval(Container.DataItem, "MovieID")%>
                        </td>
                        <td align="center">
                            <%# DataBinder.Eval(Container.DataItem, "Title")%>
                        </td>
                        <td align="center">
                            <%# DataBinder.Eval(Container.DataItem, "Director")%>
                        </td>
                        <td align="center">
                            <%# DataBinder.Eval(Container.DataItem, "YearOnShow")%>
                        </td>
                        <td align="center">
                            <%# DataBinder.Eval(Container.DataItem, "Score")%>
                        </td>
                        <td align="center">
                            <%# getRec(DataBinder.Eval(Container.DataItem, "IsRec"))%>
                        </td>
                        <td align="center">
                            <a href="javascript:edit(<%# DataBinder.Eval(Container.DataItem, "MovieID")%>);">编辑</a>
                            | <a href="javascript:del(<%# DataBinder.Eval(Container.DataItem, "MovieID")%>);">删除</a>
                            | <a href="javascript:rec(<%# DataBinder.Eval(Container.DataItem, "MovieID")%>);">推荐</a>
                            | <a href="javascript:unrec(<%# DataBinder.Eval(Container.DataItem, "MovieID")%>);">
                                取消推荐</a> | <a href="javascript:look(<%# DataBinder.Eval(Container.DataItem, "MovieID")%>);">
                                    海报</a>
                        </td>
                    </tr>
                </ItemTemplate>
                <FooterTemplate>
                    </table>
                </FooterTemplate>
            </asp:Repeater>
            <table width="100%" border="0" cellpadding="3" cellspacing="1">
                <tr class="maintablepage">
                    <td>
                        <div align="center">
                            搜索电影
                            <asp:TextBox ID="Key" runat="server" Width="200"></asp:TextBox><asp:Button ID="Button1"
                                runat="server" Text=" 搜索 " OnClick="Button1_Click" /></div>
                        <div class="pagination" runat="server" id="DivPage" align="center">
                        </div>
                    </td>
                </tr>
            </table>
        </div>
        <div id="maincopyright">
            &copy;2008 NETSNS, Version:1.0 reaslese, Help Center</div>
    </form>
</body>
</html>

<script language="javascript" type="text/javascript">
function edit(id)
{
    self.location="movieedit.aspx?id="+id;
}
function del(id)
{
    if(confirm('你确认删除此电影吗?'))
        self.location="?action=del&id="+id;
}
function look(id)
{
    self.location="piclist.aspx?movieid="+id;
}
function rec(id)
{
    if(confirm('你确认推荐此电影吗?'))
        self.location="?action=rec&id="+id;
}
function unrec(id)
{
    self.location="?action=unrec&id="+id;
}
</script>

