using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

namespace NetSNS.Web.manage.car
{
    public partial class IntroEdit : NetSNS.Web.UI.Page.ManagePage
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            Response.CacheControl = "no-cache";
            if (!Page.IsPostBack)
                getInfo();
        }


        protected void getInfo()
        {
            string s_ID = Request.QueryString["id"];
            if (s_ID == null || s_ID == "")
                PageError("ݴ!", "IntroList.aspx");
            NetSNS.BLL.User.CarClubAreaIntro intro = new NetSNS.BLL.User.CarClubAreaIntro();
            NetSNS.Model.CarClubAreaIntroInfo introinfo = new NetSNS.Model.CarClubAreaIntroInfo();
            introinfo = intro.Info(Convert.ToInt32(s_ID));
            Hid_ID.Value = introinfo.ID.ToString();
            AreaName.Text = introinfo.AreaName;
            Intro.Text = NetSNS.Common.Input.ToTxt(introinfo.Intro);
        }


        protected void Button1_Click(object sender, EventArgs e)
        {
            if (Page.IsValid)
            {
                NetSNS.BLL.User.CarClubAreaIntro intro = new NetSNS.BLL.User.CarClubAreaIntro();
                NetSNS.Model.CarClubAreaIntroInfo introinfo = new NetSNS.Model.CarClubAreaIntroInfo();
                introinfo.ID = Convert.ToInt32(Hid_ID.Value);
                introinfo.AreaName = AreaName.Text;
                introinfo.Intro = NetSNS.Common.Input.ToHtml(Intro.Text);

                int n = intro.Edit(introinfo);

                if (n == 1)
                    PageRight("޸ľϢɹ", "IntroList.aspx");
                else if (n == -1)
                    PageError("Ʋظ", "IntroList.aspx");
                else
                    PageError("޸ľϢʧ", "IntroList.aspx");
            }
        }
    }
}
