using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using NetSNS.Model;
using NetSNS.Web.UI.Control;
using NetSNS.BLL.User;

namespace NetSNS.Web.manage.car
{
    public partial class list : NetSNS.Web.UI.Page.ManagePage
    {
        CarClubUser clubuser = new CarClubUser();
        CarATC atc = new CarATC();
        Dict dict = new Dict();
        protected void Page_Load(object sender, EventArgs e)
        {
            Operate();
            LoadList();
        }

        /// <summary>
        /// طҳ
        /// </summary>
        /// <param name="PageIndex">ǰҳ</param>
        protected void LoadList()
        {
            int r, p, PageIndex = 0;
            PageIndex = Convert.ToInt32(Request.QueryString["Page"]);
            DataTable dt = null;
            if (Key.Text.Trim() != "")
            {
                SqlConditionInfo st = new SqlConditionInfo("@key", Key.Text, TypeCode.String);
                st.Blur = 3;
                dt = UtilPage.GetPage("carclublist_key_aspx", PageIndex, PAGESZ, out r, out p, st);
            }
            else
            {
                dt = UtilPage.GetPage("carclublist_aspx", PageIndex, PAGESZ, out r, out p, null);
            }

            if (dt != null)
            {
                Rpt_ClubList.DataSource = dt;
                Rpt_ClubList.DataBind();
            }
            //жǷ÷ҳ
            if (r > PAGESZ)
            {
                DivPage.InnerHtml = PageNavigator.Pagination(PageIndex, p, "list.aspx");
            }
        }

        /// <summary>
        /// 
        /// </summary>
        protected void Operate()
        {
            string s_Act = Request.QueryString["action"];

            if (s_Act != null && s_Act != "")
            {
                string s_ID = Request.QueryString["id"];
                if (s_ID == null || s_ID == "")
                    PageError("ݴ!", "list.aspx");
                CarClub club = new CarClub();
                switch (s_Act)
                {
                    case "del":
                        if (club.Del(Convert.ToInt32(s_ID)) == 1)
                            PageRight("ɾѳɹ!", "list.aspx");
                        else
                            PageError("ɾʧ!", "list.aspx");
                        break;
                    case "lock":
                        if (club.Lock(Convert.ToInt32(s_ID)) == 1)
                            PageRight("ѳɹ!", "list.aspx");
                        else
                            PageError("ʧ!", "list.aspx");
                        break;
                    case "unlock":
                        if (club.UnLock(Convert.ToInt32(s_ID)) == 1)
                            PageRight("ѳɹ!", "list.aspx");
                        else
                            PageError("ʧ!", "list.aspx");
                        break;
                    case "rec":
                        if (club.Rec(Convert.ToInt32(s_ID)) == 1)
                            PageRight("Ƽѳɹ!", "list.aspx");
                        else
                            PageError("Ƽʧ!", "list.aspx");
                        break;
                    case "unrec":
                        if (club.UnRec(Convert.ToInt32(s_ID)) == 1)
                            PageRight("ȡƼѳɹ!", "list.aspx");
                        else
                            PageError("ȡƼʧ!", "list.aspx");
                        break;
                }
            }
        }

        /// <summary>
        /// ִ
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void Button1_Click(object sender, EventArgs e)
        {
            if (!Page.IsValid)
                LoadList();
        }

        /// <summary>
        /// ȡóѻٳԱ
        /// </summary>
        /// <param name="ClubID">ѻ</param>
        /// <returns></returns>
        protected string getMemberCnt(object ClubID)
        {
            return clubuser.Count(Convert.ToInt32(ClubID)).ToString();
        }

        /// <summary>
        /// ȡóѻжٸ
        /// </summary>
        /// <param name="ClubID"></param>
        /// <returns></returns>
        protected string getAtcCnt(object ClubID)
        {
            return atc.Count(Convert.ToInt32(ClubID)).ToString();
        }

        /// <summary>
        /// ȡõ
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        protected string getAera(object id)
        {
            return dict.GetAreaName(Convert.ToInt32(id));
        }

        /// <summary>
        /// ȡǷ
        /// </summary>
        /// <param name="type"></param>
        /// <returns></returns>
        protected string getisLock(object type)
        {
            string s_lock = "<font color=red></font>";
            if (type.ToString() == "0")
                s_lock = "";
            return s_lock;
        }

        /// <summary>
        /// ȡǷƼ
        /// </summary>
        /// <param name="type"></param>
        /// <returns></returns>
        protected string getisrec(object type)
        {
            string s_rec = "<font color=red>Ƽ</font>";
            if (type.ToString() == "0")
                s_rec = "";
            return s_rec;
        }

    }
}
