using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using NetSNS.Model;
using System.Collections.Generic;

namespace NetSNS.Web.manage.user
{
    public partial class CareerEdit : NetSNS.Web.UI.Page.ManagePage
    {
        NetSNS.BLL.User.User us = new NetSNS.BLL.User.User();
        protected void Page_Load(object sender, EventArgs e)
        {
            try
            {
                if (!IsPostBack)
                {
                    this.txtUserId.Value = Request.QueryString["r"];
                    this.txtID.Value = Request.QueryString["ID"];
                }

                string type = Request.QueryString["Type"];
                if (type == "Edit")
                {
                    UpdateCareer();
                }
                else
                {
                    LoadCareerInfo();
                }
            }
            catch { }
        }

        #region ʼϢ
        public void LoadCareerInfo()
        {
            DataTable dt = us.getCareerByID(int.Parse(this.txtID.Value));
            if (dt != null)
            {
                if (dt.Rows.Count > 0)
                {
                    string check = dt.Rows[0]["IsStill"].ToString();
                    if (check == "True")
                    {
                        Check_0.Checked = true;
                    }
                    else
                    {
                        Check_0.Checked = false;
                    }

                    companyName_0.Value = dt.Rows[0]["Company"].ToString();
                    company_desc_0.Value = dt.Rows[0]["Description"].ToString();
                    company_from_0.Value = dt.Rows[0]["JoinYear"].ToString();
                    company_from_month_0.Value = dt.Rows[0]["JoinMonth"].ToString();
                    company_to_0.Value = dt.Rows[0]["LeaveYear"].ToString();
                    company_to_month_0.Value = dt.Rows[0]["LeaveMonth"].ToString();
                    txtID_0.Value = dt.Rows[0]["ID"].ToString();

                    if (dt.Rows[0]["IsStill"].ToString() == "True")
                    {
                        Check_0.Checked = true;
                    }
                    else
                    {
                        Check_0.Checked = false;
                    }
                }
            }
        }
        #endregion

        public void UpdateCareer()
        {
            UserCareerInfo uf = new UserCareerInfo();
            uf.Company = Request.QueryString["companyName"];
            uf.UserID=int.Parse(Request.QueryString["r"]);
            uf.ID = int.Parse(Request.QueryString["ID"]);
            uf.JoinYear = int.Parse(Request.QueryString["FromYear"]);
            uf.JoinMonth = int.Parse(Request.QueryString["FromMonth"]);
            uf.LeaveYear = int.Parse(Request.QueryString["ToYear"]);
            uf.LeaveMonth = int.Parse(Request.QueryString["ToMonth"]);
            uf.IsStill=int.Parse(Request.QueryString["CheckValue"]);
            uf.Description = Request.QueryString["companyDesc"];

            List<NetSNS.Model.UserCareerInfo> listStr = new List<NetSNS.Model.UserCareerInfo>();
            listStr.Add(uf);

            if (us.SaveCareer(listStr) == 1)
            {
                PageRight("޸ĻԱϢɹ!", "CareerList.aspx?r=" + Request.QueryString["r"]);
            }
            else
            {
                PageError("޸ĻԱϢʧ!", "CareerList.aspx?r=" + Request.QueryString["r"]);
            }
        }
    }
}